/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.io.InputStream;

public final class SliceSerialization {
    private SliceSerialization() {
    }

    public static class SliceDeserializer
    extends JsonDeserializer<Slice> {
        public Slice deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return Slices.wrappedBuffer((byte[])jsonParser.getBinaryValue(Base64Variants.MIME_NO_LINEFEEDS));
        }
    }

    public static class SliceSerializer
    extends JsonSerializer<Slice> {
        public void serialize(Slice slice, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            if (slice.hasByteArray()) {
                jsonGenerator.writeBinary(Base64Variants.MIME_NO_LINEFEEDS, slice.byteArray(), slice.byteArrayOffset(), slice.length());
            } else {
                jsonGenerator.writeBinary(Base64Variants.MIME_NO_LINEFEEDS, (InputStream)slice.getInput(), slice.length());
            }
        }
    }
}

