/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.oauth2;

import com.google.common.base.Strings;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.units.Duration;
import io.jsonwebtoken.io.Decoders;
import io.jsonwebtoken.security.Keys;
import java.util.concurrent.TimeUnit;
import javax.crypto.SecretKey;
import javax.validation.constraints.NotEmpty;

public class RefreshTokensConfig {
    private Duration tokenExpiration = Duration.succinctDuration((double)1.0, (TimeUnit)TimeUnit.HOURS);
    private String issuer = "Trino_coordinator";
    private String audience = "Trino_coordinator";
    private SecretKey secretKey;

    public Duration getTokenExpiration() {
        return this.tokenExpiration;
    }

    @Config(value="http-server.authentication.oauth2.refresh-tokens.issued-token.timeout")
    @ConfigDescription(value="Expiration time for issued token. It needs to be equal or lower than duration of refresh token issued by IdP")
    public RefreshTokensConfig setTokenExpiration(Duration tokenExpiration) {
        this.tokenExpiration = tokenExpiration;
        return this;
    }

    @NotEmpty
    public String getIssuer() {
        return this.issuer;
    }

    @Config(value="http-server.authentication.oauth2.refresh-tokens.issued-token.issuer")
    @ConfigDescription(value="Issuer representing this coordinator instance, that will be used in issued token. In addition current Version will be added to it")
    public RefreshTokensConfig setIssuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    @NotEmpty
    public String getAudience() {
        return this.audience;
    }

    @Config(value="http-server.authentication.oauth2.refresh-tokens.issued-token.audience")
    @ConfigDescription(value="Audience representing this coordinator instance, that will be used in issued token")
    public RefreshTokensConfig setAudience(String audience) {
        this.audience = audience;
        return this;
    }

    @Config(value="http-server.authentication.oauth2.refresh-tokens.secret-key")
    @ConfigDescription(value="Base64 encoded secret key used to encrypt generated token")
    @ConfigSecuritySensitive
    public RefreshTokensConfig setSecretKey(String key) {
        if (Strings.isNullOrEmpty((String)key)) {
            return this;
        }
        this.secretKey = Keys.hmacShaKeyFor((byte[])((byte[])Decoders.BASE64.decode((Object)key)));
        return this;
    }

    public SecretKey getSecretKey() {
        return this.secretKey;
    }
}

