/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.json.ir.IrAbsMethod;
import io.trino.json.ir.IrArithmeticBinary;
import io.trino.json.ir.IrArithmeticUnary;
import io.trino.json.ir.IrArrayAccessor;
import io.trino.json.ir.IrCeilingMethod;
import io.trino.json.ir.IrComparisonPredicate;
import io.trino.json.ir.IrConjunctionPredicate;
import io.trino.json.ir.IrContextVariable;
import io.trino.json.ir.IrDisjunctionPredicate;
import io.trino.json.ir.IrDoubleMethod;
import io.trino.json.ir.IrExistsPredicate;
import io.trino.json.ir.IrFilter;
import io.trino.json.ir.IrFloorMethod;
import io.trino.json.ir.IrIsUnknownPredicate;
import io.trino.json.ir.IrJsonNull;
import io.trino.json.ir.IrJsonPath;
import io.trino.json.ir.IrKeyValueMethod;
import io.trino.json.ir.IrLastIndexVariable;
import io.trino.json.ir.IrLiteral;
import io.trino.json.ir.IrMemberAccessor;
import io.trino.json.ir.IrNamedJsonVariable;
import io.trino.json.ir.IrNamedValueVariable;
import io.trino.json.ir.IrNegationPredicate;
import io.trino.json.ir.IrPathNode;
import io.trino.json.ir.IrPredicate;
import io.trino.json.ir.IrPredicateCurrentItemVariable;
import io.trino.json.ir.IrSizeMethod;
import io.trino.json.ir.IrStartsWithPredicate;
import io.trino.json.ir.IrTypeMethod;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.JsonPathAnalyzer;
import io.trino.sql.jsonpath.PathNodeRef;
import io.trino.sql.jsonpath.tree.AbsMethod;
import io.trino.sql.jsonpath.tree.ArithmeticBinary;
import io.trino.sql.jsonpath.tree.ArithmeticUnary;
import io.trino.sql.jsonpath.tree.ArrayAccessor;
import io.trino.sql.jsonpath.tree.CeilingMethod;
import io.trino.sql.jsonpath.tree.ComparisonPredicate;
import io.trino.sql.jsonpath.tree.ConjunctionPredicate;
import io.trino.sql.jsonpath.tree.ContextVariable;
import io.trino.sql.jsonpath.tree.DatetimeMethod;
import io.trino.sql.jsonpath.tree.DisjunctionPredicate;
import io.trino.sql.jsonpath.tree.DoubleMethod;
import io.trino.sql.jsonpath.tree.ExistsPredicate;
import io.trino.sql.jsonpath.tree.Filter;
import io.trino.sql.jsonpath.tree.FloorMethod;
import io.trino.sql.jsonpath.tree.IsUnknownPredicate;
import io.trino.sql.jsonpath.tree.JsonNullLiteral;
import io.trino.sql.jsonpath.tree.JsonPathTreeVisitor;
import io.trino.sql.jsonpath.tree.KeyValueMethod;
import io.trino.sql.jsonpath.tree.LastIndexVariable;
import io.trino.sql.jsonpath.tree.LikeRegexPredicate;
import io.trino.sql.jsonpath.tree.MemberAccessor;
import io.trino.sql.jsonpath.tree.NamedVariable;
import io.trino.sql.jsonpath.tree.NegationPredicate;
import io.trino.sql.jsonpath.tree.PathNode;
import io.trino.sql.jsonpath.tree.PredicateCurrentItemVariable;
import io.trino.sql.jsonpath.tree.SizeMethod;
import io.trino.sql.jsonpath.tree.SqlValueLiteral;
import io.trino.sql.jsonpath.tree.StartsWithPredicate;
import io.trino.sql.jsonpath.tree.TypeMethod;
import io.trino.sql.planner.LiteralInterpreter;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Literal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

class JsonPathTranslator {
    private final Session session;
    private final PlannerContext plannerContext;

    public JsonPathTranslator(Session session, PlannerContext plannerContext) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
    }

    public IrJsonPath rewriteToIr(JsonPathAnalyzer.JsonPathAnalysis pathAnalysis, List<String> parametersOrder) {
        PathNode root = pathAnalysis.getPath().getRoot();
        IrPathNode rewritten = (IrPathNode)new Rewriter(this.session, this.plannerContext, pathAnalysis.getTypes(), pathAnalysis.getJsonParameters(), parametersOrder).process(root);
        return new IrJsonPath(pathAnalysis.getPath().isLax(), rewritten);
    }

    private static class Rewriter
    extends JsonPathTreeVisitor<IrPathNode, Void> {
        private final LiteralInterpreter literalInterpreter;
        private final Map<PathNodeRef<PathNode>, Type> types;
        private final Set<PathNodeRef<PathNode>> jsonParameters;
        private final List<String> parametersOrder;

        public Rewriter(Session session, PlannerContext plannerContext, Map<PathNodeRef<PathNode>, Type> types, Set<PathNodeRef<PathNode>> jsonParameters, List<String> parametersOrder) {
            Objects.requireNonNull(session, "session is null");
            Objects.requireNonNull(plannerContext, "plannerContext is null");
            Objects.requireNonNull(types, "types is null");
            Objects.requireNonNull(jsonParameters, "jsonParameters is null");
            Objects.requireNonNull(jsonParameters, "jsonParameters is null");
            Objects.requireNonNull(parametersOrder, "parametersOrder is null");
            this.literalInterpreter = new LiteralInterpreter(plannerContext, session);
            this.types = types;
            this.jsonParameters = jsonParameters;
            this.parametersOrder = parametersOrder;
        }

        protected IrPathNode visitPathNode(PathNode node, Void context) {
            throw new UnsupportedOperationException("rewrite not implemented for " + node.getClass().getSimpleName());
        }

        protected IrPathNode visitAbsMethod(AbsMethod node, Void context) {
            IrPathNode base = (IrPathNode)this.process(node.getBase());
            return new IrAbsMethod(base, Optional.ofNullable(this.types.get(PathNodeRef.of((PathNode)node))));
        }

        protected IrPathNode visitArithmeticBinary(ArithmeticBinary node, Void context) {
            IrPathNode left = (IrPathNode)this.process(node.getLeft());
            IrPathNode right = (IrPathNode)this.process(node.getRight());
            return new IrArithmeticBinary(this.binaryOperator(node.getOperator()), left, right, Optional.ofNullable(this.types.get(PathNodeRef.of((PathNode)node))));
        }

        private IrArithmeticBinary.Operator binaryOperator(ArithmeticBinary.Operator operator) {
            return switch (operator) {
                default -> throw new IncompatibleClassChangeError();
                case ArithmeticBinary.Operator.ADD -> IrArithmeticBinary.Operator.ADD;
                case ArithmeticBinary.Operator.SUBTRACT -> IrArithmeticBinary.Operator.SUBTRACT;
                case ArithmeticBinary.Operator.MULTIPLY -> IrArithmeticBinary.Operator.MULTIPLY;
                case ArithmeticBinary.Operator.DIVIDE -> IrArithmeticBinary.Operator.DIVIDE;
                case ArithmeticBinary.Operator.MODULUS -> IrArithmeticBinary.Operator.MODULUS;
            };
        }

        protected IrPathNode visitArithmeticUnary(ArithmeticUnary node, Void context) {
            IrPathNode base = (IrPathNode)this.process(node.getBase());
            IrArithmeticUnary.Sign sign = switch (node.getSign()) {
                default -> throw new IncompatibleClassChangeError();
                case ArithmeticUnary.Sign.PLUS -> IrArithmeticUnary.Sign.PLUS;
                case ArithmeticUnary.Sign.MINUS -> IrArithmeticUnary.Sign.MINUS;
            };
            return new IrArithmeticUnary(sign, base, Optional.ofNullable(this.types.get(PathNodeRef.of((PathNode)node))));
        }

        protected IrPathNode visitArrayAccessor(ArrayAccessor node, Void context) {
            IrPathNode base = (IrPathNode)this.process(node.getBase());
            List subscripts = (List)node.getSubscripts().stream().map(subscript -> {
                IrPathNode from = (IrPathNode)this.process(subscript.getFrom());
                Optional<IrPathNode> to = subscript.getTo().map(arg_0 -> ((Rewriter)this).process(arg_0));
                return new IrArrayAccessor.Subscript(from, to);
            }).collect(ImmutableList.toImmutableList());
            return new IrArrayAccessor(base, subscripts, Optional.ofNullable(this.types.get(PathNodeRef.of((PathNode)node))));
        }

        protected IrPathNode visitCeilingMethod(CeilingMethod node, Void context) {
            IrPathNode base = (IrPathNode)this.process(node.getBase());
            return new IrCeilingMethod(base, Optional.ofNullable(this.types.get(PathNodeRef.of((PathNode)node))));
        }

        protected IrPathNode visitContextVariable(ContextVariable node, Void context) {
            return new IrContextVariable(Optional.ofNullable(this.types.get(PathNodeRef.of((PathNode)node))));
        }

        protected IrPathNode visitDatetimeMethod(DatetimeMethod node, Void context) {
            throw new IllegalStateException("datetime method is not yet supported. The query should have failed in JsonPathAnalyzer.");
        }

        protected IrPathNode visitDoubleMethod(DoubleMethod node, Void context) {
            IrPathNode base = (IrPathNode)this.process(node.getBase());
            return new IrDoubleMethod(base, Optional.ofNullable(this.types.get(PathNodeRef.of((PathNode)node))));
        }

        protected IrPathNode visitFilter(Filter node, Void context) {
            IrPathNode base = (IrPathNode)this.process(node.getBase());
            IrPredicate predicate = (IrPredicate)this.process((PathNode)node.getPredicate());
            return new IrFilter(base, predicate, Optional.ofNullable(this.types.get(PathNodeRef.of((PathNode)node))));
        }

        protected IrPathNode visitFloorMethod(FloorMethod node, Void context) {
            IrPathNode base = (IrPathNode)this.process(node.getBase());
            return new IrFloorMethod(base, Optional.ofNullable(this.types.get(PathNodeRef.of((PathNode)node))));
        }

        protected IrPathNode visitJsonNullLiteral(JsonNullLiteral node, Void context) {
            return new IrJsonNull();
        }

        protected IrPathNode visitKeyValueMethod(KeyValueMethod node, Void context) {
            IrPathNode base = (IrPathNode)this.process(node.getBase());
            return new IrKeyValueMethod(base);
        }

        protected IrPathNode visitLastIndexVariable(LastIndexVariable node, Void context) {
            return new IrLastIndexVariable(Optional.ofNullable(this.types.get(PathNodeRef.of((PathNode)node))));
        }

        protected IrPathNode visitMemberAccessor(MemberAccessor node, Void context) {
            IrPathNode base = (IrPathNode)this.process(node.getBase());
            return new IrMemberAccessor(base, node.getKey(), Optional.ofNullable(this.types.get(PathNodeRef.of((PathNode)node))));
        }

        protected IrPathNode visitNamedVariable(NamedVariable node, Void context) {
            if (this.jsonParameters.contains(PathNodeRef.of((PathNode)node))) {
                return new IrNamedJsonVariable(this.parametersOrder.indexOf(node.getName()), Optional.ofNullable(this.types.get(PathNodeRef.of((PathNode)node))));
            }
            return new IrNamedValueVariable(this.parametersOrder.indexOf(node.getName()), Optional.ofNullable(this.types.get(PathNodeRef.of((PathNode)node))));
        }

        protected IrPathNode visitPredicateCurrentItemVariable(PredicateCurrentItemVariable node, Void context) {
            return new IrPredicateCurrentItemVariable(Optional.ofNullable(this.types.get(PathNodeRef.of((PathNode)node))));
        }

        protected IrPathNode visitSizeMethod(SizeMethod node, Void context) {
            IrPathNode base = (IrPathNode)this.process(node.getBase());
            return new IrSizeMethod(base, Optional.ofNullable(this.types.get(PathNodeRef.of((PathNode)node))));
        }

        protected IrPathNode visitSqlValueLiteral(SqlValueLiteral node, Void context) {
            Literal value = node.getValue();
            return new IrLiteral(this.types.get(PathNodeRef.of((PathNode)node)), this.literalInterpreter.evaluate((Expression)value, this.types.get(PathNodeRef.of((PathNode)node))));
        }

        protected IrPathNode visitTypeMethod(TypeMethod node, Void context) {
            IrPathNode base = (IrPathNode)this.process(node.getBase());
            return new IrTypeMethod(base, Optional.ofNullable(this.types.get(PathNodeRef.of((PathNode)node))));
        }

        protected IrPathNode visitComparisonPredicate(ComparisonPredicate node, Void context) {
            Preconditions.checkArgument((boolean)BooleanType.BOOLEAN.equals((Object)this.types.get(PathNodeRef.of((PathNode)node))), (Object)"Wrong predicate type. Expected BOOLEAN");
            IrPathNode left = (IrPathNode)this.process(node.getLeft());
            IrPathNode right = (IrPathNode)this.process(node.getRight());
            IrComparisonPredicate.Operator operator = this.comparisonOperator(node.getOperator());
            return new IrComparisonPredicate(operator, left, right);
        }

        private IrComparisonPredicate.Operator comparisonOperator(ComparisonPredicate.Operator operator) {
            return switch (operator) {
                default -> throw new IncompatibleClassChangeError();
                case ComparisonPredicate.Operator.EQUAL -> IrComparisonPredicate.Operator.EQUAL;
                case ComparisonPredicate.Operator.NOT_EQUAL -> IrComparisonPredicate.Operator.NOT_EQUAL;
                case ComparisonPredicate.Operator.LESS_THAN -> IrComparisonPredicate.Operator.LESS_THAN;
                case ComparisonPredicate.Operator.GREATER_THAN -> IrComparisonPredicate.Operator.GREATER_THAN;
                case ComparisonPredicate.Operator.LESS_THAN_OR_EQUAL -> IrComparisonPredicate.Operator.LESS_THAN_OR_EQUAL;
                case ComparisonPredicate.Operator.GREATER_THAN_OR_EQUAL -> IrComparisonPredicate.Operator.GREATER_THAN_OR_EQUAL;
            };
        }

        protected IrPathNode visitConjunctionPredicate(ConjunctionPredicate node, Void context) {
            Preconditions.checkArgument((boolean)BooleanType.BOOLEAN.equals((Object)this.types.get(PathNodeRef.of((PathNode)node))), (Object)"Wrong predicate type. Expected BOOLEAN");
            IrPredicate left = (IrPredicate)this.process((PathNode)node.getLeft());
            IrPredicate right = (IrPredicate)this.process((PathNode)node.getRight());
            return new IrConjunctionPredicate(left, right);
        }

        protected IrPathNode visitDisjunctionPredicate(DisjunctionPredicate node, Void context) {
            Preconditions.checkArgument((boolean)BooleanType.BOOLEAN.equals((Object)this.types.get(PathNodeRef.of((PathNode)node))), (Object)"Wrong predicate type. Expected BOOLEAN");
            IrPredicate left = (IrPredicate)this.process((PathNode)node.getLeft());
            IrPredicate right = (IrPredicate)this.process((PathNode)node.getRight());
            return new IrDisjunctionPredicate(left, right);
        }

        protected IrPathNode visitExistsPredicate(ExistsPredicate node, Void context) {
            Preconditions.checkArgument((boolean)BooleanType.BOOLEAN.equals((Object)this.types.get(PathNodeRef.of((PathNode)node))), (Object)"Wrong predicate type. Expected BOOLEAN");
            IrPathNode path = (IrPathNode)this.process(node.getPath());
            return new IrExistsPredicate(path);
        }

        protected IrPathNode visitIsUnknownPredicate(IsUnknownPredicate node, Void context) {
            Preconditions.checkArgument((boolean)BooleanType.BOOLEAN.equals((Object)this.types.get(PathNodeRef.of((PathNode)node))), (Object)"Wrong predicate type. Expected BOOLEAN");
            IrPredicate predicate = (IrPredicate)this.process((PathNode)node.getPredicate());
            return new IrIsUnknownPredicate(predicate);
        }

        protected IrPathNode visitLikeRegexPredicate(LikeRegexPredicate node, Void context) {
            Preconditions.checkArgument((boolean)BooleanType.BOOLEAN.equals((Object)this.types.get(PathNodeRef.of((PathNode)node))), (Object)"Wrong predicate type. Expected BOOLEAN");
            throw new IllegalStateException("like_regex predicate is not yet supported. The query should have failed in JsonPathAnalyzer.");
        }

        protected IrPathNode visitNegationPredicate(NegationPredicate node, Void context) {
            Preconditions.checkArgument((boolean)BooleanType.BOOLEAN.equals((Object)this.types.get(PathNodeRef.of((PathNode)node))), (Object)"Wrong predicate type. Expected BOOLEAN");
            IrPredicate predicate = (IrPredicate)this.process((PathNode)node.getPredicate());
            return new IrNegationPredicate(predicate);
        }

        protected IrPathNode visitStartsWithPredicate(StartsWithPredicate node, Void context) {
            Preconditions.checkArgument((boolean)BooleanType.BOOLEAN.equals((Object)this.types.get(PathNodeRef.of((PathNode)node))), (Object)"Wrong predicate type. Expected BOOLEAN");
            IrPathNode whole = (IrPathNode)this.process(node.getWhole());
            IrPathNode initial = (IrPathNode)this.process(node.getInitial());
            return new IrStartsWithPredicate(whole, initial);
        }
    }
}

