/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import io.trino.sql.planner.SimplePlanVisitor;
import io.trino.sql.planner.plan.IndexJoinNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.SemiJoinNode;
import io.trino.sql.planner.plan.SpatialJoinNode;
import io.trino.sql.planner.plan.TableFunctionProcessorNode;
import io.trino.sql.planner.plan.TableScanNode;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class SchedulingOrderVisitor {
    public static List<PlanNodeId> scheduleOrder(PlanNode root) {
        ImmutableList.Builder schedulingOrder = ImmutableList.builder();
        root.accept(new Visitor(arg_0 -> ((ImmutableList.Builder)schedulingOrder).add(arg_0)), null);
        return schedulingOrder.build();
    }

    private SchedulingOrderVisitor() {
    }

    private static class Visitor
    extends SimplePlanVisitor<Void> {
        private final Consumer<PlanNodeId> schedulingOrder;

        public Visitor(Consumer<PlanNodeId> schedulingOrder) {
            this.schedulingOrder = Objects.requireNonNull(schedulingOrder, "schedulingOrder is null");
        }

        @Override
        public Void visitJoin(JoinNode node, Void context) {
            node.getRight().accept(this, context);
            node.getLeft().accept(this, context);
            return null;
        }

        @Override
        public Void visitSemiJoin(SemiJoinNode node, Void context) {
            node.getFilteringSource().accept(this, context);
            node.getSource().accept(this, context);
            return null;
        }

        @Override
        public Void visitSpatialJoin(SpatialJoinNode node, Void context) {
            node.getRight().accept(this, context);
            node.getLeft().accept(this, context);
            return null;
        }

        @Override
        public Void visitIndexJoin(IndexJoinNode node, Void context) {
            node.getIndexSource().accept(this, context);
            node.getProbeSource().accept(this, context);
            return null;
        }

        @Override
        public Void visitTableScan(TableScanNode node, Void context) {
            this.schedulingOrder.accept(node.getId());
            return null;
        }

        @Override
        public Void visitTableFunctionProcessor(TableFunctionProcessorNode node, Void context) {
            if (node.getSource().isEmpty()) {
                this.schedulingOrder.accept(node.getId());
            } else {
                node.getSource().orElseThrow().accept(this, context);
            }
            return null;
        }
    }
}

