/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.cost.AggregationStatsRule;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.operator.RetryPolicy;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.TableExecuteNode;
import java.util.Optional;

public class ApplyPreferredTableExecutePartitioning
implements Rule<TableExecuteNode> {
    public static final Pattern<TableExecuteNode> TABLE_EXECUTE_NODE_WITH_PREFERRED_PARTITIONING = Patterns.tableExecute().matching(node -> node.getPreferredPartitioningScheme().isPresent());

    @Override
    public Pattern<TableExecuteNode> getPattern() {
        return TABLE_EXECUTE_NODE_WITH_PREFERRED_PARTITIONING;
    }

    @Override
    public boolean isEnabled(Session session) {
        return SystemSessionProperties.isUsePreferredWritePartitioning(session);
    }

    @Override
    public Rule.Result apply(TableExecuteNode node, Captures captures, Rule.Context context) {
        if (SystemSessionProperties.getRetryPolicy(context.getSession()) == RetryPolicy.TASK && SystemSessionProperties.isFaultTolerantExecutionForcePreferredWritePartitioningEnabled(context.getSession())) {
            return ApplyPreferredTableExecutePartitioning.enable(node);
        }
        int minimumNumberOfPartitions = SystemSessionProperties.getPreferredWritePartitioningMinNumberOfPartitions(context.getSession());
        if (minimumNumberOfPartitions <= 1) {
            return ApplyPreferredTableExecutePartitioning.enable(node);
        }
        double expectedNumberOfPartitions = AggregationStatsRule.getRowsCount(context.getStatsProvider().getStats(node.getSource()), node.getPreferredPartitioningScheme().get().getPartitioning().getColumns());
        if (Double.isNaN(expectedNumberOfPartitions) || expectedNumberOfPartitions < (double)minimumNumberOfPartitions) {
            return Rule.Result.empty();
        }
        return ApplyPreferredTableExecutePartitioning.enable(node);
    }

    private static Rule.Result enable(TableExecuteNode node) {
        return Rule.Result.ofPlanNode(new TableExecuteNode(node.getId(), node.getSource(), node.getTarget(), node.getRowCountSymbol(), node.getFragmentSymbol(), node.getColumns(), node.getColumnNames(), node.getPreferredPartitioningScheme(), Optional.empty()));
    }
}

