/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.cost.TableStatsProvider;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.OperatorNameUtil;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.FunctionCallBuilder;
import io.trino.sql.planner.Partitioning;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.optimizations.PlanOptimizer;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.ApplyNode;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.ChildReplacer;
import io.trino.sql.planner.plan.CorrelatedJoinNode;
import io.trino.sql.planner.plan.DistinctLimitNode;
import io.trino.sql.planner.plan.EnforceSingleRowNode;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.GroupIdNode;
import io.trino.sql.planner.plan.IndexJoinNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.MarkDistinctNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanVisitor;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.RowNumberNode;
import io.trino.sql.planner.plan.SemiJoinNode;
import io.trino.sql.planner.plan.SpatialJoinNode;
import io.trino.sql.planner.plan.TopNRankingNode;
import io.trino.sql.planner.plan.UnionNode;
import io.trino.sql.planner.plan.UnnestNode;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.tree.CoalesceExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.GenericLiteral;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.SymbolReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class HashGenerationOptimizer
implements PlanOptimizer {
    public static final int INITIAL_HASH_VALUE = 0;
    private static final String HASH_CODE = OperatorNameUtil.mangleOperatorName(OperatorType.HASH_CODE);
    private final Metadata metadata;

    public HashGenerationOptimizer(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, TypeProvider types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector, TableStatsProvider tableStatsProvider) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        if (SystemSessionProperties.isOptimizeHashGenerationEnabled(session)) {
            PlanWithProperties result = plan.accept(new Rewriter(session, this.metadata, idAllocator, symbolAllocator, types), new HashComputationSet());
            return result.getNode();
        }
        return plan;
    }

    private static Optional<HashComputation> computeHash(Iterable<Symbol> fields) {
        Objects.requireNonNull(fields, "fields is null");
        ImmutableList symbols = ImmutableList.copyOf(fields);
        if (symbols.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new HashComputation(fields));
    }

    public static Optional<Expression> getHashExpression(Session session, Metadata metadata, SymbolAllocator symbolAllocator, List<Symbol> symbols) {
        if (symbols.isEmpty()) {
            return Optional.empty();
        }
        GenericLiteral result = new GenericLiteral("bigint", String.valueOf(0));
        for (Symbol symbol : symbols) {
            FunctionCall hashField = FunctionCallBuilder.resolve(session, metadata).setName(QualifiedName.of((String)HASH_CODE)).addArgument(symbolAllocator.getTypes().get(symbol), (Expression)new SymbolReference(symbol.getName())).build();
            hashField = new CoalesceExpression((Expression)hashField, (Expression)new LongLiteral(String.valueOf(0)), new Expression[0]);
            result = FunctionCallBuilder.resolve(session, metadata).setName(QualifiedName.of((String)"combine_hash")).addArgument((Type)BigintType.BIGINT, (Expression)result).addArgument((Type)BigintType.BIGINT, (Expression)hashField).build();
        }
        return Optional.of(result);
    }

    private static Map<Symbol, Symbol> computeIdentityTranslations(Map<Symbol, Expression> assignments) {
        HashMap<Symbol, Symbol> outputToInput = new HashMap<Symbol, Symbol>();
        for (Map.Entry<Symbol, Expression> assignment : assignments.entrySet()) {
            if (!(assignment.getValue() instanceof SymbolReference)) continue;
            outputToInput.put(assignment.getKey(), Symbol.from(assignment.getValue()));
        }
        return outputToInput;
    }

    private static class Rewriter
    extends PlanVisitor<PlanWithProperties, HashComputationSet> {
        private final Session session;
        private final Metadata metadata;
        private final PlanNodeIdAllocator idAllocator;
        private final SymbolAllocator symbolAllocator;
        private final TypeProvider types;

        private Rewriter(Session session, Metadata metadata, PlanNodeIdAllocator idAllocator, SymbolAllocator symbolAllocator, TypeProvider types) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
            this.symbolAllocator = Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
            this.types = Objects.requireNonNull(types, "types is null");
        }

        @Override
        protected PlanWithProperties visitPlan(PlanNode node, HashComputationSet parentPreference) {
            return this.planSimpleNodeWithProperties(node, parentPreference);
        }

        @Override
        public PlanWithProperties visitEnforceSingleRow(EnforceSingleRowNode node, HashComputationSet parentPreference) {
            return this.planSimpleNodeWithProperties(node, new HashComputationSet(), true);
        }

        @Override
        public PlanWithProperties visitApply(ApplyNode node, HashComputationSet context) {
            return new PlanWithProperties(node, (Map<HashComputation, Symbol>)ImmutableMap.of());
        }

        @Override
        public PlanWithProperties visitCorrelatedJoin(CorrelatedJoinNode node, HashComputationSet context) {
            return new PlanWithProperties(node, (Map<HashComputation, Symbol>)ImmutableMap.of());
        }

        @Override
        public PlanWithProperties visitAggregation(AggregationNode node, HashComputationSet parentPreference) {
            Optional<HashComputation> groupByHash = Optional.empty();
            if (!node.isStreamable() && !this.canSkipHashGeneration(node.getGroupingKeys())) {
                groupByHash = HashGenerationOptimizer.computeHash(node.getGroupingKeys());
            }
            HashComputationSet requiredHashes = new HashComputationSet(groupByHash);
            PlanWithProperties child = this.planAndEnforce(node.getSource(), requiredHashes, false, requiredHashes);
            Optional<Symbol> hashSymbol = groupByHash.map(child::getRequiredHashSymbol);
            return new PlanWithProperties(AggregationNode.builderFrom(node).setSource(child.getNode()).setHashSymbol(hashSymbol).build(), (Map<HashComputation, Symbol>)(hashSymbol.isPresent() ? ImmutableMap.of((Object)groupByHash.get(), (Object)hashSymbol.get()) : ImmutableMap.of()));
        }

        private boolean canSkipHashGeneration(List<Symbol> partitionSymbols) {
            return partitionSymbols.isEmpty() || partitionSymbols.size() == 1 && this.types.get((Symbol)Iterables.getOnlyElement(partitionSymbols)).equals(BigintType.BIGINT);
        }

        @Override
        public PlanWithProperties visitGroupId(GroupIdNode node, HashComputationSet parentPreference) {
            return this.planSimpleNodeWithProperties(node, parentPreference.pruneSymbols(node.getSource().getOutputSymbols()));
        }

        @Override
        public PlanWithProperties visitDistinctLimit(DistinctLimitNode node, HashComputationSet parentPreference) {
            if (this.canSkipHashGeneration(node.getDistinctSymbols())) {
                return this.planSimpleNodeWithProperties(node, parentPreference);
            }
            Optional<HashComputation> hashComputation = HashGenerationOptimizer.computeHash(node.getDistinctSymbols());
            PlanWithProperties child = this.planAndEnforce(node.getSource(), new HashComputationSet(hashComputation), false, parentPreference.withHashComputation(node, hashComputation));
            Symbol hashSymbol = child.getRequiredHashSymbol(hashComputation.get());
            return new PlanWithProperties(new DistinctLimitNode(node.getId(), child.getNode(), node.getLimit(), node.isPartial(), node.getDistinctSymbols(), Optional.of(hashSymbol)), (Map<HashComputation, Symbol>)ImmutableMap.of((Object)hashComputation.get(), (Object)hashSymbol));
        }

        @Override
        public PlanWithProperties visitMarkDistinct(MarkDistinctNode node, HashComputationSet parentPreference) {
            if (this.canSkipHashGeneration(node.getDistinctSymbols())) {
                return this.planSimpleNodeWithProperties(node, parentPreference, false);
            }
            Optional<HashComputation> hashComputation = HashGenerationOptimizer.computeHash(node.getDistinctSymbols());
            PlanWithProperties child = this.planAndEnforce(node.getSource(), new HashComputationSet(hashComputation), false, parentPreference.withHashComputation(node, hashComputation));
            Symbol hashSymbol = child.getRequiredHashSymbol(hashComputation.get());
            return new PlanWithProperties(new MarkDistinctNode(node.getId(), child.getNode(), node.getMarkerSymbol(), node.getDistinctSymbols(), Optional.of(hashSymbol)), (Map<HashComputation, Symbol>)child.getHashSymbols());
        }

        @Override
        public PlanWithProperties visitRowNumber(RowNumberNode node, HashComputationSet parentPreference) {
            if (node.getPartitionBy().isEmpty()) {
                return this.planSimpleNodeWithProperties(node, parentPreference);
            }
            Optional<HashComputation> hashComputation = HashGenerationOptimizer.computeHash(node.getPartitionBy());
            PlanWithProperties child = this.planAndEnforce(node.getSource(), new HashComputationSet(hashComputation), false, parentPreference.withHashComputation(node, hashComputation));
            Symbol hashSymbol = child.getRequiredHashSymbol(hashComputation.get());
            return new PlanWithProperties(new RowNumberNode(node.getId(), child.getNode(), node.getPartitionBy(), node.isOrderSensitive(), node.getRowNumberSymbol(), node.getMaxRowCountPerPartition(), Optional.of(hashSymbol)), (Map<HashComputation, Symbol>)child.getHashSymbols());
        }

        @Override
        public PlanWithProperties visitTopNRanking(TopNRankingNode node, HashComputationSet parentPreference) {
            if (node.getPartitionBy().isEmpty()) {
                return this.planSimpleNodeWithProperties(node, parentPreference);
            }
            Optional<HashComputation> hashComputation = HashGenerationOptimizer.computeHash(node.getPartitionBy());
            PlanWithProperties child = this.planAndEnforce(node.getSource(), new HashComputationSet(hashComputation), false, parentPreference.withHashComputation(node, hashComputation));
            Symbol hashSymbol = child.getRequiredHashSymbol(hashComputation.get());
            return new PlanWithProperties(new TopNRankingNode(node.getId(), child.getNode(), node.getSpecification(), node.getRankingType(), node.getRankingSymbol(), node.getMaxRankingPerPartition(), node.isPartial(), Optional.of(hashSymbol)), (Map<HashComputation, Symbol>)child.getHashSymbols());
        }

        @Override
        public PlanWithProperties visitJoin(JoinNode node, HashComputationSet parentPreference) {
            List<JoinNode.EquiJoinClause> clauses = node.getCriteria();
            if (clauses.isEmpty()) {
                PlanWithProperties left = this.planAndEnforce(node.getLeft(), new HashComputationSet(), true, new HashComputationSet());
                PlanWithProperties right = this.planAndEnforce(node.getRight(), new HashComputationSet(), true, new HashComputationSet());
                Preconditions.checkState((left.getHashSymbols().isEmpty() && right.getHashSymbols().isEmpty() ? 1 : 0) != 0);
                return new PlanWithProperties(ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)left.getNode(), (Object)right.getNode())), (Map<HashComputation, Symbol>)ImmutableMap.of());
            }
            Optional<HashComputation> leftHashComputation = HashGenerationOptimizer.computeHash(Lists.transform(clauses, JoinNode.EquiJoinClause::getLeft));
            PlanWithProperties left = this.planAndEnforce(node.getLeft(), new HashComputationSet(leftHashComputation), true, new HashComputationSet(leftHashComputation));
            Symbol leftHashSymbol = left.getRequiredHashSymbol(leftHashComputation.get());
            Optional<HashComputation> rightHashComputation = HashGenerationOptimizer.computeHash(Lists.transform(clauses, JoinNode.EquiJoinClause::getRight));
            PlanWithProperties right = this.planAndEnforce(node.getRight(), new HashComputationSet(rightHashComputation), true, new HashComputationSet(rightHashComputation));
            Symbol rightHashSymbol = right.getRequiredHashSymbol(rightHashComputation.get());
            HashMap<HashComputation, Symbol> allHashSymbols = new HashMap<HashComputation, Symbol>();
            if (node.getType() == JoinNode.Type.INNER || node.getType() == JoinNode.Type.LEFT) {
                allHashSymbols.putAll((Map<HashComputation, Symbol>)left.getHashSymbols());
            }
            if (node.getType() == JoinNode.Type.INNER || node.getType() == JoinNode.Type.RIGHT) {
                allHashSymbols.putAll((Map<HashComputation, Symbol>)right.getHashSymbols());
            }
            return this.buildJoinNodeWithPreferredHashes(node, left, right, allHashSymbols, parentPreference, Optional.of(leftHashSymbol), Optional.of(rightHashSymbol));
        }

        private PlanWithProperties buildJoinNodeWithPreferredHashes(JoinNode node, PlanWithProperties left, PlanWithProperties right, Map<HashComputation, Symbol> allHashSymbols, HashComputationSet parentPreference, Optional<Symbol> leftHashSymbol, Optional<Symbol> rightHashSymbol) {
            Map hashSymbolsWithParentPreferences = (Map)allHashSymbols.entrySet().stream().filter(entry -> parentPreference.getHashes().contains(entry.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
            ImmutableSet preferredHashSymbols = ImmutableSet.copyOf(hashSymbolsWithParentPreferences.values());
            ImmutableSet leftOutputSymbols = ImmutableSet.copyOf(node.getLeftOutputSymbols());
            ImmutableSet rightOutputSymbols = ImmutableSet.copyOf(node.getRightOutputSymbols());
            List newLeftOutputSymbols = (List)left.getNode().getOutputSymbols().stream().filter(arg_0 -> Rewriter.lambda$buildJoinNodeWithPreferredHashes$1((Set)leftOutputSymbols, (Set)preferredHashSymbols, arg_0)).collect(ImmutableList.toImmutableList());
            List newRightOutputSymbols = (List)right.getNode().getOutputSymbols().stream().filter(arg_0 -> Rewriter.lambda$buildJoinNodeWithPreferredHashes$2((Set)rightOutputSymbols, (Set)preferredHashSymbols, arg_0)).collect(ImmutableList.toImmutableList());
            return new PlanWithProperties(new JoinNode(node.getId(), node.getType(), left.getNode(), right.getNode(), node.getCriteria(), newLeftOutputSymbols, newRightOutputSymbols, node.isMaySkipOutputDuplicates(), node.getFilter(), leftHashSymbol, rightHashSymbol, node.getDistributionType(), node.isSpillable(), node.getDynamicFilters(), node.getReorderJoinStatsAndCost()), hashSymbolsWithParentPreferences);
        }

        @Override
        public PlanWithProperties visitSemiJoin(SemiJoinNode node, HashComputationSet parentPreference) {
            Optional<HashComputation> sourceHashComputation = HashGenerationOptimizer.computeHash((Iterable<Symbol>)ImmutableList.of((Object)node.getSourceJoinSymbol()));
            PlanWithProperties source = this.planAndEnforce(node.getSource(), new HashComputationSet(sourceHashComputation), true, new HashComputationSet(sourceHashComputation));
            Symbol sourceHashSymbol = source.getRequiredHashSymbol(sourceHashComputation.get());
            Optional<HashComputation> filterHashComputation = HashGenerationOptimizer.computeHash((Iterable<Symbol>)ImmutableList.of((Object)node.getFilteringSourceJoinSymbol()));
            HashComputationSet requiredHashes = new HashComputationSet(filterHashComputation);
            PlanWithProperties filteringSource = this.planAndEnforce(node.getFilteringSource(), requiredHashes, true, requiredHashes);
            Symbol filteringSourceHashSymbol = filteringSource.getRequiredHashSymbol(filterHashComputation.get());
            return new PlanWithProperties(new SemiJoinNode(node.getId(), source.getNode(), filteringSource.getNode(), node.getSourceJoinSymbol(), node.getFilteringSourceJoinSymbol(), node.getSemiJoinOutput(), Optional.of(sourceHashSymbol), Optional.of(filteringSourceHashSymbol), node.getDistributionType(), node.getDynamicFilterId()), (Map<HashComputation, Symbol>)source.getHashSymbols());
        }

        @Override
        public PlanWithProperties visitSpatialJoin(SpatialJoinNode node, HashComputationSet parentPreference) {
            PlanWithProperties left = this.planAndEnforce(node.getLeft(), new HashComputationSet(), true, new HashComputationSet());
            PlanWithProperties right = this.planAndEnforce(node.getRight(), new HashComputationSet(), true, new HashComputationSet());
            Verify.verify((boolean)left.getHashSymbols().isEmpty(), (String)"probe side of the spatial join should not include hash symbols", (Object[])new Object[0]);
            Verify.verify((boolean)right.getHashSymbols().isEmpty(), (String)"build side of the spatial join should not include hash symbols", (Object[])new Object[0]);
            return new PlanWithProperties(ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)left.getNode(), (Object)right.getNode())), (Map<HashComputation, Symbol>)ImmutableMap.of());
        }

        @Override
        public PlanWithProperties visitIndexJoin(IndexJoinNode node, HashComputationSet parentPreference) {
            List<IndexJoinNode.EquiJoinClause> clauses = node.getCriteria();
            Optional<HashComputation> probeHashComputation = HashGenerationOptimizer.computeHash(Lists.transform(clauses, IndexJoinNode.EquiJoinClause::getProbe));
            PlanWithProperties probe = this.planAndEnforce(node.getProbeSource(), new HashComputationSet(probeHashComputation), true, new HashComputationSet(probeHashComputation));
            Symbol probeHashSymbol = probe.getRequiredHashSymbol(probeHashComputation.get());
            Optional<HashComputation> indexHashComputation = HashGenerationOptimizer.computeHash(Lists.transform(clauses, IndexJoinNode.EquiJoinClause::getIndex));
            HashComputationSet requiredHashes = new HashComputationSet(indexHashComputation);
            PlanWithProperties index = this.planAndEnforce(node.getIndexSource(), requiredHashes, true, requiredHashes);
            Symbol indexHashSymbol = index.getRequiredHashSymbol(indexHashComputation.get());
            HashMap<HashComputation, Symbol> allHashSymbols = new HashMap<HashComputation, Symbol>();
            if (node.getType() == IndexJoinNode.Type.INNER) {
                allHashSymbols.putAll((Map<HashComputation, Symbol>)probe.getHashSymbols());
            }
            allHashSymbols.putAll((Map<HashComputation, Symbol>)index.getHashSymbols());
            return new PlanWithProperties(new IndexJoinNode(node.getId(), node.getType(), probe.getNode(), index.getNode(), node.getCriteria(), Optional.of(probeHashSymbol), Optional.of(indexHashSymbol)), allHashSymbols);
        }

        @Override
        public PlanWithProperties visitWindow(WindowNode node, HashComputationSet parentPreference) {
            if (node.getPartitionBy().isEmpty()) {
                return this.planSimpleNodeWithProperties(node, parentPreference, true);
            }
            Optional<HashComputation> hashComputation = HashGenerationOptimizer.computeHash(node.getPartitionBy());
            PlanWithProperties child = this.planAndEnforce(node.getSource(), new HashComputationSet(hashComputation), true, parentPreference.withHashComputation(node, hashComputation));
            Symbol hashSymbol = child.getRequiredHashSymbol(hashComputation.get());
            return new PlanWithProperties(new WindowNode(node.getId(), child.getNode(), node.getSpecification(), node.getWindowFunctions(), Optional.of(hashSymbol), node.getPrePartitionedInputs(), node.getPreSortedOrderPrefix()), (Map<HashComputation, Symbol>)child.getHashSymbols());
        }

        @Override
        public PlanWithProperties visitExchange(ExchangeNode node, HashComputationSet parentPreference) {
            HashComputationSet preference = parentPreference.pruneSymbols(node.getOutputSymbols());
            Optional<HashComputation> partitionSymbols = Optional.empty();
            PartitioningScheme partitioningScheme = node.getPartitioningScheme();
            PartitioningHandle partitioningHandle = partitioningScheme.getPartitioning().getHandle();
            if ((partitioningHandle.equals(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION) || partitioningHandle.equals(SystemPartitioningHandle.SCALED_WRITER_HASH_DISTRIBUTION)) && partitioningScheme.getPartitioning().getArguments().stream().allMatch(Partitioning.ArgumentBinding::isVariable)) {
                partitionSymbols = HashGenerationOptimizer.computeHash((Iterable)partitioningScheme.getPartitioning().getArguments().stream().map(Partitioning.ArgumentBinding::getColumn).collect(ImmutableList.toImmutableList()));
                preference = preference.withHashComputation(partitionSymbols);
            }
            ImmutableList hashSymbolOrder = ImmutableList.copyOf(preference.getHashes());
            HashMap<HashComputation, Symbol> newHashSymbols = new HashMap<HashComputation, Symbol>();
            for (HashComputation preferredHashSymbol : hashSymbolOrder) {
                newHashSymbols.put(preferredHashSymbol, this.symbolAllocator.newHashSymbol());
            }
            partitioningScheme = new PartitioningScheme(partitioningScheme.getPartitioning(), (List<Symbol>)ImmutableList.builder().addAll(partitioningScheme.getOutputLayout()).addAll((Iterable)hashSymbolOrder.stream().map(newHashSymbols::get).collect(ImmutableList.toImmutableList())).build(), partitionSymbols.map(newHashSymbols::get), partitioningScheme.isReplicateNullsAndAny(), partitioningScheme.getBucketToPartition(), partitioningScheme.getPartitionCount());
            ImmutableList.Builder newInputs = ImmutableList.builder();
            ImmutableList.Builder newSources = ImmutableList.builder();
            for (int sourceId = 0; sourceId < node.getSources().size(); ++sourceId) {
                PlanNode source = node.getSources().get(sourceId);
                List<Symbol> inputSymbols = node.getInputs().get(sourceId);
                HashMap<Symbol, Symbol> outputToInputMap = new HashMap<Symbol, Symbol>();
                for (int symbolId = 0; symbolId < inputSymbols.size(); ++symbolId) {
                    outputToInputMap.put(node.getOutputSymbols().get(symbolId), inputSymbols.get(symbolId));
                }
                Function<Symbol, Optional<Symbol>> outputToInputTranslator = symbol -> Optional.of((Symbol)outputToInputMap.get(symbol));
                HashComputationSet sourceContext = preference.translate(outputToInputTranslator);
                PlanWithProperties child = this.planAndEnforce(source, sourceContext, true, sourceContext);
                newSources.add((Object)child.getNode());
                ImmutableList.Builder newInputSymbols = ImmutableList.builder();
                newInputSymbols.addAll((Iterable)node.getInputs().get(sourceId));
                for (HashComputation preferredHashSymbol : hashSymbolOrder) {
                    HashComputation hashComputation = preferredHashSymbol.translate(outputToInputTranslator).get();
                    newInputSymbols.add((Object)child.getRequiredHashSymbol(hashComputation));
                }
                newInputs.add((Object)newInputSymbols.build());
            }
            return new PlanWithProperties(new ExchangeNode(node.getId(), node.getType(), node.getScope(), partitioningScheme, (List<PlanNode>)newSources.build(), (List<List<Symbol>>)newInputs.build(), node.getOrderingScheme()), newHashSymbols);
        }

        @Override
        public PlanWithProperties visitUnion(UnionNode node, HashComputationSet parentPreference) {
            HashComputationSet preference = parentPreference.pruneSymbols(node.getOutputSymbols());
            HashMap<HashComputation, Symbol> newHashSymbols = new HashMap<HashComputation, Symbol>();
            for (HashComputation preferredHashSymbol : preference.getHashes()) {
                newHashSymbols.put(preferredHashSymbol, this.symbolAllocator.newHashSymbol());
            }
            ImmutableListMultimap.Builder newSymbolMapping = ImmutableListMultimap.builder();
            newSymbolMapping.putAll(node.getSymbolMapping());
            ImmutableList.Builder newSources = ImmutableList.builder();
            for (int sourceId = 0; sourceId < node.getSources().size(); ++sourceId) {
                HashMap<Symbol, Symbol> outputToInputMap = new HashMap<Symbol, Symbol>();
                for (Symbol outputSymbol : node.getOutputSymbols()) {
                    outputToInputMap.put(outputSymbol, (Symbol)node.getSymbolMapping().get((Object)outputSymbol).get(sourceId));
                }
                Function<Symbol, Optional<Symbol>> outputToInputTranslator = symbol -> Optional.of((Symbol)outputToInputMap.get(symbol));
                HashComputationSet sourcePreference = preference.translate(outputToInputTranslator);
                PlanWithProperties child = this.planAndEnforce(node.getSources().get(sourceId), sourcePreference, true, sourcePreference);
                newSources.add((Object)child.getNode());
                for (Map.Entry entry : newHashSymbols.entrySet()) {
                    HashComputation hashComputation = ((HashComputation)entry.getKey()).translate(outputToInputTranslator).get();
                    newSymbolMapping.put((Object)((Symbol)entry.getValue()), (Object)child.getRequiredHashSymbol(hashComputation));
                }
            }
            return new PlanWithProperties(new UnionNode(node.getId(), (List<PlanNode>)newSources.build(), (ListMultimap<Symbol, Symbol>)newSymbolMapping.build(), (List<Symbol>)ImmutableList.copyOf((Collection)newSymbolMapping.build().keySet())), newHashSymbols);
        }

        @Override
        public PlanWithProperties visitProject(ProjectNode node, HashComputationSet parentPreference) {
            Map<Symbol, Symbol> outputToInputMapping = HashGenerationOptimizer.computeIdentityTranslations(node.getAssignments().getMap());
            HashComputationSet sourceContext = parentPreference.translate(symbol -> Optional.ofNullable((Symbol)outputToInputMapping.get(symbol)));
            PlanWithProperties child = this.plan(node.getSource(), sourceContext);
            Assignments.Builder newAssignments = Assignments.builder();
            newAssignments.putAll(node.getAssignments());
            HashMap<HashComputation, Symbol> allHashSymbols = new HashMap<HashComputation, Symbol>();
            for (HashComputation hashComputation : sourceContext.getHashes()) {
                SymbolReference hashExpression;
                Symbol hashSymbol = (Symbol)child.getHashSymbols().get((Object)hashComputation);
                if (hashSymbol == null) {
                    hashSymbol = this.symbolAllocator.newHashSymbol();
                    hashExpression = hashComputation.getHashExpression(this.session, this.metadata, this.types);
                } else {
                    hashExpression = hashSymbol.toSymbolReference();
                }
                newAssignments.put(hashSymbol, (Expression)hashExpression);
                for (HashComputation sourceHashComputation : sourceContext.lookup(hashComputation)) {
                    allHashSymbols.put(sourceHashComputation, hashSymbol);
                }
            }
            return new PlanWithProperties(new ProjectNode(node.getId(), child.getNode(), newAssignments.build()), allHashSymbols);
        }

        @Override
        public PlanWithProperties visitUnnest(UnnestNode node, HashComputationSet parentPreference) {
            PlanWithProperties child = this.plan(node.getSource(), parentPreference.pruneSymbols(node.getSource().getOutputSymbols()));
            HashMap<HashComputation, Symbol> hashSymbols = new HashMap<HashComputation, Symbol>((Map<HashComputation, Symbol>)child.getHashSymbols());
            hashSymbols.keySet().retainAll(parentPreference.getHashes());
            return new PlanWithProperties(new UnnestNode(node.getId(), child.getNode(), (List<Symbol>)ImmutableList.builder().addAll(node.getReplicateSymbols()).addAll(hashSymbols.values()).build(), node.getMappings(), node.getOrdinalitySymbol(), node.getJoinType(), node.getFilter()), hashSymbols);
        }

        private PlanWithProperties planSimpleNodeWithProperties(PlanNode node, HashComputationSet preferredHashes) {
            return this.planSimpleNodeWithProperties(node, preferredHashes, true);
        }

        private PlanWithProperties planSimpleNodeWithProperties(PlanNode node, HashComputationSet preferredHashes, boolean alwaysPruneExtraHashSymbols) {
            if (node.getSources().isEmpty()) {
                return new PlanWithProperties(node, (Map<HashComputation, Symbol>)ImmutableMap.of());
            }
            PlanWithProperties source = this.planAndEnforce((PlanNode)Iterables.getOnlyElement(node.getSources()), new HashComputationSet(), alwaysPruneExtraHashSymbols, preferredHashes);
            PlanNode result = ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)source.getNode()));
            HashMap<HashComputation, Symbol> hashSymbols = new HashMap<HashComputation, Symbol>((Map<HashComputation, Symbol>)source.getHashSymbols());
            hashSymbols.values().retainAll(result.getOutputSymbols());
            return new PlanWithProperties(result, hashSymbols);
        }

        private PlanWithProperties planAndEnforce(PlanNode node, HashComputationSet requiredHashes, boolean pruneExtraHashSymbols, HashComputationSet preferredHashes) {
            boolean preferenceSatisfied;
            PlanWithProperties result = this.plan(node, preferredHashes);
            if (pruneExtraHashSymbols) {
                Set resultHashes = result.getHashSymbols().keySet();
                ImmutableSet requiredAndPreferredHashes = ImmutableSet.builder().addAll(requiredHashes.getHashes()).addAll(preferredHashes.getHashes()).build();
                preferenceSatisfied = resultHashes.containsAll(requiredHashes.getHashes()) && requiredAndPreferredHashes.containsAll(resultHashes);
            } else {
                preferenceSatisfied = result.getHashSymbols().keySet().containsAll(requiredHashes.getHashes());
            }
            if (preferenceSatisfied) {
                return result;
            }
            return this.enforce(result, requiredHashes);
        }

        private PlanWithProperties enforce(PlanWithProperties planWithProperties, HashComputationSet requiredHashes) {
            Assignments.Builder assignments = Assignments.builder();
            HashMap<HashComputation, Symbol> outputHashSymbols = new HashMap<HashComputation, Symbol>();
            BiMap resultHashSymbols = planWithProperties.getHashSymbols().inverse();
            for (Symbol symbol : planWithProperties.getNode().getOutputSymbols()) {
                HashComputation partitionSymbols = (HashComputation)resultHashSymbols.get(symbol);
                if (partitionSymbols != null && !requiredHashes.getHashes().contains(partitionSymbols)) continue;
                assignments.put(symbol, (Expression)symbol.toSymbolReference());
                if (partitionSymbols == null) continue;
                outputHashSymbols.put(partitionSymbols, symbol);
            }
            for (HashComputation hashComputation : requiredHashes.getHashes()) {
                if (planWithProperties.getHashSymbols().containsKey((Object)hashComputation)) continue;
                Expression hashExpression = hashComputation.getHashExpression(this.session, this.metadata, this.types);
                Symbol hashSymbol = this.symbolAllocator.newHashSymbol();
                assignments.put(hashSymbol, hashExpression);
                outputHashSymbols.put(hashComputation, hashSymbol);
            }
            ProjectNode projectNode = new ProjectNode(this.idAllocator.getNextId(), planWithProperties.getNode(), assignments.build());
            return new PlanWithProperties(projectNode, outputHashSymbols);
        }

        private PlanWithProperties plan(PlanNode node, HashComputationSet parentPreference) {
            PlanWithProperties result = node.accept(this, parentPreference);
            Preconditions.checkState((boolean)result.getNode().getOutputSymbols().containsAll(result.getHashSymbols().values()), (String)"Node %s declares hash symbols not in the output", (Object)result.getNode().getClass().getSimpleName());
            return result;
        }

        private static /* synthetic */ boolean lambda$buildJoinNodeWithPreferredHashes$2(Set rightOutputSymbols, Set preferredHashSymbols, Symbol symbol) {
            return rightOutputSymbols.contains(symbol) || preferredHashSymbols.contains(symbol);
        }

        private static /* synthetic */ boolean lambda$buildJoinNodeWithPreferredHashes$1(Set leftOutputSymbols, Set preferredHashSymbols, Symbol symbol) {
            return leftOutputSymbols.contains(symbol) || preferredHashSymbols.contains(symbol);
        }
    }

    private static class HashComputationSet {
        private final Multimap<HashComputation, HashComputation> hashes;

        public HashComputationSet() {
            this.hashes = ImmutableSetMultimap.of();
        }

        public HashComputationSet(Optional<HashComputation> hash) {
            Objects.requireNonNull(hash, "hash is null");
            this.hashes = hash.isPresent() ? ImmutableSetMultimap.of((Object)hash.get(), (Object)hash.get()) : ImmutableSetMultimap.of();
        }

        private HashComputationSet(Multimap<HashComputation, HashComputation> hashes) {
            Objects.requireNonNull(hashes, "hashes is null");
            this.hashes = ImmutableSetMultimap.copyOf(hashes);
        }

        public Set<HashComputation> getHashes() {
            return this.hashes.keySet();
        }

        public HashComputationSet pruneSymbols(List<Symbol> symbols) {
            ImmutableSet uniqueSymbols = ImmutableSet.copyOf(symbols);
            ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
            this.hashes.keySet().stream().filter(arg_0 -> HashComputationSet.lambda$pruneSymbols$0((Set)uniqueSymbols, arg_0)).forEach(hash -> builder.putAll(hash, (Iterable)this.hashes.get(hash)));
            return new HashComputationSet((Multimap<HashComputation, HashComputation>)builder.build());
        }

        public HashComputationSet translate(Function<Symbol, Optional<Symbol>> translator) {
            ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
            for (HashComputation hashComputation : this.hashes.keySet()) {
                hashComputation.translate(translator).ifPresent(hash -> builder.put(hash, (Object)hashComputation));
            }
            return new HashComputationSet((Multimap<HashComputation, HashComputation>)builder.build());
        }

        public Collection<HashComputation> lookup(HashComputation hashComputation) {
            return this.hashes.get((Object)hashComputation);
        }

        public HashComputationSet withHashComputation(PlanNode node, Optional<HashComputation> hashComputation) {
            return this.pruneSymbols(node.getOutputSymbols()).withHashComputation(hashComputation);
        }

        public HashComputationSet withHashComputation(Optional<HashComputation> hashComputation) {
            if (hashComputation.isEmpty() || this.hashes.containsKey((Object)hashComputation.get())) {
                return this;
            }
            return new HashComputationSet((Multimap<HashComputation, HashComputation>)ImmutableSetMultimap.builder().putAll(this.hashes).put((Object)hashComputation.get(), (Object)hashComputation.get()).build());
        }

        private static /* synthetic */ boolean lambda$pruneSymbols$0(Set uniqueSymbols, HashComputation hash) {
            return hash.canComputeWith(uniqueSymbols);
        }
    }

    private static class PlanWithProperties {
        private final PlanNode node;
        private final BiMap<HashComputation, Symbol> hashSymbols;

        public PlanWithProperties(PlanNode node, Map<HashComputation, Symbol> hashSymbols) {
            this.node = Objects.requireNonNull(node, "node is null");
            this.hashSymbols = ImmutableBiMap.copyOf(Objects.requireNonNull(hashSymbols, "hashSymbols is null"));
        }

        public PlanNode getNode() {
            return this.node;
        }

        public BiMap<HashComputation, Symbol> getHashSymbols() {
            return this.hashSymbols;
        }

        public Symbol getRequiredHashSymbol(HashComputation hash) {
            Symbol hashSymbol = (Symbol)this.hashSymbols.get((Object)hash);
            Objects.requireNonNull(hashSymbol, () -> "No hash symbol generated for " + hash);
            return hashSymbol;
        }
    }

    private static class HashComputation {
        private final List<Symbol> fields;

        private HashComputation(Iterable<Symbol> fields) {
            Objects.requireNonNull(fields, "fields is null");
            this.fields = ImmutableList.copyOf(fields);
            Preconditions.checkArgument((!this.fields.isEmpty() ? 1 : 0) != 0, (Object)"fields cannot be empty");
        }

        public List<Symbol> getFields() {
            return this.fields;
        }

        public Optional<HashComputation> translate(Function<Symbol, Optional<Symbol>> translator) {
            ImmutableList.Builder newSymbols = ImmutableList.builder();
            for (Symbol field : this.fields) {
                Optional<Symbol> newSymbol = translator.apply(field);
                if (newSymbol.isEmpty()) {
                    return Optional.empty();
                }
                newSymbols.add((Object)newSymbol.get());
            }
            return HashGenerationOptimizer.computeHash((Iterable<Symbol>)newSymbols.build());
        }

        public boolean canComputeWith(Set<Symbol> availableFields) {
            return availableFields.containsAll(this.fields);
        }

        private Expression getHashExpression(Session session, Metadata metadata, TypeProvider types) {
            GenericLiteral hashExpression = new GenericLiteral("bigint", Integer.toString(0));
            for (Symbol field : this.fields) {
                hashExpression = HashComputation.getHashFunctionCall(session, (Expression)hashExpression, field, metadata, types);
            }
            return hashExpression;
        }

        private static Expression getHashFunctionCall(Session session, Expression previousHashValue, Symbol symbol, Metadata metadata, TypeProvider types) {
            FunctionCall functionCall = FunctionCallBuilder.resolve(session, metadata).setName(QualifiedName.of((String)HASH_CODE)).addArgument(types.get(symbol), (Expression)symbol.toSymbolReference()).build();
            return FunctionCallBuilder.resolve(session, metadata).setName(QualifiedName.of((String)"combine_hash")).addArgument((Type)BigintType.BIGINT, previousHashValue).addArgument((Type)BigintType.BIGINT, HashComputation.orNullHashCode((Expression)functionCall)).build();
        }

        private static Expression orNullHashCode(Expression expression) {
            return new CoalesceExpression(expression, (Expression)new LongLiteral(String.valueOf(0)), new Expression[0]);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HashComputation that = (HashComputation)o;
            return Objects.equals(this.fields, that.fields);
        }

        public int hashCode() {
            return Objects.hash(this.fields);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("fields", this.fields).toString();
        }
    }
}

