/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.statistics.ColumnStatisticMetadata;
import io.trino.spi.statistics.TableStatisticType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class StatisticAggregationsDescriptor<T> {
    private final Map<String, T> grouping;
    private final Map<TableStatisticType, T> tableStatistics;
    private final Map<ColumnStatisticMetadata, T> columnStatistics;

    public static <T> StatisticAggregationsDescriptor<T> empty() {
        return StatisticAggregationsDescriptor.builder().build();
    }

    public StatisticAggregationsDescriptor(Map<String, T> grouping, Map<TableStatisticType, T> tableStatistics, Map<ColumnStatisticMetadata, T> columnStatistics) {
        this.grouping = ImmutableMap.copyOf(Objects.requireNonNull(grouping, "grouping is null"));
        this.tableStatistics = ImmutableMap.copyOf(Objects.requireNonNull(tableStatistics, "tableStatistics is null"));
        this.columnStatistics = ImmutableMap.copyOf(Objects.requireNonNull(columnStatistics, "columnStatistics is null"));
    }

    @JsonCreator
    @Deprecated
    public static <T> StatisticAggregationsDescriptor<T> fromJson(@JsonProperty(value="grouping") Map<String, T> grouping, @JsonProperty(value="tableStatistics") Map<TableStatisticType, T> tableStatistics, @JsonProperty(value="columnStatisticsList") List<ColumnStatisticAggregationsDescriptor<T>> columnStatistics) {
        return new StatisticAggregationsDescriptor<T>(grouping, tableStatistics, (Map)columnStatistics.stream().collect(ImmutableMap.toImmutableMap(ColumnStatisticAggregationsDescriptor::metadata, ColumnStatisticAggregationsDescriptor::input)));
    }

    @JsonProperty
    public Map<String, T> getGrouping() {
        return this.grouping;
    }

    @JsonProperty
    public Map<TableStatisticType, T> getTableStatistics() {
        return this.tableStatistics;
    }

    @JsonIgnore
    public Map<ColumnStatisticMetadata, T> getColumnStatistics() {
        return this.columnStatistics;
    }

    @JsonProperty
    @Deprecated
    public List<ColumnStatisticAggregationsDescriptor<T>> getColumnStatisticsList() {
        return (List)this.columnStatistics.entrySet().stream().map((? super T entry) -> new ColumnStatisticAggregationsDescriptor((ColumnStatisticMetadata)entry.getKey(), entry.getValue())).collect(ImmutableList.toImmutableList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatisticAggregationsDescriptor that = (StatisticAggregationsDescriptor)o;
        return Objects.equals(this.grouping, that.grouping) && Objects.equals(this.tableStatistics, that.tableStatistics) && Objects.equals(this.columnStatistics, that.columnStatistics);
    }

    public int hashCode() {
        return Objects.hash(this.grouping, this.tableStatistics, this.columnStatistics);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("grouping", this.grouping).add("tableStatistics", this.tableStatistics).add("columnStatistics", this.columnStatistics).toString();
    }

    public static <B> Builder<B> builder() {
        return new Builder();
    }

    public <T2> StatisticAggregationsDescriptor<T2> map(Function<T, T2> mapper) {
        return new StatisticAggregationsDescriptor<T2>(StatisticAggregationsDescriptor.map(this.getGrouping(), mapper), StatisticAggregationsDescriptor.map(this.getTableStatistics(), mapper), StatisticAggregationsDescriptor.map(this.getColumnStatistics(), mapper));
    }

    private static <K, V1, V2> Map<K, V2> map(Map<K, V1> input, Function<V1, V2> mapper) {
        return (Map)input.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> mapper.apply(entry.getValue())));
    }

    public static class Builder<T> {
        private final ImmutableMap.Builder<String, T> grouping = ImmutableMap.builder();
        private final ImmutableMap.Builder<TableStatisticType, T> tableStatistics = ImmutableMap.builder();
        private final ImmutableMap.Builder<ColumnStatisticMetadata, T> columnStatistics = ImmutableMap.builder();

        public void addGrouping(String column, T key) {
            this.grouping.put((Object)column, key);
        }

        public void addTableStatistic(TableStatisticType type, T key) {
            this.tableStatistics.put((Object)type, key);
        }

        public void addColumnStatistic(ColumnStatisticMetadata statisticMetadata, T key) {
            this.columnStatistics.put((Object)statisticMetadata, key);
        }

        public StatisticAggregationsDescriptor<T> build() {
            return new StatisticAggregationsDescriptor(this.grouping.buildOrThrow(), this.tableStatistics.buildOrThrow(), this.columnStatistics.buildOrThrow());
        }
    }

    public record ColumnStatisticAggregationsDescriptor<T>(ColumnStatisticMetadata metadata, T input) {
    }
}

