/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.Session;
import io.trino.metadata.InsertTableHandle;
import io.trino.metadata.MergeHandle;
import io.trino.metadata.Metadata;
import io.trino.metadata.OutputTableHandle;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TableExecuteHandle;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TableLayout;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.RowChangeParadigm;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.Type;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.PlanVisitor;
import io.trino.sql.planner.plan.StatisticAggregations;
import io.trino.sql.planner.plan.StatisticAggregationsDescriptor;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.concurrent.Immutable;

@Immutable
public class TableWriterNode
extends PlanNode {
    private final PlanNode source;
    private final WriterTarget target;
    private final Symbol rowCountSymbol;
    private final Symbol fragmentSymbol;
    private final List<Symbol> columns;
    private final List<String> columnNames;
    private final Optional<PartitioningScheme> partitioningScheme;
    private final Optional<PartitioningScheme> preferredPartitioningScheme;
    private final Optional<StatisticAggregations> statisticsAggregation;
    private final Optional<StatisticAggregationsDescriptor<Symbol>> statisticsAggregationDescriptor;
    private final List<Symbol> outputs;

    @JsonCreator
    public TableWriterNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="target") WriterTarget target, @JsonProperty(value="rowCountSymbol") Symbol rowCountSymbol, @JsonProperty(value="fragmentSymbol") Symbol fragmentSymbol, @JsonProperty(value="columns") List<Symbol> columns, @JsonProperty(value="columnNames") List<String> columnNames, @JsonProperty(value="partitioningScheme") Optional<PartitioningScheme> partitioningScheme, @JsonProperty(value="preferredPartitioningScheme") Optional<PartitioningScheme> preferredPartitioningScheme, @JsonProperty(value="statisticsAggregation") Optional<StatisticAggregations> statisticsAggregation, @JsonProperty(value="statisticsAggregationDescriptor") Optional<StatisticAggregationsDescriptor<Symbol>> statisticsAggregationDescriptor) {
        super(id);
        Objects.requireNonNull(columns, "columns is null");
        Objects.requireNonNull(columnNames, "columnNames is null");
        Preconditions.checkArgument((columns.size() == columnNames.size() ? 1 : 0) != 0, (Object)"columns and columnNames sizes don't match");
        this.source = Objects.requireNonNull(source, "source is null");
        this.target = Objects.requireNonNull(target, "target is null");
        this.rowCountSymbol = Objects.requireNonNull(rowCountSymbol, "rowCountSymbol is null");
        this.fragmentSymbol = Objects.requireNonNull(fragmentSymbol, "fragmentSymbol is null");
        this.columns = ImmutableList.copyOf(columns);
        this.columnNames = ImmutableList.copyOf(columnNames);
        this.partitioningScheme = Objects.requireNonNull(partitioningScheme, "partitioningScheme is null");
        this.preferredPartitioningScheme = Objects.requireNonNull(preferredPartitioningScheme, "preferredPartitioningScheme is null");
        this.statisticsAggregation = Objects.requireNonNull(statisticsAggregation, "statisticsAggregation is null");
        this.statisticsAggregationDescriptor = Objects.requireNonNull(statisticsAggregationDescriptor, "statisticsAggregationDescriptor is null");
        Preconditions.checkArgument((statisticsAggregation.isPresent() == statisticsAggregationDescriptor.isPresent() ? 1 : 0) != 0, (Object)"statisticsAggregation and statisticsAggregationDescriptor must be either present or absent");
        Preconditions.checkArgument((partitioningScheme.isEmpty() || preferredPartitioningScheme.isEmpty() ? 1 : 0) != 0, (Object)"Both partitioningScheme and preferredPartitioningScheme cannot be present");
        ImmutableList.Builder outputs = ImmutableList.builder().add((Object)rowCountSymbol).add((Object)fragmentSymbol);
        statisticsAggregation.ifPresent(aggregation -> {
            outputs.addAll(aggregation.getGroupingSymbols());
            outputs.addAll(aggregation.getAggregations().keySet());
        });
        this.outputs = outputs.build();
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public WriterTarget getTarget() {
        return this.target;
    }

    @JsonProperty
    public Symbol getRowCountSymbol() {
        return this.rowCountSymbol;
    }

    @JsonProperty
    public Symbol getFragmentSymbol() {
        return this.fragmentSymbol;
    }

    @JsonProperty
    public List<Symbol> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @JsonProperty
    public Optional<PartitioningScheme> getPartitioningScheme() {
        return this.partitioningScheme;
    }

    @JsonProperty
    public Optional<PartitioningScheme> getPreferredPartitioningScheme() {
        return this.preferredPartitioningScheme;
    }

    @JsonProperty
    public Optional<StatisticAggregations> getStatisticsAggregation() {
        return this.statisticsAggregation;
    }

    @JsonProperty
    public Optional<StatisticAggregationsDescriptor<Symbol>> getStatisticsAggregationDescriptor() {
        return this.statisticsAggregationDescriptor;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return this.outputs;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitTableWriter(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new TableWriterNode(this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.target, this.rowCountSymbol, this.fragmentSymbol, this.columns, this.columnNames, this.partitioningScheme, this.preferredPartitioningScheme, this.statisticsAggregation, this.statisticsAggregationDescriptor);
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="@type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=CreateTarget.class, name="CreateTarget"), @JsonSubTypes.Type(value=InsertTarget.class, name="InsertTarget"), @JsonSubTypes.Type(value=MergeTarget.class, name="MergeTarget"), @JsonSubTypes.Type(value=RefreshMaterializedViewTarget.class, name="RefreshMaterializedViewTarget"), @JsonSubTypes.Type(value=TableExecuteTarget.class, name="TableExecuteTarget")})
    public static abstract class WriterTarget {
        public abstract String toString();

        public abstract boolean supportsReportingWrittenBytes(Metadata var1, Session var2);

        public abstract boolean supportsMultipleWritersPerPartition(Metadata var1, Session var2);

        public abstract OptionalInt getMaxWriterTasks(Metadata var1, Session var2);
    }

    public static class MergeParadigmAndTypes {
        private final Optional<RowChangeParadigm> paradigm;
        private final List<Type> columnTypes;
        private final List<String> columnNames;
        private final Type rowIdType;

        @JsonCreator
        public MergeParadigmAndTypes(@JsonProperty(value="paradigm") Optional<RowChangeParadigm> paradigm, @JsonProperty(value="columnTypes") List<Type> columnTypes, @JsonProperty(value="columnNames") List<String> columnNames, @JsonProperty(value="rowIdType") Type rowIdType) {
            this.paradigm = Objects.requireNonNull(paradigm, "paradigm is null");
            this.columnTypes = Objects.requireNonNull(columnTypes, "columnTypes is null");
            this.columnNames = Objects.requireNonNull(columnNames, "columnNames is null");
            this.rowIdType = Objects.requireNonNull(rowIdType, "rowIdType is null");
        }

        @JsonProperty
        public Optional<RowChangeParadigm> getParadigm() {
            return this.paradigm;
        }

        @JsonProperty
        public List<Type> getColumnTypes() {
            return this.columnTypes;
        }

        @JsonProperty
        public List<String> getColumnNames() {
            return this.columnNames;
        }

        @JsonProperty
        public Type getRowIdType() {
            return this.rowIdType;
        }
    }

    public static class MergeTarget
    extends WriterTarget {
        private final TableHandle handle;
        private final Optional<MergeHandle> mergeHandle;
        private final SchemaTableName schemaTableName;
        private final MergeParadigmAndTypes mergeParadigmAndTypes;

        @JsonCreator
        public MergeTarget(@JsonProperty(value="handle") TableHandle handle, @JsonProperty(value="mergeHandle") Optional<MergeHandle> mergeHandle, @JsonProperty(value="schemaTableName") SchemaTableName schemaTableName, @JsonProperty(value="mergeParadigmAndTypes") MergeParadigmAndTypes mergeParadigmAndTypes) {
            this.handle = Objects.requireNonNull(handle, "handle is null");
            this.mergeHandle = Objects.requireNonNull(mergeHandle, "mergeHandle is null");
            this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
            this.mergeParadigmAndTypes = Objects.requireNonNull(mergeParadigmAndTypes, "mergeElements is null");
        }

        @JsonProperty
        public TableHandle getHandle() {
            return this.handle;
        }

        @JsonProperty
        public Optional<MergeHandle> getMergeHandle() {
            return this.mergeHandle;
        }

        @JsonProperty
        public SchemaTableName getSchemaTableName() {
            return this.schemaTableName;
        }

        @JsonProperty
        public MergeParadigmAndTypes getMergeParadigmAndTypes() {
            return this.mergeParadigmAndTypes;
        }

        @Override
        public String toString() {
            return this.handle.toString();
        }

        @Override
        public boolean supportsReportingWrittenBytes(Metadata metadata, Session session) {
            return false;
        }

        @Override
        public boolean supportsMultipleWritersPerPartition(Metadata metadata, Session session) {
            return false;
        }

        @Override
        public OptionalInt getMaxWriterTasks(Metadata metadata, Session session) {
            return OptionalInt.empty();
        }
    }

    public static class TableExecuteTarget
    extends WriterTarget {
        private final TableExecuteHandle executeHandle;
        private final Optional<TableHandle> sourceHandle;
        private final SchemaTableName schemaTableName;
        private final boolean reportingWrittenBytesSupported;

        @JsonCreator
        public TableExecuteTarget(@JsonProperty(value="executeHandle") TableExecuteHandle executeHandle, @JsonProperty(value="sourceHandle") Optional<TableHandle> sourceHandle, @JsonProperty(value="schemaTableName") SchemaTableName schemaTableName, @JsonProperty(value="reportingWrittenBytesSupported") boolean reportingWrittenBytesSupported) {
            this.executeHandle = Objects.requireNonNull(executeHandle, "handle is null");
            this.sourceHandle = Objects.requireNonNull(sourceHandle, "sourceHandle is null");
            this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
            this.reportingWrittenBytesSupported = reportingWrittenBytesSupported;
        }

        @JsonProperty
        public TableExecuteHandle getExecuteHandle() {
            return this.executeHandle;
        }

        @JsonProperty
        public Optional<TableHandle> getSourceHandle() {
            return this.sourceHandle;
        }

        public TableHandle getMandatorySourceHandle() {
            return this.sourceHandle.orElseThrow();
        }

        @JsonProperty
        public SchemaTableName getSchemaTableName() {
            return this.schemaTableName;
        }

        @JsonProperty
        public boolean isReportingWrittenBytesSupported() {
            return this.reportingWrittenBytesSupported;
        }

        @Override
        public String toString() {
            return this.executeHandle.toString();
        }

        @Override
        public boolean supportsReportingWrittenBytes(Metadata metadata, Session session) {
            return this.sourceHandle.map(tableHandle -> metadata.supportsReportingWrittenBytes(session, (TableHandle)tableHandle)).orElse(this.reportingWrittenBytesSupported);
        }

        @Override
        public boolean supportsMultipleWritersPerPartition(Metadata metadata, Session session) {
            return metadata.getLayoutForTableExecute(session, this.executeHandle).map(layout -> layout.getLayout().supportsMultipleWritersPerPartition()).orElse(true);
        }

        @Override
        public OptionalInt getMaxWriterTasks(Metadata metadata, Session session) {
            return metadata.getMaxWriterTasks(session, this.executeHandle.getCatalogHandle().getCatalogName());
        }
    }

    public static class UpdateTarget
    extends WriterTarget {
        private final Optional<TableHandle> handle;
        private final SchemaTableName schemaTableName;
        private final List<String> updatedColumns;
        private final List<ColumnHandle> updatedColumnHandles;

        @JsonCreator
        public UpdateTarget(@JsonProperty(value="handle") Optional<TableHandle> handle, @JsonProperty(value="schemaTableName") SchemaTableName schemaTableName, @JsonProperty(value="updatedColumns") List<String> updatedColumns, @JsonProperty(value="updatedColumnHandles") List<ColumnHandle> updatedColumnHandles) {
            this.handle = Objects.requireNonNull(handle, "handle is null");
            this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
            Preconditions.checkArgument((updatedColumns.size() == updatedColumnHandles.size() ? 1 : 0) != 0, (String)"updatedColumns size %s must equal updatedColumnHandles size %s", (int)updatedColumns.size(), (int)updatedColumnHandles.size());
            this.updatedColumns = Objects.requireNonNull(updatedColumns, "updatedColumns is null");
            this.updatedColumnHandles = Objects.requireNonNull(updatedColumnHandles, "updatedColumnHandles is null");
        }

        @JsonProperty
        public Optional<TableHandle> getHandle() {
            return this.handle;
        }

        @JsonIgnore
        public TableHandle getHandleOrElseThrow() {
            return this.handle.orElseThrow(() -> new IllegalStateException("UpdateTarge does not contain handle"));
        }

        @JsonProperty
        public SchemaTableName getSchemaTableName() {
            return this.schemaTableName;
        }

        @JsonProperty
        public List<String> getUpdatedColumns() {
            return this.updatedColumns;
        }

        @JsonProperty
        public List<ColumnHandle> getUpdatedColumnHandles() {
            return this.updatedColumnHandles;
        }

        @Override
        public String toString() {
            return this.handle.map(Object::toString).orElse("[]");
        }

        @Override
        public boolean supportsReportingWrittenBytes(Metadata metadata, Session session) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean supportsMultipleWritersPerPartition(Metadata metadata, Session session) {
            throw new UnsupportedOperationException();
        }

        @Override
        public OptionalInt getMaxWriterTasks(Metadata metadata, Session session) {
            throw new UnsupportedOperationException();
        }
    }

    public static class DeleteTarget
    extends WriterTarget {
        private final Optional<TableHandle> handle;
        private final SchemaTableName schemaTableName;

        @JsonCreator
        public DeleteTarget(@JsonProperty(value="handle") Optional<TableHandle> handle, @JsonProperty(value="schemaTableName") SchemaTableName schemaTableName) {
            this.handle = Objects.requireNonNull(handle, "handle is null");
            this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        }

        @JsonProperty
        public Optional<TableHandle> getHandle() {
            return this.handle;
        }

        @JsonIgnore
        public TableHandle getHandleOrElseThrow() {
            return this.handle.orElseThrow(() -> new IllegalStateException("DeleteTarget does not contain handle"));
        }

        @JsonProperty
        public SchemaTableName getSchemaTableName() {
            return this.schemaTableName;
        }

        @Override
        public String toString() {
            return this.handle.map(Object::toString).orElse("[]");
        }

        @Override
        public boolean supportsReportingWrittenBytes(Metadata metadata, Session session) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean supportsMultipleWritersPerPartition(Metadata metadata, Session session) {
            throw new UnsupportedOperationException();
        }

        @Override
        public OptionalInt getMaxWriterTasks(Metadata metadata, Session session) {
            throw new UnsupportedOperationException();
        }
    }

    public static class RefreshMaterializedViewTarget
    extends WriterTarget {
        private final TableHandle tableHandle;
        private final InsertTableHandle insertHandle;
        private final SchemaTableName schemaTableName;
        private final List<TableHandle> sourceTableHandles;

        @JsonCreator
        public RefreshMaterializedViewTarget(@JsonProperty(value="tableHandle") TableHandle tableHandle, @JsonProperty(value="insertHandle") InsertTableHandle insertHandle, @JsonProperty(value="schemaTableName") SchemaTableName schemaTableName, @JsonProperty(value="sourceTableHandles") List<TableHandle> sourceTableHandles) {
            this.tableHandle = Objects.requireNonNull(tableHandle, "tableHandle is null");
            this.insertHandle = Objects.requireNonNull(insertHandle, "insertHandle is null");
            this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
            this.sourceTableHandles = ImmutableList.copyOf(sourceTableHandles);
        }

        @JsonProperty
        public TableHandle getTableHandle() {
            return this.tableHandle;
        }

        @JsonProperty
        public InsertTableHandle getInsertHandle() {
            return this.insertHandle;
        }

        @JsonProperty
        public SchemaTableName getSchemaTableName() {
            return this.schemaTableName;
        }

        @JsonProperty
        public List<TableHandle> getSourceTableHandles() {
            return this.sourceTableHandles;
        }

        @Override
        public String toString() {
            return this.insertHandle.toString();
        }

        @Override
        public boolean supportsReportingWrittenBytes(Metadata metadata, Session session) {
            return metadata.supportsReportingWrittenBytes(session, this.tableHandle);
        }

        @Override
        public boolean supportsMultipleWritersPerPartition(Metadata metadata, Session session) {
            return metadata.getInsertLayout(session, this.tableHandle).map(layout -> layout.getLayout().supportsMultipleWritersPerPartition()).orElse(true);
        }

        @Override
        public OptionalInt getMaxWriterTasks(Metadata metadata, Session session) {
            return metadata.getMaxWriterTasks(session, this.tableHandle.getCatalogHandle().getCatalogName());
        }
    }

    public static class RefreshMaterializedViewReference
    extends WriterTarget {
        private final String table;
        private final TableHandle storageTableHandle;
        private final List<TableHandle> sourceTableHandles;

        public RefreshMaterializedViewReference(String table, TableHandle storageTableHandle, List<TableHandle> sourceTableHandles) {
            this.table = Objects.requireNonNull(table, "table is null");
            this.storageTableHandle = Objects.requireNonNull(storageTableHandle, "storageTableHandle is null");
            this.sourceTableHandles = ImmutableList.copyOf(sourceTableHandles);
        }

        public TableHandle getStorageTableHandle() {
            return this.storageTableHandle;
        }

        public List<TableHandle> getSourceTableHandles() {
            return this.sourceTableHandles;
        }

        @Override
        public String toString() {
            return this.table;
        }

        @Override
        public boolean supportsReportingWrittenBytes(Metadata metadata, Session session) {
            return metadata.supportsReportingWrittenBytes(session, this.storageTableHandle);
        }

        @Override
        public boolean supportsMultipleWritersPerPartition(Metadata metadata, Session session) {
            return metadata.getInsertLayout(session, this.storageTableHandle).map(layout -> layout.getLayout().supportsMultipleWritersPerPartition()).orElse(true);
        }

        @Override
        public OptionalInt getMaxWriterTasks(Metadata metadata, Session session) {
            return metadata.getMaxWriterTasks(session, this.storageTableHandle.getCatalogHandle().getCatalogName());
        }
    }

    public static class InsertTarget
    extends WriterTarget {
        private final InsertTableHandle handle;
        private final SchemaTableName schemaTableName;
        private final boolean reportingWrittenBytesSupported;
        private final boolean multipleWritersPerPartitionSupported;
        private final OptionalInt maxWriterTasks;

        @JsonCreator
        public InsertTarget(@JsonProperty(value="handle") InsertTableHandle handle, @JsonProperty(value="schemaTableName") SchemaTableName schemaTableName, @JsonProperty(value="reportingWrittenBytesSupported") boolean reportingWrittenBytesSupported, @JsonProperty(value="multipleWritersPerPartitionSupported") boolean multipleWritersPerPartitionSupported, @JsonProperty(value="maxWriterTasks") OptionalInt maxWriterTasks) {
            this.handle = Objects.requireNonNull(handle, "handle is null");
            this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
            this.reportingWrittenBytesSupported = reportingWrittenBytesSupported;
            this.multipleWritersPerPartitionSupported = multipleWritersPerPartitionSupported;
            this.maxWriterTasks = Objects.requireNonNull(maxWriterTasks, "maxWriterTasks is null");
        }

        @JsonProperty
        public InsertTableHandle getHandle() {
            return this.handle;
        }

        @JsonProperty
        public SchemaTableName getSchemaTableName() {
            return this.schemaTableName;
        }

        @JsonProperty
        public boolean getReportingWrittenBytesSupported() {
            return this.reportingWrittenBytesSupported;
        }

        @JsonProperty
        public boolean isMultipleWritersPerPartitionSupported() {
            return this.multipleWritersPerPartitionSupported;
        }

        @Override
        public String toString() {
            return this.handle.toString();
        }

        @Override
        public boolean supportsReportingWrittenBytes(Metadata metadata, Session session) {
            return this.reportingWrittenBytesSupported;
        }

        @Override
        public boolean supportsMultipleWritersPerPartition(Metadata metadata, Session session) {
            return this.multipleWritersPerPartitionSupported;
        }

        @Override
        public OptionalInt getMaxWriterTasks(Metadata metadata, Session session) {
            return this.maxWriterTasks;
        }
    }

    public static class InsertReference
    extends WriterTarget {
        private final TableHandle handle;
        private final List<ColumnHandle> columns;

        public InsertReference(TableHandle handle, List<ColumnHandle> columns) {
            this.handle = Objects.requireNonNull(handle, "handle is null");
            this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
        }

        public TableHandle getHandle() {
            return this.handle;
        }

        public List<ColumnHandle> getColumns() {
            return this.columns;
        }

        @Override
        public String toString() {
            return this.handle.toString();
        }

        @Override
        public boolean supportsReportingWrittenBytes(Metadata metadata, Session session) {
            return metadata.supportsReportingWrittenBytes(session, this.handle);
        }

        @Override
        public boolean supportsMultipleWritersPerPartition(Metadata metadata, Session session) {
            return metadata.getInsertLayout(session, this.handle).map(layout -> layout.getLayout().supportsMultipleWritersPerPartition()).orElse(true);
        }

        @Override
        public OptionalInt getMaxWriterTasks(Metadata metadata, Session session) {
            return metadata.getMaxWriterTasks(session, this.handle.getCatalogHandle().getCatalogName());
        }
    }

    public static class CreateTarget
    extends WriterTarget {
        private final OutputTableHandle handle;
        private final SchemaTableName schemaTableName;
        private final boolean reportingWrittenBytesSupported;
        private final boolean multipleWritersPerPartitionSupported;
        private final OptionalInt maxWriterTasks;

        @JsonCreator
        public CreateTarget(@JsonProperty(value="handle") OutputTableHandle handle, @JsonProperty(value="schemaTableName") SchemaTableName schemaTableName, @JsonProperty(value="reportingWrittenBytesSupported") boolean reportingWrittenBytesSupported, @JsonProperty(value="multipleWritersPerPartitionSupported") boolean multipleWritersPerPartitionSupported, @JsonProperty(value="maxWriterTasks") OptionalInt maxWriterTasks) {
            this.handle = Objects.requireNonNull(handle, "handle is null");
            this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
            this.reportingWrittenBytesSupported = reportingWrittenBytesSupported;
            this.multipleWritersPerPartitionSupported = multipleWritersPerPartitionSupported;
            this.maxWriterTasks = Objects.requireNonNull(maxWriterTasks, "maxWriterTasks is null");
        }

        @JsonProperty
        public OutputTableHandle getHandle() {
            return this.handle;
        }

        @JsonProperty
        public SchemaTableName getSchemaTableName() {
            return this.schemaTableName;
        }

        @JsonProperty
        public boolean getReportingWrittenBytesSupported() {
            return this.reportingWrittenBytesSupported;
        }

        @JsonProperty
        public boolean isMultipleWritersPerPartitionSupported() {
            return this.multipleWritersPerPartitionSupported;
        }

        @Override
        public String toString() {
            return this.handle.toString();
        }

        @Override
        public boolean supportsReportingWrittenBytes(Metadata metadata, Session session) {
            return this.reportingWrittenBytesSupported;
        }

        @Override
        public boolean supportsMultipleWritersPerPartition(Metadata metadata, Session session) {
            return this.multipleWritersPerPartitionSupported;
        }

        @Override
        public OptionalInt getMaxWriterTasks(Metadata metadata, Session session) {
            return this.maxWriterTasks;
        }
    }

    public static class CreateReference
    extends WriterTarget {
        private final String catalog;
        private final ConnectorTableMetadata tableMetadata;
        private final Optional<TableLayout> layout;

        public CreateReference(String catalog, ConnectorTableMetadata tableMetadata, Optional<TableLayout> layout) {
            this.catalog = Objects.requireNonNull(catalog, "catalog is null");
            this.tableMetadata = Objects.requireNonNull(tableMetadata, "tableMetadata is null");
            this.layout = Objects.requireNonNull(layout, "layout is null");
        }

        public String getCatalog() {
            return this.catalog;
        }

        @Override
        public boolean supportsReportingWrittenBytes(Metadata metadata, Session session) {
            QualifiedObjectName fullTableName = new QualifiedObjectName(this.catalog, this.tableMetadata.getTableSchema().getTable().getSchemaName(), this.tableMetadata.getTableSchema().getTable().getTableName());
            return metadata.supportsReportingWrittenBytes(session, fullTableName, this.tableMetadata.getProperties());
        }

        @Override
        public boolean supportsMultipleWritersPerPartition(Metadata metadata, Session session) {
            return this.layout.map(tableLayout -> tableLayout.getLayout().supportsMultipleWritersPerPartition()).orElse(true);
        }

        @Override
        public OptionalInt getMaxWriterTasks(Metadata metadata, Session session) {
            return metadata.getMaxWriterTasks(session, this.catalog);
        }

        public Optional<TableLayout> getLayout() {
            return this.layout;
        }

        public ConnectorTableMetadata getTableMetadata() {
            return this.tableMetadata;
        }

        @Override
        public String toString() {
            return this.catalog + "." + this.tableMetadata.getTable();
        }
    }
}

