/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.google.common.collect.ImmutableList;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.metadata.PolymorphicScalarFunctionBuilder;
import io.trino.metadata.SqlScalarFunction;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.Signature;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.Int128Math;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;

public final class DecimalSaturatedFloorCasts {
    public static final SqlScalarFunction DECIMAL_TO_DECIMAL_SATURATED_FLOOR_CAST = new PolymorphicScalarFunctionBuilder(DecimalSaturatedFloorCasts.class).signature(Signature.builder().operatorType(OperatorType.SATURATED_FLOOR_CAST).argumentType(new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"source_precision"), TypeSignatureParameter.typeVariable((String)"source_scale")})).returnType(new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"result_precision"), TypeSignatureParameter.typeVariable((String)"result_scale")})).build()).deterministic(true).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.methods("shortDecimalToShortDecimal", "shortDecimalToLongDecimal", "longDecimalToShortDecimal", "longDecimalToLongDecimal").withExtraParameters(context -> {
        int sourcePrecision = Math.toIntExact(context.getLiteral("source_precision"));
        int sourceScale = Math.toIntExact(context.getLiteral("source_scale"));
        int resultPrecision = Math.toIntExact(context.getLiteral("result_precision"));
        int resultScale = Math.toIntExact(context.getLiteral("result_scale"));
        return ImmutableList.of((Object)sourcePrecision, (Object)sourceScale, (Object)resultPrecision, (Object)resultScale);
    }))).build();
    public static final SqlScalarFunction DECIMAL_TO_BIGINT_SATURATED_FLOOR_CAST = DecimalSaturatedFloorCasts.decimalToGenericIntegerTypeSaturatedFloorCast((Type)BigintType.BIGINT, Long.MIN_VALUE, Long.MAX_VALUE);
    public static final SqlScalarFunction DECIMAL_TO_INTEGER_SATURATED_FLOOR_CAST = DecimalSaturatedFloorCasts.decimalToGenericIntegerTypeSaturatedFloorCast((Type)IntegerType.INTEGER, Integer.MIN_VALUE, Integer.MAX_VALUE);
    public static final SqlScalarFunction DECIMAL_TO_SMALLINT_SATURATED_FLOOR_CAST = DecimalSaturatedFloorCasts.decimalToGenericIntegerTypeSaturatedFloorCast((Type)SmallintType.SMALLINT, -32768L, 32767L);
    public static final SqlScalarFunction DECIMAL_TO_TINYINT_SATURATED_FLOOR_CAST = DecimalSaturatedFloorCasts.decimalToGenericIntegerTypeSaturatedFloorCast((Type)TinyintType.TINYINT, -128L, 127L);
    public static final SqlScalarFunction BIGINT_TO_DECIMAL_SATURATED_FLOOR_CAST = DecimalSaturatedFloorCasts.genericIntegerTypeToDecimalSaturatedFloorCast((Type)BigintType.BIGINT);
    public static final SqlScalarFunction INTEGER_TO_DECIMAL_SATURATED_FLOOR_CAST = DecimalSaturatedFloorCasts.genericIntegerTypeToDecimalSaturatedFloorCast((Type)IntegerType.INTEGER);
    public static final SqlScalarFunction SMALLINT_TO_DECIMAL_SATURATED_FLOOR_CAST = DecimalSaturatedFloorCasts.genericIntegerTypeToDecimalSaturatedFloorCast((Type)SmallintType.SMALLINT);
    public static final SqlScalarFunction TINYINT_TO_DECIMAL_SATURATED_FLOOR_CAST = DecimalSaturatedFloorCasts.genericIntegerTypeToDecimalSaturatedFloorCast((Type)TinyintType.TINYINT);

    private DecimalSaturatedFloorCasts() {
    }

    @UsedByGeneratedCode
    public static long shortDecimalToShortDecimal(long value, int sourcePrecision, int sourceScale, int resultPrecision, int resultScale) {
        return DecimalSaturatedFloorCasts.saturatedCast(Int128.valueOf((long)value), sourceScale, resultPrecision, resultScale).toLongExact();
    }

    @UsedByGeneratedCode
    public static Int128 shortDecimalToLongDecimal(long value, int sourcePrecision, int sourceScale, int resultPrecision, int resultScale) {
        return DecimalSaturatedFloorCasts.saturatedCast(Int128.valueOf((long)value), sourceScale, resultPrecision, resultScale);
    }

    @UsedByGeneratedCode
    public static long longDecimalToShortDecimal(Int128 value, int sourcePrecision, int sourceScale, int resultPrecision, int resultScale) {
        return DecimalSaturatedFloorCasts.saturatedCast(value, sourceScale, resultPrecision, resultScale).toLongExact();
    }

    @UsedByGeneratedCode
    public static Int128 longDecimalToLongDecimal(Int128 value, int sourcePrecision, int sourceScale, int resultPrecision, int resultScale) {
        return DecimalSaturatedFloorCasts.saturatedCast(value, sourceScale, resultPrecision, resultScale);
    }

    private static Int128 saturatedCast(Int128 value, int sourceScale, int resultPrecision, int resultScale) {
        int scale = resultScale - sourceScale;
        if (scale > 0) {
            value = Int128Math.multiply((Int128)value, (Int128)Int128Math.powerOfTen((int)scale));
        } else if (scale < 0) {
            value = Int128Math.floorDiv((Int128)value, (Int128)Int128Math.powerOfTen((int)(-scale)));
        }
        Int128 maxUnscaledValue = Int128Math.subtract((Int128)Int128Math.powerOfTen((int)resultPrecision), (Int128)Int128.ONE);
        if (value.compareTo(maxUnscaledValue) > 0) {
            return maxUnscaledValue;
        }
        Int128 minUnscaledValue = Int128Math.negate((Int128)maxUnscaledValue);
        if (value.compareTo(minUnscaledValue) < 0) {
            return minUnscaledValue;
        }
        return value;
    }

    private static SqlScalarFunction decimalToGenericIntegerTypeSaturatedFloorCast(Type type, long minValue, long maxValue) {
        return new PolymorphicScalarFunctionBuilder(DecimalSaturatedFloorCasts.class).signature(Signature.builder().operatorType(OperatorType.SATURATED_FLOOR_CAST).argumentType(new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"source_precision"), TypeSignatureParameter.typeVariable((String)"source_scale")})).returnType(type.getTypeSignature()).build()).deterministic(true).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.methods("shortDecimalToGenericIntegerType", "longDecimalToGenericIntegerType").withExtraParameters(context -> {
            int sourceScale = Math.toIntExact(context.getLiteral("source_scale"));
            return ImmutableList.of((Object)sourceScale, (Object)minValue, (Object)maxValue);
        }))).build();
    }

    @UsedByGeneratedCode
    public static long shortDecimalToGenericIntegerType(long value, int sourceScale, long minValue, long maxValue) {
        return DecimalSaturatedFloorCasts.saturatedCast(Int128.valueOf((long)value), sourceScale, minValue, maxValue);
    }

    @UsedByGeneratedCode
    public static long longDecimalToGenericIntegerType(Int128 value, int sourceScale, long minValue, long maxValue) {
        return DecimalSaturatedFloorCasts.saturatedCast(value, sourceScale, minValue, maxValue);
    }

    private static long saturatedCast(Int128 value, int sourceScale, long minValue, long maxValue) {
        if (sourceScale > 0) {
            value = Int128Math.floorDiv((Int128)value, (Int128)Int128Math.powerOfTen((int)sourceScale));
        }
        if (value.compareTo(Int128.valueOf((long)maxValue)) > 0) {
            return maxValue;
        }
        if (value.compareTo(Int128.valueOf((long)minValue)) < 0) {
            return minValue;
        }
        return value.toLongExact();
    }

    private static SqlScalarFunction genericIntegerTypeToDecimalSaturatedFloorCast(Type integerType) {
        return new PolymorphicScalarFunctionBuilder(DecimalSaturatedFloorCasts.class).signature(Signature.builder().operatorType(OperatorType.SATURATED_FLOOR_CAST).argumentType(integerType).returnType(new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"result_precision"), TypeSignatureParameter.typeVariable((String)"result_scale")})).build()).deterministic(true).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.methods("genericIntegerTypeToShortDecimal", "genericIntegerTypeToLongDecimal").withExtraParameters(context -> {
            int resultPrecision = Math.toIntExact(context.getLiteral("result_precision"));
            int resultScale = Math.toIntExact(context.getLiteral("result_scale"));
            return ImmutableList.of((Object)resultPrecision, (Object)resultScale);
        }))).build();
    }

    @UsedByGeneratedCode
    public static long genericIntegerTypeToShortDecimal(long value, int resultPrecision, int resultScale) {
        return DecimalSaturatedFloorCasts.saturatedCast(Int128.valueOf((long)value), 0, resultPrecision, resultScale).toLongExact();
    }

    @UsedByGeneratedCode
    public static Int128 genericIntegerTypeToLongDecimal(long value, int resultPrecision, int resultScale) {
        return DecimalSaturatedFloorCasts.saturatedCast(Int128.valueOf((long)value), 0, resultPrecision, resultScale);
    }
}

