/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.likematcher.LikeMatcher;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.AbstractVariableWidthType;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import java.util.Optional;

public class LikePatternType
extends AbstractVariableWidthType {
    public static final LikePatternType LIKE_PATTERN = new LikePatternType();
    public static final String NAME = "LikePattern";

    private LikePatternType() {
        super(new TypeSignature(NAME, new TypeSignatureParameter[0]), LikeMatcher.class);
    }

    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        throw new UnsupportedOperationException();
    }

    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        throw new UnsupportedOperationException();
    }

    public Object getObject(Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        int offset = 0;
        int length = block.getInt(position, offset);
        String pattern = block.getSlice(position, offset += 4, length).toStringUtf8();
        boolean hasEscape = block.getByte(position, offset += length) != 0;
        ++offset;
        Optional<Character> escape = Optional.empty();
        if (hasEscape) {
            escape = Optional.of(Character.valueOf((char)block.getInt(position, offset)));
        }
        return LikeMatcher.compile(pattern, escape);
    }

    public void writeObject(BlockBuilder blockBuilder, Object value) {
        LikeMatcher matcher = (LikeMatcher)value;
        Slice pattern = Slices.utf8Slice((String)matcher.getPattern());
        int length = pattern.length();
        blockBuilder.writeInt(length);
        blockBuilder.writeBytes(pattern, 0, length);
        if (matcher.getEscape().isEmpty()) {
            blockBuilder.writeByte(0);
        } else {
            blockBuilder.writeByte(1);
            blockBuilder.writeInt((int)matcher.getEscape().get().charValue());
        }
        blockBuilder.closeEntry();
    }
}

