/*
 * Decompiled with CFR 0.152.
 */
package io.trino.util;

import com.google.common.base.MoreObjects;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import io.trino.client.ErrorLocation;
import io.trino.execution.ExecutionFailureInfo;
import io.trino.execution.Failure;
import io.trino.spi.ErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.HostAddress;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.TrinoTransportException;
import io.trino.sql.parser.ParsingException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public final class Failures {
    private static final String NODE_CRASHED_ERROR = "The node may have crashed or be under too much load. This is probably a transient issue, so please retry your query in a few minutes.";
    public static final String WORKER_NODE_ERROR = "Encountered too many errors talking to a worker node. The node may have crashed or be under too much load. This is probably a transient issue, so please retry your query in a few minutes.";
    public static final String REMOTE_TASK_MISMATCH_ERROR = "Could not communicate with the remote task. The node may have crashed or be under too much load. This is probably a transient issue, so please retry your query in a few minutes.";

    private Failures() {
    }

    public static ExecutionFailureInfo toFailure(Throwable failure) {
        return Failures.toFailure(failure, Sets.newIdentityHashSet());
    }

    public static void checkCondition(boolean condition, ErrorCodeSupplier errorCode, String formatString, Object ... args) {
        if (!condition) {
            throw new TrinoException(errorCode, String.format(formatString, args));
        }
    }

    public static List<ExecutionFailureInfo> toFailures(Collection<? extends Throwable> failures) {
        return (List)failures.stream().map(Failures::toFailure).collect(ImmutableList.toImmutableList());
    }

    private static ExecutionFailureInfo toFailure(Throwable throwable, Set<Throwable> seenFailures) {
        String type;
        if (throwable == null) {
            return null;
        }
        HostAddress remoteHost = null;
        if (throwable instanceof Failure) {
            type = ((Failure)throwable).getType();
        } else {
            Class<?> clazz = throwable.getClass();
            type = (String)MoreObjects.firstNonNull((Object)clazz.getCanonicalName(), (Object)clazz.getName());
        }
        if (throwable instanceof TrinoTransportException) {
            remoteHost = ((TrinoTransportException)throwable).getRemoteHost();
        }
        if (seenFailures.contains(throwable)) {
            return new ExecutionFailureInfo(type, "[cyclic] " + throwable.getMessage(), null, (List<ExecutionFailureInfo>)ImmutableList.of(), (List<String>)ImmutableList.of(), null, StandardErrorCode.GENERIC_INTERNAL_ERROR.toErrorCode(), remoteHost);
        }
        seenFailures.add(throwable);
        ExecutionFailureInfo cause = Failures.toFailure(throwable.getCause(), seenFailures);
        ErrorCode errorCode = Failures.toErrorCode(throwable);
        if (errorCode == null) {
            errorCode = cause == null ? StandardErrorCode.GENERIC_INTERNAL_ERROR.toErrorCode() : cause.getErrorCode();
        }
        return new ExecutionFailureInfo(type, throwable.getMessage(), cause, (List)Arrays.stream(throwable.getSuppressed()).map(failure -> Failures.toFailure(failure, seenFailures)).collect(ImmutableList.toImmutableList()), (List)Arrays.stream(throwable.getStackTrace()).map(Objects::toString).collect(ImmutableList.toImmutableList()), Failures.getErrorLocation(throwable), errorCode, remoteHost);
    }

    @Nullable
    private static ErrorLocation getErrorLocation(Throwable throwable) {
        if (throwable instanceof ParsingException) {
            ParsingException parsingException = (ParsingException)throwable;
            return new ErrorLocation(parsingException.getLineNumber(), parsingException.getColumnNumber());
        }
        if (throwable instanceof TrinoException) {
            TrinoException trinoException = (TrinoException)throwable;
            return trinoException.getLocation().map(location -> new ErrorLocation(location.getLineNumber(), location.getColumnNumber())).orElse(null);
        }
        return null;
    }

    @Nullable
    private static ErrorCode toErrorCode(Throwable throwable) {
        Failure failure;
        Objects.requireNonNull(throwable);
        if (throwable instanceof TrinoException) {
            TrinoException trinoException = (TrinoException)throwable;
            return trinoException.getErrorCode();
        }
        if (throwable instanceof Failure && (failure = (Failure)throwable).getErrorCode() != null) {
            return failure.getErrorCode();
        }
        if (throwable instanceof ParsingException) {
            return StandardErrorCode.SYNTAX_ERROR.toErrorCode();
        }
        return null;
    }

    public static TrinoException internalError(Throwable t) {
        Throwables.throwIfInstanceOf((Throwable)t, Error.class);
        Throwables.throwIfInstanceOf((Throwable)t, TrinoException.class);
        return new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
    }
}

