/*
 * Decompiled with CFR 0.152.
 */
package io.trino;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.trino.RowPagesBuilder;
import io.trino.SessionTestUtils;
import io.trino.operator.OperatorAssertion;
import io.trino.operator.PagesIndex;
import io.trino.operator.PagesIndexPageSorter;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.testing.MaterializedResult;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPagesIndexPageSorter {
    private static final PagesIndexPageSorter sorter = new PagesIndexPageSorter((PagesIndex.Factory)new PagesIndex.TestingFactory(false));

    @Test
    public void testPageSorter() {
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)VarcharType.VARCHAR);
        List sortChannels = Ints.asList((int[])new int[]{0});
        ImmutableList sortOrders = ImmutableList.of((Object)SortOrder.ASC_NULLS_FIRST);
        List<Page> inputPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(2L, 1.1, "d").row(1L, 2.2, "c").pageBreak().row(-2L, 2.2, "b").row(-12L, 2.2, "a").build();
        List<Page> expectedPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(-12L, 2.2, "a").row(-2L, 2.2, "b").pageBreak().row(1L, 2.2, "c").row(2L, 1.1, "d").build();
        TestPagesIndexPageSorter.assertSorted(inputPages, expectedPages, (List<Type>)types, sortChannels, (List<SortOrder>)sortOrders, 100);
    }

    @Test
    public void testPageSorterMultipleChannels() {
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)VarcharType.VARCHAR);
        List sortChannels = Ints.asList((int[])new int[]{0, 1, 2});
        List<SortOrder> sortOrders = Collections.nCopies(sortChannels.size(), SortOrder.ASC_NULLS_FIRST);
        List<Page> inputPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(2L, 1.1, "d").row(1L, 2.2, "c").pageBreak().row(1L, 2.2, "b").row(1L, 2.2, "a").pageBreak().row(1L, 2.2, null).row(1L, null, "z").row(1L, null, null).build();
        List<Page> expectedPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(1L, null, null).row(1L, null, "z").row(1L, 2.2, null).row(1L, 2.2, "a").row(1L, 2.2, "b").row(1L, 2.2, "c").row(2L, 1.1, "d").build();
        TestPagesIndexPageSorter.assertSorted(inputPages, expectedPages, (List<Type>)types, sortChannels, sortOrders, 100);
    }

    @Test
    public void testPageSorterSorted() {
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)VarcharType.VARCHAR);
        List sortChannels = Ints.asList((int[])new int[]{0});
        ImmutableList sortOrders = ImmutableList.of((Object)SortOrder.ASC_NULLS_FIRST);
        List<Page> inputPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(-12L, 2.2, "a").row(-2L, 2.2, "b").pageBreak().row(1L, 2.2, "d").row(2L, 1.1, "c").build();
        List<Page> expectedPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(-12L, 2.2, "a").row(-2L, 2.2, "b").row(1L, 2.2, "d").row(2L, 1.1, "c").build();
        TestPagesIndexPageSorter.assertSorted(inputPages, expectedPages, (List<Type>)types, sortChannels, (List<SortOrder>)sortOrders, 100);
    }

    @Test
    public void testPageSorterForceExpansion() {
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)VarcharType.VARCHAR);
        List sortChannels = Ints.asList((int[])new int[]{0});
        ImmutableList sortOrders = ImmutableList.of((Object)SortOrder.ASC_NULLS_FIRST);
        List<Page> inputPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(2L, 1.1, "c").row(1L, 2.2, "d").pageBreak().row(-2L, 2.2, "b").row(-12L, 2.2, "a").build();
        List<Page> expectedPages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(-12L, 2.2, "a").row(-2L, 2.2, "b").pageBreak().row(1L, 2.2, "d").row(2L, 1.1, "c").build();
        TestPagesIndexPageSorter.assertSorted(inputPages, expectedPages, (List<Type>)types, sortChannels, (List<SortOrder>)sortOrders, 2);
    }

    private static void assertSorted(List<Page> inputPages, List<Page> expectedPages, List<Type> types, List<Integer> sortChannels, List<SortOrder> sortOrders, int expectedPositions) {
        long[] sortedAddresses = sorter.sort(types, inputPages, sortChannels, sortOrders, expectedPositions);
        List<Page> outputPages = TestPagesIndexPageSorter.createOutputPages(types, inputPages, sortedAddresses);
        MaterializedResult expected = OperatorAssertion.toMaterializedResult(SessionTestUtils.TEST_SESSION, types, expectedPages);
        MaterializedResult actual = OperatorAssertion.toMaterializedResult(SessionTestUtils.TEST_SESSION, types, outputPages);
        Assert.assertEquals((Collection)actual.getMaterializedRows(), (Collection)expected.getMaterializedRows());
    }

    private static List<Page> createOutputPages(List<Type> types, List<Page> inputPages, long[] sortedAddresses) {
        PageBuilder pageBuilder = new PageBuilder(types);
        pageBuilder.reset();
        for (long address : sortedAddresses) {
            int index = sorter.decodePageIndex(address);
            int position = sorter.decodePositionIndex(address);
            Page page = inputPages.get(index);
            for (int i = 0; i < types.size(); ++i) {
                Type type = types.get(i);
                type.appendTo(page.getBlock(i), position, pageBuilder.getBlockBuilder(i));
            }
            pageBuilder.declarePosition();
        }
        return ImmutableList.of((Object)pageBuilder.build());
    }
}

