/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MoreCollectors;
import com.google.common.util.concurrent.MoreExecutors;
import io.trino.Session;
import io.trino.client.NodeVersion;
import io.trino.connector.CatalogServiceProvider;
import io.trino.connector.MockConnectorFactory;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.AbstractMockMetadata;
import io.trino.metadata.ColumnPropertyManager;
import io.trino.metadata.MaterializedViewDefinition;
import io.trino.metadata.MaterializedViewPropertyManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TableMetadata;
import io.trino.metadata.TableSchema;
import io.trino.metadata.ViewColumn;
import io.trino.metadata.ViewDefinition;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.MaterializedViewNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TestingColumnHandle;
import io.trino.spi.function.OperatorType;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.security.Identity;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.TestingConnectorTransactionHandle;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.tree.QualifiedName;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingHandles;
import io.trino.testing.TestingMetadata;
import io.trino.testing.TestingSession;
import io.trino.transaction.TransactionManager;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test
public abstract class BaseDataDefinitionTaskTest {
    public static final String SCHEMA = "schema";
    protected static final String COLUMN_PROPERTY_NAME = "column_property";
    protected static final Long COLUMN_PROPERTY_DEFAULT_VALUE = null;
    protected static final String MATERIALIZED_VIEW_PROPERTY_1_NAME = "property1";
    protected static final Long MATERIALIZED_VIEW_PROPERTY_1_DEFAULT_VALUE = null;
    protected static final String MATERIALIZED_VIEW_PROPERTY_2_NAME = "property2";
    protected static final String MATERIALIZED_VIEW_PROPERTY_2_DEFAULT_VALUE = "defaultProperty2Value";
    private LocalQueryRunner queryRunner;
    protected Session testSession;
    protected MockMetadata metadata;
    protected PlannerContext plannerContext;
    protected ColumnPropertyManager columnPropertyManager;
    protected MaterializedViewPropertyManager materializedViewPropertyManager;
    protected TransactionManager transactionManager;
    protected QueryStateMachine queryStateMachine;

    @BeforeMethod
    public void setUp() {
        this.testSession = TestingSession.testSessionBuilder().setCatalog("test-catalog").build();
        this.queryRunner = LocalQueryRunner.create((Session)this.testSession);
        this.transactionManager = this.queryRunner.getTransactionManager();
        this.queryRunner.createCatalog("test-catalog", (ConnectorFactory)MockConnectorFactory.create("initial"), (Map)ImmutableMap.of());
        this.metadata = new MockMetadata("test-catalog");
        this.plannerContext = TestingPlannerContext.plannerContextBuilder().withMetadata(this.metadata).build();
        ImmutableMap columnProperties = ImmutableMap.of((Object)COLUMN_PROPERTY_NAME, (Object)PropertyMetadata.longProperty((String)COLUMN_PROPERTY_NAME, (String)"column_property 1", (Long)COLUMN_PROPERTY_DEFAULT_VALUE, (boolean)false));
        this.columnPropertyManager = new ColumnPropertyManager(CatalogServiceProvider.singleton((CatalogHandle)TestingHandles.TEST_CATALOG_HANDLE, (Object)columnProperties));
        ImmutableMap properties = ImmutableMap.of((Object)MATERIALIZED_VIEW_PROPERTY_1_NAME, (Object)PropertyMetadata.longProperty((String)MATERIALIZED_VIEW_PROPERTY_1_NAME, (String)"property 1", (Long)MATERIALIZED_VIEW_PROPERTY_1_DEFAULT_VALUE, (boolean)false), (Object)MATERIALIZED_VIEW_PROPERTY_2_NAME, (Object)PropertyMetadata.stringProperty((String)MATERIALIZED_VIEW_PROPERTY_2_NAME, (String)"property 2", (String)MATERIALIZED_VIEW_PROPERTY_2_DEFAULT_VALUE, (boolean)false));
        this.materializedViewPropertyManager = new MaterializedViewPropertyManager(CatalogServiceProvider.singleton((CatalogHandle)TestingHandles.TEST_CATALOG_HANDLE, (Object)properties));
        this.queryStateMachine = BaseDataDefinitionTaskTest.stateMachine(this.transactionManager, MetadataManager.createTestMetadataManager(), (AccessControl)new AllowAllAccessControl(), this.testSession);
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        if (this.queryRunner != null) {
            this.queryRunner.close();
            this.queryRunner = null;
        }
        this.testSession = null;
        this.metadata = null;
        this.plannerContext = null;
        this.materializedViewPropertyManager = null;
        this.transactionManager = null;
        this.queryStateMachine = null;
    }

    protected static QualifiedObjectName qualifiedObjectName(String objectName) {
        return new QualifiedObjectName("test-catalog", SCHEMA, objectName);
    }

    protected static QualifiedName qualifiedName(String name) {
        return QualifiedName.of((String)"test-catalog", (String[])new String[]{SCHEMA, name});
    }

    protected static QualifiedName qualifiedColumnName(String tableName, String columnName) {
        return QualifiedName.of((String)"test-catalog", (String[])new String[]{SCHEMA, tableName, columnName});
    }

    protected static QualifiedObjectName asQualifiedObjectName(QualifiedName viewName) {
        return QualifiedObjectName.valueOf((String)viewName.toString());
    }

    protected static QualifiedName asQualifiedName(QualifiedObjectName qualifiedObjectName) {
        return QualifiedName.of((String)qualifiedObjectName.getCatalogName(), (String[])new String[]{qualifiedObjectName.getSchemaName(), qualifiedObjectName.getObjectName()});
    }

    protected MaterializedViewDefinition someMaterializedView() {
        return this.someMaterializedView("select * from some_table", (List<ViewColumn>)ImmutableList.of((Object)new ViewColumn("test", BigintType.BIGINT.getTypeId(), Optional.empty())));
    }

    protected MaterializedViewDefinition someMaterializedView(String sql, List<ViewColumn> columns) {
        return new MaterializedViewDefinition(sql, Optional.empty(), Optional.empty(), columns, Optional.empty(), Optional.empty(), Identity.ofUser((String)"owner"), Optional.empty(), (Map)ImmutableMap.of((Object)MATERIALIZED_VIEW_PROPERTY_2_NAME, (Object)MATERIALIZED_VIEW_PROPERTY_2_DEFAULT_VALUE));
    }

    protected static ConnectorTableMetadata someTable(QualifiedObjectName tableName) {
        return new ConnectorTableMetadata(tableName.asSchemaTableName(), (List)ImmutableList.of((Object)new ColumnMetadata("test", (Type)BigintType.BIGINT)));
    }

    protected static ViewDefinition someView() {
        return BaseDataDefinitionTaskTest.viewDefinition("SELECT 1", (ImmutableList<ViewColumn>)ImmutableList.of((Object)new ViewColumn("test", BigintType.BIGINT.getTypeId(), Optional.empty())));
    }

    protected static ViewDefinition viewDefinition(String sql, ImmutableList<ViewColumn> columns) {
        return new ViewDefinition(sql, Optional.empty(), Optional.empty(), columns, Optional.empty(), Optional.empty());
    }

    private static QueryStateMachine stateMachine(TransactionManager transactionManager, MetadataManager metadata, AccessControl accessControl, Session session) {
        return QueryStateMachine.begin(Optional.empty(), (String)"test", Optional.empty(), (Session)session, (URI)URI.create("fake://uri"), (ResourceGroupId)new ResourceGroupId("test"), (boolean)false, (TransactionManager)transactionManager, (AccessControl)accessControl, (Executor)MoreExecutors.directExecutor(), (Metadata)metadata, (WarningCollector)WarningCollector.NOOP, (PlanOptimizersStatsCollector)PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector(), Optional.empty(), (boolean)true, (NodeVersion)new NodeVersion("test"));
    }

    protected static class MockMetadata
    extends AbstractMockMetadata {
        private final MetadataManager delegate;
        private final String catalogName;
        private final List<CatalogSchemaName> schemas = new CopyOnWriteArrayList<CatalogSchemaName>();
        private final AtomicBoolean failCreateSchema = new AtomicBoolean();
        private final Map<SchemaTableName, ConnectorTableMetadata> tables = new ConcurrentHashMap<SchemaTableName, ConnectorTableMetadata>();
        private final Map<SchemaTableName, ViewDefinition> views = new ConcurrentHashMap<SchemaTableName, ViewDefinition>();
        private final Map<SchemaTableName, MaterializedViewDefinition> materializedViews = new ConcurrentHashMap<SchemaTableName, MaterializedViewDefinition>();

        public MockMetadata(String catalogName) {
            this.delegate = MetadataManager.createTestMetadataManager();
            this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        }

        @Override
        public Optional<CatalogHandle> getCatalogHandle(Session session, String catalogName) {
            if (this.catalogName.equals(catalogName)) {
                return Optional.of(TestingHandles.TEST_CATALOG_HANDLE);
            }
            return Optional.empty();
        }

        public void failCreateSchema() {
            this.failCreateSchema.set(true);
        }

        @Override
        public boolean schemaExists(Session session, CatalogSchemaName schema) {
            return this.schemas.contains(schema);
        }

        @Override
        public void createSchema(Session session, CatalogSchemaName schema, Map<String, Object> properties, TrinoPrincipal principal) {
            if (this.failCreateSchema.get()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, "TEST create schema fail: " + schema);
            }
            if (this.schemas.contains(schema)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Schema already exists");
            }
            this.schemas.add(schema);
        }

        @Override
        public TableSchema getTableSchema(Session session, TableHandle tableHandle) {
            return new TableSchema("test-catalog", this.getTableMetadata(tableHandle).getTableSchema());
        }

        @Override
        public Optional<TableHandle> getTableHandle(Session session, QualifiedObjectName tableName) {
            return Optional.ofNullable(this.tables.get(tableName.asSchemaTableName())).map(tableMetadata -> new TableHandle(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorTableHandle)new TestingMetadata.TestingTableHandle(tableName.asSchemaTableName()), (ConnectorTransactionHandle)TestingConnectorTransactionHandle.INSTANCE));
        }

        @Override
        public TableMetadata getTableMetadata(Session session, TableHandle tableHandle) {
            return new TableMetadata("test-catalog", this.getTableMetadata(tableHandle));
        }

        @Override
        public void createTable(Session session, String catalogName, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
            Preconditions.checkArgument((ignoreExisting || !this.tables.containsKey(tableMetadata.getTable()) ? 1 : 0) != 0);
            this.tables.put(tableMetadata.getTable(), tableMetadata);
        }

        @Override
        public void dropTable(Session session, TableHandle tableHandle, CatalogSchemaTableName tableName) {
            this.tables.remove(tableName.getSchemaTableName());
        }

        @Override
        public void renameTable(Session session, TableHandle tableHandle, CatalogSchemaTableName currentTableName, QualifiedObjectName newTableName) {
            SchemaTableName oldTableName = currentTableName.getSchemaTableName();
            this.tables.put(newTableName.asSchemaTableName(), (ConnectorTableMetadata)Verify.verifyNotNull((Object)this.tables.get(oldTableName), (String)"Table not found %s", (Object[])new Object[]{oldTableName}));
            this.tables.remove(oldTableName);
        }

        @Override
        public void addColumn(Session session, TableHandle tableHandle, CatalogSchemaTableName table, ColumnMetadata column) {
            SchemaTableName tableName = table.getSchemaTableName();
            ConnectorTableMetadata metadata = this.tables.get(tableName);
            ImmutableList.Builder columns = ImmutableList.builderWithExpectedSize((int)(metadata.getColumns().size() + 1));
            columns.addAll((Iterable)metadata.getColumns());
            columns.add((Object)column);
            this.tables.put(tableName, new ConnectorTableMetadata(tableName, (List)columns.build()));
        }

        @Override
        public void dropColumn(Session session, TableHandle tableHandle, CatalogSchemaTableName table, ColumnHandle columnHandle) {
            SchemaTableName tableName = table.getSchemaTableName();
            ConnectorTableMetadata metadata = this.tables.get(tableName);
            String columnName = ((TestingColumnHandle)columnHandle).getName();
            List columns = (List)metadata.getColumns().stream().filter(column -> !column.getName().equals(columnName)).collect(ImmutableList.toImmutableList());
            this.tables.put(tableName, new ConnectorTableMetadata(tableName, columns));
        }

        @Override
        public void renameColumn(Session session, TableHandle tableHandle, CatalogSchemaTableName table, ColumnHandle source, String target) {
            SchemaTableName tableName = table.getSchemaTableName();
            ConnectorTableMetadata metadata = this.tables.get(tableName);
            String columnName = ((TestingColumnHandle)source).getName();
            List columns = (List)metadata.getColumns().stream().map(column -> column.getName().equals(columnName) ? ColumnMetadata.builderFrom((ColumnMetadata)column).setName(target).build() : column).collect(ImmutableList.toImmutableList());
            this.tables.put(tableName, new ConnectorTableMetadata(tableName, columns));
        }

        @Override
        public void setColumnType(Session session, TableHandle tableHandle, ColumnHandle columnHandle, Type type) {
            SchemaTableName tableName = this.getTableName(tableHandle);
            ConnectorTableMetadata metadata = this.tables.get(tableName);
            ImmutableList.Builder columns = ImmutableList.builderWithExpectedSize((int)metadata.getColumns().size());
            for (ColumnMetadata column : metadata.getColumns()) {
                if (column.getName().equals(((TestingColumnHandle)columnHandle).getName())) {
                    columns.add((Object)new ColumnMetadata(column.getName(), type));
                    continue;
                }
                columns.add((Object)column);
            }
            this.tables.put(tableName, new ConnectorTableMetadata(tableName, (List)columns.build()));
        }

        private ConnectorTableMetadata getTableMetadata(TableHandle tableHandle) {
            return this.tables.get(this.getTableName(tableHandle));
        }

        private SchemaTableName getTableName(TableHandle tableHandle) {
            return ((TestingMetadata.TestingTableHandle)tableHandle.getConnectorHandle()).getTableName();
        }

        @Override
        public Map<String, ColumnHandle> getColumnHandles(Session session, TableHandle tableHandle) {
            return (Map)this.getTableMetadata(tableHandle).getColumns().stream().collect(ImmutableMap.toImmutableMap(ColumnMetadata::getName, column -> new TestingColumnHandle(column.getName())));
        }

        @Override
        public ColumnMetadata getColumnMetadata(Session session, TableHandle tableHandle, ColumnHandle columnHandle) {
            String columnName = ((TestingColumnHandle)columnHandle).getName();
            return (ColumnMetadata)this.getTableMetadata(tableHandle).getColumns().stream().filter(column -> column.getName().equals(columnName)).collect(MoreCollectors.onlyElement());
        }

        @Override
        public Optional<MaterializedViewDefinition> getMaterializedView(Session session, QualifiedObjectName viewName) {
            return Optional.ofNullable(this.materializedViews.get(viewName.asSchemaTableName()));
        }

        @Override
        public void createMaterializedView(Session session, QualifiedObjectName viewName, MaterializedViewDefinition definition, boolean replace, boolean ignoreExisting) {
            Preconditions.checkArgument((ignoreExisting || !this.materializedViews.containsKey(viewName.asSchemaTableName()) ? 1 : 0) != 0);
            this.materializedViews.put(viewName.asSchemaTableName(), definition);
        }

        @Override
        public synchronized void setMaterializedViewProperties(Session session, QualifiedObjectName viewName, Map<String, Optional<Object>> properties) {
            MaterializedViewDefinition existingDefinition = this.getMaterializedView(session, viewName).orElseThrow(() -> new MaterializedViewNotFoundException(viewName.asSchemaTableName()));
            HashMap<String, Object> newProperties = new HashMap<String, Object>(existingDefinition.getProperties());
            for (Map.Entry<String, Optional<Object>> entry : properties.entrySet()) {
                if (entry.getValue().isPresent()) {
                    newProperties.put(entry.getKey(), entry.getValue().orElseThrow());
                    continue;
                }
                newProperties.remove(entry.getKey());
            }
            this.materializedViews.put(viewName.asSchemaTableName(), new MaterializedViewDefinition(existingDefinition.getOriginalSql(), existingDefinition.getCatalog(), existingDefinition.getSchema(), existingDefinition.getColumns(), existingDefinition.getGracePeriod(), existingDefinition.getComment(), (Identity)existingDefinition.getRunAsIdentity().get(), existingDefinition.getStorageTable(), newProperties));
        }

        @Override
        public void dropMaterializedView(Session session, QualifiedObjectName viewName) {
            this.materializedViews.remove(viewName.asSchemaTableName());
        }

        @Override
        public Optional<ViewDefinition> getView(Session session, QualifiedObjectName viewName) {
            return Optional.ofNullable(this.views.get(viewName.asSchemaTableName()));
        }

        @Override
        public void createView(Session session, QualifiedObjectName viewName, ViewDefinition definition, boolean replace) {
            Preconditions.checkArgument((replace || !this.views.containsKey(viewName.asSchemaTableName()) ? 1 : 0) != 0);
            this.views.put(viewName.asSchemaTableName(), definition);
        }

        @Override
        public void dropView(Session session, QualifiedObjectName viewName) {
            this.views.remove(viewName.asSchemaTableName());
        }

        @Override
        public void renameView(Session session, QualifiedObjectName source, QualifiedObjectName target) {
            SchemaTableName oldViewName = source.asSchemaTableName();
            this.views.put(target.asSchemaTableName(), (ViewDefinition)Verify.verifyNotNull((Object)this.views.get(oldViewName), (String)"View not found %s", (Object[])new Object[]{oldViewName}));
            this.views.remove(oldViewName);
        }

        @Override
        public void setTableComment(Session session, TableHandle tableHandle, Optional<String> comment) {
            ConnectorTableMetadata tableMetadata = this.getTableMetadata(tableHandle);
            ConnectorTableMetadata newTableMetadata = new ConnectorTableMetadata(tableMetadata.getTable(), tableMetadata.getColumns(), tableMetadata.getProperties(), comment);
            this.tables.put(tableMetadata.getTable(), newTableMetadata);
        }

        @Override
        public void setViewComment(Session session, QualifiedObjectName viewName, Optional<String> comment) {
            ViewDefinition view = this.views.get(viewName.asSchemaTableName());
            this.views.put(viewName.asSchemaTableName(), new ViewDefinition(view.getOriginalSql(), view.getCatalog(), view.getSchema(), view.getColumns(), comment, view.getRunAsIdentity()));
        }

        @Override
        public void setColumnComment(Session session, TableHandle tableHandle, ColumnHandle column, Optional<String> comment) {
            ConnectorTableMetadata tableMetadata = this.getTableMetadata(tableHandle);
            TestingColumnHandle columnHandle = (TestingColumnHandle)column;
            ConnectorTableMetadata newTableMetadata = new ConnectorTableMetadata(tableMetadata.getTable(), (List)tableMetadata.getColumns().stream().map(tableColumn -> Objects.equals(tableColumn.getName(), columnHandle.getName()) ? MockMetadata.withComment(tableColumn, comment) : tableColumn).collect(ImmutableList.toImmutableList()), tableMetadata.getProperties(), tableMetadata.getComment());
            this.tables.put(tableMetadata.getTable(), newTableMetadata);
        }

        @Override
        public void setViewColumnComment(Session session, QualifiedObjectName viewName, String columnName, Optional<String> comment) {
            ViewDefinition view = this.views.get(viewName.asSchemaTableName());
            this.views.put(viewName.asSchemaTableName(), new ViewDefinition(view.getOriginalSql(), view.getCatalog(), view.getSchema(), (List)view.getColumns().stream().map(currentViewColumn -> columnName.equals(currentViewColumn.getName()) ? new ViewColumn(currentViewColumn.getName(), currentViewColumn.getType(), comment) : currentViewColumn).collect(ImmutableList.toImmutableList()), view.getComment(), view.getRunAsIdentity()));
        }

        @Override
        public void renameMaterializedView(Session session, QualifiedObjectName source, QualifiedObjectName target) {
            SchemaTableName oldViewName = source.asSchemaTableName();
            this.materializedViews.put(target.asSchemaTableName(), (MaterializedViewDefinition)Verify.verifyNotNull((Object)this.materializedViews.get(oldViewName), (String)"Materialized View not found %s", (Object[])new Object[]{oldViewName}));
            this.materializedViews.remove(oldViewName);
        }

        @Override
        public ResolvedFunction getCoercion(Session session, OperatorType operatorType, Type fromType, Type toType) {
            return this.delegate.getCoercion(session, operatorType, fromType, toType);
        }

        private static ColumnMetadata withComment(ColumnMetadata tableColumn, Optional<String> comment) {
            return ColumnMetadata.builderFrom((ColumnMetadata)tableColumn).setComment(comment).build();
        }
    }
}

