/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.MoreCollectors;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.trino.execution.AddColumnTask;
import io.trino.execution.BaseDataDefinitionTaskTest;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TableHandle;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.tree.AddColumn;
import io.trino.sql.tree.ColumnDefinition;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.Property;
import io.trino.sql.tree.QualifiedName;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestAddColumnTask
extends BaseDataDefinitionTaskTest {
    @Test
    public void testAddColumn() {
        QualifiedObjectName tableName = TestAddColumnTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "test-catalog", TestAddColumnTask.someTable(tableName), false);
        TableHandle table = this.metadata.getTableHandle(this.testSession, tableName).get();
        Assertions.assertThat((List)this.metadata.getTableMetadata(this.testSession, table).getColumns()).containsExactly((Object[])new ColumnMetadata[]{new ColumnMetadata("test", (Type)BigintType.BIGINT)});
        MoreFutures.getFutureValue(this.executeAddColumn(TestAddColumnTask.asQualifiedName(tableName), new Identifier("new_col"), (Type)IntegerType.INTEGER, Optional.empty(), false, false));
        Assertions.assertThat((List)this.metadata.getTableMetadata(this.testSession, table).getColumns()).containsExactly((Object[])new ColumnMetadata[]{new ColumnMetadata("test", (Type)BigintType.BIGINT), new ColumnMetadata("new_col", (Type)IntegerType.INTEGER)});
    }

    @Test
    public void testAddColumnWithComment() {
        QualifiedObjectName tableName = TestAddColumnTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "test-catalog", TestAddColumnTask.someTable(tableName), false);
        TableHandle table = this.metadata.getTableHandle(this.testSession, tableName).get();
        MoreFutures.getFutureValue(this.executeAddColumn(TestAddColumnTask.asQualifiedName(tableName), new Identifier("new_col"), (Type)IntegerType.INTEGER, Optional.of("test comment"), false, false));
        Assertions.assertThat((List)this.metadata.getTableMetadata(this.testSession, table).getColumns()).containsExactly((Object[])new ColumnMetadata[]{new ColumnMetadata("test", (Type)BigintType.BIGINT), ColumnMetadata.builder().setName("new_col").setType((Type)IntegerType.INTEGER).setComment(Optional.of("test comment")).build()});
    }

    @Test
    public void testAddColumnWithColumnProperty() {
        QualifiedObjectName tableName = TestAddColumnTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "test-catalog", TestAddColumnTask.someTable(tableName), false);
        TableHandle table = this.metadata.getTableHandle(this.testSession, tableName).get();
        Property columnProperty = new Property(new Identifier("column_property"), (Expression)new LongLiteral("111"));
        MoreFutures.getFutureValue(this.executeAddColumn(TestAddColumnTask.asQualifiedName(tableName), new Identifier("new_col"), (Type)IntegerType.INTEGER, (List<Property>)ImmutableList.of((Object)columnProperty), false, false));
        ColumnMetadata columnMetadata = (ColumnMetadata)this.metadata.getTableMetadata(this.testSession, table).getColumns().stream().filter(column -> column.getName().equals("new_col")).collect(MoreCollectors.onlyElement());
        Assertions.assertThat((Map)columnMetadata.getProperties()).containsExactly(new Map.Entry[]{Map.entry("column_property", 111L)});
    }

    @Test
    public void testAddColumnNotExistingTable() {
        QualifiedObjectName tableName = TestAddColumnTask.qualifiedObjectName("not_existing_table");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeAddColumn(TestAddColumnTask.asQualifiedName(tableName), new Identifier("test"), (Type)IntegerType.INTEGER, Optional.empty(), false, false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND}).hasMessageContaining("Table '%s' does not exist", new Object[]{tableName});
    }

    @Test
    public void testAddColumnNotExistingTableIfExists() {
        QualifiedName tableName = TestAddColumnTask.qualifiedName("not_existing_table");
        MoreFutures.getFutureValue(this.executeAddColumn(tableName, new Identifier("test"), (Type)IntegerType.INTEGER, Optional.empty(), true, false));
    }

    @Test
    public void testAddColumnNotExists() {
        QualifiedObjectName tableName = TestAddColumnTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "test-catalog", TestAddColumnTask.someTable(tableName), false);
        TableHandle table = this.metadata.getTableHandle(this.testSession, tableName).get();
        Assertions.assertThat((List)this.metadata.getTableMetadata(this.testSession, table).getColumns()).containsExactly((Object[])new ColumnMetadata[]{new ColumnMetadata("test", (Type)BigintType.BIGINT)});
        MoreFutures.getFutureValue(this.executeAddColumn(TestAddColumnTask.asQualifiedName(tableName), new Identifier("test"), (Type)IntegerType.INTEGER, Optional.empty(), false, true));
        Assertions.assertThat((List)this.metadata.getTableMetadata(this.testSession, table).getColumns()).containsExactly((Object[])new ColumnMetadata[]{new ColumnMetadata("test", (Type)BigintType.BIGINT)});
    }

    @Test
    public void testAddColumnAlreadyExist() {
        QualifiedObjectName tableName = TestAddColumnTask.qualifiedObjectName("existing_table");
        this.metadata.createTable(this.testSession, "test-catalog", TestAddColumnTask.someTable(tableName), false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeAddColumn(TestAddColumnTask.asQualifiedName(tableName), new Identifier("test"), (Type)IntegerType.INTEGER, Optional.empty(), false, false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_ALREADY_EXISTS}).hasMessage("Column 'test' already exists");
    }

    @Test
    public void testAddColumnOnView() {
        QualifiedObjectName viewName = TestAddColumnTask.qualifiedObjectName("existing_view");
        this.metadata.createView(this.testSession, viewName, TestAddColumnTask.someView(), false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeAddColumn(TestAddColumnTask.asQualifiedName(viewName), new Identifier("test"), (Type)IntegerType.INTEGER, Optional.empty(), false, false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND}).hasMessageContaining("Table '%s' does not exist", new Object[]{viewName});
    }

    @Test
    public void testAddColumnOnMaterializedView() {
        QualifiedObjectName materializedViewName = TestAddColumnTask.qualifiedObjectName("existing_materialized_view");
        this.metadata.createMaterializedView(this.testSession, QualifiedObjectName.valueOf((String)materializedViewName.toString()), this.someMaterializedView(), false, false);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> MoreFutures.getFutureValue(this.executeAddColumn(TestAddColumnTask.asQualifiedName(materializedViewName), new Identifier("test"), (Type)IntegerType.INTEGER, Optional.empty(), false, false))).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND}).hasMessageContaining("Table '%s' does not exist", new Object[]{materializedViewName});
    }

    private ListenableFuture<Void> executeAddColumn(QualifiedName table, Identifier column, Type type, Optional<String> comment, boolean tableExists, boolean columnNotExists) {
        ColumnDefinition columnDefinition = new ColumnDefinition(column, TypeSignatureTranslator.toSqlType((Type)type), true, (List)ImmutableList.of(), comment);
        return this.executeAddColumn(table, columnDefinition, tableExists, columnNotExists);
    }

    private ListenableFuture<Void> executeAddColumn(QualifiedName table, Identifier column, Type type, List<Property> properties, boolean tableExists, boolean columnNotExists) {
        ColumnDefinition columnDefinition = new ColumnDefinition(column, TypeSignatureTranslator.toSqlType((Type)type), true, properties, Optional.empty());
        return this.executeAddColumn(table, columnDefinition, tableExists, columnNotExists);
    }

    private ListenableFuture<Void> executeAddColumn(QualifiedName table, ColumnDefinition columnDefinition, boolean tableExists, boolean columnNotExists) {
        return new AddColumnTask(this.plannerContext, (AccessControl)new AllowAllAccessControl(), this.columnPropertyManager).execute(new AddColumn(table, columnDefinition, tableExists, columnNotExists), this.queryStateMachine, (List)ImmutableList.of(), WarningCollector.NOOP);
    }
}

