/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.Threads;
import io.airlift.slice.Slice;
import io.airlift.stats.CounterStat;
import io.airlift.stats.GcMonitor;
import io.airlift.stats.TestingGcMonitor;
import io.airlift.tracing.Tracing;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.trino.SessionTestUtils;
import io.trino.exchange.ExchangeManagerRegistry;
import io.trino.execution.DynamicFiltersCollector;
import io.trino.execution.SplitAssignment;
import io.trino.execution.SqlTask;
import io.trino.execution.SqlTaskExecutionFactory;
import io.trino.execution.StageId;
import io.trino.execution.TaskId;
import io.trino.execution.TaskInfo;
import io.trino.execution.TaskManagerConfig;
import io.trino.execution.TaskState;
import io.trino.execution.TaskStateMachine;
import io.trino.execution.TaskStatus;
import io.trino.execution.TaskTestUtils;
import io.trino.execution.buffer.BufferResult;
import io.trino.execution.buffer.BufferState;
import io.trino.execution.buffer.OutputBuffers;
import io.trino.execution.buffer.PagesSerdeUtil;
import io.trino.execution.buffer.PipelinedOutputBuffers;
import io.trino.execution.executor.TaskExecutor;
import io.trino.memory.MemoryPool;
import io.trino.memory.QueryContext;
import io.trino.operator.TaskContext;
import io.trino.spi.QueryId;
import io.trino.spi.predicate.Domain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.spiller.SpillSpaceTracker;
import io.trino.sql.planner.LocalExecutionPlanner;
import io.trino.testing.TestingSession;
import io.trino.testing.assertions.Assert;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestSqlTask {
    public static final PipelinedOutputBuffers.OutputBufferId OUT = new PipelinedOutputBuffers.OutputBufferId(0);
    private TaskExecutor taskExecutor;
    private ScheduledExecutorService taskNotificationExecutor;
    private ScheduledExecutorService driverYieldExecutor;
    private SqlTaskExecutionFactory sqlTaskExecutionFactory;
    private final AtomicInteger nextTaskId = new AtomicInteger();

    @BeforeClass
    public void setUp() {
        this.taskExecutor = new TaskExecutor(8, 16, 3, 4, Ticker.systemTicker());
        this.taskExecutor.start();
        this.taskNotificationExecutor = Executors.newScheduledThreadPool(10, Threads.threadsNamed((String)"task-notification-%s"));
        this.driverYieldExecutor = Executors.newScheduledThreadPool(2, Threads.threadsNamed((String)"driver-yield-%s"));
        LocalExecutionPlanner planner = TaskTestUtils.createTestingPlanner();
        this.sqlTaskExecutionFactory = new SqlTaskExecutionFactory((Executor)this.taskNotificationExecutor, this.taskExecutor, planner, TaskTestUtils.createTestSplitMonitor(), Tracing.noopTracer(), new TaskManagerConfig());
    }

    @AfterClass(alwaysRun=true)
    public void destroy() {
        this.taskExecutor.stop();
        this.taskExecutor = null;
        this.taskNotificationExecutor.shutdownNow();
        this.driverYieldExecutor.shutdown();
        this.sqlTaskExecutionFactory = null;
    }

    @Test(timeOut=30000L)
    public void testEmptyQuery() throws Exception {
        SqlTask sqlTask = this.createInitialTask();
        TaskInfo taskInfo = sqlTask.updateTask(SessionTestUtils.TEST_SESSION, Span.getInvalid(), Optional.of(TaskTestUtils.PLAN_FRAGMENT), (List)ImmutableList.of(), (OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withNoMoreBufferIds(), (Map)ImmutableMap.of());
        org.testng.Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
        org.testng.Assert.assertEquals((long)taskInfo.getTaskStatus().getVersion(), (long)0L);
        taskInfo = sqlTask.getTaskInfo();
        org.testng.Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
        org.testng.Assert.assertEquals((long)taskInfo.getTaskStatus().getVersion(), (long)0L);
        taskInfo = sqlTask.updateTask(SessionTestUtils.TEST_SESSION, Span.getInvalid(), Optional.of(TaskTestUtils.PLAN_FRAGMENT), (List)ImmutableList.of((Object)new SplitAssignment(TaskTestUtils.TABLE_SCAN_NODE_ID, (Set)ImmutableSet.of(), true)), (OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withNoMoreBufferIds(), (Map)ImmutableMap.of());
        org.testng.Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FINISHED);
        taskInfo = (TaskInfo)sqlTask.getTaskInfo(0L).get();
        org.testng.Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FINISHED);
    }

    @Test(timeOut=30000L)
    public void testSimpleQuery() throws Exception {
        SqlTask sqlTask = this.createInitialTask();
        org.testng.Assert.assertEquals((Object)sqlTask.getTaskStatus().getState(), (Object)TaskState.RUNNING);
        org.testng.Assert.assertEquals((long)sqlTask.getTaskStatus().getVersion(), (long)0L);
        sqlTask.updateTask(SessionTestUtils.TEST_SESSION, Span.getInvalid(), Optional.of(TaskTestUtils.PLAN_FRAGMENT), (List)ImmutableList.of((Object)new SplitAssignment(TaskTestUtils.TABLE_SCAN_NODE_ID, (Set)ImmutableSet.of((Object)TaskTestUtils.SPLIT), true)), (OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds(), (Map)ImmutableMap.of());
        TaskInfo taskInfo = (TaskInfo)sqlTask.getTaskInfo(0L).get();
        org.testng.Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FLUSHING);
        org.testng.Assert.assertEquals((long)taskInfo.getTaskStatus().getVersion(), (long)1L);
        org.testng.Assert.assertTrue((boolean)sqlTask.getTaskInfo(0L).isDone());
        BufferResult results = (BufferResult)sqlTask.getTaskResults(OUT, 0L, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).get();
        org.testng.Assert.assertFalse((boolean)results.isBufferComplete());
        org.testng.Assert.assertEquals((int)results.getSerializedPages().size(), (int)1);
        org.testng.Assert.assertEquals((int)PagesSerdeUtil.getSerializedPagePositionCount((Slice)((Slice)results.getSerializedPages().get(0))), (int)1);
        boolean moreResults = true;
        while (moreResults) {
            moreResults = !(results = (BufferResult)sqlTask.getTaskResults(OUT, results.getToken() + (long)results.getSerializedPages().size(), DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).get()).isBufferComplete();
        }
        org.testng.Assert.assertEquals((int)results.getSerializedPages().size(), (int)0);
        TaskInfo info = sqlTask.destroyTaskResults(OUT);
        org.testng.Assert.assertEquals((Object)info.getOutputBuffers().getState(), (Object)BufferState.FINISHED);
        taskInfo = (TaskInfo)sqlTask.getTaskInfo(info.getTaskStatus().getVersion()).get();
        org.testng.Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FINISHED);
        org.testng.Assert.assertTrue((boolean)sqlTask.getTaskInfo(100L).isDone());
        taskInfo = sqlTask.getTaskInfo();
        org.testng.Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FINISHED);
    }

    @Test
    public void testCancel() {
        int attempts;
        SqlTask sqlTask = this.createInitialTask();
        TaskInfo taskInfo = sqlTask.updateTask(SessionTestUtils.TEST_SESSION, Span.getInvalid(), Optional.of(TaskTestUtils.PLAN_FRAGMENT), (List)ImmutableList.of(), (OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds(), (Map)ImmutableMap.of());
        org.testng.Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
        org.testng.Assert.assertNull((Object)taskInfo.getStats().getEndTime());
        taskInfo = sqlTask.getTaskInfo();
        org.testng.Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
        org.testng.Assert.assertNull((Object)taskInfo.getStats().getEndTime());
        taskInfo = sqlTask.cancel();
        org.testng.Assert.assertTrue((boolean)taskInfo.getTaskStatus().getState().isTerminatingOrDone());
        for (attempts = 1; !taskInfo.getTaskStatus().getState().isDone() && attempts < 3; ++attempts) {
            taskInfo = (TaskInfo)Futures.getUnchecked((Future)sqlTask.getTaskInfo(taskInfo.getTaskStatus().getVersion()));
        }
        org.testng.Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.CANCELED, (String)("Failed to see CANCELED after " + attempts + " attempts"));
        org.testng.Assert.assertNotNull((Object)taskInfo.getStats().getEndTime());
        taskInfo = sqlTask.getTaskInfo();
        org.testng.Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.CANCELED);
        org.testng.Assert.assertNotNull((Object)taskInfo.getStats().getEndTime());
    }

    @Test(timeOut=30000L)
    public void testAbort() throws Exception {
        SqlTask sqlTask = this.createInitialTask();
        org.testng.Assert.assertEquals((Object)sqlTask.getTaskStatus().getState(), (Object)TaskState.RUNNING);
        org.testng.Assert.assertEquals((long)sqlTask.getTaskStatus().getVersion(), (long)0L);
        sqlTask.updateTask(SessionTestUtils.TEST_SESSION, Span.getInvalid(), Optional.of(TaskTestUtils.PLAN_FRAGMENT), (List)ImmutableList.of((Object)new SplitAssignment(TaskTestUtils.TABLE_SCAN_NODE_ID, (Set)ImmutableSet.of((Object)TaskTestUtils.SPLIT), true)), (OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds(), (Map)ImmutableMap.of());
        TaskInfo taskInfo = (TaskInfo)sqlTask.getTaskInfo(0L).get();
        org.testng.Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FLUSHING);
        org.testng.Assert.assertEquals((long)taskInfo.getTaskStatus().getVersion(), (long)1L);
        sqlTask.destroyTaskResults(OUT);
        taskInfo = (TaskInfo)sqlTask.getTaskInfo(taskInfo.getTaskStatus().getVersion()).get();
        org.testng.Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FINISHED);
        taskInfo = sqlTask.getTaskInfo();
        org.testng.Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FINISHED);
    }

    @Test
    public void testBufferCloseOnFinish() throws Exception {
        SqlTask sqlTask = this.createInitialTask();
        PipelinedOutputBuffers outputBuffers = PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds();
        TaskTestUtils.updateTask(sqlTask, TaskTestUtils.EMPTY_SPLIT_ASSIGNMENTS, (OutputBuffers)outputBuffers);
        ListenableFuture bufferResult = sqlTask.getTaskResults(OUT, 0L, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE));
        org.testng.Assert.assertFalse((boolean)bufferResult.isDone());
        TaskTestUtils.updateTask(sqlTask, (List<SplitAssignment>)ImmutableList.of((Object)new SplitAssignment(TaskTestUtils.TABLE_SCAN_NODE_ID, (Set)ImmutableSet.of(), true)), (OutputBuffers)outputBuffers);
        sqlTask.destroyTaskResults(OUT);
        bufferResult.get(1L, TimeUnit.SECONDS);
        bufferResult = sqlTask.getTaskResults(OUT, 0L, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE));
        org.testng.Assert.assertTrue((boolean)bufferResult.isDone());
        org.testng.Assert.assertTrue((boolean)((BufferResult)bufferResult.get()).isBufferComplete());
    }

    @Test
    public void testBufferCloseOnCancel() throws Exception {
        SqlTask sqlTask = this.createInitialTask();
        TaskTestUtils.updateTask(sqlTask, TaskTestUtils.EMPTY_SPLIT_ASSIGNMENTS, (OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds());
        ListenableFuture bufferResult = sqlTask.getTaskResults(OUT, 0L, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE));
        org.testng.Assert.assertFalse((boolean)bufferResult.isDone());
        sqlTask.cancel();
        org.testng.Assert.assertTrue((boolean)sqlTask.getTaskInfo().getTaskStatus().getState().isTerminatingOrDone());
        bufferResult.get(1L, TimeUnit.SECONDS);
        bufferResult = sqlTask.getTaskResults(OUT, 0L, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE));
        org.testng.Assert.assertTrue((boolean)bufferResult.isDone());
        org.testng.Assert.assertTrue((boolean)((BufferResult)bufferResult.get()).isBufferComplete());
    }

    @Test(timeOut=30000L)
    public void testBufferNotCloseOnFail() throws Exception {
        SqlTask sqlTask = this.createInitialTask();
        TaskTestUtils.updateTask(sqlTask, TaskTestUtils.EMPTY_SPLIT_ASSIGNMENTS, (OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds());
        ListenableFuture bufferResult = sqlTask.getTaskResults(OUT, 0L, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE));
        org.testng.Assert.assertFalse((boolean)bufferResult.isDone());
        long taskStatusVersion = sqlTask.getTaskInfo().getTaskStatus().getVersion();
        sqlTask.failed((Throwable)new Exception("test"));
        TaskInfo taskInfo = (TaskInfo)sqlTask.getTaskInfo(taskStatusVersion).get();
        org.testng.Assert.assertTrue((boolean)taskInfo.getTaskStatus().getState().isTerminatingOrDone());
        taskStatusVersion = taskInfo.getTaskStatus().getVersion();
        org.testng.Assert.assertEquals((Object)((TaskInfo)sqlTask.getTaskInfo(taskStatusVersion).get()).getTaskStatus().getState(), (Object)TaskState.FAILED);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> bufferResult.get(1L, TimeUnit.SECONDS)).isInstanceOf(TimeoutException.class)).hasMessageContaining("Waited 1 seconds");
        org.testng.Assert.assertFalse((boolean)sqlTask.getTaskResults(OUT, 0L, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).isDone());
    }

    @Test(timeOut=30000L)
    public void testDynamicFilters() throws Exception {
        SqlTask sqlTask = this.createInitialTask();
        sqlTask.updateTask(SessionTestUtils.TEST_SESSION, Span.getInvalid(), Optional.of(TaskTestUtils.PLAN_FRAGMENT_WITH_DYNAMIC_FILTER_SOURCE), (List)ImmutableList.of((Object)new SplitAssignment(TaskTestUtils.TABLE_SCAN_NODE_ID, (Set)ImmutableSet.of((Object)TaskTestUtils.SPLIT), false)), (OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds(), (Map)ImmutableMap.of());
        org.testng.Assert.assertEquals((long)sqlTask.getTaskStatus().getDynamicFiltersVersion(), (long)0L);
        TaskContext taskContext = sqlTask.getQueryContext().getTaskContextByTaskId(sqlTask.getTaskId());
        ListenableFuture future = sqlTask.getTaskStatus(0L);
        org.testng.Assert.assertFalse((boolean)future.isDone());
        taskContext.updateDomains((Map)ImmutableMap.of((Object)TaskTestUtils.DYNAMIC_FILTER_SOURCE_ID, (Object)Domain.none((Type)BigintType.BIGINT)));
        org.testng.Assert.assertEquals((long)sqlTask.getTaskStatus().getVersion(), (long)1L);
        org.testng.Assert.assertEquals((long)sqlTask.getTaskStatus().getDynamicFiltersVersion(), (long)1L);
        future.get();
    }

    @Test(timeOut=30000L)
    public void testDynamicFilterFetchAfterTaskDone() throws Exception {
        SqlTask sqlTask = this.createInitialTask();
        PipelinedOutputBuffers outputBuffers = PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds();
        sqlTask.updateTask(SessionTestUtils.TEST_SESSION, Span.getInvalid(), Optional.of(TaskTestUtils.PLAN_FRAGMENT_WITH_DYNAMIC_FILTER_SOURCE), (List)ImmutableList.of((Object)new SplitAssignment(TaskTestUtils.TABLE_SCAN_NODE_ID, (Set)ImmutableSet.of(), false)), (OutputBuffers)outputBuffers, (Map)ImmutableMap.of());
        org.testng.Assert.assertEquals((long)sqlTask.getTaskStatus().getDynamicFiltersVersion(), (long)0L);
        TaskTestUtils.updateTask(sqlTask, (List<SplitAssignment>)ImmutableList.of((Object)new SplitAssignment(TaskTestUtils.TABLE_SCAN_NODE_ID, (Set)ImmutableSet.of(), true)), (OutputBuffers)outputBuffers);
        TaskInfo info = sqlTask.destroyTaskResults(OUT);
        org.testng.Assert.assertEquals((Object)info.getOutputBuffers().getState(), (Object)BufferState.FINISHED);
        Assert.assertEventually((Duration)new Duration(10.0, TimeUnit.SECONDS), () -> {
            TaskStatus status = (TaskStatus)sqlTask.getTaskStatus(info.getTaskStatus().getVersion()).get();
            org.testng.Assert.assertEquals((Object)status.getState(), (Object)TaskState.FINISHED);
            org.testng.Assert.assertEquals((long)status.getDynamicFiltersVersion(), (long)1L);
        });
        DynamicFiltersCollector.VersionedDynamicFilterDomains versionedDynamicFilters = sqlTask.acknowledgeAndGetNewDynamicFilterDomains(0L);
        org.testng.Assert.assertEquals((long)versionedDynamicFilters.getVersion(), (long)1L);
        org.testng.Assert.assertEquals((Map)versionedDynamicFilters.getDynamicFilterDomains(), (Map)ImmutableMap.of((Object)TaskTestUtils.DYNAMIC_FILTER_SOURCE_ID, (Object)Domain.none((Type)VarcharType.VARCHAR)));
    }

    private SqlTask createInitialTask() {
        TaskId taskId = new TaskId(new StageId("query", 0), this.nextTaskId.incrementAndGet(), 0);
        URI location = URI.create("fake://task/" + taskId);
        QueryContext queryContext = new QueryContext(new QueryId("query"), DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE), new MemoryPool(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE)), (GcMonitor)new TestingGcMonitor(), (Executor)this.taskNotificationExecutor, this.driverYieldExecutor, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE), new SpillSpaceTracker(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE)));
        queryContext.addTaskContext(new TaskStateMachine(taskId, (Executor)this.taskNotificationExecutor), TestingSession.testSessionBuilder().build(), () -> {}, false, false);
        return SqlTask.createSqlTask((TaskId)taskId, (URI)location, (String)"fake", (QueryContext)queryContext, (Tracer)Tracing.noopTracer(), (SqlTaskExecutionFactory)this.sqlTaskExecutionFactory, (ExecutorService)this.taskNotificationExecutor, sqlTask -> {}, (DataSize)DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE), (DataSize)DataSize.of((long)200L, (DataSize.Unit)DataSize.Unit.MEGABYTE), (ExchangeManagerRegistry)new ExchangeManagerRegistry(), (CounterStat)new CounterStat());
    }
}

