/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.node.NodeInfo;
import io.airlift.slice.Slice;
import io.airlift.stats.GcMonitor;
import io.airlift.stats.TestingGcMonitor;
import io.airlift.testing.TestingTicker;
import io.airlift.tracing.Tracing;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.opentelemetry.api.trace.Span;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.connector.CatalogProperties;
import io.trino.connector.ConnectorServices;
import io.trino.connector.ConnectorServicesProvider;
import io.trino.exchange.ExchangeManagerRegistry;
import io.trino.execution.LocationFactory;
import io.trino.execution.ScheduledSplit;
import io.trino.execution.SplitAssignment;
import io.trino.execution.SplitRunner;
import io.trino.execution.SqlTaskManager;
import io.trino.execution.StageId;
import io.trino.execution.TaskFailureListener;
import io.trino.execution.TaskId;
import io.trino.execution.TaskInfo;
import io.trino.execution.TaskManagementExecutor;
import io.trino.execution.TaskManagerConfig;
import io.trino.execution.TaskState;
import io.trino.execution.TaskStateMachine;
import io.trino.execution.TaskTestUtils;
import io.trino.execution.buffer.BufferResult;
import io.trino.execution.buffer.BufferState;
import io.trino.execution.buffer.OutputBuffers;
import io.trino.execution.buffer.PagesSerdeUtil;
import io.trino.execution.buffer.PipelinedOutputBuffers;
import io.trino.execution.executor.TaskExecutor;
import io.trino.execution.executor.TaskHandle;
import io.trino.memory.LocalMemoryManager;
import io.trino.memory.NodeMemoryConfig;
import io.trino.memory.QueryContext;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.metadata.InternalNode;
import io.trino.operator.DirectExchangeClient;
import io.trino.operator.DirectExchangeClientSupplier;
import io.trino.operator.RetryPolicy;
import io.trino.spi.QueryId;
import io.trino.spi.VersionEmbedder;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.exchange.ExchangeId;
import io.trino.spiller.LocalSpillManager;
import io.trino.spiller.NodeSpillConfig;
import io.trino.testing.TestingSession;
import io.trino.version.EmbedVersion;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import javax.annotation.concurrent.GuardedBy;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestSqlTaskManager {
    private static final TaskId TASK_ID = new TaskId(new StageId("query", 0), 1, 0);
    public static final PipelinedOutputBuffers.OutputBufferId OUT = new PipelinedOutputBuffers.OutputBufferId(0);
    private TaskExecutor taskExecutor;
    private TaskManagementExecutor taskManagementExecutor;
    private LocalMemoryManager localMemoryManager;
    private LocalSpillManager localSpillManager;

    @BeforeClass
    public void setUp() {
        this.localMemoryManager = new LocalMemoryManager(new NodeMemoryConfig());
        this.localSpillManager = new LocalSpillManager(new NodeSpillConfig());
        this.taskExecutor = new TaskExecutor(8, 16, 3, 4, Ticker.systemTicker());
        this.taskExecutor.start();
        this.taskManagementExecutor = new TaskManagementExecutor();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.taskExecutor.stop();
        this.taskExecutor = null;
        this.taskManagementExecutor.close();
        this.taskManagementExecutor = null;
    }

    @Test
    public void testEmptyQuery() {
        try (SqlTaskManager sqlTaskManager = this.createSqlTaskManager(new TaskManagerConfig());){
            TaskId taskId = TASK_ID;
            TaskInfo taskInfo = this.createTask(sqlTaskManager, taskId, (OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withNoMoreBufferIds());
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
            taskInfo = this.createTask(sqlTaskManager, taskId, (ImmutableSet<ScheduledSplit>)ImmutableSet.of(), (OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withNoMoreBufferIds());
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FINISHED);
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FINISHED);
        }
    }

    @Test(timeOut=30000L)
    public void testSimpleQuery() throws Exception {
        try (SqlTaskManager sqlTaskManager = this.createSqlTaskManager(new TaskManagerConfig());){
            TaskId taskId = TASK_ID;
            this.createTask(sqlTaskManager, taskId, (ImmutableSet<ScheduledSplit>)ImmutableSet.of((Object)TaskTestUtils.SPLIT), (OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds());
            TaskInfo taskInfo = (TaskInfo)sqlTaskManager.getTaskInfo(taskId, 0L).get();
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FLUSHING);
            BufferResult results = (BufferResult)sqlTaskManager.getTaskResults(taskId, OUT, 0L, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).getResultsFuture().get();
            Assert.assertFalse((boolean)results.isBufferComplete());
            Assert.assertEquals((int)results.getSerializedPages().size(), (int)1);
            Assert.assertEquals((int)PagesSerdeUtil.getSerializedPagePositionCount((Slice)((Slice)results.getSerializedPages().get(0))), (int)1);
            boolean moreResults = true;
            while (moreResults) {
                moreResults = !(results = (BufferResult)sqlTaskManager.getTaskResults(taskId, OUT, results.getToken() + (long)results.getSerializedPages().size(), DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).getResultsFuture().get()).isBufferComplete();
            }
            Assert.assertTrue((boolean)results.isBufferComplete());
            Assert.assertEquals((int)results.getSerializedPages().size(), (int)0);
            TaskInfo info = sqlTaskManager.destroyTaskResults(taskId, OUT);
            Assert.assertEquals((Object)info.getOutputBuffers().getState(), (Object)BufferState.FINISHED);
            taskInfo = (TaskInfo)sqlTaskManager.getTaskInfo(taskId, taskInfo.getTaskStatus().getVersion()).get();
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FINISHED);
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FINISHED);
        }
    }

    @Test
    public void testCancel() throws InterruptedException, ExecutionException, TimeoutException {
        try (SqlTaskManager sqlTaskManager = this.createSqlTaskManager(new TaskManagerConfig());){
            TaskId taskId = TASK_ID;
            TaskInfo taskInfo = this.createTask(sqlTaskManager, taskId, (OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds());
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
            Assert.assertNull((Object)taskInfo.getStats().getEndTime());
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
            Assert.assertNull((Object)taskInfo.getStats().getEndTime());
            taskInfo = TestSqlTaskManager.pollTerminatingTaskInfoUntilDone(sqlTaskManager, sqlTaskManager.cancelTask(taskId));
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.CANCELED);
            Assert.assertNotNull((Object)taskInfo.getStats().getEndTime());
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.CANCELED);
            Assert.assertNotNull((Object)taskInfo.getStats().getEndTime());
        }
    }

    @Test
    public void testAbort() throws InterruptedException, ExecutionException, TimeoutException {
        try (SqlTaskManager sqlTaskManager = this.createSqlTaskManager(new TaskManagerConfig());){
            TaskId taskId = TASK_ID;
            TaskInfo taskInfo = this.createTask(sqlTaskManager, taskId, (OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds());
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
            Assert.assertNull((Object)taskInfo.getStats().getEndTime());
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
            Assert.assertNull((Object)taskInfo.getStats().getEndTime());
            taskInfo = TestSqlTaskManager.pollTerminatingTaskInfoUntilDone(sqlTaskManager, sqlTaskManager.abortTask(taskId));
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.ABORTED);
            Assert.assertNotNull((Object)taskInfo.getStats().getEndTime());
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.ABORTED);
            Assert.assertNotNull((Object)taskInfo.getStats().getEndTime());
        }
    }

    @Test(timeOut=30000L)
    public void testAbortResults() throws Exception {
        try (SqlTaskManager sqlTaskManager = this.createSqlTaskManager(new TaskManagerConfig());){
            TaskId taskId = TASK_ID;
            this.createTask(sqlTaskManager, taskId, (ImmutableSet<ScheduledSplit>)ImmutableSet.of((Object)TaskTestUtils.SPLIT), (OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds());
            TaskInfo taskInfo = (TaskInfo)sqlTaskManager.getTaskInfo(taskId, 0L).get();
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FLUSHING);
            sqlTaskManager.destroyTaskResults(taskId, OUT);
            taskInfo = (TaskInfo)sqlTaskManager.getTaskInfo(taskId, taskInfo.getTaskStatus().getVersion()).get();
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FINISHED);
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FINISHED);
        }
    }

    @Test
    public void testRemoveOldTasks() throws InterruptedException, ExecutionException, TimeoutException {
        try (SqlTaskManager sqlTaskManager = this.createSqlTaskManager(new TaskManagerConfig().setInfoMaxAge(new Duration(5.0, TimeUnit.MILLISECONDS)));){
            TaskId taskId = TASK_ID;
            TaskInfo taskInfo = this.createTask(sqlTaskManager, taskId, (OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds());
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
            taskInfo = TestSqlTaskManager.pollTerminatingTaskInfoUntilDone(sqlTaskManager, sqlTaskManager.cancelTask(taskId));
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.CANCELED);
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.CANCELED);
            Thread.sleep(100L);
            sqlTaskManager.removeOldTasks();
            for (TaskInfo info : sqlTaskManager.getAllTaskInfo()) {
                Assert.assertNotEquals((Object)info.getTaskStatus().getTaskId(), (Object)taskId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailStuckSplitTasks() throws InterruptedException, ExecutionException, TimeoutException {
        TestingTicker ticker = new TestingTicker();
        TaskHandle taskHandle = this.taskExecutor.addTask(TASK_ID, () -> 1.0, 1, new Duration(1.0, TimeUnit.SECONDS), OptionalInt.of(1));
        MockSplitRunner mockSplitRunner = new MockSplitRunner();
        TaskExecutor taskExecutor = new TaskExecutor(4, 8, 3, 4, (Ticker)ticker);
        taskExecutor.enqueueSplits(taskHandle, false, (List)ImmutableList.of((Object)mockSplitRunner));
        taskExecutor.start();
        try {
            mockSplitRunner.waitForStart();
            TaskManagerConfig taskManagerConfig = new TaskManagerConfig().setInterruptStuckSplitTasksEnabled(true).setInterruptStuckSplitTasksDetectionInterval(new Duration(10.0, TimeUnit.SECONDS)).setInterruptStuckSplitTasksWarningThreshold(new Duration(10.0, TimeUnit.SECONDS)).setInterruptStuckSplitTasksTimeout(new Duration(10.0, TimeUnit.SECONDS));
            try (SqlTaskManager sqlTaskManager = this.createSqlTaskManager(taskManagerConfig, new NodeMemoryConfig(), taskExecutor, stackTraceElements -> true);){
                sqlTaskManager.addStateChangeListener(TASK_ID, state -> {
                    if (state.isTerminatingOrDone() && !taskHandle.isDestroyed()) {
                        taskExecutor.removeTask(taskHandle);
                    }
                });
                ticker.increment(30L, TimeUnit.SECONDS);
                sqlTaskManager.failStuckSplitTasks();
                mockSplitRunner.waitForFinish();
                List taskInfos = sqlTaskManager.getAllTaskInfo();
                Assert.assertEquals((int)taskInfos.size(), (int)1);
                TaskInfo taskInfo = TestSqlTaskManager.pollTerminatingTaskInfoUntilDone(sqlTaskManager, (TaskInfo)taskInfos.get(0));
                Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FAILED);
            }
        }
        finally {
            taskExecutor.stop();
        }
    }

    @Test
    public void testSessionPropertyMemoryLimitOverride() {
        NodeMemoryConfig memoryConfig = new NodeMemoryConfig().setMaxQueryMemoryPerNode(DataSize.ofBytes((long)3L));
        try (SqlTaskManager sqlTaskManager = this.createSqlTaskManager(new TaskManagerConfig(), memoryConfig);){
            TaskId reduceLimitsId = new TaskId(new StageId("q1", 0), 1, 0);
            TaskId increaseLimitsId = new TaskId(new StageId("q2", 0), 1, 0);
            QueryContext reducesLimitsContext = sqlTaskManager.getQueryContext(reduceLimitsId.getQueryId());
            QueryContext attemptsIncreaseContext = sqlTaskManager.getQueryContext(increaseLimitsId.getQueryId());
            Assert.assertFalse((boolean)reducesLimitsContext.isMemoryLimitsInitialized());
            Assert.assertEquals((long)reducesLimitsContext.getMaxUserMemory(), (long)memoryConfig.getMaxQueryMemoryPerNode().toBytes());
            Assert.assertFalse((boolean)attemptsIncreaseContext.isMemoryLimitsInitialized());
            Assert.assertEquals((long)attemptsIncreaseContext.getMaxUserMemory(), (long)memoryConfig.getMaxQueryMemoryPerNode().toBytes());
            sqlTaskManager.updateTask(TestingSession.testSessionBuilder().setSystemProperty("query_max_memory_per_node", "1B").build(), reduceLimitsId, Span.getInvalid(), Optional.of(TaskTestUtils.PLAN_FRAGMENT), (List)ImmutableList.of((Object)new SplitAssignment(TaskTestUtils.TABLE_SCAN_NODE_ID, (Set)ImmutableSet.of((Object)TaskTestUtils.SPLIT), true)), (OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds(), (Map)ImmutableMap.of());
            Assert.assertTrue((boolean)reducesLimitsContext.isMemoryLimitsInitialized());
            Assert.assertEquals((long)reducesLimitsContext.getMaxUserMemory(), (long)1L);
            sqlTaskManager.updateTask(TestingSession.testSessionBuilder().setSystemProperty("query_max_memory_per_node", "10B").build(), increaseLimitsId, Span.getInvalid(), Optional.of(TaskTestUtils.PLAN_FRAGMENT), (List)ImmutableList.of((Object)new SplitAssignment(TaskTestUtils.TABLE_SCAN_NODE_ID, (Set)ImmutableSet.of((Object)TaskTestUtils.SPLIT), true)), (OutputBuffers)PipelinedOutputBuffers.createInitial((PipelinedOutputBuffers.BufferType)PipelinedOutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds(), (Map)ImmutableMap.of());
            Assert.assertTrue((boolean)attemptsIncreaseContext.isMemoryLimitsInitialized());
            Assert.assertEquals((long)attemptsIncreaseContext.getMaxUserMemory(), (long)memoryConfig.getMaxQueryMemoryPerNode().toBytes());
        }
    }

    private SqlTaskManager createSqlTaskManager(TaskManagerConfig config) {
        return this.createSqlTaskManager(config, new NodeMemoryConfig());
    }

    private SqlTaskManager createSqlTaskManager(TaskManagerConfig taskManagerConfig, NodeMemoryConfig nodeMemoryConfig) {
        return new SqlTaskManager((VersionEmbedder)new EmbedVersion("testversion"), (ConnectorServicesProvider)new NoConnectorServicesProvider(), TaskTestUtils.createTestingPlanner(), (LocationFactory)new MockLocationFactory(), this.taskExecutor, TaskTestUtils.createTestSplitMonitor(), new NodeInfo("test"), this.localMemoryManager, this.taskManagementExecutor, taskManagerConfig, nodeMemoryConfig, this.localSpillManager, new NodeSpillConfig(), (GcMonitor)new TestingGcMonitor(), Tracing.noopTracer(), new ExchangeManagerRegistry());
    }

    private SqlTaskManager createSqlTaskManager(TaskManagerConfig taskManagerConfig, NodeMemoryConfig nodeMemoryConfig, TaskExecutor taskExecutor, Predicate<List<StackTraceElement>> stuckSplitStackTracePredicate) {
        return new SqlTaskManager((VersionEmbedder)new EmbedVersion("testversion"), (ConnectorServicesProvider)new NoConnectorServicesProvider(), TaskTestUtils.createTestingPlanner(), (LocationFactory)new MockLocationFactory(), taskExecutor, TaskTestUtils.createTestSplitMonitor(), new NodeInfo("test"), this.localMemoryManager, this.taskManagementExecutor, taskManagerConfig, nodeMemoryConfig, this.localSpillManager, new NodeSpillConfig(), (GcMonitor)new TestingGcMonitor(), Tracing.noopTracer(), new ExchangeManagerRegistry(), stuckSplitStackTracePredicate);
    }

    private TaskInfo createTask(SqlTaskManager sqlTaskManager, TaskId taskId, ImmutableSet<ScheduledSplit> splits, OutputBuffers outputBuffers) {
        return sqlTaskManager.updateTask(SessionTestUtils.TEST_SESSION, taskId, Span.getInvalid(), Optional.of(TaskTestUtils.PLAN_FRAGMENT), (List)ImmutableList.of((Object)new SplitAssignment(TaskTestUtils.TABLE_SCAN_NODE_ID, splits, true)), outputBuffers, (Map)ImmutableMap.of());
    }

    private TaskInfo createTask(SqlTaskManager sqlTaskManager, TaskId taskId, OutputBuffers outputBuffers) {
        sqlTaskManager.getQueryContext(taskId.getQueryId()).addTaskContext(new TaskStateMachine(taskId, MoreExecutors.directExecutor()), TestingSession.testSessionBuilder().build(), () -> {}, false, false);
        return sqlTaskManager.updateTask(SessionTestUtils.TEST_SESSION, taskId, Span.getInvalid(), Optional.of(TaskTestUtils.PLAN_FRAGMENT), (List)ImmutableList.of(), outputBuffers, (Map)ImmutableMap.of());
    }

    private static TaskInfo pollTerminatingTaskInfoUntilDone(SqlTaskManager taskManager, TaskInfo taskInfo) throws InterruptedException, ExecutionException, TimeoutException {
        Assert.assertTrue((boolean)taskInfo.getTaskStatus().getState().isTerminatingOrDone());
        for (int attempts = 3; attempts > 0 && taskInfo.getTaskStatus().getState().isTerminating(); --attempts) {
            taskInfo = (TaskInfo)taskManager.getTaskInfo(taskInfo.getTaskStatus().getTaskId(), taskInfo.getTaskStatus().getVersion()).get(5L, TimeUnit.SECONDS);
        }
        return taskInfo;
    }

    private static class MockSplitRunner
    implements SplitRunner {
        private final SettableFuture<Void> startedFuture = SettableFuture.create();
        private final SettableFuture<Void> finishedFuture = SettableFuture.create();
        @GuardedBy(value="this")
        private Thread runnerThread;
        @GuardedBy(value="this")
        private boolean closed;

        private MockSplitRunner() {
        }

        public void waitForStart() throws ExecutionException, InterruptedException, TimeoutException {
            this.startedFuture.get(10L, TimeUnit.SECONDS);
        }

        public void waitForFinish() throws ExecutionException, InterruptedException, TimeoutException {
            this.finishedFuture.get(10L, TimeUnit.SECONDS);
        }

        public int getPipelineId() {
            return 0;
        }

        public Span getPipelineSpan() {
            return Span.getInvalid();
        }

        public synchronized boolean isFinished() {
            return this.closed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ListenableFuture<Void> processFor(Duration duration) {
            this.startedFuture.set(null);
            MockSplitRunner mockSplitRunner = this;
            synchronized (mockSplitRunner) {
                this.runnerThread = Thread.currentThread();
                if (this.closed) {
                    this.finishedFuture.set(null);
                    return Futures.immediateVoidFuture();
                }
            }
            try {
                while (true) {
                    Thread.sleep(100000L);
                }
            }
            catch (InterruptedException e) {
                MockSplitRunner mockSplitRunner2 = this;
                synchronized (mockSplitRunner2) {
                    this.closed = true;
                }
                this.finishedFuture.set(null);
                return Futures.immediateVoidFuture();
            }
        }

        public String getInfo() {
            return "MockSplitRunner";
        }

        public synchronized void close() {
            this.closed = true;
            if (this.runnerThread != null) {
                this.runnerThread.interrupt();
            }
        }
    }

    private static class NoConnectorServicesProvider
    implements ConnectorServicesProvider {
        private NoConnectorServicesProvider() {
        }

        public void loadInitialCatalogs() {
        }

        public void ensureCatalogsLoaded(Session session, List<CatalogProperties> catalogs) {
        }

        public void pruneCatalogs(Set<CatalogHandle> catalogsInUse) {
            throw new UnsupportedOperationException();
        }

        public ConnectorServices getConnectorServices(CatalogHandle catalogHandle) {
            throw new UnsupportedOperationException();
        }
    }

    public static class MockLocationFactory
    implements LocationFactory {
        public URI createQueryLocation(QueryId queryId) {
            return URI.create("http://fake.invalid/query/" + queryId);
        }

        public URI createLocalTaskLocation(TaskId taskId) {
            return URI.create("http://fake.invalid/task/" + taskId);
        }

        public URI createTaskLocation(InternalNode node, TaskId taskId) {
            return URI.create("http://fake.invalid/task/" + node.getNodeIdentifier() + "/" + taskId);
        }

        public URI createMemoryInfoLocation(InternalNode node) {
            return URI.create("http://fake.invalid/" + node.getNodeIdentifier() + "/memory");
        }
    }

    public static class MockDirectExchangeClientSupplier
    implements DirectExchangeClientSupplier {
        public DirectExchangeClient get(QueryId queryId, ExchangeId exchangeId, LocalMemoryContext memoryContext, TaskFailureListener taskFailureListener, RetryPolicy retryPolicy) {
            throw new UnsupportedOperationException();
        }
    }
}

