/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.resourcegroups;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.units.DataSize;
import io.trino.execution.ManagedQueryExecution;
import io.trino.execution.MockManagedQueryExecution;
import io.trino.execution.QueryState;
import io.trino.execution.resourcegroups.InternalResourceGroup;
import io.trino.server.QueryStateInfo;
import io.trino.server.ResourceGroupInfo;
import io.trino.spi.resourcegroups.ResourceGroupState;
import io.trino.spi.resourcegroups.SchedulingPolicy;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.apache.commons.math3.distribution.BinomialDistribution;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestResourceGroups {
    @Test(timeOut=10000L)
    public void testQueueFull() {
        InternalResourceGroup root = new InternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        root.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        root.setMaxQueuedQueries(1);
        root.setHardConcurrencyLimit(1);
        MockManagedQueryExecution query1 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        root.run((ManagedQueryExecution)query1);
        Assert.assertEquals((Object)query1.getState(), (Object)QueryState.RUNNING);
        MockManagedQueryExecution query2 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        root.run((ManagedQueryExecution)query2);
        Assert.assertEquals((Object)query2.getState(), (Object)QueryState.QUEUED);
        MockManagedQueryExecution query3 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        root.run((ManagedQueryExecution)query3);
        Assert.assertEquals((Object)query3.getState(), (Object)QueryState.FAILED);
        Assert.assertEquals((String)query3.getThrowable().getMessage(), (String)"Too many queued queries for \"root\"");
    }

    @Test(timeOut=10000L)
    public void testFairEligibility() {
        InternalResourceGroup root = new InternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        root.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        root.setMaxQueuedQueries(4);
        root.setHardConcurrencyLimit(1);
        InternalResourceGroup group1 = root.getOrCreateSubGroup("1");
        group1.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        group1.setMaxQueuedQueries(4);
        group1.setHardConcurrencyLimit(1);
        InternalResourceGroup group2 = root.getOrCreateSubGroup("2");
        group2.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        group2.setMaxQueuedQueries(4);
        group2.setHardConcurrencyLimit(1);
        InternalResourceGroup group3 = root.getOrCreateSubGroup("3");
        group3.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        group3.setMaxQueuedQueries(4);
        group3.setHardConcurrencyLimit(1);
        MockManagedQueryExecution query1a = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        group1.run((ManagedQueryExecution)query1a);
        Assert.assertEquals((Object)query1a.getState(), (Object)QueryState.RUNNING);
        MockManagedQueryExecution query1b = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        group1.run((ManagedQueryExecution)query1b);
        Assert.assertEquals((Object)query1b.getState(), (Object)QueryState.QUEUED);
        MockManagedQueryExecution query2a = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        group2.run((ManagedQueryExecution)query2a);
        Assert.assertEquals((Object)query2a.getState(), (Object)QueryState.QUEUED);
        MockManagedQueryExecution query2b = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        group2.run((ManagedQueryExecution)query2b);
        Assert.assertEquals((Object)query2b.getState(), (Object)QueryState.QUEUED);
        MockManagedQueryExecution query3a = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        group3.run((ManagedQueryExecution)query3a);
        Assert.assertEquals((Object)query3a.getState(), (Object)QueryState.QUEUED);
        query1a.complete();
        Assert.assertEquals((Object)query1b.getState(), (Object)QueryState.QUEUED);
        Assert.assertEquals((Object)query2a.getState(), (Object)QueryState.RUNNING);
        Assert.assertEquals((Object)query2b.getState(), (Object)QueryState.QUEUED);
        Assert.assertEquals((Object)query3a.getState(), (Object)QueryState.QUEUED);
        query2a.complete();
        Assert.assertEquals((Object)query3a.getState(), (Object)QueryState.RUNNING);
        Assert.assertEquals((Object)query2b.getState(), (Object)QueryState.QUEUED);
        Assert.assertEquals((Object)query1b.getState(), (Object)QueryState.QUEUED);
        query3a.complete();
        Assert.assertEquals((Object)query1b.getState(), (Object)QueryState.RUNNING);
        Assert.assertEquals((Object)query2b.getState(), (Object)QueryState.QUEUED);
    }

    @Test
    public void testSetSchedulingPolicy() {
        InternalResourceGroup root = new InternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        root.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        root.setMaxQueuedQueries(4);
        root.setHardConcurrencyLimit(1);
        InternalResourceGroup group1 = root.getOrCreateSubGroup("1");
        group1.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        group1.setMaxQueuedQueries(4);
        group1.setHardConcurrencyLimit(2);
        InternalResourceGroup group2 = root.getOrCreateSubGroup("2");
        group2.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        group2.setMaxQueuedQueries(4);
        group2.setHardConcurrencyLimit(2);
        MockManagedQueryExecution query1a = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        group1.run((ManagedQueryExecution)query1a);
        Assert.assertEquals((Object)query1a.getState(), (Object)QueryState.RUNNING);
        MockManagedQueryExecution query1b = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        group1.run((ManagedQueryExecution)query1b);
        Assert.assertEquals((Object)query1b.getState(), (Object)QueryState.QUEUED);
        MockManagedQueryExecution query1c = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        group1.run((ManagedQueryExecution)query1c);
        Assert.assertEquals((Object)query1c.getState(), (Object)QueryState.QUEUED);
        MockManagedQueryExecution query2a = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        group2.run((ManagedQueryExecution)query2a);
        Assert.assertEquals((Object)query2a.getState(), (Object)QueryState.QUEUED);
        Assert.assertEquals((int)root.getInfo().getNumEligibleSubGroups(), (int)2);
        Assert.assertEquals((int)root.getOrCreateSubGroup("1").getQueuedQueries(), (int)2);
        Assert.assertEquals((int)root.getOrCreateSubGroup("2").getQueuedQueries(), (int)1);
        Assert.assertEquals((Object)root.getSchedulingPolicy(), (Object)SchedulingPolicy.FAIR);
        root.setSchedulingPolicy(SchedulingPolicy.QUERY_PRIORITY);
        Assert.assertEquals((int)root.getInfo().getNumEligibleSubGroups(), (int)2);
        Assert.assertEquals((int)root.getOrCreateSubGroup("1").getQueuedQueries(), (int)2);
        Assert.assertEquals((int)root.getOrCreateSubGroup("2").getQueuedQueries(), (int)1);
        Assert.assertEquals((Object)root.getSchedulingPolicy(), (Object)SchedulingPolicy.QUERY_PRIORITY);
        Assert.assertEquals((Object)root.getOrCreateSubGroup("1").getSchedulingPolicy(), (Object)SchedulingPolicy.QUERY_PRIORITY);
        Assert.assertEquals((Object)root.getOrCreateSubGroup("2").getSchedulingPolicy(), (Object)SchedulingPolicy.QUERY_PRIORITY);
    }

    @Test(timeOut=10000L)
    public void testFairQueuing() {
        InternalResourceGroup root = new InternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        root.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        root.setMaxQueuedQueries(4);
        root.setHardConcurrencyLimit(1);
        InternalResourceGroup group1 = root.getOrCreateSubGroup("1");
        group1.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        group1.setMaxQueuedQueries(4);
        group1.setHardConcurrencyLimit(2);
        InternalResourceGroup group2 = root.getOrCreateSubGroup("2");
        group2.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        group2.setMaxQueuedQueries(4);
        group2.setHardConcurrencyLimit(2);
        MockManagedQueryExecution query1a = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        group1.run((ManagedQueryExecution)query1a);
        Assert.assertEquals((Object)query1a.getState(), (Object)QueryState.RUNNING);
        MockManagedQueryExecution query1b = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        group1.run((ManagedQueryExecution)query1b);
        Assert.assertEquals((Object)query1b.getState(), (Object)QueryState.QUEUED);
        MockManagedQueryExecution query1c = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        group1.run((ManagedQueryExecution)query1c);
        Assert.assertEquals((Object)query1c.getState(), (Object)QueryState.QUEUED);
        MockManagedQueryExecution query2a = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        group2.run((ManagedQueryExecution)query2a);
        Assert.assertEquals((Object)query2a.getState(), (Object)QueryState.QUEUED);
        query1a.complete();
        Assert.assertEquals((Object)query1b.getState(), (Object)QueryState.RUNNING);
        Assert.assertEquals((Object)query1c.getState(), (Object)QueryState.QUEUED);
        Assert.assertEquals((Object)query2a.getState(), (Object)QueryState.QUEUED);
        query1b.complete();
        Assert.assertEquals((Object)query2a.getState(), (Object)QueryState.RUNNING);
        Assert.assertEquals((Object)query1c.getState(), (Object)QueryState.QUEUED);
    }

    @Test(timeOut=10000L)
    public void testMemoryLimit() {
        InternalResourceGroup root = new InternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        root.setSoftMemoryLimitBytes(1L);
        root.setMaxQueuedQueries(4);
        root.setHardConcurrencyLimit(3);
        MockManagedQueryExecution query1 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().withInitialMemoryUsage(DataSize.ofBytes((long)2L)).build();
        root.run((ManagedQueryExecution)query1);
        root.updateGroupsAndProcessQueuedQueries();
        Assert.assertEquals((Object)query1.getState(), (Object)QueryState.RUNNING);
        MockManagedQueryExecution query2 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        root.run((ManagedQueryExecution)query2);
        Assert.assertEquals((Object)query2.getState(), (Object)QueryState.QUEUED);
        MockManagedQueryExecution query3 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        root.run((ManagedQueryExecution)query3);
        Assert.assertEquals((Object)query3.getState(), (Object)QueryState.QUEUED);
        query1.complete();
        Assert.assertEquals((Object)query2.getState(), (Object)QueryState.RUNNING);
        Assert.assertEquals((Object)query3.getState(), (Object)QueryState.RUNNING);
    }

    @Test
    public void testSubgroupMemoryLimit() {
        InternalResourceGroup root = new InternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        root.setSoftMemoryLimitBytes(10L);
        root.setMaxQueuedQueries(4);
        root.setHardConcurrencyLimit(3);
        InternalResourceGroup subgroup = root.getOrCreateSubGroup("subgroup");
        subgroup.setSoftMemoryLimitBytes(1L);
        subgroup.setMaxQueuedQueries(4);
        subgroup.setHardConcurrencyLimit(3);
        MockManagedQueryExecution query1 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().withInitialMemoryUsage(DataSize.ofBytes((long)2L)).build();
        subgroup.run((ManagedQueryExecution)query1);
        root.updateGroupsAndProcessQueuedQueries();
        Assert.assertEquals((Object)query1.getState(), (Object)QueryState.RUNNING);
        MockManagedQueryExecution query2 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        subgroup.run((ManagedQueryExecution)query2);
        Assert.assertEquals((Object)query2.getState(), (Object)QueryState.QUEUED);
        MockManagedQueryExecution query3 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        subgroup.run((ManagedQueryExecution)query3);
        Assert.assertEquals((Object)query3.getState(), (Object)QueryState.QUEUED);
        query1.complete();
        Assert.assertEquals((Object)query2.getState(), (Object)QueryState.RUNNING);
        Assert.assertEquals((Object)query3.getState(), (Object)QueryState.RUNNING);
    }

    @Test(timeOut=10000L)
    public void testSoftCpuLimit() {
        InternalResourceGroup root = new InternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        root.setSoftMemoryLimitBytes(1L);
        root.setSoftCpuLimit(Duration.ofSeconds(1L));
        root.setHardCpuLimit(Duration.ofSeconds(2L));
        root.setCpuQuotaGenerationMillisPerSecond(2000L);
        root.setMaxQueuedQueries(1);
        root.setHardConcurrencyLimit(2);
        MockManagedQueryExecution query1 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().withInitialMemoryUsage(DataSize.ofBytes((long)1L)).withQueryId("query_id").withInitialCpuUsageMillis(1000L).build();
        root.run((ManagedQueryExecution)query1);
        Assert.assertEquals((Object)query1.getState(), (Object)QueryState.RUNNING);
        MockManagedQueryExecution query2 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        root.run((ManagedQueryExecution)query2);
        Assert.assertEquals((Object)query2.getState(), (Object)QueryState.RUNNING);
        MockManagedQueryExecution query3 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        root.run((ManagedQueryExecution)query3);
        Assert.assertEquals((Object)query3.getState(), (Object)QueryState.QUEUED);
        query1.complete();
        Assert.assertEquals((Object)query2.getState(), (Object)QueryState.RUNNING);
        Assert.assertEquals((Object)query3.getState(), (Object)QueryState.QUEUED);
        root.generateCpuQuota(2L);
        root.updateGroupsAndProcessQueuedQueries();
        Assert.assertEquals((Object)query2.getState(), (Object)QueryState.RUNNING);
        Assert.assertEquals((Object)query3.getState(), (Object)QueryState.RUNNING);
    }

    @Test(timeOut=10000L)
    public void testHardCpuLimit() {
        InternalResourceGroup root = new InternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        root.setSoftMemoryLimitBytes(1L);
        root.setHardCpuLimit(Duration.ofSeconds(1L));
        root.setCpuQuotaGenerationMillisPerSecond(2000L);
        root.setMaxQueuedQueries(1);
        root.setHardConcurrencyLimit(1);
        MockManagedQueryExecution query1 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().withInitialMemoryUsage(DataSize.ofBytes((long)1L)).withQueryId("query_id").withInitialCpuUsageMillis(2000L).build();
        root.run((ManagedQueryExecution)query1);
        Assert.assertEquals((Object)query1.getState(), (Object)QueryState.RUNNING);
        MockManagedQueryExecution query2 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        root.run((ManagedQueryExecution)query2);
        Assert.assertEquals((Object)query2.getState(), (Object)QueryState.QUEUED);
        query1.complete();
        root.updateGroupsAndProcessQueuedQueries();
        Assert.assertEquals((Object)query2.getState(), (Object)QueryState.QUEUED);
        root.generateCpuQuota(2L);
        root.updateGroupsAndProcessQueuedQueries();
        Assert.assertEquals((Object)query2.getState(), (Object)QueryState.RUNNING);
    }

    @Test(timeOut=10000L)
    public void testCpuUsageUpdateForRunningQuery() {
        InternalResourceGroup root = new InternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        InternalResourceGroup child = root.getOrCreateSubGroup("child");
        Stream.of(root, child).forEach(group -> {
            group.setCpuQuotaGenerationMillisPerSecond(1L);
            group.setHardCpuLimit(Duration.ofMillis(3L));
            group.setSoftCpuLimit(Duration.ofMillis(3L));
            group.setHardConcurrencyLimit(100);
            group.setMaxQueuedQueries(100);
        });
        MockManagedQueryExecution q1 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        child.run((ManagedQueryExecution)q1);
        Assert.assertEquals((Object)q1.getState(), (Object)QueryState.RUNNING);
        q1.consumeCpuTimeMillis(4L);
        root.updateGroupsAndProcessQueuedQueries();
        Stream.of(root, child).forEach(group -> TestResourceGroups.assertExceedsCpuLimit(group, 4L));
        MockManagedQueryExecution q2 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        child.run((ManagedQueryExecution)q2);
        Assert.assertEquals((Object)q2.getState(), (Object)QueryState.QUEUED);
        root.generateCpuQuota(2L);
        Stream.of(root, child).forEach(group -> TestResourceGroups.assertWithinCpuLimit(group, 2L));
        MockManagedQueryExecution q3 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        child.run((ManagedQueryExecution)q3);
        Assert.assertEquals((Object)q3.getState(), (Object)QueryState.RUNNING);
        Assert.assertEquals((Object)q2.getState(), (Object)QueryState.QUEUED);
        root.updateGroupsAndProcessQueuedQueries();
        Assert.assertEquals((Object)q2.getState(), (Object)QueryState.RUNNING);
    }

    @Test(timeOut=10000L)
    public void testCpuUsageUpdateAtQueryCompletion() {
        InternalResourceGroup root = new InternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        InternalResourceGroup child = root.getOrCreateSubGroup("child");
        Stream.of(root, child).forEach(group -> {
            group.setCpuQuotaGenerationMillisPerSecond(1L);
            group.setHardCpuLimit(Duration.ofMillis(3L));
            group.setSoftCpuLimit(Duration.ofMillis(3L));
            group.setHardConcurrencyLimit(100);
            group.setMaxQueuedQueries(100);
        });
        MockManagedQueryExecution q1 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        child.run((ManagedQueryExecution)q1);
        Assert.assertEquals((Object)q1.getState(), (Object)QueryState.RUNNING);
        q1.consumeCpuTimeMillis(4L);
        q1.complete();
        Stream.of(root, child).forEach(group -> TestResourceGroups.assertExceedsCpuLimit(group, 4L));
        MockManagedQueryExecution q2 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        child.run((ManagedQueryExecution)q2);
        Assert.assertEquals((Object)q2.getState(), (Object)QueryState.QUEUED);
        root.generateCpuQuota(2L);
        Stream.of(root, child).forEach(group -> TestResourceGroups.assertWithinCpuLimit(group, 2L));
        Assert.assertEquals((Object)q2.getState(), (Object)QueryState.QUEUED);
        root.updateGroupsAndProcessQueuedQueries();
        Stream.of(root, child).forEach(group -> TestResourceGroups.assertWithinCpuLimit(group, 2L));
        Assert.assertEquals((Object)q2.getState(), (Object)QueryState.RUNNING);
    }

    @Test(timeOut=10000L)
    public void testMemoryUsageUpdateForRunningQuery() {
        InternalResourceGroup root = new InternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        InternalResourceGroup child = root.getOrCreateSubGroup("child");
        Stream.of(root, child).forEach(group -> {
            group.setHardConcurrencyLimit(100);
            group.setMaxQueuedQueries(100);
            group.setSoftMemoryLimitBytes(3L);
        });
        MockManagedQueryExecution q1 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        child.run((ManagedQueryExecution)q1);
        Assert.assertEquals((Object)q1.getState(), (Object)QueryState.RUNNING);
        q1.setMemoryUsage(DataSize.ofBytes((long)4L));
        Stream.of(root, child).forEach(group -> TestResourceGroups.assertWithinMemoryLimit(group, 0L));
        root.updateGroupsAndProcessQueuedQueries();
        Stream.of(root, child).forEach(group -> TestResourceGroups.assertExceedsMemoryLimit(group, 4L));
        MockManagedQueryExecution q2 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        child.run((ManagedQueryExecution)q2);
        Assert.assertEquals((Object)q2.getState(), (Object)QueryState.QUEUED);
        q1.setMemoryUsage(DataSize.ofBytes((long)2L));
        MockManagedQueryExecution q3 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        child.run((ManagedQueryExecution)q3);
        Assert.assertEquals((Object)q3.getState(), (Object)QueryState.QUEUED);
        root.updateGroupsAndProcessQueuedQueries();
        Stream.of(root, child).forEach(group -> TestResourceGroups.assertWithinMemoryLimit(group, 2L));
        Assert.assertEquals((Object)q2.getState(), (Object)QueryState.RUNNING);
        Assert.assertEquals((Object)q3.getState(), (Object)QueryState.RUNNING);
    }

    @Test(timeOut=10000L)
    public void testMemoryUsageUpdateAtQueryCompletion() {
        InternalResourceGroup root = new InternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        InternalResourceGroup child = root.getOrCreateSubGroup("child");
        Stream.of(root, child).forEach(group -> {
            group.setHardConcurrencyLimit(100);
            group.setMaxQueuedQueries(100);
            group.setSoftMemoryLimitBytes(3L);
        });
        MockManagedQueryExecution q1 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        child.run((ManagedQueryExecution)q1);
        Assert.assertEquals((Object)q1.getState(), (Object)QueryState.RUNNING);
        q1.setMemoryUsage(DataSize.ofBytes((long)4L));
        Stream.of(root, child).forEach(group -> TestResourceGroups.assertWithinMemoryLimit(group, 0L));
        root.updateGroupsAndProcessQueuedQueries();
        Stream.of(root, child).forEach(group -> TestResourceGroups.assertExceedsMemoryLimit(group, 4L));
        q1.complete();
        Stream.of(root, child).forEach(group -> TestResourceGroups.assertWithinMemoryLimit(group, 0L));
        MockManagedQueryExecution q2 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        child.run((ManagedQueryExecution)q2);
        Assert.assertEquals((Object)q2.getState(), (Object)QueryState.RUNNING);
    }

    @Test(timeOut=10000L)
    public void testRecursiveCpuUsageUpdate() {
        InternalResourceGroup root = new InternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        InternalResourceGroup rootChild1 = root.getOrCreateSubGroup("rootChild1");
        InternalResourceGroup rootChild2 = root.getOrCreateSubGroup("rootChild2");
        InternalResourceGroup rootChild1Child1 = rootChild1.getOrCreateSubGroup("rootChild1Child1");
        InternalResourceGroup rootChild1Child2 = rootChild1.getOrCreateSubGroup("rootChild1Child2");
        Stream.of(root, rootChild1, rootChild2, rootChild1Child1, rootChild1Child2).forEach(group -> {
            group.setCpuQuotaGenerationMillisPerSecond(1L);
            group.setHardConcurrencyLimit(100);
            group.setMaxQueuedQueries(100);
        });
        root.setHardCpuLimit(Duration.ofMillis(16L));
        rootChild1.setHardCpuLimit(Duration.ofMillis(6L));
        rootChild1Child1.setHardCpuLimit(Duration.ofMillis(100L));
        rootChild1Child2.setHardCpuLimit(Duration.ofMillis(100L));
        rootChild2.setHardCpuLimit(Duration.ofMillis(100L));
        MockManagedQueryExecution q1 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        MockManagedQueryExecution q2 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        MockManagedQueryExecution q3 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        rootChild1Child1.run((ManagedQueryExecution)q1);
        rootChild1Child2.run((ManagedQueryExecution)q2);
        rootChild2.run((ManagedQueryExecution)q3);
        Assert.assertEquals((Object)q1.getState(), (Object)QueryState.RUNNING);
        Assert.assertEquals((Object)q2.getState(), (Object)QueryState.RUNNING);
        Assert.assertEquals((Object)q3.getState(), (Object)QueryState.RUNNING);
        q1.consumeCpuTimeMillis(4L);
        q2.consumeCpuTimeMillis(10L);
        q3.consumeCpuTimeMillis(4L);
        root.updateGroupsAndProcessQueuedQueries();
        TestResourceGroups.assertExceedsCpuLimit(root, 18L);
        TestResourceGroups.assertExceedsCpuLimit(rootChild1, 14L);
        TestResourceGroups.assertWithinCpuLimit(rootChild2, 4L);
        TestResourceGroups.assertWithinCpuLimit(rootChild1Child1, 4L);
        TestResourceGroups.assertWithinCpuLimit(rootChild1Child2, 10L);
        MockManagedQueryExecution q4 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        rootChild2.run((ManagedQueryExecution)q4);
        Assert.assertEquals((Object)q4.getState(), (Object)QueryState.QUEUED);
        MockManagedQueryExecution q5 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        rootChild1Child1.run((ManagedQueryExecution)q5);
        Assert.assertEquals((Object)q5.getState(), (Object)QueryState.QUEUED);
        root.generateCpuQuota(4L);
        TestResourceGroups.assertWithinCpuLimit(root, 14L);
        TestResourceGroups.assertExceedsCpuLimit(rootChild1, 10L);
        TestResourceGroups.assertWithinCpuLimit(rootChild2, 0L);
        TestResourceGroups.assertWithinCpuLimit(rootChild1Child1, 0L);
        TestResourceGroups.assertWithinCpuLimit(rootChild1Child2, 6L);
        root.updateGroupsAndProcessQueuedQueries();
        Assert.assertEquals((Object)q4.getState(), (Object)QueryState.RUNNING);
        Assert.assertEquals((Object)q5.getState(), (Object)QueryState.QUEUED);
        q2.consumeCpuTimeMillis(3L);
        q2.complete();
        TestResourceGroups.assertExceedsCpuLimit(root, 17L);
        TestResourceGroups.assertExceedsCpuLimit(rootChild1, 13L);
        TestResourceGroups.assertWithinCpuLimit(rootChild1Child2, 9L);
        MockManagedQueryExecution q6 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        rootChild2.run((ManagedQueryExecution)q6);
        Assert.assertEquals((Object)q6.getState(), (Object)QueryState.QUEUED);
        root.generateCpuQuota(6L);
        TestResourceGroups.assertWithinCpuLimit(root, 11L);
        TestResourceGroups.assertExceedsCpuLimit(rootChild1, 7L);
        TestResourceGroups.assertWithinCpuLimit(rootChild2, 0L);
        TestResourceGroups.assertWithinCpuLimit(rootChild1Child1, 0L);
        TestResourceGroups.assertWithinCpuLimit(rootChild1Child2, 3L);
        root.updateGroupsAndProcessQueuedQueries();
        Assert.assertEquals((Object)q5.getState(), (Object)QueryState.QUEUED);
        Assert.assertEquals((Object)q6.getState(), (Object)QueryState.RUNNING);
        root.generateCpuQuota(2L);
        TestResourceGroups.assertWithinCpuLimit(rootChild1, 5L);
        root.updateGroupsAndProcessQueuedQueries();
        Assert.assertEquals((Object)q5.getState(), (Object)QueryState.RUNNING);
    }

    @Test(timeOut=10000L)
    public void testMemoryUpdateRecursively() {
        InternalResourceGroup root = new InternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor()){

            public void triggerProcessQueuedQueries() {
            }
        };
        InternalResourceGroup rootChild1 = root.getOrCreateSubGroup("rootChild1");
        InternalResourceGroup rootChild2 = root.getOrCreateSubGroup("rootChild2");
        InternalResourceGroup rootChild1Child1 = rootChild1.getOrCreateSubGroup("rootChild1Child1");
        InternalResourceGroup rootChild1Child2 = rootChild1.getOrCreateSubGroup("rootChild1Child2");
        Stream.of(root, rootChild1, rootChild2, rootChild1Child1, rootChild1Child2).forEach(group -> {
            group.setHardConcurrencyLimit(100);
            group.setMaxQueuedQueries(100);
        });
        root.setSoftMemoryLimitBytes(8L);
        rootChild1.setSoftMemoryLimitBytes(3L);
        rootChild2.setSoftMemoryLimitBytes(100L);
        rootChild1Child1.setSoftMemoryLimitBytes(100L);
        rootChild1Child2.setSoftMemoryLimitBytes(100L);
        MockManagedQueryExecution q1 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        MockManagedQueryExecution q2 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        MockManagedQueryExecution q3 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        rootChild1Child1.run((ManagedQueryExecution)q1);
        rootChild1Child2.run((ManagedQueryExecution)q2);
        rootChild2.run((ManagedQueryExecution)q3);
        Assert.assertEquals((Object)q1.getState(), (Object)QueryState.RUNNING);
        Assert.assertEquals((Object)q2.getState(), (Object)QueryState.RUNNING);
        Assert.assertEquals((Object)q3.getState(), (Object)QueryState.RUNNING);
        q1.setMemoryUsage(DataSize.ofBytes((long)2L));
        q2.setMemoryUsage(DataSize.ofBytes((long)5L));
        q3.setMemoryUsage(DataSize.ofBytes((long)2L));
        root.updateGroupsAndProcessQueuedQueries();
        TestResourceGroups.assertExceedsMemoryLimit(root, 9L);
        TestResourceGroups.assertExceedsMemoryLimit(rootChild1, 7L);
        TestResourceGroups.assertWithinMemoryLimit(rootChild2, 2L);
        TestResourceGroups.assertWithinMemoryLimit(rootChild1Child1, 2L);
        TestResourceGroups.assertWithinMemoryLimit(rootChild1Child2, 5L);
        MockManagedQueryExecution q4 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        rootChild2.run((ManagedQueryExecution)q4);
        Assert.assertEquals((Object)q4.getState(), (Object)QueryState.QUEUED);
        MockManagedQueryExecution q5 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        rootChild1Child1.run((ManagedQueryExecution)q5);
        Assert.assertEquals((Object)q5.getState(), (Object)QueryState.QUEUED);
        q1.setMemoryUsage(DataSize.ofBytes((long)0L));
        root.updateGroupsAndProcessQueuedQueries();
        TestResourceGroups.assertWithinMemoryLimit(root, 7L);
        TestResourceGroups.assertExceedsMemoryLimit(rootChild1, 5L);
        TestResourceGroups.assertWithinMemoryLimit(rootChild1Child1, 0L);
        Assert.assertEquals((Object)q4.getState(), (Object)QueryState.RUNNING);
        Assert.assertEquals((Object)q5.getState(), (Object)QueryState.QUEUED);
        q2.complete();
        TestResourceGroups.assertWithinMemoryLimit(root, 2L);
        TestResourceGroups.assertWithinMemoryLimit(rootChild1, 0L);
        MockManagedQueryExecution q6 = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().build();
        rootChild1Child2.run((ManagedQueryExecution)q6);
        Assert.assertEquals((Object)q6.getState(), (Object)QueryState.RUNNING);
        Assert.assertEquals((Object)q5.getState(), (Object)QueryState.QUEUED);
        root.updateGroupsAndProcessQueuedQueries();
        Assert.assertEquals((Object)q5.getState(), (Object)QueryState.RUNNING);
    }

    @Test(timeOut=10000L)
    public void testPriorityScheduling() {
        InternalResourceGroup root = new InternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        root.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        root.setMaxQueuedQueries(100);
        root.setHardConcurrencyLimit(0);
        root.setSchedulingPolicy(SchedulingPolicy.QUERY_PRIORITY);
        InternalResourceGroup group1 = root.getOrCreateSubGroup("1");
        group1.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        group1.setMaxQueuedQueries(100);
        group1.setHardConcurrencyLimit(1);
        InternalResourceGroup group2 = root.getOrCreateSubGroup("2");
        group2.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        group2.setMaxQueuedQueries(100);
        group2.setHardConcurrencyLimit(1);
        TreeMap<Integer, MockManagedQueryExecution> queries = new TreeMap<Integer, MockManagedQueryExecution>();
        Random random = new Random();
        for (int i = 0; i < 100; ++i) {
            int priority;
            while (queries.containsKey(priority = random.nextInt(1000000) + 1)) {
            }
            MockManagedQueryExecution query = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().withQueryId("query_id").withPriority(priority).build();
            if (random.nextBoolean()) {
                group1.run((ManagedQueryExecution)query);
            } else {
                group2.run((ManagedQueryExecution)query);
            }
            queries.put(priority, query);
        }
        root.setHardConcurrencyLimit(1);
        ArrayList orderedQueries = new ArrayList(queries.values());
        Collections.reverse(orderedQueries);
        for (MockManagedQueryExecution query : orderedQueries) {
            root.updateGroupsAndProcessQueuedQueries();
            Assert.assertEquals((Object)query.getState(), (Object)QueryState.RUNNING);
            query.complete();
        }
    }

    @Test(timeOut=10000L)
    public void testWeightedScheduling() {
        InternalResourceGroup root = new InternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor()){

            public void triggerProcessQueuedQueries() {
            }
        };
        root.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        root.setMaxQueuedQueries(4);
        root.setHardConcurrencyLimit(0);
        root.setSchedulingPolicy(SchedulingPolicy.WEIGHTED);
        InternalResourceGroup group1 = root.getOrCreateSubGroup("1");
        group1.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        group1.setMaxQueuedQueries(2);
        group1.setHardConcurrencyLimit(2);
        group1.setSoftConcurrencyLimit(2);
        InternalResourceGroup group2 = root.getOrCreateSubGroup("2");
        group2.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        group2.setMaxQueuedQueries(2);
        group2.setHardConcurrencyLimit(2);
        group2.setSoftConcurrencyLimit(2);
        group2.setSchedulingWeight(2);
        Set<MockManagedQueryExecution> group1Queries = TestResourceGroups.fillGroupTo(group1, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 2);
        Set<MockManagedQueryExecution> group2Queries = TestResourceGroups.fillGroupTo(group2, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 2);
        root.setHardConcurrencyLimit(1);
        int group2Ran = 0;
        for (int i = 0; i < 1000; ++i) {
            Iterator<MockManagedQueryExecution> iterator = group1Queries.iterator();
            while (iterator.hasNext()) {
                MockManagedQueryExecution query = iterator.next();
                if (query.getState() != QueryState.RUNNING) continue;
                query.complete();
                iterator.remove();
            }
            group2Ran += TestResourceGroups.completeGroupQueries(group2Queries);
            root.updateGroupsAndProcessQueuedQueries();
            group1Queries = TestResourceGroups.fillGroupTo(group1, group1Queries, 2);
            group2Queries = TestResourceGroups.fillGroupTo(group2, group2Queries, 2);
        }
        BinomialDistribution binomial = new BinomialDistribution(1000, 0.6666666666666666);
        int lowerBound = binomial.inverseCumulativeProbability(1.0E-6);
        int upperBound = binomial.inverseCumulativeProbability(0.999999);
        io.airlift.testing.Assertions.assertLessThan((Comparable)Integer.valueOf(group2Ran), (Comparable)Integer.valueOf(upperBound));
        io.airlift.testing.Assertions.assertGreaterThan((Comparable)Integer.valueOf(group2Ran), (Comparable)Integer.valueOf(lowerBound));
    }

    @Test(timeOut=10000L)
    public void testWeightedFairScheduling() {
        InternalResourceGroup root = new InternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor()){

            public void triggerProcessQueuedQueries() {
            }
        };
        root.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        root.setMaxQueuedQueries(50);
        root.setHardConcurrencyLimit(0);
        root.setSchedulingPolicy(SchedulingPolicy.WEIGHTED_FAIR);
        InternalResourceGroup group1 = root.getOrCreateSubGroup("1");
        group1.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        group1.setMaxQueuedQueries(50);
        group1.setHardConcurrencyLimit(2);
        group1.setSoftConcurrencyLimit(2);
        group1.setSchedulingWeight(1);
        InternalResourceGroup group2 = root.getOrCreateSubGroup("2");
        group2.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        group2.setMaxQueuedQueries(50);
        group2.setHardConcurrencyLimit(2);
        group2.setSoftConcurrencyLimit(2);
        group2.setSchedulingWeight(2);
        Set<MockManagedQueryExecution> group1Queries = TestResourceGroups.fillGroupTo(group1, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 4);
        Set<MockManagedQueryExecution> group2Queries = TestResourceGroups.fillGroupTo(group2, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 4);
        root.setHardConcurrencyLimit(3);
        int group1Ran = 0;
        int group2Ran = 0;
        for (int i = 0; i < 1000; ++i) {
            group1Ran += TestResourceGroups.completeGroupQueries(group1Queries);
            group2Ran += TestResourceGroups.completeGroupQueries(group2Queries);
            root.updateGroupsAndProcessQueuedQueries();
            group1Queries = TestResourceGroups.fillGroupTo(group1, group1Queries, 4);
            group2Queries = TestResourceGroups.fillGroupTo(group2, group2Queries, 4);
        }
        io.airlift.testing.Assertions.assertBetweenInclusive((Comparable)Integer.valueOf(group1Ran), (Comparable)Integer.valueOf(995), (Comparable)Integer.valueOf(1000));
        io.airlift.testing.Assertions.assertBetweenInclusive((Comparable)Integer.valueOf(group2Ran), (Comparable)Integer.valueOf(1995), (Comparable)Integer.valueOf(2000));
    }

    @Test(timeOut=10000L)
    public void testWeightedFairSchedulingEqualWeights() {
        InternalResourceGroup root = new InternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor()){

            public void triggerProcessQueuedQueries() {
            }
        };
        root.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        root.setMaxQueuedQueries(50);
        root.setHardConcurrencyLimit(0);
        root.setSchedulingPolicy(SchedulingPolicy.WEIGHTED_FAIR);
        InternalResourceGroup group1 = root.getOrCreateSubGroup("1");
        group1.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        group1.setMaxQueuedQueries(50);
        group1.setHardConcurrencyLimit(2);
        group1.setSoftConcurrencyLimit(2);
        group1.setSchedulingWeight(1);
        InternalResourceGroup group2 = root.getOrCreateSubGroup("2");
        group2.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        group2.setMaxQueuedQueries(50);
        group2.setHardConcurrencyLimit(2);
        group2.setSoftConcurrencyLimit(2);
        group2.setSchedulingWeight(1);
        InternalResourceGroup group3 = root.getOrCreateSubGroup("3");
        group3.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        group3.setMaxQueuedQueries(50);
        group3.setHardConcurrencyLimit(2);
        group3.setSoftConcurrencyLimit(2);
        group3.setSchedulingWeight(2);
        Set<MockManagedQueryExecution> group1Queries = TestResourceGroups.fillGroupTo(group1, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 4);
        Set<MockManagedQueryExecution> group2Queries = TestResourceGroups.fillGroupTo(group2, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 4);
        Set<MockManagedQueryExecution> group3Queries = TestResourceGroups.fillGroupTo(group3, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 4);
        root.setHardConcurrencyLimit(4);
        int group1Ran = 0;
        int group2Ran = 0;
        int group3Ran = 0;
        for (int i = 0; i < 1000; ++i) {
            group1Ran += TestResourceGroups.completeGroupQueries(group1Queries);
            group2Ran += TestResourceGroups.completeGroupQueries(group2Queries);
            group3Ran += TestResourceGroups.completeGroupQueries(group3Queries);
            root.updateGroupsAndProcessQueuedQueries();
            group1Queries = TestResourceGroups.fillGroupTo(group1, group1Queries, 4);
            group2Queries = TestResourceGroups.fillGroupTo(group2, group2Queries, 4);
            group3Queries = TestResourceGroups.fillGroupTo(group3, group3Queries, 4);
        }
        BinomialDistribution binomial = new BinomialDistribution(4000, 0.25);
        int lowerBound = binomial.inverseCumulativeProbability(1.0E-6);
        int upperBound = binomial.inverseCumulativeProbability(0.999999);
        io.airlift.testing.Assertions.assertBetweenInclusive((Comparable)Integer.valueOf(group1Ran), (Comparable)Integer.valueOf(lowerBound), (Comparable)Integer.valueOf(upperBound));
        io.airlift.testing.Assertions.assertBetweenInclusive((Comparable)Integer.valueOf(group2Ran), (Comparable)Integer.valueOf(lowerBound), (Comparable)Integer.valueOf(upperBound));
        io.airlift.testing.Assertions.assertBetweenInclusive((Comparable)Integer.valueOf(group3Ran), (Comparable)Integer.valueOf(2 * lowerBound), (Comparable)Integer.valueOf(2 * upperBound));
    }

    @Test(timeOut=10000L)
    public void testWeightedFairSchedulingNoStarvation() {
        InternalResourceGroup root = new InternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor()){

            public void triggerProcessQueuedQueries() {
            }
        };
        root.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        root.setMaxQueuedQueries(50);
        root.setHardConcurrencyLimit(0);
        root.setSchedulingPolicy(SchedulingPolicy.WEIGHTED_FAIR);
        InternalResourceGroup group1 = root.getOrCreateSubGroup("1");
        group1.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        group1.setMaxQueuedQueries(50);
        group1.setHardConcurrencyLimit(2);
        group1.setSoftConcurrencyLimit(2);
        group1.setSchedulingWeight(1);
        InternalResourceGroup group2 = root.getOrCreateSubGroup("2");
        group2.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        group2.setMaxQueuedQueries(50);
        group2.setHardConcurrencyLimit(2);
        group2.setSoftConcurrencyLimit(2);
        group2.setSchedulingWeight(2);
        Set<MockManagedQueryExecution> group1Queries = TestResourceGroups.fillGroupTo(group1, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 4);
        Set<MockManagedQueryExecution> group2Queries = TestResourceGroups.fillGroupTo(group2, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 4);
        root.setHardConcurrencyLimit(1);
        int group1Ran = 0;
        for (int i = 0; i < 2000; ++i) {
            group1Ran += TestResourceGroups.completeGroupQueries(group1Queries);
            TestResourceGroups.completeGroupQueries(group2Queries);
            root.updateGroupsAndProcessQueuedQueries();
            group1Queries = TestResourceGroups.fillGroupTo(group1, group1Queries, 4);
            group2Queries = TestResourceGroups.fillGroupTo(group2, group2Queries, 4);
        }
        Assert.assertEquals((int)group1Ran, (int)1000);
        Assert.assertEquals((int)group1Ran, (int)1000);
    }

    @Test
    public void testGetInfo() {
        InternalResourceGroup root = new InternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor()){

            public void triggerProcessQueuedQueries() {
            }
        };
        root.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        root.setMaxQueuedQueries(40);
        root.setHardConcurrencyLimit(0);
        root.setSchedulingPolicy(SchedulingPolicy.WEIGHTED);
        InternalResourceGroup rootA = root.getOrCreateSubGroup("a");
        rootA.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootA.setMaxQueuedQueries(20);
        rootA.setHardConcurrencyLimit(2);
        InternalResourceGroup rootB = root.getOrCreateSubGroup("b");
        rootB.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootB.setMaxQueuedQueries(20);
        rootB.setHardConcurrencyLimit(2);
        rootB.setSchedulingWeight(2);
        rootB.setSchedulingPolicy(SchedulingPolicy.QUERY_PRIORITY);
        InternalResourceGroup rootAX = rootA.getOrCreateSubGroup("x");
        rootAX.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootAX.setMaxQueuedQueries(10);
        rootAX.setHardConcurrencyLimit(10);
        InternalResourceGroup rootAY = rootA.getOrCreateSubGroup("y");
        rootAY.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootAY.setMaxQueuedQueries(10);
        rootAY.setHardConcurrencyLimit(10);
        InternalResourceGroup rootBX = rootB.getOrCreateSubGroup("x");
        rootBX.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootBX.setMaxQueuedQueries(10);
        rootBX.setHardConcurrencyLimit(10);
        InternalResourceGroup rootBY = rootB.getOrCreateSubGroup("y");
        rootBY.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootBY.setMaxQueuedQueries(10);
        rootBY.setHardConcurrencyLimit(10);
        Set<MockManagedQueryExecution> queries = TestResourceGroups.fillGroupTo(rootAX, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 10, false);
        queries.addAll(TestResourceGroups.fillGroupTo(rootAY, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 10, false));
        queries.addAll(TestResourceGroups.fillGroupTo(rootBX, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 10, true));
        queries.addAll(TestResourceGroups.fillGroupTo(rootBY, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 10, true));
        ResourceGroupInfo info = root.getInfo();
        Assert.assertEquals((int)info.getNumRunningQueries(), (int)0);
        Assert.assertEquals((int)info.getNumQueuedQueries(), (int)40);
        root.setHardConcurrencyLimit(4);
        root.updateGroupsAndProcessQueuedQueries();
        info = root.getInfo();
        Assert.assertEquals((int)info.getNumRunningQueries(), (int)4);
        Assert.assertEquals((int)info.getNumQueuedQueries(), (int)36);
        Iterator<MockManagedQueryExecution> iterator = queries.iterator();
        while (iterator.hasNext()) {
            MockManagedQueryExecution query = iterator.next();
            if (query.getState() != QueryState.RUNNING) continue;
            query.complete();
            iterator.remove();
        }
        root.updateGroupsAndProcessQueuedQueries();
        info = root.getInfo();
        Assert.assertEquals((int)info.getNumRunningQueries(), (int)4);
        Assert.assertEquals((int)info.getNumQueuedQueries(), (int)32);
        root.setHardConcurrencyLimit(10);
        root.updateGroupsAndProcessQueuedQueries();
        info = root.getInfo();
        Assert.assertEquals((int)info.getNumRunningQueries(), (int)4);
        Assert.assertEquals((int)info.getNumQueuedQueries(), (int)32);
        rootB.setHardConcurrencyLimit(10);
        root.updateGroupsAndProcessQueuedQueries();
        info = root.getInfo();
        Assert.assertEquals((int)info.getNumRunningQueries(), (int)10);
        Assert.assertEquals((int)info.getNumQueuedQueries(), (int)26);
    }

    @Test
    public void testGetResourceGroupStateInfo() {
        InternalResourceGroup root = new InternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        root.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE).toBytes());
        root.setMaxQueuedQueries(40);
        root.setHardConcurrencyLimit(10);
        root.setSchedulingPolicy(SchedulingPolicy.WEIGHTED);
        InternalResourceGroup rootA = root.getOrCreateSubGroup("a");
        rootA.setSoftMemoryLimitBytes(DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootA.setMaxQueuedQueries(20);
        rootA.setHardConcurrencyLimit(0);
        InternalResourceGroup rootB = root.getOrCreateSubGroup("b");
        rootB.setSoftMemoryLimitBytes(DataSize.of((long)5L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootB.setMaxQueuedQueries(20);
        rootB.setHardConcurrencyLimit(1);
        rootB.setSchedulingWeight(2);
        rootB.setSchedulingPolicy(SchedulingPolicy.QUERY_PRIORITY);
        InternalResourceGroup rootAX = rootA.getOrCreateSubGroup("x");
        rootAX.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootAX.setMaxQueuedQueries(10);
        rootAX.setHardConcurrencyLimit(10);
        InternalResourceGroup rootAY = rootA.getOrCreateSubGroup("y");
        rootAY.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootAY.setMaxQueuedQueries(10);
        rootAY.setHardConcurrencyLimit(10);
        Set<MockManagedQueryExecution> queries = TestResourceGroups.fillGroupTo(rootAX, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 5, false);
        queries.addAll(TestResourceGroups.fillGroupTo(rootAY, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 5, false));
        queries.addAll(TestResourceGroups.fillGroupTo(rootB, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 10, true));
        ResourceGroupInfo rootInfo = root.getFullInfo();
        Assert.assertEquals((Object)rootInfo.getId(), (Object)root.getId());
        Assert.assertEquals((Object)rootInfo.getState(), (Object)ResourceGroupState.CAN_RUN);
        Assert.assertEquals((long)rootInfo.getSoftMemoryLimit().toBytes(), (long)root.getSoftMemoryLimitBytes());
        Assert.assertEquals((Object)rootInfo.getMemoryUsage(), (Object)DataSize.ofBytes((long)0L));
        Assert.assertEquals((long)rootInfo.getCpuUsage().toMillis(), (long)0L);
        List subGroups = (List)rootInfo.getSubGroups().get();
        Assert.assertEquals((int)subGroups.size(), (int)2);
        TestResourceGroups.assertGroupInfoEquals((ResourceGroupInfo)subGroups.get(0), rootA.getInfo());
        Assert.assertEquals((Object)((ResourceGroupInfo)subGroups.get(0)).getId(), (Object)rootA.getId());
        Assert.assertEquals((Object)((ResourceGroupInfo)subGroups.get(0)).getState(), (Object)ResourceGroupState.CAN_QUEUE);
        Assert.assertEquals((long)((ResourceGroupInfo)subGroups.get(0)).getSoftMemoryLimit().toBytes(), (long)rootA.getSoftMemoryLimitBytes());
        Assert.assertEquals((int)((ResourceGroupInfo)subGroups.get(0)).getHardConcurrencyLimit(), (int)rootA.getHardConcurrencyLimit());
        Assert.assertEquals((int)((ResourceGroupInfo)subGroups.get(0)).getMaxQueuedQueries(), (int)rootA.getMaxQueuedQueries());
        Assert.assertEquals((int)((ResourceGroupInfo)subGroups.get(0)).getNumEligibleSubGroups(), (int)2);
        Assert.assertEquals((int)((ResourceGroupInfo)subGroups.get(0)).getNumRunningQueries(), (int)0);
        Assert.assertEquals((int)((ResourceGroupInfo)subGroups.get(0)).getNumQueuedQueries(), (int)10);
        TestResourceGroups.assertGroupInfoEquals((ResourceGroupInfo)subGroups.get(1), rootB.getInfo());
        Assert.assertEquals((Object)((ResourceGroupInfo)subGroups.get(1)).getId(), (Object)rootB.getId());
        Assert.assertEquals((Object)((ResourceGroupInfo)subGroups.get(1)).getState(), (Object)ResourceGroupState.CAN_QUEUE);
        Assert.assertEquals((long)((ResourceGroupInfo)subGroups.get(1)).getSoftMemoryLimit().toBytes(), (long)rootB.getSoftMemoryLimitBytes());
        Assert.assertEquals((int)((ResourceGroupInfo)subGroups.get(1)).getHardConcurrencyLimit(), (int)rootB.getHardConcurrencyLimit());
        Assert.assertEquals((int)((ResourceGroupInfo)subGroups.get(1)).getMaxQueuedQueries(), (int)rootB.getMaxQueuedQueries());
        Assert.assertEquals((int)((ResourceGroupInfo)subGroups.get(1)).getNumEligibleSubGroups(), (int)0);
        Assert.assertEquals((int)((ResourceGroupInfo)subGroups.get(1)).getNumRunningQueries(), (int)1);
        Assert.assertEquals((int)((ResourceGroupInfo)subGroups.get(1)).getNumQueuedQueries(), (int)9);
        Assert.assertEquals((int)rootInfo.getSoftConcurrencyLimit(), (int)root.getSoftConcurrencyLimit());
        Assert.assertEquals((int)rootInfo.getHardConcurrencyLimit(), (int)root.getHardConcurrencyLimit());
        Assert.assertEquals((int)rootInfo.getMaxQueuedQueries(), (int)root.getMaxQueuedQueries());
        Assert.assertEquals((int)rootInfo.getNumQueuedQueries(), (int)19);
        List runningQueries = (List)rootInfo.getRunningQueries().get();
        Assert.assertEquals((int)runningQueries.size(), (int)1);
        QueryStateInfo queryInfo = (QueryStateInfo)runningQueries.get(0);
        Assert.assertEquals((Object)queryInfo.getResourceGroupId(), Optional.of(rootB.getId()));
    }

    @Test
    public void testGetBlockedQueuedQueries() {
        InternalResourceGroup root = new InternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        root.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        root.setMaxQueuedQueries(40);
        root.setHardConcurrencyLimit(0);
        InternalResourceGroup rootA = root.getOrCreateSubGroup("a");
        rootA.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootA.setMaxQueuedQueries(20);
        rootA.setHardConcurrencyLimit(8);
        InternalResourceGroup rootAX = rootA.getOrCreateSubGroup("x");
        rootAX.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootAX.setMaxQueuedQueries(10);
        rootAX.setHardConcurrencyLimit(8);
        InternalResourceGroup rootAY = rootA.getOrCreateSubGroup("y");
        rootAY.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootAY.setMaxQueuedQueries(10);
        rootAY.setHardConcurrencyLimit(5);
        InternalResourceGroup rootB = root.getOrCreateSubGroup("b");
        rootB.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootB.setMaxQueuedQueries(20);
        rootB.setHardConcurrencyLimit(8);
        InternalResourceGroup rootBX = rootB.getOrCreateSubGroup("x");
        rootBX.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootBX.setMaxQueuedQueries(10);
        rootBX.setHardConcurrencyLimit(8);
        InternalResourceGroup rootBY = rootB.getOrCreateSubGroup("y");
        rootBY.setSoftMemoryLimitBytes(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
        rootBY.setMaxQueuedQueries(10);
        rootBY.setHardConcurrencyLimit(5);
        Set<MockManagedQueryExecution> queries = TestResourceGroups.fillGroupTo(rootAX, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 10, false);
        queries.addAll(TestResourceGroups.fillGroupTo(rootAY, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 10, false));
        queries.addAll(TestResourceGroups.fillGroupTo(rootBX, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 10, true));
        queries.addAll(TestResourceGroups.fillGroupTo(rootBY, (Set<MockManagedQueryExecution>)ImmutableSet.of(), 10, true));
        Assert.assertEquals((int)root.getWaitingQueuedQueries(), (int)16);
        Assert.assertEquals((int)rootA.getWaitingQueuedQueries(), (int)13);
        Assert.assertEquals((int)rootAX.getWaitingQueuedQueries(), (int)10);
        Assert.assertEquals((int)rootAY.getWaitingQueuedQueries(), (int)10);
        Assert.assertEquals((int)rootB.getWaitingQueuedQueries(), (int)13);
        Assert.assertEquals((int)rootBX.getWaitingQueuedQueries(), (int)10);
        Assert.assertEquals((int)rootBY.getWaitingQueuedQueries(), (int)10);
        root.setHardConcurrencyLimit(20);
        root.updateGroupsAndProcessQueuedQueries();
        Assert.assertEquals((int)root.getWaitingQueuedQueries(), (int)0);
        Assert.assertEquals((int)rootA.getWaitingQueuedQueries(), (int)5);
        Assert.assertEquals((int)rootAX.getWaitingQueuedQueries(), (int)6);
        Assert.assertEquals((int)rootAY.getWaitingQueuedQueries(), (int)6);
        Assert.assertEquals((int)rootB.getWaitingQueuedQueries(), (int)5);
        Assert.assertEquals((int)rootBX.getWaitingQueuedQueries(), (int)6);
        Assert.assertEquals((int)rootBY.getWaitingQueuedQueries(), (int)6);
    }

    private static int completeGroupQueries(Set<MockManagedQueryExecution> groupQueries) {
        int groupRan = 0;
        Iterator<MockManagedQueryExecution> iterator = groupQueries.iterator();
        while (iterator.hasNext()) {
            MockManagedQueryExecution query = iterator.next();
            if (query.getState() != QueryState.RUNNING) continue;
            query.complete();
            iterator.remove();
            ++groupRan;
        }
        return groupRan;
    }

    private static Set<MockManagedQueryExecution> fillGroupTo(InternalResourceGroup group, Set<MockManagedQueryExecution> existingQueries, int count) {
        return TestResourceGroups.fillGroupTo(group, existingQueries, count, false);
    }

    private static Set<MockManagedQueryExecution> fillGroupTo(InternalResourceGroup group, Set<MockManagedQueryExecution> existingQueries, int count, boolean queryPriority) {
        int existingCount = existingQueries.size();
        HashSet<MockManagedQueryExecution> queries = new HashSet<MockManagedQueryExecution>(existingQueries);
        for (int i = 0; i < count - existingCount; ++i) {
            MockManagedQueryExecution query = new MockManagedQueryExecution.MockManagedQueryExecutionBuilder().withQueryId(group.getId().toString().replace(".", "") + Integer.toString(i)).withPriority(queryPriority ? i + 1 : 1).build();
            queries.add(query);
            group.run((ManagedQueryExecution)query);
        }
        return queries;
    }

    private static void assertGroupInfoEquals(ResourceGroupInfo actual, ResourceGroupInfo expected) {
        Assert.assertTrue((actual.getSchedulingWeight() == expected.getSchedulingWeight() && actual.getSoftConcurrencyLimit() == expected.getSoftConcurrencyLimit() && actual.getHardConcurrencyLimit() == expected.getHardConcurrencyLimit() && actual.getMaxQueuedQueries() == expected.getMaxQueuedQueries() && actual.getNumQueuedQueries() == expected.getNumQueuedQueries() && actual.getNumRunningQueries() == expected.getNumRunningQueries() && actual.getNumEligibleSubGroups() == expected.getNumEligibleSubGroups() && Objects.equals(actual.getId(), expected.getId()) && actual.getState() == expected.getState() && actual.getSchedulingPolicy() == expected.getSchedulingPolicy() && Objects.equals(actual.getSoftMemoryLimit(), expected.getSoftMemoryLimit()) && Objects.equals(actual.getMemoryUsage(), expected.getMemoryUsage()) && Objects.equals(actual.getCpuUsage(), expected.getCpuUsage()) ? 1 : 0) != 0);
    }

    private static void assertExceedsCpuLimit(InternalResourceGroup group, long expectedMillis) {
        long actualMillis = group.getResourceUsageSnapshot().getCpuUsageMillis();
        Assert.assertEquals((long)actualMillis, (long)expectedMillis);
        Assert.assertTrue((actualMillis >= group.getHardCpuLimit().toMillis() ? 1 : 0) != 0);
    }

    private static void assertWithinCpuLimit(InternalResourceGroup group, long expectedMillis) {
        long actualMillis = group.getResourceUsageSnapshot().getCpuUsageMillis();
        Assert.assertEquals((long)actualMillis, (long)expectedMillis);
        Assert.assertTrue((actualMillis < group.getHardCpuLimit().toMillis() ? 1 : 0) != 0);
    }

    private static void assertExceedsMemoryLimit(InternalResourceGroup group, long expectedBytes) {
        long actualBytes = group.getResourceUsageSnapshot().getMemoryUsageBytes();
        Assert.assertEquals((long)actualBytes, (long)expectedBytes);
        Assertions.assertThat((long)actualBytes).isGreaterThan(group.getSoftMemoryLimitBytes());
    }

    private static void assertWithinMemoryLimit(InternalResourceGroup group, long expectedBytes) {
        long actualBytes = group.getResourceUsageSnapshot().getMemoryUsageBytes();
        Assert.assertEquals((long)actualBytes, (long)expectedBytes);
        Assertions.assertThat((long)actualBytes).isLessThanOrEqualTo(group.getSoftMemoryLimitBytes());
    }
}

