/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.math.DoubleMath;
import io.airlift.slice.Slices;
import io.trino.Session;
import io.trino.block.BlockAssertions;
import io.trino.operator.BigintGroupByHash;
import io.trino.operator.GroupByHash;
import io.trino.operator.GroupByIdBlock;
import io.trino.operator.MultiChannelGroupByHash;
import io.trino.operator.UpdateMemory;
import io.trino.operator.Work;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.VariableWidthBlock;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import io.trino.sql.gen.JoinCompiler;
import io.trino.testing.TestingSession;
import io.trino.type.BlockTypeOperators;
import io.trino.type.TypeTestUtils;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestGroupByHash {
    private static final int MAX_GROUP_ID = 500;
    private static final int[] CONTAINS_CHANNELS = new int[]{0};
    private static final Session TEST_SESSION = TestingSession.testSessionBuilder().build();
    private static final TypeOperators TYPE_OPERATORS = new TypeOperators();
    private static final BlockTypeOperators TYPE_OPERATOR_FACTORY = new BlockTypeOperators(TYPE_OPERATORS);
    private static final JoinCompiler JOIN_COMPILER = new JoinCompiler(TYPE_OPERATORS);

    @DataProvider
    public Object[][] dataType() {
        return new Object[][]{{VarcharType.VARCHAR}, {BigintType.BIGINT}};
    }

    @DataProvider
    public Object[][] groupByHashType() {
        return new Object[][]{{GroupByHashType.BIGINT}, {GroupByHashType.MULTI_CHANNEL}};
    }

    @Test(dataProvider="groupByHashType")
    public void testAddPage(GroupByHashType groupByHashType) {
        GroupByHash groupByHash = groupByHashType.createGroupByHash();
        for (int tries = 0; tries < 2; ++tries) {
            for (int value = 0; value < 500; ++value) {
                Block block = BlockAssertions.createLongsBlock(value);
                Block hashBlock = TypeTestUtils.getHashBlock((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), block);
                Page page = new Page(new Block[]{block, hashBlock});
                for (int addValuesTries = 0; addValuesTries < 10; ++addValuesTries) {
                    groupByHash.addPage(page).process();
                    Assert.assertEquals((int)groupByHash.getGroupCount(), (int)(tries == 0 ? value + 1 : 500));
                    Work work = groupByHash.getGroupIds(page);
                    work.process();
                    GroupByIdBlock groupIds = (GroupByIdBlock)work.getResult();
                    Assert.assertEquals((int)groupByHash.getGroupCount(), (int)(tries == 0 ? value + 1 : 500));
                    Assert.assertEquals((long)groupIds.getGroupCount(), (long)(tries == 0 ? (long)(value + 1) : 500L));
                    Assert.assertEquals((int)groupIds.getPositionCount(), (int)1);
                    long groupId = groupIds.getGroupId(0);
                    Assert.assertEquals((long)groupId, (long)value);
                }
            }
        }
    }

    @Test(dataProvider="groupByHashType")
    public void testRunLengthEncodedInputPage(GroupByHashType groupByHashType) {
        GroupByHash groupByHash = groupByHashType.createGroupByHash();
        Block block = BlockAssertions.createLongsBlock(0L);
        Block hashBlock = TypeTestUtils.getHashBlock((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), block);
        Page page = new Page(new Block[]{RunLengthEncodedBlock.create((Block)block, (int)2), RunLengthEncodedBlock.create((Block)hashBlock, (int)2)});
        groupByHash.addPage(page).process();
        Assert.assertEquals((int)groupByHash.getGroupCount(), (int)1);
        Work work = groupByHash.getGroupIds(page);
        work.process();
        GroupByIdBlock groupIds = (GroupByIdBlock)work.getResult();
        Assert.assertEquals((long)groupIds.getGroupCount(), (long)1L);
        Assert.assertEquals((int)groupIds.getPositionCount(), (int)2);
        Assert.assertEquals((long)groupIds.getGroupId(0), (long)0L);
        Assert.assertEquals((long)groupIds.getGroupId(1), (long)0L);
        List children = groupIds.getChildren();
        Assert.assertEquals((int)children.size(), (int)1);
        Assert.assertTrue((boolean)(children.get(0) instanceof RunLengthEncodedBlock));
    }

    @Test(dataProvider="groupByHashType")
    public void testDictionaryInputPage(GroupByHashType groupByHashType) {
        GroupByHash groupByHash = groupByHashType.createGroupByHash();
        Block block = BlockAssertions.createLongsBlock(0L, 1L);
        Block hashBlock = TypeTestUtils.getHashBlock((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), block);
        int[] ids = new int[]{0, 0, 1, 1};
        Page page = new Page(new Block[]{DictionaryBlock.create((int)ids.length, (Block)block, (int[])ids), DictionaryBlock.create((int)ids.length, (Block)hashBlock, (int[])ids)});
        groupByHash.addPage(page).process();
        Assert.assertEquals((int)groupByHash.getGroupCount(), (int)2);
        Work work = groupByHash.getGroupIds(page);
        work.process();
        GroupByIdBlock groupIds = (GroupByIdBlock)work.getResult();
        Assert.assertEquals((long)groupIds.getGroupCount(), (long)2L);
        Assert.assertEquals((int)groupIds.getPositionCount(), (int)4);
        Assert.assertEquals((long)groupIds.getGroupId(0), (long)0L);
        Assert.assertEquals((long)groupIds.getGroupId(1), (long)0L);
        Assert.assertEquals((long)groupIds.getGroupId(2), (long)1L);
        Assert.assertEquals((long)groupIds.getGroupId(3), (long)1L);
    }

    @Test(dataProvider="groupByHashType")
    public void testNullGroup(GroupByHashType groupByHashType) {
        GroupByHash groupByHash = groupByHashType.createGroupByHash();
        Block block = BlockAssertions.createLongsBlock(new Long[]{null});
        Block hashBlock = TypeTestUtils.getHashBlock((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), block);
        Page page = new Page(new Block[]{block, hashBlock});
        groupByHash.addPage(page).process();
        block = BlockAssertions.createLongSequenceBlock(1, 132748);
        hashBlock = TypeTestUtils.getHashBlock((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), block);
        page = new Page(new Block[]{block, hashBlock});
        groupByHash.addPage(page).process();
        block = BlockAssertions.createLongsBlock(0);
        hashBlock = TypeTestUtils.getHashBlock((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), block);
        page = new Page(new Block[]{block, hashBlock});
        Assert.assertFalse((boolean)groupByHash.contains(0, page, CONTAINS_CHANNELS));
    }

    @Test(dataProvider="groupByHashType")
    public void testGetGroupIds(GroupByHashType groupByHashType) {
        GroupByHash groupByHash = groupByHashType.createGroupByHash();
        for (int tries = 0; tries < 2; ++tries) {
            for (int value = 0; value < 500; ++value) {
                Block block = BlockAssertions.createLongsBlock(value);
                Block hashBlock = TypeTestUtils.getHashBlock((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), block);
                Page page = new Page(new Block[]{block, hashBlock});
                for (int addValuesTries = 0; addValuesTries < 10; ++addValuesTries) {
                    Work work = groupByHash.getGroupIds(page);
                    work.process();
                    GroupByIdBlock groupIds = (GroupByIdBlock)work.getResult();
                    Assert.assertEquals((long)groupIds.getGroupCount(), (long)(tries == 0 ? (long)(value + 1) : 500L));
                    Assert.assertEquals((int)groupIds.getPositionCount(), (int)1);
                    long groupId = groupIds.getGroupId(0);
                    Assert.assertEquals((long)groupId, (long)value);
                }
            }
        }
    }

    @Test
    public void testTypes() {
        GroupByHash groupByHash = GroupByHash.createGroupByHash((Session)TEST_SESSION, (List)ImmutableList.of((Object)VarcharType.VARCHAR), (int[])new int[]{0}, Optional.of(1), (int)100, (JoinCompiler)JOIN_COMPILER, (BlockTypeOperators)TYPE_OPERATOR_FACTORY, (UpdateMemory)UpdateMemory.NOOP);
        Assert.assertEquals((Collection)groupByHash.getTypes(), (Collection)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT));
    }

    @Test(dataProvider="groupByHashType")
    public void testAppendTo(GroupByHashType groupByHashType) {
        Block valuesBlock = BlockAssertions.createLongSequenceBlock(0, 100);
        Block hashBlock = TypeTestUtils.getHashBlock((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), valuesBlock);
        GroupByHash groupByHash = groupByHashType.createGroupByHash();
        Work work = groupByHash.getGroupIds(new Page(new Block[]{valuesBlock, hashBlock}));
        work.process();
        GroupByIdBlock groupIds = (GroupByIdBlock)work.getResult();
        for (int i = 0; i < groupIds.getPositionCount(); ++i) {
            Assert.assertEquals((long)groupIds.getGroupId(i), (long)i);
        }
        Assert.assertEquals((int)groupByHash.getGroupCount(), (int)100);
        PageBuilder pageBuilder = new PageBuilder(groupByHash.getTypes());
        for (int i = 0; i < groupByHash.getGroupCount(); ++i) {
            pageBuilder.declarePosition();
            groupByHash.appendValuesTo(i, pageBuilder);
        }
        Page page = pageBuilder.build();
        for (int i = 0; i < groupByHash.getTypes().size(); ++i) {
            Assert.assertEquals((int)page.getBlock(i).getPositionCount(), (int)100);
        }
        Assert.assertEquals((int)page.getPositionCount(), (int)100);
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, page.getBlock(0), valuesBlock);
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, page.getBlock(1), hashBlock);
    }

    @Test(dataProvider="groupByHashType")
    public void testAppendToMultipleTuplesPerGroup(GroupByHashType groupByHashType) {
        ArrayList<Long> values = new ArrayList<Long>();
        for (long i = 0L; i < 100L; ++i) {
            values.add(i % 50L);
        }
        Block valuesBlock = BlockAssertions.createLongsBlock(values);
        Block hashBlock = TypeTestUtils.getHashBlock((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), valuesBlock);
        GroupByHash groupByHash = groupByHashType.createGroupByHash();
        groupByHash.getGroupIds(new Page(new Block[]{valuesBlock, hashBlock})).process();
        Assert.assertEquals((int)groupByHash.getGroupCount(), (int)50);
        PageBuilder pageBuilder = new PageBuilder(groupByHash.getTypes());
        for (int i = 0; i < groupByHash.getGroupCount(); ++i) {
            pageBuilder.declarePosition();
            groupByHash.appendValuesTo(i, pageBuilder);
        }
        Page outputPage = pageBuilder.build();
        Assert.assertEquals((int)outputPage.getPositionCount(), (int)50);
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, outputPage.getBlock(0), BlockAssertions.createLongSequenceBlock(0, 50));
    }

    @Test(dataProvider="groupByHashType")
    public void testContains(GroupByHashType groupByHashType) {
        Block valuesBlock = BlockAssertions.createLongSequenceBlock(0, 10);
        Block hashBlock = TypeTestUtils.getHashBlock((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), valuesBlock);
        GroupByHash groupByHash = groupByHashType.createGroupByHash();
        groupByHash.getGroupIds(new Page(new Block[]{valuesBlock, hashBlock})).process();
        Block testBlock = BlockAssertions.createLongsBlock(3);
        Block testHashBlock = TypeTestUtils.getHashBlock((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), testBlock);
        Assert.assertTrue((boolean)groupByHash.contains(0, new Page(new Block[]{testBlock, testHashBlock}), CONTAINS_CHANNELS));
        testBlock = BlockAssertions.createLongsBlock(11);
        testHashBlock = TypeTestUtils.getHashBlock((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), testBlock);
        Assert.assertFalse((boolean)groupByHash.contains(0, new Page(new Block[]{testBlock, testHashBlock}), CONTAINS_CHANNELS));
    }

    @Test
    public void testContainsMultipleColumns() {
        Block valuesBlock = BlockAssertions.createDoubleSequenceBlock(0, 10);
        Block stringValuesBlock = BlockAssertions.createStringSequenceBlock(0, 10);
        Block hashBlock = TypeTestUtils.getHashBlock((List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)VarcharType.VARCHAR), valuesBlock, stringValuesBlock);
        int[] hashChannels = new int[]{0, 1};
        GroupByHash groupByHash = GroupByHash.createGroupByHash((Session)TEST_SESSION, (List)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)VarcharType.VARCHAR), (int[])hashChannels, Optional.of(2), (int)100, (JoinCompiler)JOIN_COMPILER, (BlockTypeOperators)TYPE_OPERATOR_FACTORY, (UpdateMemory)UpdateMemory.NOOP);
        groupByHash.getGroupIds(new Page(new Block[]{valuesBlock, stringValuesBlock, hashBlock})).process();
        Block testValuesBlock = BlockAssertions.createDoublesBlock(3.0);
        Block testStringValuesBlock = BlockAssertions.createStringsBlock("3");
        Block testHashBlock = TypeTestUtils.getHashBlock((List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)VarcharType.VARCHAR), testValuesBlock, testStringValuesBlock);
        Assert.assertTrue((boolean)groupByHash.contains(0, new Page(new Block[]{testValuesBlock, testStringValuesBlock, testHashBlock}), hashChannels));
    }

    @Test(dataProvider="groupByHashType")
    public void testForceRehash(GroupByHashType groupByHashType) {
        Block valuesBlock = BlockAssertions.createLongSequenceBlock(0, 100);
        Block hashBlock = TypeTestUtils.getHashBlock((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), valuesBlock);
        GroupByHash groupByHash = groupByHashType.createGroupByHash(4, UpdateMemory.NOOP);
        groupByHash.getGroupIds(new Page(new Block[]{valuesBlock, hashBlock})).process();
        for (int i = 0; i < valuesBlock.getPositionCount(); ++i) {
            Assert.assertTrue((boolean)groupByHash.contains(i, new Page(new Block[]{valuesBlock, hashBlock}), CONTAINS_CHANNELS));
        }
    }

    @Test(dataProvider="dataType")
    public void testUpdateMemory(Type type) {
        Block valuesBlock;
        int length = 1000000;
        if (type == VarcharType.VARCHAR) {
            valuesBlock = BlockAssertions.createStringSequenceBlock(0, length);
        } else if (type == BigintType.BIGINT) {
            valuesBlock = BlockAssertions.createLongSequenceBlock(0, length);
        } else {
            throw new IllegalArgumentException("unsupported data type");
        }
        Block hashBlock = TypeTestUtils.getHashBlock((List<? extends Type>)ImmutableList.of((Object)type), valuesBlock);
        AtomicInteger rehashCount = new AtomicInteger();
        GroupByHash groupByHash = GroupByHash.createGroupByHash((List)ImmutableList.of((Object)type), (int[])new int[]{0}, Optional.of(1), (int)1, (boolean)false, (JoinCompiler)JOIN_COMPILER, (BlockTypeOperators)TYPE_OPERATOR_FACTORY, () -> {
            rehashCount.incrementAndGet();
            return true;
        });
        groupByHash.addPage(new Page(new Block[]{valuesBlock, hashBlock})).process();
        Assert.assertEquals((int)rehashCount.get(), (int)(2 * DoubleMath.log2((double)((double)length / 0.75), (RoundingMode)RoundingMode.FLOOR)));
    }

    @Test(dataProvider="dataType")
    public void testMemoryReservationYield(Type type) {
        Block valuesBlock;
        int length = 1000000;
        if (type == VarcharType.VARCHAR) {
            valuesBlock = BlockAssertions.createStringSequenceBlock(0, length);
        } else if (type == BigintType.BIGINT) {
            valuesBlock = BlockAssertions.createLongSequenceBlock(0, length);
        } else {
            throw new IllegalArgumentException("unsupported data type");
        }
        Block hashBlock = TypeTestUtils.getHashBlock((List<? extends Type>)ImmutableList.of((Object)type), valuesBlock);
        Page page = new Page(new Block[]{valuesBlock, hashBlock});
        AtomicInteger currentQuota = new AtomicInteger(0);
        AtomicInteger allowedQuota = new AtomicInteger(6);
        UpdateMemory updateMemory = () -> {
            if (currentQuota.get() < allowedQuota.get()) {
                currentQuota.getAndIncrement();
                return true;
            }
            return false;
        };
        int yields = 0;
        GroupByHash groupByHash = GroupByHash.createGroupByHash((List)ImmutableList.of((Object)type), (int[])new int[]{0}, Optional.of(1), (int)1, (boolean)false, (JoinCompiler)JOIN_COMPILER, (BlockTypeOperators)TYPE_OPERATOR_FACTORY, (UpdateMemory)updateMemory);
        boolean finish = false;
        Work addPageWork = groupByHash.addPage(page);
        while (!finish) {
            finish = addPageWork.process();
            if (finish) continue;
            Assert.assertEquals((int)currentQuota.get(), (int)allowedQuota.get());
            Assert.assertFalse((boolean)addPageWork.process());
            Assert.assertEquals((int)currentQuota.get(), (int)allowedQuota.get());
            ++yields;
            allowedQuota.getAndAdd(6);
        }
        Assert.assertEquals((int)length, (int)groupByHash.getGroupCount());
        Assert.assertEquals((int)currentQuota.get(), (int)40);
        Assert.assertEquals((int)(currentQuota.get() / 3 / 2), (int)yields);
        currentQuota.set(0);
        allowedQuota.set(6);
        yields = 0;
        groupByHash = GroupByHash.createGroupByHash((List)ImmutableList.of((Object)type), (int[])new int[]{0}, Optional.of(1), (int)1, (boolean)false, (JoinCompiler)JOIN_COMPILER, (BlockTypeOperators)TYPE_OPERATOR_FACTORY, (UpdateMemory)updateMemory);
        finish = false;
        Work getGroupIdsWork = groupByHash.getGroupIds(page);
        while (!finish) {
            finish = getGroupIdsWork.process();
            if (finish) continue;
            Assert.assertEquals((int)currentQuota.get(), (int)allowedQuota.get());
            Assert.assertFalse((boolean)getGroupIdsWork.process());
            Assert.assertEquals((int)currentQuota.get(), (int)allowedQuota.get());
            ++yields;
            allowedQuota.getAndAdd(6);
        }
        Assert.assertEquals((int)length, (int)groupByHash.getGroupCount());
        Assert.assertEquals((int)length, (int)((GroupByIdBlock)getGroupIdsWork.getResult()).getPositionCount());
        Assert.assertEquals((int)currentQuota.get(), (int)40);
        Assert.assertEquals((int)(currentQuota.get() / 3 / 2), (int)yields);
    }

    @Test(dataProvider="groupByHashType")
    public void testMemoryReservationYieldWithDictionary(GroupByHashType groupByHashType) {
        int dictionaryLength = 1000;
        int length = 2000000;
        int[] ids = IntStream.range(0, dictionaryLength).toArray();
        Block valuesBlock = DictionaryBlock.create((int)dictionaryLength, (Block)BlockAssertions.createLongSequenceBlock(0, length), (int[])ids);
        Block hashBlock = DictionaryBlock.create((int)dictionaryLength, (Block)TypeTestUtils.getHashBlock((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), valuesBlock), (int[])ids);
        Page page = new Page(new Block[]{valuesBlock, hashBlock});
        AtomicInteger currentQuota = new AtomicInteger(0);
        AtomicInteger allowedQuota = new AtomicInteger(6);
        UpdateMemory updateMemory = () -> {
            if (currentQuota.get() < allowedQuota.get()) {
                currentQuota.getAndIncrement();
                return true;
            }
            return false;
        };
        int yields = 0;
        GroupByHash groupByHash = groupByHashType.createGroupByHash(1, updateMemory);
        boolean finish = false;
        Work addPageWork = groupByHash.addPage(page);
        while (!finish) {
            finish = addPageWork.process();
            if (finish) continue;
            Assert.assertEquals((int)currentQuota.get(), (int)allowedQuota.get());
            Assert.assertFalse((boolean)addPageWork.process());
            Assert.assertEquals((int)currentQuota.get(), (int)allowedQuota.get());
            ++yields;
            allowedQuota.getAndAdd(6);
        }
        Assert.assertEquals((int)dictionaryLength, (int)groupByHash.getGroupCount());
        Assert.assertEquals((int)currentQuota.get(), (int)20);
        Assert.assertEquals((int)(currentQuota.get() / 3 / 2), (int)yields);
        currentQuota.set(0);
        allowedQuota.set(6);
        yields = 0;
        groupByHash = groupByHashType.createGroupByHash(1, updateMemory);
        finish = false;
        Work getGroupIdsWork = groupByHash.getGroupIds(page);
        while (!finish) {
            finish = getGroupIdsWork.process();
            if (finish) continue;
            Assert.assertEquals((int)currentQuota.get(), (int)allowedQuota.get());
            Assert.assertFalse((boolean)getGroupIdsWork.process());
            Assert.assertEquals((int)currentQuota.get(), (int)allowedQuota.get());
            ++yields;
            allowedQuota.getAndAdd(6);
        }
        Assert.assertEquals((int)dictionaryLength, (int)groupByHash.getGroupCount());
        Assert.assertEquals((int)dictionaryLength, (int)((GroupByIdBlock)getGroupIdsWork.getResult()).getPositionCount());
        Assert.assertEquals((int)currentQuota.get(), (int)20);
        Assert.assertEquals((int)(currentQuota.get() / 3 / 2), (int)yields);
    }

    @Test
    public void testLowCardinalityDictionariesAddPage() {
        GroupByHash groupByHash = GroupByHash.createGroupByHash((Session)TEST_SESSION, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT), (int[])new int[]{0, 1}, Optional.empty(), (int)100, (JoinCompiler)JOIN_COMPILER, (BlockTypeOperators)TYPE_OPERATOR_FACTORY, (UpdateMemory)UpdateMemory.NOOP);
        Block firstBlock = BlockAssertions.createLongDictionaryBlock(0, 1000, 10);
        Block secondBlock = BlockAssertions.createLongDictionaryBlock(0, 1000, 10);
        Page page = new Page(new Block[]{firstBlock, secondBlock});
        Work work = groupByHash.addPage(page);
        Assertions.assertThat((Object)work).isInstanceOf(MultiChannelGroupByHash.AddLowCardinalityDictionaryPageWork.class);
        work.process();
        Assertions.assertThat((int)groupByHash.getGroupCount()).isEqualTo(10);
        firstBlock = BlockAssertions.createLongDictionaryBlock(10, 1000, 5);
        secondBlock = BlockAssertions.createLongDictionaryBlock(10, 1000, 7);
        page = new Page(new Block[]{firstBlock, secondBlock});
        groupByHash.addPage(page).process();
        Assertions.assertThat((int)groupByHash.getGroupCount()).isEqualTo(45);
    }

    @Test
    public void testLowCardinalityDictionariesGetGroupIds() {
        GroupByHash groupByHash = GroupByHash.createGroupByHash((Session)TEST_SESSION, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT), (int[])new int[]{0, 1, 2, 3, 4}, Optional.empty(), (int)100, (JoinCompiler)JOIN_COMPILER, (BlockTypeOperators)TYPE_OPERATOR_FACTORY, (UpdateMemory)UpdateMemory.NOOP);
        GroupByHash lowCardinalityGroupByHash = GroupByHash.createGroupByHash((Session)TEST_SESSION, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT), (int[])new int[]{0, 1, 2, 3}, Optional.empty(), (int)100, (JoinCompiler)JOIN_COMPILER, (BlockTypeOperators)TYPE_OPERATOR_FACTORY, (UpdateMemory)UpdateMemory.NOOP);
        Block sameValueBlock = BlockAssertions.createLongRepeatBlock(0, 100);
        Block block1 = BlockAssertions.createLongDictionaryBlock(0, 100, 1);
        Block block2 = BlockAssertions.createLongDictionaryBlock(0, 100, 2);
        Block block3 = BlockAssertions.createLongDictionaryBlock(0, 100, 3);
        Block block4 = BlockAssertions.createLongDictionaryBlock(0, 100, 4);
        Page lowCardinalityPage = new Page(new Block[]{block1, block2, block3, block4});
        Page page = new Page(new Block[]{block1, block2, block3, block4, sameValueBlock});
        Work lowCardinalityWork = lowCardinalityGroupByHash.getGroupIds(lowCardinalityPage);
        Assertions.assertThat((Object)lowCardinalityWork).isInstanceOf(MultiChannelGroupByHash.GetLowCardinalityDictionaryGroupIdsWork.class);
        Work work = groupByHash.getGroupIds(page);
        lowCardinalityWork.process();
        work.process();
        GroupByIdBlock lowCardinalityResults = (GroupByIdBlock)lowCardinalityWork.getResult();
        GroupByIdBlock results = (GroupByIdBlock)work.getResult();
        Assertions.assertThat((long)lowCardinalityResults.getGroupCount()).isEqualTo(results.getGroupCount());
    }

    @Test
    public void testLowCardinalityDictionariesProperGroupIdOrder() {
        int i;
        GroupByHash groupByHash = GroupByHash.createGroupByHash((Session)TEST_SESSION, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT), (int[])new int[]{0, 1}, Optional.empty(), (int)100, (JoinCompiler)JOIN_COMPILER, (BlockTypeOperators)TYPE_OPERATOR_FACTORY, (UpdateMemory)UpdateMemory.NOOP);
        LongArrayBlock dictionary = new LongArrayBlock(2, Optional.empty(), new long[]{0L, 1L});
        int[] ids = new int[32];
        for (int i2 = 0; i2 < 16; ++i2) {
            ids[i2] = 1;
        }
        Block block1 = DictionaryBlock.create((int)ids.length, (Block)dictionary, (int[])ids);
        Block block2 = DictionaryBlock.create((int)ids.length, (Block)dictionary, (int[])ids);
        Page page = new Page(new Block[]{block1, block2});
        Work work = groupByHash.getGroupIds(page);
        Assertions.assertThat((Object)work).isInstanceOf(MultiChannelGroupByHash.GetLowCardinalityDictionaryGroupIdsWork.class);
        work.process();
        GroupByIdBlock results = (GroupByIdBlock)work.getResult();
        for (i = 0; i < 16; ++i) {
            Assertions.assertThat((long)results.getGroupId(i)).isEqualTo(0L);
        }
        for (i = 16; i < 32; ++i) {
            Assertions.assertThat((long)results.getGroupId(i)).isEqualTo(1L);
        }
    }

    @Test
    public void testProperWorkTypesSelected() {
        Block bigintBlock = BlockAssertions.createLongsBlock(1, 2, 3, 4, 5, 6, 7, 8);
        Block bigintDictionaryBlock = BlockAssertions.createLongDictionaryBlock(0, 8);
        Block bigintRleBlock = BlockAssertions.createRepeatedValuesBlock(42L, 8);
        Block varcharBlock = BlockAssertions.createStringsBlock("1", "2", "3", "4", "5", "6", "7", "8");
        Block varcharDictionaryBlock = BlockAssertions.createStringDictionaryBlock(1, 8);
        Block varcharRleBlock = RunLengthEncodedBlock.create((Block)new VariableWidthBlock(1, Slices.EMPTY_SLICE, new int[]{0, 1}, Optional.empty()), (int)8);
        Block bigintBigDictionaryBlock = BlockAssertions.createLongDictionaryBlock(1, 8, 1000);
        Block bigintSingletonDictionaryBlock = BlockAssertions.createLongDictionaryBlock(1, 500000, 1);
        Block bigintHugeDictionaryBlock = BlockAssertions.createLongDictionaryBlock(1, 500000, 66000);
        Page singleBigintPage = new Page(new Block[]{bigintBlock});
        this.assertGroupByHashWork(singleBigintPage, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), BigintGroupByHash.GetGroupIdsWork.class);
        Page singleBigintDictionaryPage = new Page(new Block[]{bigintDictionaryBlock});
        this.assertGroupByHashWork(singleBigintDictionaryPage, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), BigintGroupByHash.GetDictionaryGroupIdsWork.class);
        Page singleBigintRlePage = new Page(new Block[]{bigintRleBlock});
        this.assertGroupByHashWork(singleBigintRlePage, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), BigintGroupByHash.GetRunLengthEncodedGroupIdsWork.class);
        Page singleVarcharPage = new Page(new Block[]{varcharBlock});
        this.assertGroupByHashWork(singleVarcharPage, (List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), MultiChannelGroupByHash.GetNonDictionaryGroupIdsWork.class);
        Page singleVarcharDictionaryPage = new Page(new Block[]{varcharDictionaryBlock});
        this.assertGroupByHashWork(singleVarcharDictionaryPage, (List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), MultiChannelGroupByHash.GetDictionaryGroupIdsWork.class);
        Page singleVarcharRlePage = new Page(new Block[]{varcharRleBlock});
        this.assertGroupByHashWork(singleVarcharRlePage, (List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), MultiChannelGroupByHash.GetRunLengthEncodedGroupIdsWork.class);
        Page lowCardinalityDictionaryPage = new Page(new Block[]{bigintDictionaryBlock, varcharDictionaryBlock});
        this.assertGroupByHashWork(lowCardinalityDictionaryPage, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR), MultiChannelGroupByHash.GetLowCardinalityDictionaryGroupIdsWork.class);
        Page highCardinalityDictionaryPage = new Page(new Block[]{bigintDictionaryBlock, bigintBigDictionaryBlock});
        this.assertGroupByHashWork(highCardinalityDictionaryPage, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR), MultiChannelGroupByHash.GetNonDictionaryGroupIdsWork.class);
        Page lowCardinalityHugeDictionaryPage = new Page(new Block[]{bigintSingletonDictionaryBlock, bigintHugeDictionaryBlock});
        this.assertGroupByHashWork(lowCardinalityHugeDictionaryPage, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT), MultiChannelGroupByHash.GetNonDictionaryGroupIdsWork.class);
    }

    private void assertGroupByHashWork(Page page, List<Type> types, Class<?> clazz) {
        GroupByHash groupByHash = GroupByHash.createGroupByHash(types, (int[])IntStream.range(0, types.size()).toArray(), Optional.empty(), (int)100, (boolean)true, (JoinCompiler)JOIN_COMPILER, (BlockTypeOperators)TYPE_OPERATOR_FACTORY, (UpdateMemory)UpdateMemory.NOOP);
        Work work = groupByHash.getGroupIds(page);
        Assertions.assertThat((Object)work).isInstanceOf(clazz);
    }

    private static enum GroupByHashType {
        BIGINT,
        MULTI_CHANNEL;


        public GroupByHash createGroupByHash() {
            return this.createGroupByHash(100, UpdateMemory.NOOP);
        }

        public GroupByHash createGroupByHash(int expectedSize, UpdateMemory updateMemory) {
            switch (this) {
                case BIGINT: {
                    return new BigintGroupByHash(0, true, expectedSize, updateMemory);
                }
                case MULTI_CHANNEL: {
                    return new MultiChannelGroupByHash((List)ImmutableList.of((Object)BigintType.BIGINT), new int[]{0}, Optional.of(1), expectedSize, true, JOIN_COMPILER, TYPE_OPERATOR_FACTORY, updateMemory);
                }
            }
            throw new UnsupportedOperationException();
        }
    }
}

