/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.operator.aggregation.DecimalSumAggregation;
import io.trino.operator.aggregation.state.LongDecimalWithOverflowState;
import io.trino.operator.aggregation.state.LongDecimalWithOverflowStateFactory;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Int128;
import java.math.BigInteger;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestDecimalSumAggregation {
    private static final BigInteger TWO = new BigInteger("2");
    private static final DecimalType TYPE = DecimalType.createDecimalType((int)38, (int)0);
    private LongDecimalWithOverflowState state;

    @BeforeMethod
    public void setUp() {
        this.state = new LongDecimalWithOverflowStateFactory().createSingleState();
    }

    @Test
    public void testOverflow() {
        TestDecimalSumAggregation.addToState(this.state, TWO.pow(126));
        Assert.assertEquals((long)this.state.getOverflow(), (long)0L);
        Assert.assertEquals((Object)this.getDecimal(this.state), (Object)Int128.valueOf((BigInteger)TWO.pow(126)));
        TestDecimalSumAggregation.addToState(this.state, TWO.pow(126));
        Assert.assertEquals((long)this.state.getOverflow(), (long)1L);
        Assert.assertEquals((Object)this.getDecimal(this.state), (Object)Int128.valueOf((long)Long.MIN_VALUE, (long)0L));
    }

    @Test
    public void testUnderflow() {
        TestDecimalSumAggregation.addToState(this.state, TWO.pow(126).negate());
        Assert.assertEquals((long)this.state.getOverflow(), (long)0L);
        Assert.assertEquals((Object)this.getDecimal(this.state), (Object)Int128.valueOf((BigInteger)TWO.pow(126).negate()));
        TestDecimalSumAggregation.addToState(this.state, TWO.pow(126).negate());
        Assert.assertEquals((long)this.state.getOverflow(), (long)0L);
        Assert.assertEquals((Object)this.getDecimal(this.state), (Object)Int128.valueOf((long)Long.MIN_VALUE, (long)0L));
    }

    @Test
    public void testUnderflowAfterOverflow() {
        TestDecimalSumAggregation.addToState(this.state, TWO.pow(126));
        TestDecimalSumAggregation.addToState(this.state, TWO.pow(126));
        TestDecimalSumAggregation.addToState(this.state, TWO.pow(125));
        Assert.assertEquals((long)this.state.getOverflow(), (long)1L);
        Assert.assertEquals((Object)this.getDecimal(this.state), (Object)Int128.valueOf((long)-6917529027641081856L, (long)0L));
        TestDecimalSumAggregation.addToState(this.state, TWO.pow(126).negate());
        TestDecimalSumAggregation.addToState(this.state, TWO.pow(126).negate());
        TestDecimalSumAggregation.addToState(this.state, TWO.pow(126).negate());
        Assert.assertEquals((long)this.state.getOverflow(), (long)0L);
        Assert.assertEquals((Object)this.getDecimal(this.state), (Object)Int128.valueOf((BigInteger)TWO.pow(125).negate()));
    }

    @Test
    public void testCombineOverflow() {
        TestDecimalSumAggregation.addToState(this.state, TWO.pow(125));
        TestDecimalSumAggregation.addToState(this.state, TWO.pow(126));
        LongDecimalWithOverflowState otherState = new LongDecimalWithOverflowStateFactory().createSingleState();
        TestDecimalSumAggregation.addToState(otherState, TWO.pow(125));
        TestDecimalSumAggregation.addToState(otherState, TWO.pow(126));
        DecimalSumAggregation.combine((LongDecimalWithOverflowState)this.state, (LongDecimalWithOverflowState)otherState);
        Assert.assertEquals((long)this.state.getOverflow(), (long)1L);
        Assert.assertEquals((Object)this.getDecimal(this.state), (Object)Int128.valueOf((long)-4611686018427387904L, (long)0L));
    }

    @Test
    public void testCombineUnderflow() {
        TestDecimalSumAggregation.addToState(this.state, TWO.pow(125).negate());
        TestDecimalSumAggregation.addToState(this.state, TWO.pow(126).negate());
        LongDecimalWithOverflowState otherState = new LongDecimalWithOverflowStateFactory().createSingleState();
        TestDecimalSumAggregation.addToState(otherState, TWO.pow(125).negate());
        TestDecimalSumAggregation.addToState(otherState, TWO.pow(126).negate());
        DecimalSumAggregation.combine((LongDecimalWithOverflowState)this.state, (LongDecimalWithOverflowState)otherState);
        Assert.assertEquals((long)this.state.getOverflow(), (long)-1L);
        Assert.assertEquals((Object)this.getDecimal(this.state), (Object)Int128.valueOf((long)0x4000000000000000L, (long)0L));
    }

    @Test
    public void testOverflowOnOutput() {
        TestDecimalSumAggregation.addToState(this.state, TWO.pow(126));
        TestDecimalSumAggregation.addToState(this.state, TWO.pow(126));
        Assert.assertEquals((long)this.state.getOverflow(), (long)1L);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DecimalSumAggregation.outputLongDecimal((LongDecimalWithOverflowState)this.state, (BlockBuilder)new VariableWidthBlockBuilder(null, 10, 100))).isInstanceOf(ArithmeticException.class)).hasMessage("Decimal overflow");
    }

    private static void addToState(LongDecimalWithOverflowState state, BigInteger value) {
        if (TYPE.isShort()) {
            DecimalSumAggregation.inputShortDecimal((LongDecimalWithOverflowState)state, (long)Int128.valueOf((BigInteger)value).toLongExact());
        } else {
            BlockBuilder blockBuilder = TYPE.createFixedSizeBlockBuilder(1);
            TYPE.writeObject(blockBuilder, (Object)Int128.valueOf((BigInteger)value));
            DecimalSumAggregation.inputLongDecimal((LongDecimalWithOverflowState)state, (Block)blockBuilder.build(), (int)0);
        }
    }

    private Int128 getDecimal(LongDecimalWithOverflowState state) {
        long[] decimal = state.getDecimalArray();
        int offset = state.getDecimalArrayOffset();
        return Int128.valueOf((long)decimal[offset], (long)decimal[offset + 1]);
    }
}

