/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.groupby;

import com.google.common.primitives.Ints;
import io.trino.operator.GroupByIdBlock;
import io.trino.operator.aggregation.AggregationTestUtils;
import io.trino.operator.aggregation.GroupedAggregator;
import io.trino.operator.aggregation.TestingAggregationFunction;
import io.trino.operator.aggregation.groupby.AggregationTestOutput;
import io.trino.spi.Page;
import io.trino.spi.type.Type;
import io.trino.sql.planner.plan.AggregationNode;
import java.util.OptionalInt;
import java.util.stream.IntStream;

public class AggregationTestInput {
    private final Page[] pages;
    private final TestingAggregationFunction function;
    private final int[] args;
    private final int offset;

    public AggregationTestInput(TestingAggregationFunction function, Page[] pages, int offset) {
        this.pages = pages;
        this.function = function;
        this.args = IntStream.range(0, pages[0].getChannelCount()).toArray();
        this.offset = offset;
    }

    public void runPagesOnAggregatorWithAssertion(long groupId, Type finalType, GroupedAggregator groupedAggregator, AggregationTestOutput expectedValue) {
        for (Page page : this.getPages()) {
            groupedAggregator.processPage(AggregationTestInput.getGroupIdBlock(groupId, page), page);
        }
        expectedValue.validateAggregator(finalType, groupedAggregator, groupId);
    }

    private static GroupByIdBlock getGroupIdBlock(long groupId, Page page) {
        return AggregationTestUtils.createGroupByIdBlock((int)groupId, page.getPositionCount());
    }

    private Page[] getPages() {
        Page[] pages = this.pages;
        if (this.offset > 0) {
            pages = AggregationTestUtils.offsetColumns(pages, this.offset);
        }
        return pages;
    }

    public GroupedAggregator createGroupedAggregator() {
        return this.function.createAggregatorFactory(AggregationNode.Step.SINGLE, Ints.asList((int[])this.args), OptionalInt.empty()).createGroupedAggregator();
    }
}

