/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.airlift.jcodings.Encoding;
import io.airlift.jcodings.specific.NonStrictUTF8Encoding;
import io.airlift.joni.Matcher;
import io.airlift.joni.Regex;
import io.airlift.joni.Syntax;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.likematcher.LikeMatcher;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.type.JoniRegexp;
import io.trino.util.Failures;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.results.format.ResultFormatType;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@BenchmarkMode(value={Mode.AverageTime})
@Fork(value=3)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=30, time=500, timeUnit=TimeUnit.MILLISECONDS)
public class BenchmarkLike {
    private static final Syntax SYNTAX = new Syntax(0x800006, 0, 0, 0, new Syntax.MetaCharTable(92, 0, 0, 0, 0, 0));

    @Benchmark
    public boolean matchJoni(Data data) {
        return BenchmarkLike.likeVarchar(data.data, data.joniPattern);
    }

    @Benchmark
    public boolean matchDfa(Data data) {
        return data.dfaMatcher.match(data.bytes, 0, data.bytes.length);
    }

    @Benchmark
    public boolean matchNfa(Data data) {
        return data.nfaMatcher.match(data.bytes, 0, data.bytes.length);
    }

    @Benchmark
    public JoniRegexp compileJoni(Data data) {
        return BenchmarkLike.compileJoni(data.pattern, '\u0000', false);
    }

    @Benchmark
    public LikeMatcher compileDfa(Data data) {
        return LikeMatcher.compile((String)data.pattern, Optional.empty(), (boolean)true);
    }

    @Benchmark
    public LikeMatcher compileNfa(Data data) {
        return LikeMatcher.compile((String)data.pattern, Optional.empty(), (boolean)false);
    }

    @Benchmark
    public boolean allJoni(Data data) {
        return BenchmarkLike.likeVarchar(data.data, BenchmarkLike.compileJoni(Slices.utf8Slice((String)data.pattern).toStringUtf8(), '0', false));
    }

    @Benchmark
    public boolean allDfa(Data data) {
        return LikeMatcher.compile((String)data.pattern, Optional.empty(), (boolean)true).match(data.bytes, 0, data.bytes.length);
    }

    @Benchmark
    public boolean allNfa(Data data) {
        return LikeMatcher.compile((String)data.pattern, Optional.empty(), (boolean)false).match(data.bytes, 0, data.bytes.length);
    }

    public static boolean likeVarchar(Slice value, JoniRegexp pattern) {
        Matcher matcher;
        int offset;
        if (value.hasByteArray()) {
            offset = value.byteArrayOffset();
            matcher = pattern.regex().matcher(value.byteArray(), offset, offset + value.length());
        } else {
            offset = 0;
            matcher = pattern.matcher(value.getBytes());
        }
        return matcher.match(offset, offset + value.length(), 0) != -1;
    }

    private static JoniRegexp compileJoni(String patternString, char escapeChar, boolean shouldEscape) {
        byte[] bytes = BenchmarkLike.likeToRegex(patternString, escapeChar, shouldEscape).getBytes(StandardCharsets.UTF_8);
        Regex joniRegex = new Regex(bytes, 0, bytes.length, 4, (Encoding)NonStrictUTF8Encoding.INSTANCE, SYNTAX);
        return new JoniRegexp(Slices.wrappedBuffer((byte[])bytes), joniRegex);
    }

    private static String likeToRegex(String patternString, char escapeChar, boolean shouldEscape) {
        StringBuilder regex = new StringBuilder(patternString.length() * 2);
        regex.append('^');
        boolean escaped = false;
        block7: for (char currentChar : patternString.toCharArray()) {
            BenchmarkLike.checkEscape(!escaped || currentChar == '%' || currentChar == '_' || currentChar == escapeChar);
            if (shouldEscape && !escaped && currentChar == escapeChar) {
                escaped = true;
                continue;
            }
            switch (currentChar) {
                case '%': {
                    regex.append(escaped ? "%" : ".*");
                    escaped = false;
                    continue block7;
                }
                case '_': {
                    regex.append(escaped ? "_" : ".");
                    escaped = false;
                    continue block7;
                }
                default: {
                    switch (currentChar) {
                        case '$': 
                        case '*': 
                        case '.': 
                        case '\\': 
                        case '^': {
                            regex.append('\\');
                        }
                    }
                    regex.append(currentChar);
                    escaped = false;
                }
            }
        }
        BenchmarkLike.checkEscape(!escaped);
        regex.append('$');
        return regex.toString();
    }

    private static void checkEscape(boolean condition) {
        Failures.checkCondition((boolean)condition, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (String)"Escape character must be followed by '%%', '_' or the escape character itself", (Object[])new Object[0]);
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkLike.class.getSimpleName() + ".*").resultFormat(ResultFormatType.JSON).build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class Data {
        @Param(value={"%", "_%", "%_", "abc%", "%abc", "_____", "abc%def%ghi", "%abc%def%", "%a%a%a%a%", "%aaaaaaaaaaaaaaaaaaaaaaaaaa%"})
        private String pattern;
        private Slice data;
        private byte[] bytes;
        private JoniRegexp joniPattern;
        private LikeMatcher dfaMatcher;
        private LikeMatcher nfaMatcher;

        @Setup
        public void setup() {
            this.data = Slices.utf8Slice((String)(switch (this.pattern) {
                case "%" -> "qeroighqeorhgqerhb2eriuyerqiubgierubgleuqrbgilquebriuqebryqebrhqerhqsnajkbcowuhet";
                case "_%", "%_" -> "qeroighqeorhgqerhb2eriuyerqiubgierubgleuqrbgilquebriuqebryqebrhqerhqsnajkbcowuhet";
                case "abc%" -> "abcqeroighqeorhgqerhb2eriuyerqiubgierubgleuqrbgilquebriuqebryqebrhqerhqsnajkbcowuhet";
                case "%abc" -> "qeroighqeorhgqerhb2eriuyerqiubgierubgleuqrbgilquebriuqebryqebrhqerhqsnajkbcowuhetabc";
                case "_____" -> "abcde";
                case "abc%def%ghi" -> "abc qeroighqeorhgqerhb2eriuyerqiubgier def ubgleuqrbgilquebriuqebryqebrhqerhqsnajkbcowuhet ghi";
                case "%abc%def%" -> "fdnbqerbfklerqbgqjerbgkr abc qeroighqeorhgqerhb2eriuyerqiubgier def ubgleuqrbgilquebriuqebryqebrhqerhqsnajkbcowuhet";
                case "%a%a%a%a%" -> "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa";
                case "%aaaaaaaaaaaaaaaaaaaaaaaaaa%" -> "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa";
                default -> throw new IllegalArgumentException("Unknown pattern: " + this.pattern);
            }));
            this.dfaMatcher = LikeMatcher.compile((String)this.pattern, Optional.empty(), (boolean)true);
            this.nfaMatcher = LikeMatcher.compile((String)this.pattern, Optional.empty(), (boolean)false);
            this.joniPattern = BenchmarkLike.compileJoni(Slices.utf8Slice((String)this.pattern).toStringUtf8(), '0', false);
            this.bytes = this.data.getBytes();
        }
    }
}

