/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.util.Arrays;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestArrayTrimFunction {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testTrimArray() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("trim_array", "ARRAY[1, 2, 3, 4]", "2")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)1, (Object)2));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("trim_array", "ARRAY[1, 2, 3, 4]", "0")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)1, (Object)2, (Object)3, (Object)4));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("trim_array", "ARRAY[1, 2, 3, 4]", "1")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)1, (Object)2, (Object)3));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("trim_array", "ARRAY[1, 2, 3, 4]", "3")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)1));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("trim_array", "ARRAY[1, 2, 3, 4]", "4")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("trim_array", "ARRAY['a', 'b', 'c', 'd']", "1")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)1))).isEqualTo(ImmutableList.of((Object)"a", (Object)"b", (Object)"c"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("trim_array", "ARRAY['a', 'b', null, 'd']", "1")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)1))).isEqualTo(Arrays.asList("a", "b", null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("trim_array", "ARRAY[ARRAY[1, 2, 3], ARRAY[4, 5, 6]]", "1")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)1, (Object)2, (Object)3)));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.function("trim_array", "ARRAY[1, 2, 3, 4]", "5").evaluate()).hasMessage("size must not exceed array cardinality 4: 5");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.function("trim_array", "ARRAY[1, 2, 3, 4]", "-1").evaluate()).hasMessage("size must not be negative: -1");
    }
}

