/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamp;

import io.trino.Session;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.TestingSession;
import io.trino.testing.assertions.TrinoExceptionAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestHumanReadableSeconds {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        Session session = TestingSession.testSessionBuilder().setTimeZoneKey(TestingSession.DEFAULT_TIME_ZONE_KEY).build();
        this.assertions = new QueryAssertions(session);
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testToHumanRedableSecondsFormat() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("human_readable_seconds", "0")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("0 seconds");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("human_readable_seconds", "1")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1 second");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("human_readable_seconds", "60")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1 minute");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("human_readable_seconds", "-60")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1 minute");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("human_readable_seconds", "61")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1 minute, 1 second");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("human_readable_seconds", "-61")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1 minute, 1 second");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("human_readable_seconds(535333.9513888889)")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("6 days, 4 hours, 42 minutes, 14 seconds");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("human_readable_seconds(535333.2513888889)")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("6 days, 4 hours, 42 minutes, 13 seconds");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("human_readable_seconds", "56363463")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("93 weeks, 1 day, 8 hours, 31 minutes, 3 seconds");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("human_readable_seconds", "3660")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1 hour, 1 minute");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("human_readable_seconds", "3601")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1 hour, 1 second");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("human_readable_seconds", "8003")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("2 hours, 13 minutes, 23 seconds");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("human_readable_seconds", "NULL")))).isNull((Type)VarcharType.VARCHAR);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.function("human_readable_seconds", "0.0E0 / 0.0E0").evaluate()).hasMessage("Invalid argument found: NaN");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.function("human_readable_seconds", "1.0E0 / 0.0E0").evaluate()).hasMessage("Invalid argument found: Infinity");
    }
}

