/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security;

import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import io.trino.server.security.UserMapping;
import io.trino.server.security.UserMappingException;
import java.io.File;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestUserMapping {
    private File testFile;

    @BeforeClass
    public void setUp() throws URISyntaxException {
        this.testFile = new File(Resources.getResource((String)"user-mapping.json").toURI());
    }

    @Test
    public void testStaticFactory() throws Exception {
        UserMapping defaultUserMapping = UserMapping.createUserMapping(Optional.empty(), Optional.empty());
        Assert.assertEquals((String)defaultUserMapping.mapUser("test@example.com"), (String)"test@example.com");
        UserMapping singlePatternUserMapping = UserMapping.createUserMapping(Optional.of("(.*?)@.*"), Optional.empty());
        Assert.assertEquals((String)singlePatternUserMapping.mapUser("test@example.com"), (String)"test");
        UserMapping fileUserMapping = UserMapping.createUserMapping(Optional.empty(), Optional.of(this.testFile));
        Assert.assertEquals((String)fileUserMapping.mapUser("test@example.com"), (String)"test_file");
        Assert.assertEquals((String)fileUserMapping.mapUser("user"), (String)"user");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> fileUserMapping.mapUser("test")).isInstanceOf(UserMappingException.class)).hasMessage("Principal is not allowed");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> UserMapping.createUserMapping(Optional.of("(.*?)@.*"), Optional.of(this.testFile))).isInstanceOf(IllegalArgumentException.class)).hasMessage("user mapping pattern and file can not both be set");
    }

    @Test
    public void testSimplePatternRule() throws Exception {
        UserMapping userMapping = new UserMapping((List)ImmutableList.of((Object)new UserMapping.Rule("(.*?)@.*")));
        Assert.assertEquals((String)userMapping.mapUser("test@example.com"), (String)"test");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> userMapping.mapUser("no at sign")).isInstanceOf(UserMappingException.class)).hasMessage("No user mapping patterns match the principal");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> userMapping.mapUser("@no user string")).isInstanceOf(UserMappingException.class)).hasMessage("Principal matched, but mapped user is empty");
    }

    @Test
    public void testReplacePatternRule() throws Exception {
        UserMapping userMapping = new UserMapping((List)ImmutableList.of((Object)new UserMapping.Rule("(.*?)@.*", "$1 ^ $1", true, UserMapping.Case.KEEP)));
        Assert.assertEquals((String)userMapping.mapUser("test@example.com"), (String)"test ^ test");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> userMapping.mapUser("no at sign")).isInstanceOf(UserMappingException.class)).hasMessage("No user mapping patterns match the principal");
        UserMapping emptyMapping = new UserMapping((List)ImmutableList.of((Object)new UserMapping.Rule("(.*?)@.*", "  ", true, UserMapping.Case.KEEP)));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> emptyMapping.mapUser("test@example.com")).isInstanceOf(UserMappingException.class)).hasMessage("Principal matched, but mapped user is empty");
    }

    @Test
    public void testNotAllowedRule() {
        UserMapping userMapping = new UserMapping((List)ImmutableList.of((Object)new UserMapping.Rule("(.*?)@.*", "$1", false, UserMapping.Case.KEEP)));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> userMapping.mapUser("test@example.com")).isInstanceOf(UserMappingException.class)).hasMessage("Principal is not allowed");
        UserMapping emptyMapping = new UserMapping((List)ImmutableList.of((Object)new UserMapping.Rule("(.*?)@.*", "", false, UserMapping.Case.KEEP)));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> emptyMapping.mapUser("test@example.com")).isInstanceOf(UserMappingException.class)).hasMessage("Principal is not allowed");
    }

    @Test
    public void testMultipleRule() throws Exception {
        UserMapping userMapping = new UserMapping((List)ImmutableList.of((Object)new UserMapping.Rule("test@example.com", "", false, UserMapping.Case.KEEP), (Object)new UserMapping.Rule("(.*?)@example.com")));
        Assert.assertEquals((String)userMapping.mapUser("apple@example.com"), (String)"apple");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> userMapping.mapUser("test@example.com")).isInstanceOf(UserMappingException.class)).hasMessage("Principal is not allowed");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> userMapping.mapUser("apple@other.example.com")).isInstanceOf(UserMappingException.class)).hasMessage("No user mapping patterns match the principal");
    }

    @Test
    public void testLowercaseUsernameRule() throws UserMappingException {
        UserMapping userMapping = new UserMapping((List)ImmutableList.of((Object)new UserMapping.Rule("(.*)@EXAMPLE\\.COM", "$1", true, UserMapping.Case.LOWER)));
        Assert.assertEquals((String)userMapping.mapUser("TEST@EXAMPLE.COM"), (String)"test");
    }

    @Test
    public void testUppercaseUsernameRule() throws UserMappingException {
        UserMapping userMapping = new UserMapping((List)ImmutableList.of((Object)new UserMapping.Rule("(.*)@example\\.com", "$1", true, UserMapping.Case.UPPER)));
        Assert.assertEquals((String)userMapping.mapUser("test@example.com"), (String)"TEST");
    }

    @Test
    public void testDocsExample() throws Exception {
        File docExample = new File("../../docs/src/main/sphinx/security/user-mapping.json");
        UserMapping userMapping = UserMapping.createUserMapping(Optional.empty(), Optional.of(docExample));
        Assert.assertEquals((String)userMapping.mapUser("apple@example.com"), (String)"apple");
        Assert.assertEquals((String)userMapping.mapUser("apple@uk.example.com"), (String)"apple_uk");
        Assert.assertEquals((String)userMapping.mapUser("apple@de.example.com"), (String)"apple_de");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> userMapping.mapUser("apple@unknown.com")).isInstanceOf(UserMappingException.class)).hasMessage("No user mapping patterns match the principal");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> userMapping.mapUser("test@example.com")).isInstanceOf(UserMappingException.class)).hasMessage("Principal is not allowed");
        Assert.assertEquals((String)userMapping.mapUser("test@uppercase.com"), (String)"TEST");
    }
}

