/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import io.trino.json.ir.IrAbsMethod;
import io.trino.json.ir.IrArithmeticBinary;
import io.trino.json.ir.IrArithmeticUnary;
import io.trino.json.ir.IrArrayAccessor;
import io.trino.json.ir.IrCeilingMethod;
import io.trino.json.ir.IrComparisonPredicate;
import io.trino.json.ir.IrConjunctionPredicate;
import io.trino.json.ir.IrContextVariable;
import io.trino.json.ir.IrDescendantMemberAccessor;
import io.trino.json.ir.IrDisjunctionPredicate;
import io.trino.json.ir.IrDoubleMethod;
import io.trino.json.ir.IrExistsPredicate;
import io.trino.json.ir.IrFilter;
import io.trino.json.ir.IrFloorMethod;
import io.trino.json.ir.IrIsUnknownPredicate;
import io.trino.json.ir.IrJsonNull;
import io.trino.json.ir.IrJsonPath;
import io.trino.json.ir.IrKeyValueMethod;
import io.trino.json.ir.IrLastIndexVariable;
import io.trino.json.ir.IrLiteral;
import io.trino.json.ir.IrMemberAccessor;
import io.trino.json.ir.IrNamedJsonVariable;
import io.trino.json.ir.IrNamedValueVariable;
import io.trino.json.ir.IrNegationPredicate;
import io.trino.json.ir.IrPathNode;
import io.trino.json.ir.IrPredicate;
import io.trino.json.ir.IrPredicateCurrentItemVariable;
import io.trino.json.ir.IrSizeMethod;
import io.trino.json.ir.IrStartsWithPredicate;
import io.trino.json.ir.IrTypeMethod;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Optional;

public class PathNodes {
    private PathNodes() {
    }

    public static IrJsonPath path(boolean lax, IrPathNode root) {
        return new IrJsonPath(lax, root);
    }

    public static IrPathNode abs(IrPathNode base) {
        return new IrAbsMethod(base, Optional.empty());
    }

    public static IrPathNode add(IrPathNode left, IrPathNode right) {
        return new IrArithmeticBinary(IrArithmeticBinary.Operator.ADD, left, right, Optional.empty());
    }

    public static IrPathNode subtract(IrPathNode left, IrPathNode right) {
        return new IrArithmeticBinary(IrArithmeticBinary.Operator.SUBTRACT, left, right, Optional.empty());
    }

    public static IrPathNode multiply(IrPathNode left, IrPathNode right) {
        return new IrArithmeticBinary(IrArithmeticBinary.Operator.MULTIPLY, left, right, Optional.empty());
    }

    public static IrPathNode divide(IrPathNode left, IrPathNode right) {
        return new IrArithmeticBinary(IrArithmeticBinary.Operator.DIVIDE, left, right, Optional.empty());
    }

    public static IrPathNode modulus(IrPathNode left, IrPathNode right) {
        return new IrArithmeticBinary(IrArithmeticBinary.Operator.MODULUS, left, right, Optional.empty());
    }

    public static IrPathNode plus(IrPathNode base) {
        return new IrArithmeticUnary(IrArithmeticUnary.Sign.PLUS, base, Optional.empty());
    }

    public static IrPathNode minus(IrPathNode base) {
        return new IrArithmeticUnary(IrArithmeticUnary.Sign.MINUS, base, Optional.empty());
    }

    public static IrPathNode wildcardArrayAccessor(IrPathNode base) {
        return new IrArrayAccessor(base, (List)ImmutableList.of(), Optional.empty());
    }

    public static IrPathNode arrayAccessor(IrPathNode base, IrArrayAccessor.Subscript ... subscripts) {
        return new IrArrayAccessor(base, (List)ImmutableList.copyOf((Object[])subscripts), Optional.empty());
    }

    public static IrArrayAccessor.Subscript at(IrPathNode path) {
        return new IrArrayAccessor.Subscript(path, Optional.empty());
    }

    public static IrArrayAccessor.Subscript range(IrPathNode fromInclusive, IrPathNode toInclusive) {
        return new IrArrayAccessor.Subscript(fromInclusive, Optional.of(toInclusive));
    }

    public static IrPathNode ceiling(IrPathNode base) {
        return new IrCeilingMethod(base, Optional.empty());
    }

    public static IrPathNode contextVariable() {
        return new IrContextVariable(Optional.empty());
    }

    public static IrPathNode toDouble(IrPathNode base) {
        return new IrDoubleMethod(base, Optional.empty());
    }

    public static IrPathNode filter(IrPathNode base, IrPredicate predicate) {
        return new IrFilter(base, predicate, Optional.empty());
    }

    public static IrPathNode floor(IrPathNode base) {
        return new IrFloorMethod(base, Optional.empty());
    }

    public static IrPathNode jsonNull() {
        return new IrJsonNull();
    }

    public static IrPathNode keyValue(IrPathNode base) {
        return new IrKeyValueMethod(base);
    }

    public static IrPathNode last() {
        return new IrLastIndexVariable(Optional.empty());
    }

    public static IrPathNode literal(Type type, Object value) {
        return new IrLiteral(type, value);
    }

    public static IrPathNode wildcardMemberAccessor(IrPathNode base) {
        return new IrMemberAccessor(base, Optional.empty(), Optional.empty());
    }

    public static IrPathNode memberAccessor(IrPathNode base, String key) {
        return new IrMemberAccessor(base, Optional.of(key), Optional.empty());
    }

    public static IrPathNode descendantMemberAccessor(IrPathNode base, String key) {
        return new IrDescendantMemberAccessor(base, key, Optional.empty());
    }

    public static IrPathNode jsonVariable(int index) {
        return new IrNamedJsonVariable(index, Optional.empty());
    }

    public static IrPathNode variable(int index) {
        return new IrNamedValueVariable(index, Optional.empty());
    }

    public static IrPathNode currentItem() {
        return new IrPredicateCurrentItemVariable(Optional.empty());
    }

    public static IrPathNode size(IrPathNode base) {
        return new IrSizeMethod(base, Optional.empty());
    }

    public static IrPathNode type(IrPathNode base) {
        return new IrTypeMethod(base, Optional.of(VarcharType.createVarcharType((int)27)));
    }

    public static IrPredicate equal(IrPathNode left, IrPathNode right) {
        return new IrComparisonPredicate(IrComparisonPredicate.Operator.EQUAL, left, right);
    }

    public static IrPredicate notEqual(IrPathNode left, IrPathNode right) {
        return new IrComparisonPredicate(IrComparisonPredicate.Operator.NOT_EQUAL, left, right);
    }

    public static IrPredicate lessThan(IrPathNode left, IrPathNode right) {
        return new IrComparisonPredicate(IrComparisonPredicate.Operator.LESS_THAN, left, right);
    }

    public static IrPredicate greaterThan(IrPathNode left, IrPathNode right) {
        return new IrComparisonPredicate(IrComparisonPredicate.Operator.GREATER_THAN, left, right);
    }

    public static IrPredicate lessThanOrEqual(IrPathNode left, IrPathNode right) {
        return new IrComparisonPredicate(IrComparisonPredicate.Operator.LESS_THAN_OR_EQUAL, left, right);
    }

    public static IrPredicate greaterThanOrEqual(IrPathNode left, IrPathNode right) {
        return new IrComparisonPredicate(IrComparisonPredicate.Operator.GREATER_THAN_OR_EQUAL, left, right);
    }

    public static IrPredicate conjunction(IrPredicate left, IrPredicate right) {
        return new IrConjunctionPredicate(left, right);
    }

    public static IrPredicate disjunction(IrPredicate left, IrPredicate right) {
        return new IrDisjunctionPredicate(left, right);
    }

    public static IrPredicate exists(IrPathNode path) {
        return new IrExistsPredicate(path);
    }

    public static IrPredicate isUnknown(IrPredicate predicate) {
        return new IrIsUnknownPredicate(predicate);
    }

    public static IrPredicate negation(IrPredicate predicate) {
        return new IrNegationPredicate(predicate);
    }

    public static IrPredicate startsWith(IrPathNode whole, IrPathNode initial) {
        return new IrStartsWithPredicate(whole, initial);
    }

    public static List<Object> sequence(Object ... items) {
        return ImmutableList.copyOf((Object[])items);
    }

    public static List<Object> singletonSequence(Object item) {
        return ImmutableList.of((Object)item);
    }

    public static List<Object> emptySequence() {
        return ImmutableList.of();
    }
}

