/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.connector.MockConnectorColumnHandle;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorTableHandle;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.security.AccessControl;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.Assignment;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.ProjectionApplicationResult;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableScanRedirectApplicationResult;
import io.trino.spi.expression.Call;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.FieldDereference;
import io.trino.spi.expression.StandardFunctions;
import io.trino.spi.expression.Variable;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanAssert;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingSession;
import io.trino.tests.BogusType;
import io.trino.transaction.TransactionBuilder;
import io.trino.transaction.TransactionManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.testng.annotations.Test;

public class TestTableScanRedirectionWithPushdown {
    private static final String MOCK_CATALOG = "mock_catalog";
    private static final String TEST_SCHEMA = "test_schema";
    private static final String TEST_TABLE = "test_table";
    private static final SchemaTableName SOURCE_TABLE = new SchemaTableName("test_schema", "test_table");
    private static final Session MOCK_SESSION = TestingSession.testSessionBuilder().setCatalog("mock_catalog").setSchema("test_schema").build();
    private static final String SOURCE_COLUMN_NAME_A = "source_col_a";
    private static final ColumnHandle SOURCE_COLUMN_HANDLE_A = new MockConnectorColumnHandle("source_col_a", (Type)IntegerType.INTEGER);
    private static final String SOURCE_COLUMN_NAME_B = "source_col_b";
    private static final ColumnHandle SOURCE_COLUMN_HANDLE_B = new MockConnectorColumnHandle("source_col_b", (Type)IntegerType.INTEGER);
    private static final String SOURCE_COLUMN_NAME_C = "source_col_c";
    private static final ColumnHandle SOURCE_COLUMN_HANDLE_C = new MockConnectorColumnHandle("source_col_c", (Type)VarcharType.VARCHAR);
    private static final String SOURCE_COLUMN_NAME_D = "source_col_d";
    private static final Type ROW_TYPE = RowType.from(Arrays.asList(RowType.field((String)"a", (Type)BigintType.BIGINT), RowType.field((String)"b", (Type)BigintType.BIGINT)));
    private static final ColumnHandle SOURCE_COLUMN_HANDLE_D = new MockConnectorColumnHandle("source_col_d", ROW_TYPE);
    private static final SchemaTableName DESTINATION_TABLE = new SchemaTableName("target_schema", "target_table");
    private static final String DESTINATION_COLUMN_NAME_A = "destination_col_a";
    private static final ColumnHandle DESTINATION_COLUMN_HANDLE_A = new MockConnectorColumnHandle("destination_col_a", (Type)IntegerType.INTEGER);
    private static final String DESTINATION_COLUMN_NAME_B = "destination_col_b";
    private static final ColumnHandle DESTINATION_COLUMN_HANDLE_B = new MockConnectorColumnHandle("destination_col_b", (Type)IntegerType.INTEGER);
    private static final String DESTINATION_COLUMN_NAME_C = "destination_col_c";
    private static final String DESTINATION_COLUMN_NAME_D = "destination_col_d";
    private static final Map<ColumnHandle, String> REDIRECTION_MAPPING_A = ImmutableMap.of((Object)SOURCE_COLUMN_HANDLE_A, (Object)"destination_col_a");
    private static final Map<ColumnHandle, String> REDIRECTION_MAPPING_AB = ImmutableMap.of((Object)SOURCE_COLUMN_HANDLE_A, (Object)"destination_col_a", (Object)SOURCE_COLUMN_HANDLE_B, (Object)"destination_col_b");
    private static final Map<ColumnHandle, String> TYPE_MISMATCHED_REDIRECTION_MAPPING_BC = ImmutableMap.of((Object)SOURCE_COLUMN_HANDLE_B, (Object)"destination_col_b", (Object)SOURCE_COLUMN_HANDLE_C, (Object)"destination_col_a");
    private static final Map<ColumnHandle, String> ROW_TYPE_REDIRECTION_MAPPING_AD = ImmutableMap.of((Object)SOURCE_COLUMN_HANDLE_A, (Object)"destination_col_a", (Object)SOURCE_COLUMN_HANDLE_D, (Object)"destination_col_c");
    private static final Map<ColumnHandle, String> BOGUS_REDIRECTION_MAPPING_BC = ImmutableMap.of((Object)SOURCE_COLUMN_HANDLE_B, (Object)"destination_col_b", (Object)SOURCE_COLUMN_HANDLE_C, (Object)"destination_col_d");

    @Test
    public void testRedirectionAfterProjectionPushdown() {
        try (LocalQueryRunner queryRunner = this.createLocalQueryRunner(this.mockApplyRedirectAfterProjectionPushdown(REDIRECTION_MAPPING_A, Optional.of(ImmutableSet.of((Object)SOURCE_COLUMN_HANDLE_A))), Optional.of(this::mockApplyProjection), Optional.empty());){
            this.assertPlan(queryRunner, "SELECT source_col_a FROM test_table", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"DEST_COL"), PlanMatchPattern.tableScan("target_table", (Map<String, String>)ImmutableMap.of((Object)"DEST_COL", (Object)DESTINATION_COLUMN_NAME_A))));
            this.assertPlan(queryRunner, "SELECT source_col_a, source_col_b FROM test_table", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"SOURCE_COLA", (Object)"SOURCE_COLB"), PlanMatchPattern.tableScan(TEST_TABLE, (Map<String, String>)ImmutableMap.of((Object)"SOURCE_COLA", (Object)SOURCE_COLUMN_NAME_A, (Object)"SOURCE_COLB", (Object)SOURCE_COLUMN_NAME_B))));
            this.assertPlan(queryRunner, "SELECT source_col_a FROM test_table WHERE source_col_a > 0", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"DEST_COL"), PlanMatchPattern.filter("DEST_COL > 0", PlanMatchPattern.tableScan(new MockConnectorTableHandle(DESTINATION_TABLE)::equals, (TupleDomain<Predicate<ColumnHandle>>)TupleDomain.all(), (Map<String, Predicate<ColumnHandle>>)ImmutableMap.of((Object)"DEST_COL", arg_0 -> ((ColumnHandle)DESTINATION_COLUMN_HANDLE_A).equals(arg_0))))));
        }
    }

    @Test
    public void testRedirectionAfterPredicatePushdownIntoTableScan() {
        try (LocalQueryRunner queryRunner = this.createLocalQueryRunner(this.getMockApplyRedirectAfterPredicatePushdown(REDIRECTION_MAPPING_A, Optional.empty()), Optional.empty(), Optional.of(this.getMockApplyFilter((Set<ColumnHandle>)ImmutableSet.of((Object)SOURCE_COLUMN_HANDLE_A, (Object)DESTINATION_COLUMN_HANDLE_A))));){
            this.assertPlan(queryRunner, "SELECT source_col_a FROM test_table WHERE source_col_a = 1", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"DEST_COL"), PlanMatchPattern.tableScan(new MockConnectorTableHandle(DESTINATION_TABLE, (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)DESTINATION_COLUMN_HANDLE_A, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L))), Optional.empty())::equals, (TupleDomain<Predicate<ColumnHandle>>)TupleDomain.withColumnDomains((Map)ImmutableMap.of(arg_0 -> ((ColumnHandle)DESTINATION_COLUMN_HANDLE_A).equals(arg_0), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L))), (Map<String, Predicate<ColumnHandle>>)ImmutableMap.of((Object)"DEST_COL", arg_0 -> ((ColumnHandle)DESTINATION_COLUMN_HANDLE_A).equals(arg_0)))));
            this.assertPlan(queryRunner, "SELECT source_col_a FROM test_table", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"SOURCE_COL"), PlanMatchPattern.tableScan(TEST_TABLE, (Map<String, String>)ImmutableMap.of((Object)"SOURCE_COL", (Object)SOURCE_COLUMN_NAME_A))));
        }
    }

    @Test
    public void testPredicatePushdownAfterRedirect() {
        try (LocalQueryRunner queryRunner = this.createLocalQueryRunner(this.getMockApplyRedirectAfterPredicatePushdown(REDIRECTION_MAPPING_AB, Optional.empty()), Optional.empty(), Optional.of(this.getMockApplyFilter((Set<ColumnHandle>)ImmutableSet.of((Object)SOURCE_COLUMN_HANDLE_A, (Object)DESTINATION_COLUMN_HANDLE_B))));){
            this.assertPlan(queryRunner, "SELECT source_col_a, source_col_b FROM test_table WHERE source_col_a = 1 AND source_col_b = 2", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"DEST_COL_A", (Object)"DEST_COL_B"), PlanMatchPattern.filter("DEST_COL_A = 1", PlanMatchPattern.tableScan(new MockConnectorTableHandle(DESTINATION_TABLE, (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)DESTINATION_COLUMN_HANDLE_B, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)2L))), Optional.empty())::equals, (TupleDomain<Predicate<ColumnHandle>>)TupleDomain.withColumnDomains((Map)ImmutableMap.of(arg_0 -> ((ColumnHandle)DESTINATION_COLUMN_HANDLE_B).equals(arg_0), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)2L))), (Map<String, Predicate<ColumnHandle>>)ImmutableMap.of((Object)"DEST_COL_A", arg_0 -> ((ColumnHandle)DESTINATION_COLUMN_HANDLE_A).equals(arg_0), (Object)"DEST_COL_B", arg_0 -> ((ColumnHandle)DESTINATION_COLUMN_HANDLE_B).equals(arg_0))))));
        }
    }

    @Test
    public void testRedirectAfterColumnPruningOnPushedDownPredicate() {
        try (LocalQueryRunner queryRunner = this.createLocalQueryRunner(this.getMockApplyRedirectAfterPredicatePushdown(REDIRECTION_MAPPING_AB, Optional.of(ImmutableSet.of((Object)SOURCE_COLUMN_HANDLE_B))), Optional.of(this::mockApplyProjection), Optional.of(this.getMockApplyFilter((Set<ColumnHandle>)ImmutableSet.of((Object)SOURCE_COLUMN_HANDLE_A, (Object)DESTINATION_COLUMN_HANDLE_A))));){
            this.assertPlan(queryRunner, "SELECT source_col_b FROM test_table WHERE source_col_a = 1", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"DEST_COL_B"), PlanMatchPattern.tableScan(new MockConnectorTableHandle(DESTINATION_TABLE, (TupleDomain<ColumnHandle>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)DESTINATION_COLUMN_HANDLE_A, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L))), Optional.of(ImmutableList.of((Object)DESTINATION_COLUMN_HANDLE_B)))::equals, (TupleDomain<Predicate<ColumnHandle>>)TupleDomain.all(), (Map<String, Predicate<ColumnHandle>>)ImmutableMap.of((Object)"DEST_COL_B", arg_0 -> ((ColumnHandle)DESTINATION_COLUMN_HANDLE_B).equals(arg_0)))));
        }
    }

    @Test
    public void testPredicateTypeWithCoercion() {
        try (LocalQueryRunner queryRunner = this.createLocalQueryRunner(this.getMockApplyRedirectAfterPredicatePushdown(TYPE_MISMATCHED_REDIRECTION_MAPPING_BC, Optional.of(ImmutableSet.of((Object)SOURCE_COLUMN_HANDLE_B))), Optional.of(this::mockApplyProjection), Optional.of(this.getMockApplyFilter((Set<ColumnHandle>)ImmutableSet.of((Object)SOURCE_COLUMN_HANDLE_C))));){
            this.assertPlan(queryRunner, "SELECT source_col_b FROM test_table WHERE source_col_c = 'foo'", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"DEST_COL_B"), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"DEST_COL_B", (Object)PlanMatchPattern.expression("DEST_COL_B")), PlanMatchPattern.filter("CAST(DEST_COL_A AS VARCHAR) = VARCHAR 'foo'", PlanMatchPattern.tableScan(new MockConnectorTableHandle(DESTINATION_TABLE, (TupleDomain<ColumnHandle>)TupleDomain.all(), Optional.of(ImmutableList.of((Object)DESTINATION_COLUMN_HANDLE_B, (Object)DESTINATION_COLUMN_HANDLE_A)))::equals, (TupleDomain<Predicate<ColumnHandle>>)TupleDomain.all(), (Map<String, Predicate<ColumnHandle>>)ImmutableMap.of((Object)"DEST_COL_B", arg_0 -> ((ColumnHandle)DESTINATION_COLUMN_HANDLE_B).equals(arg_0), (Object)"DEST_COL_A", arg_0 -> ((ColumnHandle)DESTINATION_COLUMN_HANDLE_A).equals(arg_0)))))));
        }
    }

    @Test
    public void testPredicateTypeMismatchWithMissingCoercion() {
        try (LocalQueryRunner queryRunner = this.createLocalQueryRunner(this.getMockApplyRedirectAfterPredicatePushdown(BOGUS_REDIRECTION_MAPPING_BC, Optional.of(ImmutableSet.of((Object)SOURCE_COLUMN_HANDLE_B))), Optional.of(this::mockApplyProjection), Optional.of(this.getMockApplyFilter((Set<ColumnHandle>)ImmutableSet.of((Object)SOURCE_COLUMN_HANDLE_C))));){
            TransactionBuilder.transaction((TransactionManager)queryRunner.getTransactionManager(), (AccessControl)queryRunner.getAccessControl()).execute(MOCK_SESSION, session -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> queryRunner.createPlan(session, "SELECT source_col_b FROM test_table WHERE source_col_c = 'foo'", WarningCollector.NOOP, PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector())).isInstanceOf(TrinoException.class)).hasMessageMatching("Cast not possible from redirected column mock_catalog.target_schema.target_table.destination_col_d with type Bogus to source column .*mock_catalog.test_schema.test_table.*source_col_c.* with type: varchar"));
        }
    }

    @Test
    public void testRedirectionBeforeDeferencePushdown() {
        try (LocalQueryRunner queryRunner = this.createLocalQueryRunner(this.mockApplyRedirectAfterProjectionPushdown(ROW_TYPE_REDIRECTION_MAPPING_AD, Optional.of(ImmutableSet.of((Object)SOURCE_COLUMN_HANDLE_A, (Object)SOURCE_COLUMN_HANDLE_D))), Optional.of(this::mockApplyProjection), Optional.empty());){
            MockConnectorColumnHandle destinationColumnHandleC0 = new MockConnectorColumnHandle("destination_col_c#0", (Type)BigintType.BIGINT);
            this.assertPlan(queryRunner, "SELECT source_col_a, source_col_d.a FROM test_table", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"DEST_COL_A", (Object)"DEST_COL_C#0"), PlanMatchPattern.tableScan(new MockConnectorTableHandle(DESTINATION_TABLE, (TupleDomain<ColumnHandle>)TupleDomain.all(), Optional.of(ImmutableList.of((Object)DESTINATION_COLUMN_HANDLE_A, (Object)destinationColumnHandleC0)))::equals, (TupleDomain<Predicate<ColumnHandle>>)TupleDomain.all(), (Map<String, Predicate<ColumnHandle>>)ImmutableMap.of((Object)"DEST_COL_A", arg_0 -> ((ColumnHandle)DESTINATION_COLUMN_HANDLE_A).equals(arg_0), (Object)"DEST_COL_C#0", arg_0 -> ((ColumnHandle)destinationColumnHandleC0).equals(arg_0)))));
        }
    }

    private LocalQueryRunner createLocalQueryRunner(MockConnectorFactory.ApplyTableScanRedirect applyTableScanRedirect, Optional<MockConnectorFactory.ApplyProjection> applyProjection, Optional<MockConnectorFactory.ApplyFilter> applyFilter) {
        LocalQueryRunner queryRunner = LocalQueryRunner.create((Session)MOCK_SESSION);
        MockConnectorFactory.Builder builder = MockConnectorFactory.builder().withGetTableHandle((session, schemaTableName) -> new MockConnectorTableHandle((SchemaTableName)schemaTableName)).withGetColumns(name -> {
            if (name.equals((Object)SOURCE_TABLE)) {
                return ImmutableList.of((Object)new ColumnMetadata(SOURCE_COLUMN_NAME_A, (Type)IntegerType.INTEGER), (Object)new ColumnMetadata(SOURCE_COLUMN_NAME_B, (Type)IntegerType.INTEGER), (Object)new ColumnMetadata(SOURCE_COLUMN_NAME_C, (Type)VarcharType.VARCHAR), (Object)new ColumnMetadata(SOURCE_COLUMN_NAME_D, ROW_TYPE));
            }
            if (name.equals((Object)DESTINATION_TABLE)) {
                return ImmutableList.of((Object)new ColumnMetadata(DESTINATION_COLUMN_NAME_A, (Type)IntegerType.INTEGER), (Object)new ColumnMetadata(DESTINATION_COLUMN_NAME_B, (Type)IntegerType.INTEGER), (Object)new ColumnMetadata(DESTINATION_COLUMN_NAME_C, ROW_TYPE), (Object)new ColumnMetadata(DESTINATION_COLUMN_NAME_D, (Type)BogusType.BOGUS));
            }
            throw new IllegalArgumentException();
        }).withApplyTableScanRedirect(applyTableScanRedirect);
        applyProjection.ifPresent(builder::withApplyProjection);
        applyFilter.ifPresent(builder::withApplyFilter);
        queryRunner.createCatalog(MOCK_CATALOG, (ConnectorFactory)builder.build(), (Map)ImmutableMap.of());
        return queryRunner;
    }

    private Optional<ProjectionApplicationResult<ConnectorTableHandle>> mockApplyProjection(ConnectorSession session, ConnectorTableHandle tableHandle, List<ConnectorExpression> projections, Map<String, ColumnHandle> assignments) {
        MockConnectorTableHandle handle = (MockConnectorTableHandle)tableHandle;
        ImmutableList.Builder newColumnsBuilder = ImmutableList.builder();
        ImmutableList.Builder outputExpressions = ImmutableList.builder();
        ImmutableList.Builder outputAssignments = ImmutableList.builder();
        for (ConnectorExpression projection : projections) {
            ColumnHandle newColumnHandle;
            Variable newVariable;
            Object newVariableName;
            Type type = projection.getType();
            if (projection instanceof Variable) {
                Variable variable = (Variable)projection;
                newVariableName = variable.getName();
                newVariable = new Variable((String)newVariableName, type);
                newColumnHandle = assignments.get(newVariableName);
            } else if (projection instanceof FieldDereference) {
                FieldDereference dereference = (FieldDereference)projection;
                ConnectorExpression connectorExpression = dereference.getTarget();
                if (!(connectorExpression instanceof Variable)) {
                    throw new UnsupportedOperationException();
                }
                Variable variable = (Variable)connectorExpression;
                String dereferenceTargetName = variable.getName();
                newVariableName = ((MockConnectorColumnHandle)assignments.get(dereferenceTargetName)).getName() + "#" + dereference.getField();
                newVariable = new Variable((String)newVariableName, type);
                newColumnHandle = new MockConnectorColumnHandle((String)newVariableName, type);
            } else if (projection instanceof Call) {
                Call call = (Call)projection;
                if (!StandardFunctions.CAST_FUNCTION_NAME.equals((Object)call.getFunctionName()) || call.getArguments().size() != 1) {
                    throw new UnsupportedOperationException();
                }
                newVariableName = ((Variable)call.getArguments().get(0)).getName();
                newVariable = projection;
                newColumnHandle = assignments.get(newVariableName);
                type = ((ConnectorExpression)call.getArguments().get(0)).getType();
            } else {
                throw new UnsupportedOperationException();
            }
            newColumnsBuilder.add((Object)newColumnHandle);
            outputExpressions.add((Object)newVariable);
            outputAssignments.add((Object)new Assignment((String)newVariableName, newColumnHandle, type));
        }
        ImmutableList newColumns = newColumnsBuilder.build();
        if (handle.getColumns().isPresent() && newColumns.equals(handle.getColumns().get())) {
            return Optional.empty();
        }
        return Optional.of(new ProjectionApplicationResult((Object)new MockConnectorTableHandle(handle.getTableName(), handle.getConstraint(), Optional.of(newColumns)), (List)outputExpressions.build(), (List)outputAssignments.build(), false));
    }

    private MockConnectorFactory.ApplyFilter getMockApplyFilter(Set<ColumnHandle> pushdownColumns) {
        return (session, table, constraint) -> {
            TupleDomain newDomain;
            MockConnectorTableHandle handle = (MockConnectorTableHandle)table;
            TupleDomain<ColumnHandle> oldDomain = handle.getConstraint();
            if (oldDomain.equals((Object)(newDomain = oldDomain.intersect(constraint.getSummary().filter((columnHandle, domain) -> pushdownColumns.contains(columnHandle)))))) {
                return Optional.empty();
            }
            return Optional.of(new ConstraintApplicationResult((Object)new MockConnectorTableHandle(handle.getTableName(), (TupleDomain<ColumnHandle>)newDomain, Optional.empty()), constraint.getSummary().filter((columnHandle, domain) -> !pushdownColumns.contains(columnHandle)), false));
        };
    }

    private MockConnectorFactory.ApplyTableScanRedirect mockApplyRedirectAfterProjectionPushdown(Map<ColumnHandle, String> redirectionMapping, Optional<Set<ColumnHandle>> requiredProjections) {
        return this.getMockApplyRedirect(redirectionMapping, requiredProjections, false);
    }

    private MockConnectorFactory.ApplyTableScanRedirect getMockApplyRedirectAfterPredicatePushdown(Map<ColumnHandle, String> redirectionMapping, Optional<Set<ColumnHandle>> requiredProjections) {
        return this.getMockApplyRedirect(redirectionMapping, requiredProjections, true);
    }

    private MockConnectorFactory.ApplyTableScanRedirect getMockApplyRedirect(Map<ColumnHandle, String> redirectionMapping, Optional<Set<ColumnHandle>> requiredProjections, boolean requirePredicatePushdown) {
        return (session, handle) -> {
            MockConnectorTableHandle mockConnectorTable = (MockConnectorTableHandle)handle;
            if (requirePredicatePushdown && mockConnectorTable.getConstraint().isAll()) {
                return Optional.empty();
            }
            Optional<List<ColumnHandle>> projectedColumns = mockConnectorTable.getColumns();
            if (requiredProjections.isPresent() && (projectedColumns.isEmpty() || !((Set)requiredProjections.get()).equals(ImmutableSet.copyOf((Collection)projectedColumns.get())))) {
                return Optional.empty();
            }
            return Optional.of(new TableScanRedirectApplicationResult(new CatalogSchemaTableName(MOCK_CATALOG, DESTINATION_TABLE), redirectionMapping, mockConnectorTable.getConstraint().transformKeys(MockConnectorColumnHandle.class::cast).filter((columnHandle, domain) -> redirectionMapping.containsKey(columnHandle)).transformKeys(redirectionMapping::get)));
        };
    }

    void assertPlan(LocalQueryRunner queryRunner, @Language(value="SQL") String sql, PlanMatchPattern pattern) {
        List optimizers = queryRunner.getPlanOptimizers(true);
        queryRunner.inTransaction(transactionSession -> {
            Plan actualPlan = queryRunner.createPlan(transactionSession, sql, optimizers, LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, WarningCollector.NOOP, PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector());
            PlanAssert.assertPlan(transactionSession, queryRunner.getMetadata(), queryRunner.getFunctionManager(), queryRunner.getStatsCalculator(), actualPlan, pattern);
            return null;
        });
    }
}

