/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.plugin.tpch.TpchConnectorFactory;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.eventlistener.QueryPlanOptimizerStatistics;
import io.trino.sql.planner.RuleStatsRecorder;
import io.trino.sql.planner.iterative.IterativeOptimizer;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.RemoveRedundantIdentityProjections;
import io.trino.sql.planner.optimizations.PlanOptimizer;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingSession;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestIterativeOptimizer {
    private LocalQueryRunner queryRunner;

    @BeforeClass
    public void setUp() {
        Session.SessionBuilder sessionBuilder = TestingSession.testSessionBuilder().setCatalog("test-catalog").setSchema("tiny").setSystemProperty("task_concurrency", "1").setSystemProperty("iterative_optimizer_timeout", "1ms");
        this.queryRunner = LocalQueryRunner.create((Session)sessionBuilder.build());
        this.queryRunner.createCatalog((String)this.queryRunner.getDefaultSession().getCatalog().get(), (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        if (this.queryRunner != null) {
            this.queryRunner.close();
            this.queryRunner = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeOut=10000L)
    public void optimizerQueryRulesStatsCollect() {
        try (LocalQueryRunner queryRunner = null;){
            Session.SessionBuilder sessionBuilder = TestingSession.testSessionBuilder().setSystemProperty("iterative_optimizer_timeout", "5s");
            queryRunner = LocalQueryRunner.create((Session)sessionBuilder.build());
            PlanOptimizersStatsCollector planOptimizersStatsCollector = new PlanOptimizersStatsCollector(10);
            IterativeOptimizer optimizer = new IterativeOptimizer(queryRunner.getPlannerContext(), new RuleStatsRecorder(), queryRunner.getStatsCalculator(), queryRunner.getCostCalculator(), (Set)ImmutableSet.of((Object)new AddIdentityOverTableScan(), (Object)new RemoveRedundantIdentityProjections()));
            queryRunner.createPlan(sessionBuilder.build(), "SELECT 1", (List)ImmutableList.of((Object)optimizer), WarningCollector.NOOP, planOptimizersStatsCollector);
            Optional queryRuleStats = planOptimizersStatsCollector.getTopRuleStats().stream().findFirst();
            Assert.assertTrue((boolean)queryRuleStats.isPresent());
            QueryPlanOptimizerStatistics queryRuleStat = (QueryPlanOptimizerStatistics)queryRuleStats.get();
            Assert.assertEquals((String)queryRuleStat.rule(), (String)RemoveRedundantIdentityProjections.class.getCanonicalName());
            Assert.assertEquals((long)queryRuleStat.invocations(), (long)4L);
            Assert.assertEquals((long)queryRuleStat.applied(), (long)3L);
            Assert.assertEquals((long)queryRuleStat.failures(), (long)0L);
        }
    }

    @Test(timeOut=10000L)
    public void optimizerTimeoutsOnNonConvergingPlan() {
        IterativeOptimizer optimizer = new IterativeOptimizer(this.queryRunner.getPlannerContext(), new RuleStatsRecorder(), this.queryRunner.getStatsCalculator(), this.queryRunner.getCostCalculator(), (Set)ImmutableSet.of((Object)new AddIdentityOverTableScan(), (Object)new RemoveRedundantIdentityProjections()));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.lambda$optimizerTimeoutsOnNonConvergingPlan$1((PlanOptimizer)optimizer)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.OPTIMIZER_TIMEOUT}).hasMessageMatching("The optimizer exhausted the time limit of 1 ms: (no rules invoked|(?s)Top rules:.*(RemoveRedundantIdentityProjections|AddIdentityOverTableScan).*)");
    }

    private /* synthetic */ void lambda$optimizerTimeoutsOnNonConvergingPlan$1(PlanOptimizer optimizer) throws Throwable {
        this.queryRunner.inTransaction(transactionSession -> this.queryRunner.createPlan(transactionSession, "SELECT nationkey FROM nation", (List)ImmutableList.of((Object)optimizer), WarningCollector.NOOP, PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector()));
    }

    private static class AddIdentityOverTableScan
    implements Rule<TableScanNode> {
        private AddIdentityOverTableScan() {
        }

        public Pattern<TableScanNode> getPattern() {
            return Patterns.tableScan();
        }

        public Rule.Result apply(TableScanNode tableScan, Captures captures, Rule.Context context) {
            return Rule.Result.ofPlanNode((PlanNode)new ProjectNode(context.getIdAllocator().getNextId(), (PlanNode)tableScan, Assignments.identity((Iterable)tableScan.getOutputSymbols())));
        }
    }
}

