/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import io.trino.spi.Plugin;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.EvaluateEmptyIntersect;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import org.testng.annotations.Test;

public class TestEvaluateEmptyIntersect
extends BaseRuleTest {
    public TestEvaluateEmptyIntersect() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotApply() {
        this.tester().assertThat((Rule<?>)new EvaluateEmptyIntersect()).on(p -> {
            Symbol output = p.symbol("output");
            Symbol input1 = p.symbol("input1");
            Symbol input2 = p.symbol("input2");
            return p.intersect((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)output, (Object)input1).put((Object)output, (Object)input2).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(1, input1), (Object)p.values(2, input2)));
        }).doesNotFire();
    }

    @Test
    public void testRemoveIntersectWhenSetEmpty() {
        this.tester().assertThat((Rule<?>)new EvaluateEmptyIntersect()).on(p -> {
            Symbol output = p.symbol("output");
            Symbol input1 = p.symbol("input1");
            Symbol input2 = p.symbol("input2");
            Symbol input3 = p.symbol("input3");
            Symbol input4 = p.symbol("input4");
            return p.intersect((ListMultimap<Symbol, Symbol>)ImmutableListMultimap.builder().put((Object)output, (Object)input1).put((Object)output, (Object)input2).put((Object)output, (Object)input3).put((Object)output, (Object)input4).build(), (List<PlanNode>)ImmutableList.of((Object)p.values(1, input1), (Object)p.values(2, input2), (Object)p.values(0, input3), (Object)p.values(3, input4)));
        }).matches(PlanMatchPattern.values("output"));
    }
}

