/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.spi.Plugin;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PushLimitThroughSemiJoin;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.SortItem;
import java.util.List;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestPushLimitThroughSemiJoin
extends BaseRuleTest {
    public TestPushLimitThroughSemiJoin() {
        super(new Plugin[0]);
    }

    @Test
    public void test() {
        this.tester().assertThat((Rule<?>)new PushLimitThroughSemiJoin()).on(p -> p.limit(1L, TestPushLimitThroughSemiJoin.buildSemiJoin(p))).matches(PlanMatchPattern.semiJoin("leftKey", "rightKey", "match", PlanMatchPattern.limit(1L, PlanMatchPattern.values("leftKey")), PlanMatchPattern.values("rightKey")));
    }

    @Test
    public void testPushLimitWithTies() {
        this.tester().assertThat((Rule<?>)new PushLimitThroughSemiJoin()).on(p -> p.limit(1L, (List<Symbol>)ImmutableList.of((Object)p.symbol("leftKey")), TestPushLimitThroughSemiJoin.buildSemiJoin(p))).matches(PlanMatchPattern.semiJoin("leftKey", "rightKey", "match", PlanMatchPattern.limit(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("leftKey", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.values("leftKey")), PlanMatchPattern.values("rightKey")));
    }

    @Test
    public void testPushLimitWithPreSortedInputs() {
        this.tester().assertThat((Rule<?>)new PushLimitThroughSemiJoin()).on(p -> p.limit(1L, false, (List<Symbol>)ImmutableList.of((Object)p.symbol("leftKey")), TestPushLimitThroughSemiJoin.buildSemiJoin(p))).matches(PlanMatchPattern.semiJoin("leftKey", "rightKey", "match", PlanMatchPattern.limit(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), false, (List<String>)ImmutableList.of((Object)"leftKey"), PlanMatchPattern.values("leftKey")), PlanMatchPattern.values("rightKey")));
    }

    @Test
    public void testDoesNotFire() {
        this.tester().assertThat((Rule<?>)new PushLimitThroughSemiJoin()).on(p -> p.semiJoin(p.symbol("leftKey"), p.symbol("rightKey"), p.symbol("output"), Optional.empty(), Optional.empty(), (PlanNode)p.values(p.symbol("leftKey")), (PlanNode)p.limit(1L, (PlanNode)p.values(p.symbol("rightKey"))))).doesNotFire();
        this.tester().assertThat((Rule<?>)new PushLimitThroughSemiJoin()).on(p -> p.limit(1L, (List<Symbol>)ImmutableList.of((Object)p.symbol("match")), TestPushLimitThroughSemiJoin.buildSemiJoin(p))).doesNotFire();
        this.tester().assertThat((Rule<?>)new PushLimitThroughSemiJoin()).on(p -> p.limit(1L, false, (List<Symbol>)ImmutableList.of((Object)p.symbol("match")), TestPushLimitThroughSemiJoin.buildSemiJoin(p))).doesNotFire();
    }

    private static PlanNode buildSemiJoin(PlanBuilder p) {
        Symbol leftKey = p.symbol("leftKey");
        Symbol rightKey = p.symbol("rightKey");
        return p.semiJoin(leftKey, rightKey, p.symbol("match"), Optional.empty(), Optional.empty(), (PlanNode)p.values(leftKey), (PlanNode)p.values(rightKey));
    }
}

