/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.type.AbstractTestType;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.testng.Assert;

public class TestIntegerType
extends AbstractTestType {
    public TestIntegerType() {
        super((Type)IntegerType.INTEGER, Integer.class, TestIntegerType.createTestBlock());
    }

    public static Block createTestBlock() {
        BlockBuilder blockBuilder = IntegerType.INTEGER.createBlockBuilder(null, 15);
        IntegerType.INTEGER.writeLong(blockBuilder, 1111L);
        IntegerType.INTEGER.writeLong(blockBuilder, 1111L);
        IntegerType.INTEGER.writeLong(blockBuilder, 1111L);
        IntegerType.INTEGER.writeLong(blockBuilder, 2222L);
        IntegerType.INTEGER.writeLong(blockBuilder, 2222L);
        IntegerType.INTEGER.writeLong(blockBuilder, 2222L);
        IntegerType.INTEGER.writeLong(blockBuilder, 2222L);
        IntegerType.INTEGER.writeLong(blockBuilder, 2222L);
        IntegerType.INTEGER.writeLong(blockBuilder, 3333L);
        IntegerType.INTEGER.writeLong(blockBuilder, 3333L);
        IntegerType.INTEGER.writeLong(blockBuilder, 4444L);
        return blockBuilder.build();
    }

    @Override
    protected Object getGreaterValue(Object value) {
        return (Long)value + 1L;
    }

    @Override
    public void testRange() {
        Type.Range range = (Type.Range)this.type.getRange().orElseThrow();
        Assert.assertEquals((Object)range.getMin(), (Object)Integer.MIN_VALUE);
        Assert.assertEquals((Object)range.getMax(), (Object)Integer.MAX_VALUE);
    }

    @Override
    public void testPreviousValue() {
        long minValue = Integer.MIN_VALUE;
        long maxValue = Integer.MAX_VALUE;
        Assertions.assertThat((Optional)this.type.getPreviousValue((Object)minValue)).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)this.type.getPreviousValue((Object)(minValue + 1L))).isEqualTo(Optional.of(minValue));
        Assertions.assertThat((Optional)this.type.getPreviousValue(this.getSampleValue())).isEqualTo(Optional.of(1110L));
        Assertions.assertThat((Optional)this.type.getPreviousValue((Object)(maxValue - 1L))).isEqualTo(Optional.of(maxValue - 2L));
        Assertions.assertThat((Optional)this.type.getPreviousValue((Object)maxValue)).isEqualTo(Optional.of(maxValue - 1L));
    }

    @Override
    public void testNextValue() {
        long minValue = Integer.MIN_VALUE;
        long maxValue = Integer.MAX_VALUE;
        Assertions.assertThat((Optional)this.type.getNextValue((Object)minValue)).isEqualTo(Optional.of(minValue + 1L));
        Assertions.assertThat((Optional)this.type.getNextValue((Object)(minValue + 1L))).isEqualTo(Optional.of(minValue + 2L));
        Assertions.assertThat((Optional)this.type.getNextValue(this.getSampleValue())).isEqualTo(Optional.of(1112L));
        Assertions.assertThat((Optional)this.type.getNextValue((Object)(maxValue - 1L))).isEqualTo(Optional.of(maxValue));
        Assertions.assertThat((Optional)this.type.getNextValue((Object)maxValue)).isEqualTo(Optional.empty());
    }
}

