/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.type.SqlIntervalDayTime;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.testng.Assert;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestIntervalDayTime {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testObject() {
        Assert.assertEquals((Object)new SqlIntervalDayTime(12, 10, 45, 32, 123), (Object)new SqlIntervalDayTime(1075532123L));
        Assert.assertEquals((Object)new SqlIntervalDayTime(-12, -10, -45, -32, -123), (Object)new SqlIntervalDayTime(-1075532123L));
        Assert.assertEquals((Object)new SqlIntervalDayTime(30, 0, 0, 0, 0), (Object)new SqlIntervalDayTime(TimeUnit.DAYS.toMillis(30L)));
        Assert.assertEquals((Object)new SqlIntervalDayTime(-30, 0, 0, 0, 0), (Object)new SqlIntervalDayTime(-TimeUnit.DAYS.toMillis(30L)));
        Assert.assertEquals((Object)new SqlIntervalDayTime(90, 0, 0, 0, 0), (Object)new SqlIntervalDayTime(TimeUnit.DAYS.toMillis(90L)));
        Assert.assertEquals((Object)new SqlIntervalDayTime(-90, 0, 0, 0, 0), (Object)new SqlIntervalDayTime(-TimeUnit.DAYS.toMillis(90L)));
    }

    @Test
    public void testAdd() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "INTERVAL '3' SECOND", "INTERVAL '3' SECOND")))).matches("INTERVAL '6' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "INTERVAL '6' DAY", "INTERVAL '6' DAY")))).matches("INTERVAL '12' DAY");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "INTERVAL '3' SECOND", "INTERVAL '6' DAY")))).matches("INTERVAL '6 00:00:03.000' DAY TO SECOND");
    }

    @Test
    public void testSubtract() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "INTERVAL '6' SECOND", "INTERVAL '3' SECOND")))).matches("INTERVAL '3' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "INTERVAL '9' DAY", "INTERVAL '6' DAY")))).matches("INTERVAL '3' DAY");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "INTERVAL '3' SECOND", "INTERVAL '6' DAY")))).matches("INTERVAL '-5 23:59:57.000' DAY TO SECOND");
    }

    @Test
    public void testMultiply() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "INTERVAL '6' SECOND", "2")))).matches("INTERVAL '12' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "2", "INTERVAL '6' SECOND")))).matches("INTERVAL '12' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "INTERVAL '1' SECOND", "2.5")))).matches("INTERVAL '2.5' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "2.5", "INTERVAL '1' SECOND")))).matches("INTERVAL '2.5' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "INTERVAL '6' DAY", "2")))).matches("INTERVAL '12' DAY");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "2", "INTERVAL '6' DAY")))).matches("INTERVAL '12' DAY");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "INTERVAL '1' DAY", "2.5")))).matches("INTERVAL '2 12:00:00.000' DAY TO SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.MULTIPLY, "2.5", "INTERVAL '1' DAY")))).matches("INTERVAL '2 12:00:00.000' DAY TO SECOND");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.operator(OperatorType.MULTIPLY, "INTERVAL '6' SECOND", "nan()").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.operator(OperatorType.MULTIPLY, "nan()", "INTERVAL '6' DAY").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
    }

    @Test
    public void testDivide() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "INTERVAL '3' SECOND", "2")))).matches("INTERVAL '1.5' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "INTERVAL '6' SECOND", "2.5")))).matches("INTERVAL '2.4' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "INTERVAL '3' DAY", "2")))).matches("INTERVAL '1 12:00:00.000' DAY TO SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.DIVIDE, "INTERVAL '4' DAY", "2.5")))).matches("INTERVAL '1 14:24:00.000' DAY TO SECOND");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.operator(OperatorType.DIVIDE, "INTERVAL '6' SECOND", "nan()").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.operator(OperatorType.DIVIDE, "INTERVAL '6' DAY", "nan()").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.operator(OperatorType.DIVIDE, "INTERVAL '6' SECOND", "0E0").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.operator(OperatorType.DIVIDE, "INTERVAL '6' DAY", "0").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT});
    }

    @Test
    public void testNegation() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.NEGATION, "INTERVAL '3' SECOND")))).matches("INTERVAL '-3' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.NEGATION, "INTERVAL '6' DAY")))).matches("INTERVAL '-6' DAY");
    }

    @Test
    public void testEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "INTERVAL '3' SECOND", "INTERVAL '3' SECOND")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "INTERVAL '6' DAY", "INTERVAL '6' DAY")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "INTERVAL '3' SECOND", "INTERVAL '4' SECOND")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "INTERVAL '7' DAY", "INTERVAL '6' DAY")))).isEqualTo(false);
    }

    @Test
    public void testNotEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "INTERVAL '3' SECOND").binding("b", "INTERVAL '4' SECOND")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "INTERVAL '6' DAY").binding("b", "INTERVAL '7' DAY")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "INTERVAL '3' SECOND").binding("b", "INTERVAL '3' SECOND")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "INTERVAL '6' DAY").binding("b", "INTERVAL '6' DAY")))).isEqualTo(false);
    }

    @Test
    public void testLessThan() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "INTERVAL '3' SECOND", "INTERVAL '4' SECOND")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "INTERVAL '6' DAY", "INTERVAL '7' DAY")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "INTERVAL '3' SECOND", "INTERVAL '3' SECOND")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "INTERVAL '3' SECOND", "INTERVAL '2' SECOND")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "INTERVAL '6' DAY", "INTERVAL '6' DAY")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "INTERVAL '6' DAY", "INTERVAL '5' DAY")))).isEqualTo(false);
    }

    @Test
    public void testLessThanOrEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "INTERVAL '3' SECOND", "INTERVAL '4' SECOND")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "INTERVAL '3' SECOND", "INTERVAL '3' SECOND")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "INTERVAL '6' DAY", "INTERVAL '6' DAY")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "INTERVAL '6' DAY", "INTERVAL '7' DAY")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "INTERVAL '3' SECOND", "INTERVAL '2' SECOND")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "INTERVAL '6' DAY", "INTERVAL '5' DAY")))).isEqualTo(false);
    }

    @Test
    public void testGreaterThan() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "INTERVAL '3' SECOND").binding("b", "INTERVAL '2' SECOND")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "INTERVAL '6' DAY").binding("b", "INTERVAL '5' DAY")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "INTERVAL '3' SECOND").binding("b", "INTERVAL '3' SECOND")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "INTERVAL '3' SECOND").binding("b", "INTERVAL '4' SECOND")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "INTERVAL '6' DAY").binding("b", "INTERVAL '6' DAY")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "INTERVAL '6' DAY").binding("b", "INTERVAL '7' DAY")))).isEqualTo(false);
    }

    @Test
    public void testGreaterThanOrEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "INTERVAL '3' SECOND").binding("b", "INTERVAL '2' SECOND")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "INTERVAL '3' SECOND").binding("b", "INTERVAL '3' SECOND")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "INTERVAL '6' DAY").binding("b", "INTERVAL '5' DAY")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "INTERVAL '6' DAY").binding("b", "INTERVAL '6' DAY")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "INTERVAL '3' SECOND").binding("b", "INTERVAL '4' SECOND")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "INTERVAL '6' DAY").binding("b", "INTERVAL '7' DAY")))).isEqualTo(false);
    }

    @Test
    public void testBetween() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "INTERVAL '3' SECOND").binding("low", "INTERVAL '2' SECOND").binding("high", "INTERVAL '4' SECOND")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "INTERVAL '3' SECOND").binding("low", "INTERVAL '3' SECOND").binding("high", "INTERVAL '4' SECOND")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "INTERVAL '3' SECOND").binding("low", "INTERVAL '2' SECOND").binding("high", "INTERVAL '3' SECOND")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "INTERVAL '3' SECOND").binding("low", "INTERVAL '3' SECOND").binding("high", "INTERVAL '3' SECOND")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "INTERVAL '3' SECOND").binding("low", "INTERVAL '4' SECOND").binding("high", "INTERVAL '5' SECOND")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "INTERVAL '3' SECOND").binding("low", "INTERVAL '1' SECOND").binding("high", "INTERVAL '2' SECOND")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "INTERVAL '3' SECOND").binding("low", "INTERVAL '4' SECOND").binding("high", "INTERVAL '2' SECOND")))).isEqualTo(false);
    }

    @Test
    public void testCastToVarchar() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS varchar)").binding("a", "INTERVAL '12 10:45:32.123' DAY TO SECOND")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("12 10:45:32.123");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS varchar)").binding("a", "INTERVAL '12 10:45:32.123' DAY TO SECOND")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("12 10:45:32.123");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS varchar)").binding("a", "INTERVAL '12 10:45:32.12' DAY TO SECOND")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("12 10:45:32.120");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS varchar)").binding("a", "INTERVAL '12 10:45:32' DAY TO SECOND")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("12 10:45:32.000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS varchar)").binding("a", "INTERVAL '12 10:45' DAY TO SECOND")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("12 10:45:00.000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS varchar)").binding("a", "INTERVAL '12 10' DAY TO SECOND")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("12 10:00:00.000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS varchar)").binding("a", "INTERVAL '12' DAY TO SECOND")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("12 00:00:00.000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS varchar)").binding("a", "INTERVAL '12 10:45' DAY TO MINUTE")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("12 10:45:00.000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS varchar)").binding("a", "INTERVAL '12 10' DAY TO MINUTE")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("12 10:00:00.000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS varchar)").binding("a", "INTERVAL '12' DAY TO MINUTE")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("12 00:00:00.000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS varchar)").binding("a", "INTERVAL '12 10' DAY TO HOUR")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("12 10:00:00.000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS varchar)").binding("a", "INTERVAL '12' DAY TO HOUR")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("12 00:00:00.000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS varchar)").binding("a", "INTERVAL '12' DAY")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("12 00:00:00.000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS varchar)").binding("a", "INTERVAL '10:45:32.123' HOUR TO SECOND")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("0 10:45:32.123");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS varchar)").binding("a", "INTERVAL '10:45:32.12' HOUR TO SECOND")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("0 10:45:32.120");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS varchar)").binding("a", "INTERVAL '10:45:32' HOUR TO SECOND")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("0 10:45:32.000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS varchar)").binding("a", "INTERVAL '10:45' HOUR TO SECOND")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("0 10:45:00.000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS varchar)").binding("a", "INTERVAL '10' HOUR TO SECOND")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("0 10:00:00.000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS varchar)").binding("a", "INTERVAL '10:45' HOUR TO MINUTE")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("0 10:45:00.000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS varchar)").binding("a", "INTERVAL '10' HOUR TO MINUTE")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("0 10:00:00.000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS varchar)").binding("a", "INTERVAL '10' HOUR")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("0 10:00:00.000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS varchar)").binding("a", "INTERVAL '45:32.123' MINUTE TO SECOND")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("0 00:45:32.123");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS varchar)").binding("a", "INTERVAL '45:32.12' MINUTE TO SECOND")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("0 00:45:32.120");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS varchar)").binding("a", "INTERVAL '45:32' MINUTE TO SECOND")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("0 00:45:32.000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS varchar)").binding("a", "INTERVAL '45' MINUTE TO SECOND")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("0 00:45:00.000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS varchar)").binding("a", "INTERVAL '45' MINUTE")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("0 00:45:00.000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS varchar)").binding("a", "INTERVAL '32.123' SECOND")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("0 00:00:32.123");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS varchar)").binding("a", "INTERVAL '32.12' SECOND")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("0 00:00:32.120");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(a AS varchar)").binding("a", "INTERVAL '32' SECOND")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("0 00:00:32.000");
    }

    @Test
    public void testIndeterminate() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "CAST(NULL AS INTERVAL DAY TO SECOND)")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "INTERVAL '45' MINUTE TO SECOND")))).isEqualTo(false);
    }
}

