/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.json.ir.IrAbsMethod;
import io.trino.json.ir.IrArithmeticBinary;
import io.trino.json.ir.IrArithmeticUnary;
import io.trino.json.ir.IrArrayAccessor;
import io.trino.json.ir.IrCeilingMethod;
import io.trino.json.ir.IrConstantJsonSequence;
import io.trino.json.ir.IrContextVariable;
import io.trino.json.ir.IrDatetimeMethod;
import io.trino.json.ir.IrDescendantMemberAccessor;
import io.trino.json.ir.IrDoubleMethod;
import io.trino.json.ir.IrFloorMethod;
import io.trino.json.ir.IrJsonNull;
import io.trino.json.ir.IrJsonPath;
import io.trino.json.ir.IrKeyValueMethod;
import io.trino.json.ir.IrLastIndexVariable;
import io.trino.json.ir.IrLiteral;
import io.trino.json.ir.IrMemberAccessor;
import io.trino.json.ir.IrNamedJsonVariable;
import io.trino.json.ir.IrNamedValueVariable;
import io.trino.json.ir.IrPathNode;
import io.trino.json.ir.IrSizeMethod;
import io.trino.json.ir.IrTypeMethod;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.block.TestingBlockEncodingSerde;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.type.InternalTypeManager;
import io.trino.type.JsonPath2016Type;
import io.trino.type.TypeDeserializer;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.RecursiveComparisonAssert;
import org.assertj.core.api.recursive.comparison.RecursiveComparisonConfiguration;
import org.testng.annotations.Test;

public class TestJsonPath2016TypeSerialization {
    private static final Type JSON_PATH_2016 = new JsonPath2016Type(new TypeDeserializer(InternalTypeManager.TESTING_TYPE_MANAGER), (BlockEncodingSerde)new TestingBlockEncodingSerde());
    private static final RecursiveComparisonConfiguration COMPARISON_CONFIGURATION = RecursiveComparisonConfiguration.builder().withStrictTypeChecking(true).build();

    @Test
    public void testJsonPathMode() {
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrJsonNull()));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(false, (IrPathNode)new IrJsonNull()));
    }

    @Test
    public void testLiterals() {
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrLiteral((Type)DecimalType.createDecimalType((int)2, (int)1), (Object)1L)));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrLiteral((Type)DoubleType.DOUBLE, (Object)1.0)));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrLiteral((Type)IntegerType.INTEGER, (Object)1L)));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrLiteral((Type)BigintType.BIGINT, (Object)1000000000000L)));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrLiteral((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"some_text"))));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrLiteral((Type)BooleanType.BOOLEAN, (Object)false)));
    }

    @Test
    public void testContextVariable() {
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrContextVariable(Optional.empty())));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrContextVariable(Optional.of(DoubleType.DOUBLE))));
    }

    @Test
    public void testNamedVariables() {
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrNamedJsonVariable(5, Optional.empty())));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrNamedJsonVariable(5, Optional.of(DoubleType.DOUBLE))));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrNamedValueVariable(5, Optional.of(DoubleType.DOUBLE))));
    }

    @Test
    public void testMethods() {
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrAbsMethod((IrPathNode)new IrLiteral((Type)DoubleType.DOUBLE, (Object)1.0), Optional.of(DoubleType.DOUBLE))));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrCeilingMethod((IrPathNode)new IrLiteral((Type)DoubleType.DOUBLE, (Object)1.0), Optional.of(DoubleType.DOUBLE))));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrDatetimeMethod((IrPathNode)new IrLiteral((Type)BigintType.BIGINT, (Object)1L), Optional.of("some_time_format"), Optional.of(TimeType.createTimeType((int)3)))));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrDoubleMethod((IrPathNode)new IrLiteral((Type)BigintType.BIGINT, (Object)1L), Optional.of(DoubleType.DOUBLE))));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrFloorMethod((IrPathNode)new IrLiteral((Type)DoubleType.DOUBLE, (Object)1.0), Optional.of(DoubleType.DOUBLE))));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrKeyValueMethod((IrPathNode)new IrJsonNull())));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrSizeMethod((IrPathNode)new IrJsonNull(), Optional.of(IntegerType.INTEGER))));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrTypeMethod((IrPathNode)new IrJsonNull(), Optional.of(VarcharType.createVarcharType((int)7)))));
    }

    @Test
    public void testArrayAccessor() {
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrArrayAccessor((IrPathNode)new IrJsonNull(), (List)ImmutableList.of(), Optional.empty())));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrArrayAccessor((IrPathNode)new IrJsonNull(), (List)ImmutableList.of((Object)new IrArrayAccessor.Subscript((IrPathNode)new IrLiteral((Type)IntegerType.INTEGER, (Object)0L), Optional.of(new IrLiteral((Type)IntegerType.INTEGER, (Object)1L))), (Object)new IrArrayAccessor.Subscript((IrPathNode)new IrLiteral((Type)IntegerType.INTEGER, (Object)3L), Optional.of(new IrLiteral((Type)IntegerType.INTEGER, (Object)5L))), (Object)new IrArrayAccessor.Subscript((IrPathNode)new IrLiteral((Type)IntegerType.INTEGER, (Object)7L), Optional.empty())), Optional.of(VarcharType.VARCHAR))));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrArrayAccessor((IrPathNode)new IrJsonNull(), (List)ImmutableList.of((Object)new IrArrayAccessor.Subscript((IrPathNode)new IrLastIndexVariable(Optional.of(IntegerType.INTEGER)), Optional.empty())), Optional.empty())));
    }

    @Test
    public void testMemberAccessor() {
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrMemberAccessor((IrPathNode)new IrJsonNull(), Optional.empty(), Optional.empty())));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrMemberAccessor((IrPathNode)new IrJsonNull(), Optional.of("some_key"), Optional.of(BigintType.BIGINT))));
    }

    @Test
    public void testDescendantMemberAccessor() {
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrDescendantMemberAccessor((IrPathNode)new IrJsonNull(), "some_key", Optional.empty())));
    }

    @Test
    public void testArithmeticBinary() {
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrArithmeticBinary(IrArithmeticBinary.Operator.ADD, (IrPathNode)new IrJsonNull(), (IrPathNode)new IrJsonNull(), Optional.empty())));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrArithmeticBinary(IrArithmeticBinary.Operator.ADD, (IrPathNode)new IrLiteral((Type)IntegerType.INTEGER, (Object)1L), (IrPathNode)new IrLiteral((Type)BigintType.BIGINT, (Object)2L), Optional.of(BigintType.BIGINT))));
    }

    @Test
    public void testArithmeticUnary() {
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrArithmeticUnary(IrArithmeticUnary.Sign.PLUS, (IrPathNode)new IrJsonNull(), Optional.empty())));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrArithmeticUnary(IrArithmeticUnary.Sign.MINUS, (IrPathNode)new IrJsonNull(), Optional.empty())));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrArithmeticUnary(IrArithmeticUnary.Sign.MINUS, (IrPathNode)new IrLiteral((Type)IntegerType.INTEGER, (Object)1L), Optional.of(IntegerType.INTEGER))));
    }

    @Test
    public void testConstantJsonSequence() {
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)IrConstantJsonSequence.EMPTY_SEQUENCE));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)IrConstantJsonSequence.singletonSequence((JsonNode)NullNode.getInstance(), Optional.empty())));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)IrConstantJsonSequence.singletonSequence((JsonNode)BooleanNode.TRUE, Optional.of(BooleanType.BOOLEAN))));
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrConstantJsonSequence((List)ImmutableList.of((Object)IntNode.valueOf((int)1), (Object)IntNode.valueOf((int)2), (Object)IntNode.valueOf((int)3)), Optional.of(IntegerType.INTEGER))));
    }

    @Test
    public void testNestedStructure() {
        TestJsonPath2016TypeSerialization.assertJsonRoundTrip(new IrJsonPath(true, (IrPathNode)new IrTypeMethod((IrPathNode)new IrArithmeticBinary(IrArithmeticBinary.Operator.MULTIPLY, (IrPathNode)new IrArithmeticUnary(IrArithmeticUnary.Sign.MINUS, (IrPathNode)new IrAbsMethod((IrPathNode)new IrFloorMethod((IrPathNode)new IrLiteral((Type)IntegerType.INTEGER, (Object)1L), Optional.of(IntegerType.INTEGER)), Optional.of(IntegerType.INTEGER)), Optional.of(IntegerType.INTEGER)), (IrPathNode)new IrCeilingMethod((IrPathNode)new IrMemberAccessor((IrPathNode)new IrContextVariable(Optional.empty()), Optional.of("some_key"), Optional.of(BigintType.BIGINT)), Optional.of(BigintType.BIGINT)), Optional.of(BigintType.BIGINT)), Optional.of(VarcharType.createVarcharType((int)7)))));
    }

    private static void assertJsonRoundTrip(IrJsonPath object) {
        BlockBuilder blockBuilder = JSON_PATH_2016.createBlockBuilder(null, 1);
        JSON_PATH_2016.writeObject(blockBuilder, (Object)object);
        Block serialized = blockBuilder.build();
        Object deserialized = JSON_PATH_2016.getObject(serialized, 0);
        ((RecursiveComparisonAssert)Assertions.assertThat(() -> new RecursiveComparisonAssert(deserialized, COMPARISON_CONFIGURATION))).isEqualTo((Object)object);
    }
}

