/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.SqlTimestamp;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.type.AbstractTestType;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestLongTimestampType
extends AbstractTestType {
    public TestLongTimestampType() {
        super((Type)TimestampType.TIMESTAMP_NANOS, SqlTimestamp.class, TestLongTimestampType.createTestBlock());
    }

    public static Block createTestBlock() {
        BlockBuilder blockBuilder = TimestampType.TIMESTAMP_NANOS.createBlockBuilder(null, 15);
        TimestampType.TIMESTAMP_NANOS.writeObject(blockBuilder, (Object)new LongTimestamp(1111123L, 123000));
        TimestampType.TIMESTAMP_NANOS.writeObject(blockBuilder, (Object)new LongTimestamp(1111123L, 123000));
        TimestampType.TIMESTAMP_NANOS.writeObject(blockBuilder, (Object)new LongTimestamp(1111123L, 123000));
        TimestampType.TIMESTAMP_NANOS.writeObject(blockBuilder, (Object)new LongTimestamp(2222123L, 123000));
        TimestampType.TIMESTAMP_NANOS.writeObject(blockBuilder, (Object)new LongTimestamp(2222123L, 123000));
        TimestampType.TIMESTAMP_NANOS.writeObject(blockBuilder, (Object)new LongTimestamp(2222123L, 123000));
        TimestampType.TIMESTAMP_NANOS.writeObject(blockBuilder, (Object)new LongTimestamp(2222123L, 123000));
        TimestampType.TIMESTAMP_NANOS.writeObject(blockBuilder, (Object)new LongTimestamp(2222123L, 123000));
        TimestampType.TIMESTAMP_NANOS.writeObject(blockBuilder, (Object)new LongTimestamp(3333123L, 123000));
        TimestampType.TIMESTAMP_NANOS.writeObject(blockBuilder, (Object)new LongTimestamp(3333123L, 123000));
        TimestampType.TIMESTAMP_NANOS.writeObject(blockBuilder, (Object)new LongTimestamp(4444123L, 123000));
        return blockBuilder.build();
    }

    @Override
    protected Object getGreaterValue(Object value) {
        LongTimestamp timestamp = (LongTimestamp)value;
        return new LongTimestamp(timestamp.getEpochMicros() + 1L, 0);
    }

    @Override
    public void testRange() {
        Type.Range range = (Type.Range)this.type.getRange().orElseThrow();
        Assert.assertEquals((Object)range.getMin(), (Object)new LongTimestamp(Long.MIN_VALUE, 0));
        Assert.assertEquals((Object)range.getMax(), (Object)new LongTimestamp(Long.MAX_VALUE, 999000));
    }

    @Test(dataProvider="testRangeEveryPrecisionDataProvider")
    public void testRangeEveryPrecision(int precision, LongTimestamp expectedMax) {
        Type.Range range = (Type.Range)TimestampType.createTimestampType((int)precision).getRange().orElseThrow();
        Assert.assertEquals((Object)range.getMin(), (Object)new LongTimestamp(Long.MIN_VALUE, 0));
        Assert.assertEquals((Object)range.getMax(), (Object)expectedMax);
    }

    @DataProvider
    public static Object[][] testRangeEveryPrecisionDataProvider() {
        return new Object[][]{{7, new LongTimestamp(Long.MAX_VALUE, 900000)}, {8, new LongTimestamp(Long.MAX_VALUE, 990000)}, {9, new LongTimestamp(Long.MAX_VALUE, 999000)}, {10, new LongTimestamp(Long.MAX_VALUE, 999900)}, {11, new LongTimestamp(Long.MAX_VALUE, 999990)}, {12, new LongTimestamp(Long.MAX_VALUE, 999999)}};
    }
}

