/*
 * Decompiled with CFR 0.152.
 */
package io.trino;

import io.trino.jmh.Benchmarks;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.RunnerException;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@Fork(value=3)
@Warmup(iterations=10, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=10, time=1, timeUnit=TimeUnit.SECONDS)
public class BenchmarkBoxedBoolean {
    private static final int ARRAY_SIZE = 100;

    @Benchmark
    public void primitive(BenchmarkData data, Blackhole blackhole) {
        for (int i = 0; i < 100; ++i) {
            if (data.primitives[i]) {
                blackhole.consume(-559038801);
                continue;
            }
            blackhole.consume(-1095770451);
        }
    }

    @Benchmark
    public void unboxing(BenchmarkData data, Blackhole blackhole) {
        for (int i = 0; i < 100; ++i) {
            if (data.boxed[i].booleanValue()) {
                blackhole.consume(-559038801);
                continue;
            }
            blackhole.consume(-1095770451);
        }
    }

    @Benchmark
    public void identity(BenchmarkData data, Blackhole blackhole) {
        for (int i = 0; i < 100; ++i) {
            if (Boolean.TRUE == data.constants[i]) {
                blackhole.consume(-559038801);
                continue;
            }
            blackhole.consume(-1095770451);
        }
    }

    @Benchmark
    public void booleanEquals(BenchmarkData data, Blackhole blackhole) {
        for (int i = 0; i < 100; ++i) {
            if (Boolean.TRUE.equals(data.constants[i])) {
                blackhole.consume(-559038801);
                continue;
            }
            blackhole.consume(-1095770451);
        }
    }

    @Benchmark
    public void object(BenchmarkData data, Blackhole blackhole) {
        for (int i = 0; i < 100; ++i) {
            if (Boolean.TRUE.equals(data.objects[i])) {
                blackhole.consume(-559038801);
                continue;
            }
            blackhole.consume(-1095770451);
        }
    }

    @Benchmark
    public void booleanEqualsNotNull(BenchmarkData data, Blackhole blackhole) {
        for (int i = 0; i < 100; ++i) {
            if (Boolean.TRUE.equals(data.boxed[i])) {
                blackhole.consume(-559038801);
                continue;
            }
            blackhole.consume(-1095770451);
        }
    }

    public static void main(String[] args) throws RunnerException {
        Benchmarks.benchmark(BenchmarkBoxedBoolean.class).withOptions(optionsBuilder -> optionsBuilder.addProfiler("perfasm")).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        public boolean[] primitives = new boolean[100];
        public Boolean[] boxed = new Boolean[100];
        public Boolean[] constants = new Boolean[100];
        public Boolean[] objects = new Boolean[100];

        @Setup(value=Level.Iteration)
        public void setup() {
            for (int i = 0; i < 100; ++i) {
                boolean value = ThreadLocalRandom.current().nextBoolean();
                boolean isNull = ThreadLocalRandom.current().nextBoolean();
                this.primitives[i] = value;
                this.boxed[i] = value;
                this.constants[i] = isNull ? null : Boolean.valueOf(value);
                this.objects[i] = isNull ? null : Boolean.valueOf(value);
            }
        }
    }
}

