/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.sql.planner.OptimizerConfig;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestOptimizerConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((OptimizerConfig)ConfigAssertions.recordDefaults(OptimizerConfig.class)).setCpuCostWeight(75.0).setMemoryCostWeight(10.0).setNetworkCostWeight(15.0).setJoinMaxBroadcastTableSize(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setJoinDistributionType(OptimizerConfig.JoinDistributionType.AUTOMATIC).setJoinMultiClauseIndependenceFactor(0.25).setJoinReorderingStrategy(OptimizerConfig.JoinReorderingStrategy.AUTOMATIC).setMaxReorderedJoins(9).setColocatedJoinsEnabled(true).setSpatialJoinsEnabled(true).setUsePreferredWritePartitioning(true).setEnableStatsCalculator(true).setStatisticsPrecalculationForPushdownEnabled(true).setCollectPlanStatisticsForAllQueries(false).setIgnoreStatsCalculatorFailures(true).setDefaultFilterFactorEnabled(false).setFilterConjunctionIndependenceFactor(0.75).setNonEstimatablePredicateApproximationEnabled(true).setOptimizeMetadataQueries(false).setOptimizeHashGeneration(true).setPushTableWriteThroughUnion(true).setDictionaryAggregation(false).setOptimizeMixedDistinctAggregations(false).setIterativeOptimizerTimeout(new Duration(3.0, TimeUnit.MINUTES)).setEnableForcedExchangeBelowGroupId(true).setEnableIntermediateAggregations(false).setPushAggregationThroughOuterJoin(true).setPushPartialAggregationThroughJoin(false).setPreAggregateCaseAggregationsEnabled(true).setMarkDistinctStrategy(null).setPreferPartialAggregation(true).setOptimizeTopNRanking(true).setDistributedSortEnabled(true).setSkipRedundantSort(true).setComplexExpressionPushdownEnabled(true).setPredicatePushdownUseTableProperties(true).setIgnoreDownstreamPreferences(false).setRewriteFilteringSemiJoinToInnerJoin(true).setOptimizeDuplicateInsensitiveJoins(true).setUseLegacyWindowFilterPushdown(false).setUseTableScanNodePartitioning(true).setTableScanNodePartitioningMinBucketToTaskRatio(0.5).setMergeProjectWithValues(true).setForceSingleNodeOutput(false).setAdaptivePartialAggregationEnabled(true).setAdaptivePartialAggregationUniqueRowsRatioThreshold(0.8).setJoinPartitionedBuildMinRowCount(1000000L).setMinInputSizePerTask(DataSize.of((long)5L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setMinInputRowsPerTask(10000000L).setUseExactPartitioning(false).setUseCostBasedPartitioning(true));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"cpu-cost-weight", (Object)"0.4").put((Object)"memory-cost-weight", (Object)"0.3").put((Object)"network-cost-weight", (Object)"0.2").put((Object)"enable-stats-calculator", (Object)"false").put((Object)"statistics-precalculation-for-pushdown.enabled", (Object)"false").put((Object)"collect-plan-statistics-for-all-queries", (Object)"true").put((Object)"optimizer.ignore-stats-calculator-failures", (Object)"false").put((Object)"optimizer.default-filter-factor-enabled", (Object)"true").put((Object)"optimizer.filter-conjunction-independence-factor", (Object)"1.0").put((Object)"optimizer.non-estimatable-predicate-approximation.enabled", (Object)"false").put((Object)"join-distribution-type", (Object)"BROADCAST").put((Object)"join-max-broadcast-table-size", (Object)"42GB").put((Object)"optimizer.join-multi-clause-independence-factor", (Object)"0.75").put((Object)"optimizer.join-reordering-strategy", (Object)"NONE").put((Object)"optimizer.max-reordered-joins", (Object)"5").put((Object)"iterative-optimizer-timeout", (Object)"10s").put((Object)"enable-forced-exchange-below-group-id", (Object)"false").put((Object)"colocated-joins-enabled", (Object)"false").put((Object)"spatial-joins-enabled", (Object)"false").put((Object)"distributed-sort", (Object)"false").put((Object)"use-preferred-write-partitioning", (Object)"false").put((Object)"optimizer.optimize-metadata-queries", (Object)"true").put((Object)"optimizer.optimize-hash-generation", (Object)"false").put((Object)"optimizer.optimize-mixed-distinct-aggregations", (Object)"true").put((Object)"optimizer.push-table-write-through-union", (Object)"false").put((Object)"optimizer.dictionary-aggregation", (Object)"true").put((Object)"optimizer.push-aggregation-through-outer-join", (Object)"false").put((Object)"optimizer.push-partial-aggregation-through-join", (Object)"true").put((Object)"optimizer.pre-aggregate-case-aggregations.enabled", (Object)"false").put((Object)"optimizer.enable-intermediate-aggregations", (Object)"true").put((Object)"optimizer.force-single-node-output", (Object)"true").put((Object)"optimizer.mark-distinct-strategy", (Object)"always").put((Object)"optimizer.prefer-partial-aggregation", (Object)"false").put((Object)"optimizer.optimize-top-n-ranking", (Object)"false").put((Object)"optimizer.skip-redundant-sort", (Object)"false").put((Object)"optimizer.complex-expression-pushdown.enabled", (Object)"false").put((Object)"optimizer.predicate-pushdown-use-table-properties", (Object)"false").put((Object)"optimizer.ignore-downstream-preferences", (Object)"true").put((Object)"optimizer.rewrite-filtering-semi-join-to-inner-join", (Object)"false").put((Object)"optimizer.optimize-duplicate-insensitive-joins", (Object)"false").put((Object)"optimizer.use-legacy-window-filter-pushdown", (Object)"true").put((Object)"optimizer.use-table-scan-node-partitioning", (Object)"false").put((Object)"optimizer.table-scan-node-partitioning-min-bucket-to-task-ratio", (Object)"0.0").put((Object)"optimizer.merge-project-with-values", (Object)"false").put((Object)"adaptive-partial-aggregation.enabled", (Object)"false").put((Object)"adaptive-partial-aggregation.unique-rows-ratio-threshold", (Object)"0.99").put((Object)"optimizer.join-partitioned-build-min-row-count", (Object)"1").put((Object)"optimizer.min-input-size-per-task", (Object)"1MB").put((Object)"optimizer.min-input-rows-per-task", (Object)"1000000").put((Object)"optimizer.use-exact-partitioning", (Object)"true").put((Object)"optimizer.use-cost-based-partitioning", (Object)"false").buildOrThrow();
        OptimizerConfig expected = new OptimizerConfig().setCpuCostWeight(0.4).setMemoryCostWeight(0.3).setNetworkCostWeight(0.2).setEnableStatsCalculator(false).setStatisticsPrecalculationForPushdownEnabled(false).setCollectPlanStatisticsForAllQueries(true).setIgnoreStatsCalculatorFailures(false).setJoinDistributionType(OptimizerConfig.JoinDistributionType.BROADCAST).setJoinMaxBroadcastTableSize(DataSize.of((long)42L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setJoinMultiClauseIndependenceFactor(0.75).setJoinReorderingStrategy(OptimizerConfig.JoinReorderingStrategy.NONE).setMaxReorderedJoins(5).setIterativeOptimizerTimeout(new Duration(10.0, TimeUnit.SECONDS)).setEnableForcedExchangeBelowGroupId(false).setColocatedJoinsEnabled(false).setSpatialJoinsEnabled(false).setUsePreferredWritePartitioning(false).setDefaultFilterFactorEnabled(true).setFilterConjunctionIndependenceFactor(1.0).setNonEstimatablePredicateApproximationEnabled(false).setOptimizeMetadataQueries(true).setOptimizeHashGeneration(false).setOptimizeMixedDistinctAggregations(true).setPushTableWriteThroughUnion(false).setDictionaryAggregation(true).setPushAggregationThroughOuterJoin(false).setPushPartialAggregationThroughJoin(true).setPreAggregateCaseAggregationsEnabled(false).setEnableIntermediateAggregations(true).setMarkDistinctStrategy(OptimizerConfig.MarkDistinctStrategy.ALWAYS).setPreferPartialAggregation(false).setOptimizeTopNRanking(false).setDistributedSortEnabled(false).setSkipRedundantSort(false).setComplexExpressionPushdownEnabled(false).setPredicatePushdownUseTableProperties(false).setIgnoreDownstreamPreferences(true).setRewriteFilteringSemiJoinToInnerJoin(false).setOptimizeDuplicateInsensitiveJoins(false).setUseLegacyWindowFilterPushdown(true).setUseTableScanNodePartitioning(false).setTableScanNodePartitioningMinBucketToTaskRatio(0.0).setMergeProjectWithValues(false).setForceSingleNodeOutput(true).setAdaptivePartialAggregationEnabled(false).setAdaptivePartialAggregationUniqueRowsRatioThreshold(0.99).setJoinPartitionedBuildMinRowCount(1L).setMinInputSizePerTask(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setMinInputRowsPerTask(1000000L).setUseExactPartitioning(true).setUseCostBasedPartitioning(false);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

