/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import io.trino.execution.QueryIdGenerator;
import io.trino.spi.QueryId;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestQueryIdGenerator {
    @Test
    public void testCreateNextQueryId() {
        int i;
        TestIdGenerator idGenerator = new TestIdGenerator();
        long millis = TestQueryIdGenerator.epochMillis(2001, 7, 14, 1, 2, 3, 4);
        idGenerator.setNow(millis);
        for (i = 0; i < 100000; ++i) {
            Assert.assertEquals((Object)idGenerator.createNextQueryId(), (Object)new QueryId(String.format("20010714_010203_%05d_%s", i, idGenerator.getCoordinatorId())));
        }
        idGenerator.setNow(millis += 1000L);
        for (i = 0; i < 100000; ++i) {
            Assert.assertEquals((Object)idGenerator.createNextQueryId(), (Object)new QueryId(String.format("20010714_010204_%05d_%s", i, idGenerator.getCoordinatorId())));
        }
        idGenerator.setNow(millis += 1000L);
        for (i = 0; i < 100; ++i) {
            Assert.assertEquals((Object)idGenerator.createNextQueryId(), (Object)new QueryId(String.format("20010714_010205_%05d_%s", i, idGenerator.getCoordinatorId())));
        }
        idGenerator.setNow(millis += 1000L);
        for (i = 100; i < 200; ++i) {
            Assert.assertEquals((Object)idGenerator.createNextQueryId(), (Object)new QueryId(String.format("20010714_010206_%05d_%s", i, idGenerator.getCoordinatorId())));
        }
        millis = TestQueryIdGenerator.epochMillis(2001, 7, 15, 0, 0, 0, 0);
        idGenerator.setNow(millis);
        for (i = 0; i < 90123; ++i) {
            Assert.assertEquals((Object)idGenerator.createNextQueryId(), (Object)new QueryId(String.format("20010715_000000_%05d_%s", i, idGenerator.getCoordinatorId())));
        }
        idGenerator.setNow(millis += 1000L);
        for (i = 0; i < 100000; ++i) {
            Assert.assertEquals((Object)idGenerator.createNextQueryId(), (Object)new QueryId(String.format("20010715_000001_%05d_%s", i, idGenerator.getCoordinatorId())));
        }
    }

    private static long epochMillis(int year, int month, int day, int hour, int minute, int second, int milli) {
        int nano = Math.toIntExact(TimeUnit.MILLISECONDS.toNanos(milli));
        LocalDateTime dateTime = LocalDateTime.of(year, month, day, hour, minute, second, nano);
        return dateTime.toInstant(ZoneOffset.UTC).toEpochMilli();
    }

    private static class TestIdGenerator
    extends QueryIdGenerator {
        private long now;

        private TestIdGenerator() {
        }

        public void setNow(long now) {
            this.now = now;
        }

        protected long nowInMillis() {
            return this.now;
        }
    }
}

