/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.json.JsonCodec;
import io.trino.SessionTestUtils;
import io.trino.client.NodeVersion;
import io.trino.execution.Column;
import io.trino.execution.Input;
import io.trino.execution.QueryInfo;
import io.trino.execution.QueryState;
import io.trino.execution.TestQueryStats;
import io.trino.operator.RetryPolicy;
import io.trino.spi.QueryId;
import io.trino.spi.TrinoWarning;
import io.trino.spi.WarningCode;
import io.trino.spi.resourcegroups.QueryType;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.security.SelectedRole;
import io.trino.sql.planner.plan.PlanFragmentId;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.tracing.TracingJsonCodec;
import io.trino.transaction.TransactionId;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestQueryInfo {
    @Test
    public void testQueryInfoRoundTrip() {
        JsonCodec codec = TracingJsonCodec.tracingJsonCodecFactory().jsonCodec(QueryInfo.class);
        QueryInfo expected = TestQueryInfo.createQueryInfo();
        QueryInfo actual = (QueryInfo)codec.fromJson(codec.toJsonBytes((Object)expected));
        Assert.assertEquals((Object)actual.getQueryId(), (Object)expected.getQueryId());
        Assert.assertEquals((Object)actual.getState(), (Object)expected.getState());
        Assert.assertEquals((boolean)actual.isScheduled(), (boolean)expected.isScheduled());
        Assert.assertEquals((Object)actual.getProgressPercentage(), (Object)expected.getProgressPercentage());
        Assert.assertEquals((Object)actual.getRunningPercentage(), (Object)expected.getRunningPercentage());
        Assert.assertEquals((Object)actual.getSelf(), (Object)expected.getSelf());
        Assert.assertEquals((Collection)actual.getFieldNames(), (Collection)expected.getFieldNames());
        Assert.assertEquals((String)actual.getQuery(), (String)expected.getQuery());
        Assert.assertEquals((Object)actual.getPreparedQuery(), (Object)expected.getPreparedQuery());
        TestQueryStats.assertExpectedQueryStats(actual.getQueryStats());
        Assert.assertEquals((Object)actual.getSetCatalog(), (Object)expected.getSetCatalog());
        Assert.assertEquals((Object)actual.getSetSchema(), (Object)expected.getSetSchema());
        Assert.assertEquals((Object)actual.getSetPath(), (Object)expected.getSetPath());
        Assert.assertEquals((Map)actual.getSetSessionProperties(), (Map)expected.getSetSessionProperties());
        Assert.assertEquals((Set)actual.getResetSessionProperties(), (Set)expected.getResetSessionProperties());
        Assert.assertEquals((Map)actual.getSetRoles(), (Map)expected.getSetRoles());
        Assert.assertEquals((Map)actual.getAddedPreparedStatements(), (Map)expected.getAddedPreparedStatements());
        Assert.assertEquals((Set)actual.getDeallocatedPreparedStatements(), (Set)expected.getDeallocatedPreparedStatements());
        Assert.assertEquals((Object)actual.getStartedTransactionId(), (Object)expected.getStartedTransactionId());
        Assert.assertEquals((boolean)actual.isClearTransactionId(), (boolean)expected.isClearTransactionId());
        Assert.assertEquals((String)actual.getUpdateType(), (String)expected.getUpdateType());
        Assert.assertEquals((Object)actual.getOutputStage(), (Object)expected.getOutputStage());
        Assert.assertEquals((Object)actual.getFailureInfo(), (Object)expected.getFailureInfo());
        Assert.assertEquals((Object)actual.getErrorCode(), (Object)expected.getErrorCode());
        Assert.assertEquals((Collection)actual.getWarnings(), (Collection)expected.getWarnings());
        Assert.assertEquals((Set)actual.getInputs(), (Set)expected.getInputs());
        Assert.assertEquals((Object)actual.getOutput(), (Object)expected.getOutput());
        Assert.assertEquals((Collection)actual.getReferencedTables(), (Collection)expected.getReferencedTables());
        Assert.assertEquals((Collection)actual.getRoutines(), (Collection)expected.getRoutines());
        Assert.assertEquals((boolean)actual.isFinalQueryInfo(), (boolean)expected.isFinalQueryInfo());
        Assert.assertEquals((Object)actual.getResourceGroupId(), (Object)expected.getResourceGroupId());
        Assert.assertEquals((Object)actual.getQueryType(), (Object)expected.getQueryType());
        Assert.assertEquals((Object)actual.getRetryPolicy(), (Object)expected.getRetryPolicy());
    }

    private static QueryInfo createQueryInfo() {
        return new QueryInfo(new QueryId("0"), SessionTestUtils.TEST_SESSION.toSessionRepresentation(), QueryState.FINISHED, URI.create("1"), (List)ImmutableList.of((Object)"number"), "SELECT 1 as number", Optional.of("prepared_query"), TestQueryStats.EXPECTED, Optional.of("set_catalog"), Optional.of("set_schema"), Optional.of("set_path"), (Map)ImmutableMap.of((Object)"set_property", (Object)"set_value"), (Set)ImmutableSet.of((Object)"reset_property"), (Map)ImmutableMap.of((Object)"set_roles", (Object)new SelectedRole(SelectedRole.Type.ROLE, Optional.of("role"))), (Map)ImmutableMap.of((Object)"added_prepared_statement", (Object)"statement"), (Set)ImmutableSet.of((Object)"deallocated_prepared_statement", (Object)"statement"), Optional.of(TransactionId.create()), true, "42", Optional.empty(), null, null, (List)ImmutableList.of((Object)new TrinoWarning(new WarningCode(1, "name"), "message")), (Set)ImmutableSet.of((Object)new Input("catalog", "schema", "talble", Optional.empty(), (List)ImmutableList.of((Object)new Column("name", "type")), new PlanFragmentId("id"), new PlanNodeId("1"))), Optional.empty(), (List)ImmutableList.of(), (List)ImmutableList.of(), true, Optional.of(new ResourceGroupId("groupId")), Optional.of(QueryType.SELECT), RetryPolicy.TASK, false, new NodeVersion("test"));
    }
}

