/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.concurrent.Threads;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.client.NodeVersion;
import io.trino.connector.MockConnectorFactory;
import io.trino.execution.QueryInfo;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.SetRoleTask;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.security.Identity;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.security.SelectedRole;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.sql.parser.ParsingOptions;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.tree.SetRole;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingSession;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.transaction.TransactionManager;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestSetRoleTask {
    private static final String CATALOG_NAME = "foo";
    private static final String SYSTEM_ROLE_CATALOG_NAME = "system_role";
    private static final String USER_NAME = "user";
    private static final String ROLE_NAME = "bar";
    private LocalQueryRunner queryRunner;
    private TransactionManager transactionManager;
    private AccessControl accessControl;
    private Metadata metadata;
    private ExecutorService executor;
    private SqlParser parser;

    @BeforeClass
    public void setUp() {
        this.queryRunner = LocalQueryRunner.create((Session)SessionTestUtils.TEST_SESSION);
        MockConnectorFactory mockConnectorFactory = MockConnectorFactory.builder().withListRoleGrants((connectorSession, roles, grantees, limit) -> ImmutableSet.of((Object)new RoleGrant(new TrinoPrincipal(PrincipalType.USER, USER_NAME), ROLE_NAME, false))).build();
        this.queryRunner.createCatalog(CATALOG_NAME, (ConnectorFactory)mockConnectorFactory, (Map)ImmutableMap.of());
        MockConnectorFactory systemConnectorFactory = MockConnectorFactory.builder().withName("system_role_connector").build();
        this.queryRunner.createCatalog(SYSTEM_ROLE_CATALOG_NAME, (ConnectorFactory)systemConnectorFactory, (Map)ImmutableMap.of());
        this.transactionManager = this.queryRunner.getTransactionManager();
        this.accessControl = this.queryRunner.getAccessControl();
        this.metadata = this.queryRunner.getMetadata();
        this.parser = this.queryRunner.getSqlParser();
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-set-role-task-executor-%s"));
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        if (this.queryRunner != null) {
            this.queryRunner.close();
            this.queryRunner = null;
        }
        this.executor.shutdownNow();
        this.executor = null;
        this.metadata = null;
        this.accessControl = null;
        this.transactionManager = null;
        this.parser = null;
    }

    @Test
    public void testSetRole() {
        this.assertSetRole("SET ROLE ALL IN foo", (Map<String, SelectedRole>)ImmutableMap.of((Object)CATALOG_NAME, (Object)new SelectedRole(SelectedRole.Type.ALL, Optional.empty())));
        this.assertSetRole("SET ROLE NONE IN foo", (Map<String, SelectedRole>)ImmutableMap.of((Object)CATALOG_NAME, (Object)new SelectedRole(SelectedRole.Type.NONE, Optional.empty())));
        this.assertSetRole("SET ROLE bar IN foo", (Map<String, SelectedRole>)ImmutableMap.of((Object)CATALOG_NAME, (Object)new SelectedRole(SelectedRole.Type.ROLE, Optional.of(ROLE_NAME))));
        this.assertSetRole("SET ROLE ALL", (Map<String, SelectedRole>)ImmutableMap.of((Object)"system", (Object)new SelectedRole(SelectedRole.Type.ALL, Optional.empty())));
        this.assertSetRole("SET ROLE NONE", (Map<String, SelectedRole>)ImmutableMap.of((Object)"system", (Object)new SelectedRole(SelectedRole.Type.NONE, Optional.empty())));
    }

    @Test
    public void testSetRoleInvalidRole() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.executeSetRole("SET ROLE unknown IN foo")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.ROLE_NOT_FOUND}).hasMessage("line 1:1: Role 'unknown' does not exist");
    }

    @Test
    public void testSetRoleInvalidCatalog() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.executeSetRole("SET ROLE foo IN invalid")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.CATALOG_NOT_FOUND}).hasMessage("line 1:1: Catalog 'invalid' does not exist");
    }

    @Test
    public void testSetCatalogRoleInCatalogWithSystemSecurity() {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.executeSetRole("SET ROLE foo IN system_role")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:1: Catalog 'system_role' does not support role management");
    }

    private void assertSetRole(String statement, Map<String, SelectedRole> expected) {
        QueryStateMachine stateMachine = this.executeSetRole(statement);
        QueryInfo queryInfo = stateMachine.getQueryInfo(Optional.empty());
        Assert.assertEquals((Map)queryInfo.getSetRoles(), expected);
    }

    private QueryStateMachine executeSetRole(String statement) {
        SetRole setRole = (SetRole)this.parser.createStatement(statement, new ParsingOptions());
        QueryStateMachine stateMachine = QueryStateMachine.begin(Optional.empty(), (String)statement, Optional.empty(), (Session)TestingSession.testSessionBuilder().setIdentity(Identity.ofUser((String)USER_NAME)).build(), (URI)URI.create("fake://uri"), (ResourceGroupId)new ResourceGroupId("test"), (boolean)false, (TransactionManager)this.transactionManager, (AccessControl)this.accessControl, (Executor)this.executor, (Metadata)this.metadata, (WarningCollector)WarningCollector.NOOP, (PlanOptimizersStatsCollector)PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector(), Optional.empty(), (boolean)true, (NodeVersion)new NodeVersion("test"));
        new SetRoleTask(this.metadata, this.accessControl).execute(setRole, stateMachine, (List)ImmutableList.of(), WarningCollector.NOOP);
        return stateMachine;
    }
}

