/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.stats.TDigest;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.execution.TaskId;
import io.trino.execution.TaskInfo;
import io.trino.execution.TaskState;
import io.trino.execution.TaskStatus;
import io.trino.execution.buffer.BufferState;
import io.trino.execution.buffer.OutputBufferInfo;
import io.trino.execution.buffer.OutputBufferStatus;
import io.trino.memory.KillTarget;
import io.trino.memory.LowMemoryKiller;
import io.trino.memory.LowMemoryKillerTestingUtils;
import io.trino.memory.TotalReservationOnBlockedNodesTaskLowMemoryKiller;
import io.trino.operator.TaskStats;
import io.trino.plugin.base.metrics.TDigestHistogram;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTotalReservationOnBlockedNodesTaskLowMemoryKiller {
    private final LowMemoryKiller lowMemoryKiller = new TotalReservationOnBlockedNodesTaskLowMemoryKiller();

    @Test
    public void testMemoryPoolHasNoReservation() {
        int memoryPool = 12;
        ImmutableMap queries = ImmutableMap.of((Object)"q_1", (Object)ImmutableMap.of((Object)"n1", (Object)0L, (Object)"n2", (Object)0L, (Object)"n3", (Object)0L, (Object)"n4", (Object)0L, (Object)"n5", (Object)0L));
        Assert.assertEquals((Object)this.lowMemoryKiller.chooseTargetToKill(LowMemoryKillerTestingUtils.toRunningQueryInfoList((Map<String, Map<String, Long>>)queries), LowMemoryKillerTestingUtils.toNodeMemoryInfoList(memoryPool, (Map<String, Map<String, Long>>)queries)), Optional.empty());
    }

    @Test
    public void testMemoryPoolNotBlocked() {
        int memoryPool = 12;
        ImmutableMap queries = ImmutableMap.builder().put((Object)"q_1", (Object)ImmutableMap.of((Object)"n1", (Object)0L, (Object)"n2", (Object)6L, (Object)"n3", (Object)0L, (Object)"n4", (Object)0L, (Object)"n5", (Object)0L)).put((Object)"q_2", (Object)ImmutableMap.of((Object)"n1", (Object)3L, (Object)"n2", (Object)5L, (Object)"n3", (Object)2L, (Object)"n4", (Object)4L, (Object)"n5", (Object)0L)).buildOrThrow();
        Assert.assertEquals((Object)this.lowMemoryKiller.chooseTargetToKill(LowMemoryKillerTestingUtils.toRunningQueryInfoList((Map<String, Map<String, Long>>)queries), LowMemoryKillerTestingUtils.toNodeMemoryInfoList(memoryPool, (Map<String, Map<String, Long>>)queries)), Optional.empty());
    }

    @Test
    public void testWillNotKillTaskForQueryWithoutTaskRetriesEnabled() {
        int memoryPool = 5;
        ImmutableMap queries = ImmutableMap.builder().put((Object)"q_1", (Object)ImmutableMap.of((Object)"n1", (Object)0L, (Object)"n2", (Object)0L, (Object)"n3", (Object)2L)).put((Object)"q_2", (Object)ImmutableMap.of((Object)"n1", (Object)3L, (Object)"n2", (Object)5L, (Object)"n3", (Object)2L)).buildOrThrow();
        ImmutableMap tasks = ImmutableMap.builder().put((Object)"q_1", (Object)ImmutableMap.of((Object)"n3", (Object)ImmutableMap.of((Object)1, (Object)5L))).put((Object)"q_2", (Object)ImmutableMap.of((Object)"n1", (Object)ImmutableMap.of((Object)1, (Object)1L, (Object)2, (Object)2L), (Object)"n2", (Object)ImmutableMap.of((Object)3, (Object)3L, (Object)4, (Object)1L, (Object)5, (Object)1L), (Object)"n3", (Object)ImmutableMap.of((Object)6, (Object)2L))).buildOrThrow();
        Assert.assertEquals((Object)this.lowMemoryKiller.chooseTargetToKill(LowMemoryKillerTestingUtils.toRunningQueryInfoList((Map<String, Map<String, Long>>)queries), LowMemoryKillerTestingUtils.toNodeMemoryInfoList(memoryPool, (Map<String, Map<String, Long>>)queries, (Map<String, Map<String, Map<Integer, Long>>>)tasks)), Optional.empty());
    }

    @Test
    public void testPreferKillingTasks() {
        int memoryPool = 12;
        ImmutableMap queries = ImmutableMap.builder().put((Object)"q_1", (Object)ImmutableMap.of((Object)"n1", (Object)0L, (Object)"n2", (Object)8L, (Object)"n3", (Object)0L, (Object)"n4", (Object)0L, (Object)"n5", (Object)0L)).put((Object)"q_2", (Object)ImmutableMap.of((Object)"n1", (Object)3L, (Object)"n2", (Object)5L, (Object)"n3", (Object)2L, (Object)"n4", (Object)4L, (Object)"n5", (Object)0L)).put((Object)"q_3", (Object)ImmutableMap.of((Object)"n1", (Object)0L, (Object)"n2", (Object)0L, (Object)"n3", (Object)11L, (Object)"n4", (Object)0L, (Object)"n5", (Object)0L)).buildOrThrow();
        ImmutableMap tasks = ImmutableMap.of((Object)"q_2", (Object)ImmutableMap.of((Object)"n1", (Object)ImmutableMap.of((Object)1, (Object)1L, (Object)2, (Object)3L), (Object)"n2", (Object)ImmutableMap.of((Object)3, (Object)3L, (Object)4, (Object)1L, (Object)5, (Object)1L), (Object)"n3", (Object)ImmutableMap.of((Object)6, (Object)2L), (Object)"n4", (Object)ImmutableMap.of((Object)7, (Object)2L, (Object)8, (Object)2L), (Object)"n5", (Object)ImmutableMap.of()));
        Assert.assertEquals((Object)this.lowMemoryKiller.chooseTargetToKill(LowMemoryKillerTestingUtils.toRunningQueryInfoList((Map<String, Map<String, Long>>)queries, (Set<String>)ImmutableSet.of((Object)"q_2")), LowMemoryKillerTestingUtils.toNodeMemoryInfoList(memoryPool, (Map<String, Map<String, Long>>)queries, (Map<String, Map<String, Map<Integer, Long>>>)tasks)), Optional.of(KillTarget.selectedTasks((Set)ImmutableSet.of((Object)LowMemoryKillerTestingUtils.taskId("q_2", 3), (Object)LowMemoryKillerTestingUtils.taskId("q_2", 6)))));
    }

    @Test
    public void testKillsBiggestTasks() {
        int memoryPool = 12;
        ImmutableMap queries = ImmutableMap.builder().put((Object)"q_1", (Object)ImmutableMap.of((Object)"n1", (Object)0L, (Object)"n2", (Object)8L, (Object)"n3", (Object)0L, (Object)"n4", (Object)0L, (Object)"n5", (Object)0L)).put((Object)"q_2", (Object)ImmutableMap.of((Object)"n1", (Object)3L, (Object)"n2", (Object)5L, (Object)"n3", (Object)2L, (Object)"n4", (Object)4L, (Object)"n5", (Object)0L)).put((Object)"q_3", (Object)ImmutableMap.of((Object)"n1", (Object)0L, (Object)"n2", (Object)0L, (Object)"n3", (Object)11L, (Object)"n4", (Object)0L, (Object)"n5", (Object)0L)).buildOrThrow();
        ImmutableMap tasks = ImmutableMap.builder().put((Object)"q_1", (Object)ImmutableMap.of((Object)"n2", (Object)ImmutableMap.of((Object)1, (Object)8L))).put((Object)"q_2", (Object)ImmutableMap.of((Object)"n1", (Object)ImmutableMap.of((Object)1, (Object)1L, (Object)2, (Object)3L), (Object)"n2", (Object)ImmutableMap.of((Object)3, (Object)3L, (Object)4, (Object)1L, (Object)5, (Object)1L), (Object)"n3", (Object)ImmutableMap.of((Object)6, (Object)2L), (Object)"n4", (Object)ImmutableMap.of((Object)7, (Object)2L, (Object)8, (Object)2L), (Object)"n5", (Object)ImmutableMap.of())).put((Object)"q_3", (Object)ImmutableMap.of((Object)"n3", (Object)ImmutableMap.of((Object)1, (Object)11L))).buildOrThrow();
        Assert.assertEquals((Object)this.lowMemoryKiller.chooseTargetToKill(LowMemoryKillerTestingUtils.toRunningQueryInfoList((Map<String, Map<String, Long>>)queries, (Set<String>)ImmutableSet.of((Object)"q_1", (Object)"q_2")), LowMemoryKillerTestingUtils.toNodeMemoryInfoList(memoryPool, (Map<String, Map<String, Long>>)queries, (Map<String, Map<String, Map<Integer, Long>>>)tasks)), Optional.of(KillTarget.selectedTasks((Set)ImmutableSet.of((Object)LowMemoryKillerTestingUtils.taskId("q_1", 1), (Object)LowMemoryKillerTestingUtils.taskId("q_2", 6)))));
    }

    @Test
    public void testPrefersKillingSpeculativeTask() {
        int memoryPool = 12;
        ImmutableMap queries = ImmutableMap.builder().put((Object)"q_1", (Object)ImmutableMap.of((Object)"n1", (Object)0L, (Object)"n2", (Object)8L, (Object)"n3", (Object)0L, (Object)"n4", (Object)0L, (Object)"n5", (Object)0L)).put((Object)"q_2", (Object)ImmutableMap.of((Object)"n1", (Object)3L, (Object)"n2", (Object)6L, (Object)"n3", (Object)2L, (Object)"n4", (Object)4L, (Object)"n5", (Object)0L)).put((Object)"q_3", (Object)ImmutableMap.of((Object)"n1", (Object)0L, (Object)"n2", (Object)0L, (Object)"n3", (Object)11L, (Object)"n4", (Object)0L, (Object)"n5", (Object)0L)).buildOrThrow();
        ImmutableMap tasks = ImmutableMap.builder().put((Object)"q_1", (Object)ImmutableMap.of((Object)"n2", (Object)ImmutableMap.of((Object)1, (Object)8L))).put((Object)"q_2", (Object)ImmutableMap.of((Object)"n1", (Object)ImmutableMap.of((Object)1, (Object)1L, (Object)2, (Object)3L), (Object)"n2", (Object)ImmutableMap.of((Object)3, (Object)3L, (Object)4, (Object)1L, (Object)5, (Object)2L), (Object)"n3", (Object)ImmutableMap.of((Object)6, (Object)2L), (Object)"n4", (Object)ImmutableMap.of((Object)7, (Object)2L, (Object)8, (Object)2L), (Object)"n5", (Object)ImmutableMap.of())).put((Object)"q_3", (Object)ImmutableMap.of((Object)"n3", (Object)ImmutableMap.of((Object)1, (Object)11L))).buildOrThrow();
        ImmutableMap taskInfos = ImmutableMap.of((Object)"q_1", (Object)ImmutableMap.of((Object)1, (Object)TestTotalReservationOnBlockedNodesTaskLowMemoryKiller.buildTaskInfo(LowMemoryKillerTestingUtils.taskId("q_1", 1), false)), (Object)"q_2", (Object)ImmutableMap.of((Object)1, (Object)TestTotalReservationOnBlockedNodesTaskLowMemoryKiller.buildTaskInfo(LowMemoryKillerTestingUtils.taskId("q_2", 1), false), (Object)2, (Object)TestTotalReservationOnBlockedNodesTaskLowMemoryKiller.buildTaskInfo(LowMemoryKillerTestingUtils.taskId("q_2", 2), false), (Object)3, (Object)TestTotalReservationOnBlockedNodesTaskLowMemoryKiller.buildTaskInfo(LowMemoryKillerTestingUtils.taskId("q_2", 3), false), (Object)4, (Object)TestTotalReservationOnBlockedNodesTaskLowMemoryKiller.buildTaskInfo(LowMemoryKillerTestingUtils.taskId("q_2", 4), true), (Object)5, (Object)TestTotalReservationOnBlockedNodesTaskLowMemoryKiller.buildTaskInfo(LowMemoryKillerTestingUtils.taskId("q_2", 5), true), (Object)6, (Object)TestTotalReservationOnBlockedNodesTaskLowMemoryKiller.buildTaskInfo(LowMemoryKillerTestingUtils.taskId("q_2", 6), false), (Object)7, (Object)TestTotalReservationOnBlockedNodesTaskLowMemoryKiller.buildTaskInfo(LowMemoryKillerTestingUtils.taskId("q_2", 7), false), (Object)8, (Object)TestTotalReservationOnBlockedNodesTaskLowMemoryKiller.buildTaskInfo(LowMemoryKillerTestingUtils.taskId("q_2", 8), false)));
        Assert.assertEquals((Object)this.lowMemoryKiller.chooseTargetToKill(LowMemoryKillerTestingUtils.toRunningQueryInfoList((Map<String, Map<String, Long>>)queries, (Set<String>)ImmutableSet.of((Object)"q_1", (Object)"q_2"), (Map<String, Map<Integer, TaskInfo>>)taskInfos), LowMemoryKillerTestingUtils.toNodeMemoryInfoList(memoryPool, (Map<String, Map<String, Long>>)queries, (Map<String, Map<String, Map<Integer, Long>>>)tasks)), Optional.of(KillTarget.selectedTasks((Set)ImmutableSet.of((Object)LowMemoryKillerTestingUtils.taskId("q_2", 5), (Object)LowMemoryKillerTestingUtils.taskId("q_2", 6)))));
    }

    private static TaskInfo buildTaskInfo(TaskId taskId, boolean speculative) {
        return new TaskInfo(new TaskStatus(taskId, "task-instance-id", 0L, TaskState.RUNNING, URI.create("fake://task/" + taskId + "/node/some_node"), "some_node", speculative, (List)ImmutableList.of(), 0, 0, OutputBufferStatus.initial(), DataSize.of((long)0L, (DataSize.Unit)DataSize.Unit.MEGABYTE), DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE), Optional.of(1), DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE), DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE), DataSize.of((long)0L, (DataSize.Unit)DataSize.Unit.MEGABYTE), 0L, Duration.valueOf((String)"0s"), 0L, 1L, 1L), DateTime.now(), new OutputBufferInfo("TESTING", BufferState.FINISHED, false, false, 0L, 0L, 0L, 0L, Optional.empty(), Optional.of(new TDigestHistogram(new TDigest())), Optional.empty()), (Set)ImmutableSet.of(), new TaskStats(DateTime.now(), null, null, null, null, null, new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), 0, 0, 0, 0L, 0, 0, 0L, 0, 0, 0.0, DataSize.ofBytes((long)0L), DataSize.ofBytes((long)0L), DataSize.ofBytes((long)0L), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), false, (Set)ImmutableSet.of(), DataSize.ofBytes((long)0L), 0L, new Duration(0.0, TimeUnit.MILLISECONDS), DataSize.ofBytes((long)0L), 0L, DataSize.ofBytes((long)0L), 0L, DataSize.ofBytes((long)0L), 0L, new Duration(0.0, TimeUnit.MILLISECONDS), DataSize.ofBytes((long)0L), 0L, new Duration(0.0, TimeUnit.MILLISECONDS), DataSize.ofBytes((long)0L), Optional.empty(), 0, new Duration(0.0, TimeUnit.MILLISECONDS), (List)ImmutableList.of()), Optional.empty(), false);
    }
}

