/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.collect.ImmutableMap;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.trino.metadata.InternalBlockEncodingSerde;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockEncoding;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.block.VariableWidthBlockEncoding;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.TestingTypeManager;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestInternalBlockEncodingSerde {
    private final TestingTypeManager testingTypeManager = new TestingTypeManager();
    private final Map<String, BlockEncoding> blockEncodings = ImmutableMap.of((Object)"VARIABLE_WIDTH", (Object)new VariableWidthBlockEncoding());
    private final BlockEncodingSerde blockEncodingSerde = new InternalBlockEncodingSerde(this.blockEncodings::get, arg_0 -> ((TestingTypeManager)this.testingTypeManager).getType(arg_0));

    @Test
    public void blockRoundTrip() {
        BlockBuilder blockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, 2);
        VarcharType.VARCHAR.writeSlice(blockBuilder, Slices.utf8Slice((String)"hello"));
        VarcharType.VARCHAR.writeSlice(blockBuilder, Slices.utf8Slice((String)"world"));
        DynamicSliceOutput sliceOutput = new DynamicSliceOutput(1024);
        this.blockEncodingSerde.writeBlock((SliceOutput)sliceOutput, blockBuilder.build());
        Block copy = this.blockEncodingSerde.readBlock((SliceInput)sliceOutput.slice().getInput());
        Assert.assertEquals((String)VarcharType.VARCHAR.getSlice(copy, 0).toStringUtf8(), (String)"hello");
        Assert.assertEquals((String)VarcharType.VARCHAR.getSlice(copy, 1).toStringUtf8(), (String)"world");
    }

    @Test
    public void testTypeRoundTrip() {
        DynamicSliceOutput sliceOutput = new DynamicSliceOutput(1024);
        this.blockEncodingSerde.writeType((SliceOutput)sliceOutput, (Type)BooleanType.BOOLEAN);
        Type actualType = this.blockEncodingSerde.readType((SliceInput)sliceOutput.slice().getInput());
        Assert.assertEquals((Object)actualType, (Object)BooleanType.BOOLEAN);
    }
}

