/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.concurrent.Threads;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.block.BlockAssertions;
import io.trino.operator.DynamicFilterSourceOperator;
import io.trino.operator.Operator;
import io.trino.operator.OperatorAssertion;
import io.trino.operator.OperatorFactory;
import io.trino.operator.PipelineContext;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeUtils;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.DynamicFilterSourceConsumer;
import io.trino.sql.planner.plan.DynamicFilterId;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.MaterializedResult;
import io.trino.testing.TestingTaskContext;
import io.trino.type.BlockTypeOperators;
import io.trino.type.ColorType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestDynamicFilterSourceOperator {
    private BlockTypeOperators blockTypeOperators;
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;
    private PipelineContext pipelineContext;
    private ImmutableList.Builder<TupleDomain<DynamicFilterId>> partitions;

    @BeforeMethod
    public void setUp() {
        this.blockTypeOperators = new BlockTypeOperators(new TypeOperators());
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-scheduledExecutor-%s")));
        this.pipelineContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).addPipelineContext(0, true, true, false);
        this.partitions = ImmutableList.builder();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    private void verifyPassthrough(Operator operator, List<Type> types, Page ... pages) {
        this.verifyPassthrough(operator, types, Arrays.asList(pages));
    }

    private void verifyPassthrough(Operator operator, List<Type> types, List<Page> pages) {
        ImmutableList inputPages = ImmutableList.copyOf(pages);
        List<Page> outputPages = OperatorAssertion.toPages(operator, inputPages.iterator());
        MaterializedResult actual = OperatorAssertion.toMaterializedResult(this.pipelineContext.getSession(), types, outputPages);
        MaterializedResult expected = OperatorAssertion.toMaterializedResult(this.pipelineContext.getSession(), types, (List<Page>)inputPages);
        Assertions.assertThat((Iterable)actual).containsExactlyElementsOf((Iterable)expected);
    }

    private OperatorFactory createOperatorFactory(DynamicFilterSourceOperator.Channel ... buildChannels) {
        return this.createOperatorFactory(100, DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.KILOBYTE), 1000000, Arrays.asList(buildChannels));
    }

    private OperatorFactory createOperatorFactory(int maxFilterDistinctValues, DataSize maxFilterSize, int minMaxCollectionLimit, Iterable<DynamicFilterSourceOperator.Channel> buildChannels) {
        return new DynamicFilterSourceOperator.DynamicFilterSourceOperatorFactory(0, new PlanNodeId("PLAN_NODE_ID"), new DynamicFilterSourceConsumer(){

            public void addPartition(TupleDomain<DynamicFilterId> tupleDomain) {
                TestDynamicFilterSourceOperator.this.partitions.add(tupleDomain);
            }

            public void setPartitionCount(int partitionCount) {
            }

            public boolean isDomainCollectionComplete() {
                return false;
            }
        }, (List)ImmutableList.copyOf(buildChannels), maxFilterDistinctValues, maxFilterSize, minMaxCollectionLimit, this.blockTypeOperators);
    }

    private Operator createOperator(OperatorFactory operatorFactory) {
        return operatorFactory.createOperator(this.pipelineContext.addDriverContext());
    }

    private static DynamicFilterSourceOperator.Channel channel(int index, Type type) {
        return new DynamicFilterSourceOperator.Channel(new DynamicFilterId(Integer.toString(index)), type, index);
    }

    private void assertDynamicFilters(int maxFilterDistinctValues, List<Type> types, List<Page> pages, List<TupleDomain<DynamicFilterId>> expectedTupleDomains) {
        this.assertDynamicFilters(maxFilterDistinctValues, DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.KILOBYTE), 1000000, types, pages, expectedTupleDomains);
    }

    private void assertDynamicFilters(int maxFilterDistinctValues, DataSize maxFilterSize, int minMaxCollectionLimit, List<Type> types, List<Page> pages, List<TupleDomain<DynamicFilterId>> expectedTupleDomains) {
        List buildChannels = (List)IntStream.range(0, types.size()).mapToObj(i -> TestDynamicFilterSourceOperator.channel(i, (Type)types.get(i))).collect(ImmutableList.toImmutableList());
        OperatorFactory operatorFactory = this.createOperatorFactory(maxFilterDistinctValues, maxFilterSize, minMaxCollectionLimit, buildChannels);
        Operator operator = this.createOperator(operatorFactory);
        this.verifyPassthrough(operator, types, pages);
        operatorFactory.noMoreOperators();
        Assert.assertEquals((long)operator.getOperatorContext().getOperatorMemoryContext().getUserMemory(), (long)0L);
        Assert.assertEquals((Collection)this.partitions.build(), expectedTupleDomains);
    }

    @Test
    public void testCollectMultipleOperators() {
        OperatorFactory operatorFactory = this.createOperatorFactory(TestDynamicFilterSourceOperator.channel(0, (Type)BigintType.BIGINT));
        Operator op1 = this.createOperator(operatorFactory);
        this.verifyPassthrough(op1, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), new Page(new Block[]{BlockAssertions.createLongsBlock(1, 2)}), new Page(new Block[]{BlockAssertions.createLongsBlock(3, 5)}));
        Operator op2 = this.createOperator(operatorFactory);
        operatorFactory.noMoreOperators();
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("0"), (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)5L))))));
        this.verifyPassthrough(op2, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), new Page(new Block[]{BlockAssertions.createLongsBlock(2, 3)}), new Page(new Block[]{BlockAssertions.createLongsBlock(1, 4)}));
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("0"), (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)5L)))), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("0"), (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)4L))))));
    }

    @Test
    public void testCollectMultipleColumns() {
        OperatorFactory operatorFactory = this.createOperatorFactory(TestDynamicFilterSourceOperator.channel(0, (Type)BooleanType.BOOLEAN), TestDynamicFilterSourceOperator.channel(1, (Type)DoubleType.DOUBLE));
        this.verifyPassthrough(this.createOperator(operatorFactory), (List<Type>)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)DoubleType.DOUBLE), new Page(new Block[]{BlockAssertions.createBooleansBlock((Boolean)true, 2), BlockAssertions.createDoublesBlock(1.5, 3.0)}), new Page(new Block[]{BlockAssertions.createBooleansBlock((Boolean)false, 1), BlockAssertions.createDoublesBlock(4.5)}));
        operatorFactory.noMoreOperators();
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("0"), (Object)Domain.multipleValues((Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)true, (Object)false)), (Object)new DynamicFilterId("1"), (Object)Domain.multipleValues((Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)1.5, (Object)3.0, (Object)4.5))))));
    }

    @Test
    public void testCollectOnlyFirstColumn() {
        OperatorFactory operatorFactory = this.createOperatorFactory(TestDynamicFilterSourceOperator.channel(0, (Type)BooleanType.BOOLEAN));
        this.verifyPassthrough(this.createOperator(operatorFactory), (List<Type>)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)DoubleType.DOUBLE), new Page(new Block[]{BlockAssertions.createBooleansBlock((Boolean)true, 2), BlockAssertions.createDoublesBlock(1.5, 3.0)}), new Page(new Block[]{BlockAssertions.createBooleansBlock((Boolean)false, 1), BlockAssertions.createDoublesBlock(4.5)}));
        operatorFactory.noMoreOperators();
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("0"), (Object)Domain.multipleValues((Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)true, (Object)false))))));
    }

    @Test
    public void testCollectOnlyLastColumn() {
        OperatorFactory operatorFactory = this.createOperatorFactory(TestDynamicFilterSourceOperator.channel(1, (Type)DoubleType.DOUBLE));
        this.verifyPassthrough(this.createOperator(operatorFactory), (List<Type>)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)DoubleType.DOUBLE), new Page(new Block[]{BlockAssertions.createBooleansBlock((Boolean)true, 2), BlockAssertions.createDoublesBlock(1.5, 3.0)}), new Page(new Block[]{BlockAssertions.createBooleansBlock((Boolean)false, 1), BlockAssertions.createDoublesBlock(4.5)}));
        operatorFactory.noMoreOperators();
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("1"), (Object)Domain.multipleValues((Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)1.5, (Object)3.0, (Object)4.5))))));
    }

    @Test
    public void testCollectWithNulls() {
        Block blockWithNulls = IntegerType.INTEGER.createFixedSizeBlockBuilder(0).writeInt(3).appendNull().writeInt(4).build();
        OperatorFactory operatorFactory = this.createOperatorFactory(TestDynamicFilterSourceOperator.channel(0, (Type)IntegerType.INTEGER));
        this.verifyPassthrough(this.createOperator(operatorFactory), (List<Type>)ImmutableList.of((Object)IntegerType.INTEGER), new Page(new Block[]{BlockAssertions.createLongsBlock(1, 2, 3)}), new Page(new Block[]{blockWithNulls}), new Page(new Block[]{BlockAssertions.createLongsBlock(4, 5)}));
        operatorFactory.noMoreOperators();
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("0"), (Object)Domain.create((ValueSet)ValueSet.of((Type)IntegerType.INTEGER, (Object)1L, (Object[])new Object[]{2L, 3L, 4L, 5L}), (boolean)false)))));
    }

    @Test
    public void testCollectWithDoubleNaN() {
        BlockBuilder input = DoubleType.DOUBLE.createBlockBuilder(null, 10);
        DoubleType.DOUBLE.writeDouble(input, 42.0);
        DoubleType.DOUBLE.writeDouble(input, Double.NaN);
        OperatorFactory operatorFactory = this.createOperatorFactory(TestDynamicFilterSourceOperator.channel(0, (Type)DoubleType.DOUBLE));
        this.verifyPassthrough(this.createOperator(operatorFactory), (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE), new Page(new Block[]{input.build()}));
        operatorFactory.noMoreOperators();
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("0"), (Object)Domain.multipleValues((Type)DoubleType.DOUBLE, (List)ImmutableList.of((Object)42.0))))));
    }

    @Test
    public void testCollectWithRealNaN() {
        BlockBuilder input = RealType.REAL.createBlockBuilder(null, 10);
        RealType.REAL.writeLong(input, (long)Float.floatToRawIntBits(42.0f));
        RealType.REAL.writeLong(input, (long)Float.floatToRawIntBits(Float.NaN));
        OperatorFactory operatorFactory = this.createOperatorFactory(TestDynamicFilterSourceOperator.channel(0, (Type)RealType.REAL));
        this.verifyPassthrough(this.createOperator(operatorFactory), (List<Type>)ImmutableList.of((Object)RealType.REAL), new Page(new Block[]{input.build()}));
        operatorFactory.noMoreOperators();
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("0"), (Object)Domain.multipleValues((Type)RealType.REAL, (List)ImmutableList.of((Object)Float.floatToRawIntBits(42.0f)))))));
    }

    @Test
    public void testCollectTooMuchRowsDouble() {
        int maxDistinctValues = 100;
        this.assertDynamicFilters(maxDistinctValues, (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE), (List<Page>)ImmutableList.of((Object)new Page(new Block[]{BlockAssertions.createDoubleSequenceBlock(0, maxDistinctValues + 1)}), (Object)new Page(new Block[]{BlockAssertions.createDoubleRepeatBlock(Double.NaN, maxDistinctValues + 1)})), (List<TupleDomain<DynamicFilterId>>)ImmutableList.of((Object)TupleDomain.all()));
    }

    @Test
    public void testCollectTooMuchRowsReal() {
        int maxDistinctValues = 100;
        this.assertDynamicFilters(maxDistinctValues, (List<Type>)ImmutableList.of((Object)RealType.REAL), (List<Page>)ImmutableList.of((Object)new Page(new Block[]{BlockAssertions.createSequenceBlockOfReal(0, maxDistinctValues + 1)}), (Object)new Page(new Block[]{BlockAssertions.createBlockOfReals(Collections.nCopies(maxDistinctValues + 1, Float.valueOf(Float.NaN)))})), (List<TupleDomain<DynamicFilterId>>)ImmutableList.of((Object)TupleDomain.all()));
    }

    @Test
    public void testCollectTooMuchRowsNonOrderable() {
        int maxDistinctValues = 100;
        this.assertDynamicFilters(maxDistinctValues, (List<Type>)ImmutableList.of((Object)ColorType.COLOR), (List<Page>)ImmutableList.of((Object)new Page(new Block[]{BlockAssertions.createColorSequenceBlock(0, maxDistinctValues + 1)})), (List<TupleDomain<DynamicFilterId>>)ImmutableList.of((Object)TupleDomain.all()));
    }

    @Test
    public void testCollectRowsNonOrderable() {
        int maxDistinctValues = 100;
        Block block = BlockAssertions.createColorSequenceBlock(0, maxDistinctValues / 2);
        ImmutableList.Builder values = ImmutableList.builder();
        for (int position = 0; position < block.getPositionCount(); ++position) {
            values.add(TypeUtils.readNativeValue((Type)ColorType.COLOR, (Block)block, (int)position));
        }
        this.assertDynamicFilters(maxDistinctValues, (List<Type>)ImmutableList.of((Object)ColorType.COLOR), (List<Page>)ImmutableList.of((Object)new Page(new Block[]{block})), (List<TupleDomain<DynamicFilterId>>)ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("0"), (Object)Domain.create((ValueSet)ValueSet.copyOf((Type)ColorType.COLOR, (Collection)values.build()), (boolean)false)))));
    }

    @Test
    public void testCollectNoFilters() {
        OperatorFactory operatorFactory = this.createOperatorFactory(new DynamicFilterSourceOperator.Channel[0]);
        this.verifyPassthrough(this.createOperator(operatorFactory), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), new Page(new Block[]{BlockAssertions.createLongsBlock(1, 2, 3)}));
        operatorFactory.noMoreOperators();
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.all()));
    }

    @Test
    public void testCollectEmptyBuildSide() {
        OperatorFactory operatorFactory = this.createOperatorFactory(TestDynamicFilterSourceOperator.channel(0, (Type)BigintType.BIGINT));
        this.verifyPassthrough(this.createOperator(operatorFactory), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), new Page[0]);
        operatorFactory.noMoreOperators();
        Assert.assertEquals((Collection)this.partitions.build(), (Collection)ImmutableList.of((Object)TupleDomain.none()));
    }

    @Test
    public void testSingleColumnCollectMinMaxRangeWhenTooManyPositions() {
        int maxDistinctValues = 100;
        Page largePage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, maxDistinctValues + 1)});
        this.assertDynamicFilters(maxDistinctValues, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), (List<Page>)ImmutableList.of((Object)largePage), (List<TupleDomain<DynamicFilterId>>)ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("0"), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)maxDistinctValues, (boolean)true), (Range[])new Range[0]), (boolean)false)))));
    }

    @Test
    public void testMultipleColumnsCollectBelowDistinctValuesLimit() {
        int maxDistinctValues = 101;
        Page largePage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 101), BlockAssertions.createLongSequenceBlock(100, 201), BlockAssertions.createLongSequenceBlock(200, 301)});
        ImmutableList expectedTupleDomains = ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("0"), (Object)Domain.create((ValueSet)ValueSet.copyOf((Type)BigintType.BIGINT, (Collection)((Collection)LongStream.rangeClosed(0L, 100L).boxed().collect(ImmutableList.toImmutableList()))), (boolean)false), (Object)new DynamicFilterId("1"), (Object)Domain.create((ValueSet)ValueSet.copyOf((Type)BigintType.BIGINT, (Collection)((Collection)LongStream.rangeClosed(100L, 200L).boxed().collect(ImmutableList.toImmutableList()))), (boolean)false), (Object)new DynamicFilterId("2"), (Object)Domain.create((ValueSet)ValueSet.copyOf((Type)BigintType.BIGINT, (Collection)((Collection)LongStream.rangeClosed(200L, 300L).boxed().collect(ImmutableList.toImmutableList()))), (boolean)false))));
        this.assertDynamicFilters(maxDistinctValues, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT), (List<Page>)ImmutableList.of((Object)largePage), (List<TupleDomain<DynamicFilterId>>)expectedTupleDomains);
    }

    @Test
    public void testMultipleColumnsBothSetAndRangeWhenTooManyDistinctValues() {
        int maxDistinctValues = 100;
        Page largePage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 101), BlockAssertions.createColorRepeatBlock(100, 101), BlockAssertions.createLongRepeatBlock(200, 101)});
        ImmutableList expectedTupleDomains = ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("0"), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)100L, (boolean)true), (Range[])new Range[0]), (boolean)false), (Object)new DynamicFilterId("1"), (Object)Domain.singleValue((Type)ColorType.COLOR, (Object)100L), (Object)new DynamicFilterId("2"), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)200L), (Range[])new Range[0]), (boolean)false))));
        this.assertDynamicFilters(maxDistinctValues, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)ColorType.COLOR, (Object)BigintType.BIGINT), (List<Page>)ImmutableList.of((Object)largePage), (List<TupleDomain<DynamicFilterId>>)expectedTupleDomains);
    }

    @Test
    public void testMultipleColumnsSingleSetWithNoRangeWhenTooManyDistinctValues() {
        int maxDistinctValues = 100;
        Page largePage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 101), BlockAssertions.createColorRepeatBlock(100, 101), BlockAssertions.createLongRepeatBlock(200, 101)});
        ImmutableList expectedTupleDomains = ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("1"), (Object)Domain.singleValue((Type)ColorType.COLOR, (Object)100L), (Object)new DynamicFilterId("2"), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)200L))));
        this.assertDynamicFilters(maxDistinctValues, DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.KILOBYTE), 100, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)ColorType.COLOR, (Object)BigintType.BIGINT), (List<Page>)ImmutableList.of((Object)largePage), (List<TupleDomain<DynamicFilterId>>)expectedTupleDomains);
    }

    @Test
    public void testMultipleColumnsCollectMinMaxWithNulls() {
        int maxDistinctValues = 100;
        Page largePage = new Page(new Block[]{BlockAssertions.createLongsBlock(Collections.nCopies(100, null)), BlockAssertions.createLongSequenceBlock(200, 301)});
        this.assertDynamicFilters(maxDistinctValues, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT), (List<Page>)ImmutableList.of((Object)largePage), (List<TupleDomain<DynamicFilterId>>)ImmutableList.of((Object)TupleDomain.none()));
    }

    @Test
    public void testSingleColumnCollectMinMaxRangeWhenTooManyBytes() {
        DataSize maxSize = DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.KILOBYTE);
        long maxByteSize = maxSize.toBytes();
        String largeText = "A".repeat((int)maxByteSize + 1);
        Page largePage = new Page(new Block[]{BlockAssertions.createStringsBlock(largeText)});
        this.assertDynamicFilters(100, maxSize, 100, (List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), (List<Page>)ImmutableList.of((Object)largePage), (List<TupleDomain<DynamicFilterId>>)ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("0"), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)largeText), (boolean)true, (Object)Slices.utf8Slice((String)largeText), (boolean)true), (Range[])new Range[0]), (boolean)false)))));
    }

    @Test
    public void testMultipleColumnsCollectMinMaxRangeWhenTooManyBytes() {
        DataSize maxSize = DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.KILOBYTE);
        long maxByteSize = maxSize.toBytes();
        String largeTextA = "A".repeat((int)(maxByteSize / 2L) + 1);
        String largeTextB = "B".repeat((int)(maxByteSize / 2L) + 1);
        Page largePage = new Page(new Block[]{BlockAssertions.createStringsBlock(largeTextA), BlockAssertions.createStringsBlock(largeTextB)});
        ImmutableList expectedTupleDomains = ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("0"), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)largeTextA), (boolean)true, (Object)Slices.utf8Slice((String)largeTextA), (boolean)true), (Range[])new Range[0]), (boolean)false), (Object)new DynamicFilterId("1"), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)largeTextB), (boolean)true, (Object)Slices.utf8Slice((String)largeTextB), (boolean)true), (Range[])new Range[0]), (boolean)false))));
        this.assertDynamicFilters(100, maxSize, 100, (List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR), (List<Page>)ImmutableList.of((Object)largePage), (List<TupleDomain<DynamicFilterId>>)expectedTupleDomains);
    }

    @Test
    public void testCollectMultipleLargePages() {
        int maxDistinctValues = 100;
        Page page1 = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(50, 151)});
        Page page2 = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 101)});
        Page page3 = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(100, 201)});
        this.assertDynamicFilters(maxDistinctValues, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), (List<Page>)ImmutableList.of((Object)page1, (Object)page2, (Object)page3), (List<TupleDomain<DynamicFilterId>>)ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("0"), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)200L, (boolean)true), (Range[])new Range[0]), (boolean)false)))));
    }

    @Test
    public void testCollectDeduplication() {
        int maxDistinctValues = 100;
        Page largePage = new Page(new Block[]{BlockAssertions.createLongRepeatBlock(7, maxDistinctValues * 10)});
        Page nullsPage = new Page(new Block[]{BlockAssertions.createLongsBlock(Arrays.asList(new Long[maxDistinctValues * 10]))});
        this.assertDynamicFilters(maxDistinctValues, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), (List<Page>)ImmutableList.of((Object)largePage, (Object)nullsPage), (List<TupleDomain<DynamicFilterId>>)ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("0"), (Object)Domain.create((ValueSet)ValueSet.of((Type)BigintType.BIGINT, (Object)7L, (Object[])new Object[0]), (boolean)false)))));
    }

    @Test
    public void testCollectMinMaxLimitSinglePage() {
        int maxDistinctValues = 100;
        this.assertDynamicFilters(maxDistinctValues, DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.KILOBYTE), 2 * maxDistinctValues, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), (List<Page>)ImmutableList.of((Object)new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 2 * maxDistinctValues + 1)})), (List<TupleDomain<DynamicFilterId>>)ImmutableList.of((Object)TupleDomain.all()));
    }

    @Test
    public void testCollectMinMaxLimitMultiplePages() {
        int maxDistinctValues = 100;
        this.assertDynamicFilters(maxDistinctValues, DataSize.of((long)10L, (DataSize.Unit)DataSize.Unit.KILOBYTE), 2 * maxDistinctValues + 1, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), (List<Page>)ImmutableList.of((Object)new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, maxDistinctValues + 1)}), (Object)new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, maxDistinctValues + 1)})), (List<TupleDomain<DynamicFilterId>>)ImmutableList.of((Object)TupleDomain.all()));
    }

    @Test
    public void testMemoryUsage() {
        OperatorFactory operatorFactory = this.createOperatorFactory(TestDynamicFilterSourceOperator.channel(0, (Type)BigintType.BIGINT), TestDynamicFilterSourceOperator.channel(1, (Type)BigintType.BIGINT));
        Operator operator = this.createOperator(operatorFactory);
        ImmutableList inputPages = ImmutableList.of((Object)new Page(new Block[]{BlockAssertions.createLongSequenceBlock(51, 101), BlockAssertions.createLongRepeatBlock(200, 50)}));
        OperatorAssertion.toPagesPartial(operator, inputPages.iterator());
        long initialMemoryUsage = operator.getOperatorContext().getOperatorMemoryContext().getUserMemory();
        Assertions.assertThat((long)initialMemoryUsage).isGreaterThan(0L);
        inputPages = ImmutableList.of((Object)new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 51), BlockAssertions.createLongSequenceBlock(51, 101)}));
        OperatorAssertion.toPagesPartial(operator, inputPages.iterator());
        long currentMemoryUsage = operator.getOperatorContext().getOperatorMemoryContext().getUserMemory();
        Assertions.assertThat((long)currentMemoryUsage).isGreaterThan(0L).isLessThan(initialMemoryUsage);
        OperatorAssertion.toPagesPartial(operator, inputPages.iterator());
        Assertions.assertThat((long)operator.getOperatorContext().getOperatorMemoryContext().getUserMemory()).isEqualTo(currentMemoryUsage);
        inputPages = ImmutableList.of((Object)new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 51), BlockAssertions.createLongSequenceBlock(0, 51)}));
        OperatorAssertion.toPagesPartial(operator, inputPages.iterator());
        Assertions.assertThat((long)operator.getOperatorContext().getOperatorMemoryContext().getUserMemory()).isEqualTo(0L);
        OperatorAssertion.finishOperator(operator);
        operatorFactory.noMoreOperators();
        Assertions.assertThat((List)this.partitions.build()).isEqualTo((Object)ImmutableList.of((Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new DynamicFilterId("0"), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)100L, (boolean)true), (Range[])new Range[0]), (boolean)false), (Object)new DynamicFilterId("1"), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)200L, (boolean)true), (Range[])new Range[0]), (boolean)false)))));
    }
}

