/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import io.trino.array.LongBigArray;
import io.trino.operator.GroupedTopNRowNumberAccumulator;
import io.trino.operator.RowIdComparisonStrategy;
import io.trino.operator.RowIdHashStrategy;
import io.trino.operator.RowReference;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestGroupedTopNRowNumberAccumulator {
    @Test
    public void testSingleGroupTopN1() {
        int topN = 1;
        LongArrayList evicted = new LongArrayList();
        GroupedTopNRowNumberAccumulator accumulator = new GroupedTopNRowNumberAccumulator(Long::compare, topN, ((List)evicted)::add);
        accumulator.verifyIntegrity();
        TestingRowReference rowReference = new TestingRowReference();
        rowReference.setRowId(0L);
        Assert.assertTrue((boolean)accumulator.add(0L, (RowReference)rowReference));
        accumulator.verifyIntegrity();
        Assert.assertTrue((boolean)rowReference.isRowIdExtracted());
        Assert.assertTrue((boolean)evicted.isEmpty());
        rowReference.setRowId(1L);
        Assert.assertFalse((boolean)accumulator.add(0L, (RowReference)rowReference));
        accumulator.verifyIntegrity();
        Assert.assertFalse((boolean)rowReference.isRowIdExtracted());
        Assert.assertTrue((boolean)evicted.isEmpty());
        rowReference.setRowId(-1L);
        Assert.assertTrue((boolean)accumulator.add(0L, (RowReference)rowReference));
        accumulator.verifyIntegrity();
        Assert.assertTrue((boolean)rowReference.isRowIdExtracted());
        Assert.assertEquals((Collection)evicted, Arrays.asList(0L));
        LongBigArray rowIdOutput = new LongBigArray();
        Assert.assertEquals((long)accumulator.drainTo(0L, rowIdOutput), (long)1L);
        accumulator.verifyIntegrity();
        Assert.assertEquals((long)rowIdOutput.get(0L), (long)-1L);
    }

    @Test
    public void testSingleGroupTopN2() {
        int topN = 2;
        LongArrayList evicted = new LongArrayList();
        GroupedTopNRowNumberAccumulator accumulator = new GroupedTopNRowNumberAccumulator(Long::compare, topN, ((List)evicted)::add);
        accumulator.verifyIntegrity();
        TestingRowReference rowReference = new TestingRowReference();
        rowReference.setRowId(0L);
        Assert.assertTrue((boolean)accumulator.add(0L, (RowReference)rowReference));
        accumulator.verifyIntegrity();
        Assert.assertTrue((boolean)rowReference.isRowIdExtracted());
        Assert.assertTrue((boolean)evicted.isEmpty());
        rowReference.setRowId(1L);
        Assert.assertTrue((boolean)accumulator.add(0L, (RowReference)rowReference));
        accumulator.verifyIntegrity();
        Assert.assertTrue((boolean)rowReference.isRowIdExtracted());
        Assert.assertTrue((boolean)evicted.isEmpty());
        rowReference.setRowId(2L);
        Assert.assertFalse((boolean)accumulator.add(0L, (RowReference)rowReference));
        accumulator.verifyIntegrity();
        Assert.assertFalse((boolean)rowReference.isRowIdExtracted());
        Assert.assertTrue((boolean)evicted.isEmpty());
        rowReference.setRowId(-2L);
        Assert.assertTrue((boolean)accumulator.add(0L, (RowReference)rowReference));
        accumulator.verifyIntegrity();
        Assert.assertTrue((boolean)rowReference.isRowIdExtracted());
        Assert.assertEquals((Collection)evicted, Arrays.asList(1L));
        rowReference.setRowId(-1L);
        Assert.assertTrue((boolean)accumulator.add(0L, (RowReference)rowReference));
        accumulator.verifyIntegrity();
        Assert.assertTrue((boolean)rowReference.isRowIdExtracted());
        Assert.assertEquals((Collection)evicted, Arrays.asList(1L, 0L));
        LongBigArray rowIdOutput = new LongBigArray();
        Assert.assertEquals((long)accumulator.drainTo(0L, rowIdOutput), (long)2L);
        accumulator.verifyIntegrity();
        Assert.assertEquals((long)rowIdOutput.get(0L), (long)-2L);
        Assert.assertEquals((long)rowIdOutput.get(1L), (long)-1L);
    }

    @Test
    public void testSingleGroupTopN2PartialFill() {
        int topN = 2;
        LongArrayList evicted = new LongArrayList();
        GroupedTopNRowNumberAccumulator accumulator = new GroupedTopNRowNumberAccumulator(Long::compare, topN, ((List)evicted)::add);
        accumulator.verifyIntegrity();
        TestingRowReference rowReference = new TestingRowReference();
        rowReference.setRowId(0L);
        Assert.assertTrue((boolean)accumulator.add(0L, (RowReference)rowReference));
        accumulator.verifyIntegrity();
        Assert.assertTrue((boolean)rowReference.isRowIdExtracted());
        Assert.assertTrue((boolean)evicted.isEmpty());
        LongBigArray rowIdOutput = new LongBigArray();
        Assert.assertEquals((long)accumulator.drainTo(0L, rowIdOutput), (long)1L);
        accumulator.verifyIntegrity();
        Assert.assertEquals((long)rowIdOutput.get(0L), (long)0L);
    }

    @Test
    public void testSingleGroupTopN4PartialFill() {
        int topN = 4;
        LongArrayList evicted = new LongArrayList();
        GroupedTopNRowNumberAccumulator accumulator = new GroupedTopNRowNumberAccumulator(Long::compare, topN, ((List)evicted)::add);
        accumulator.verifyIntegrity();
        TestingRowReference rowReference = new TestingRowReference();
        rowReference.setRowId(0L);
        Assert.assertTrue((boolean)accumulator.add(0L, (RowReference)rowReference));
        accumulator.verifyIntegrity();
        rowReference.setRowId(1L);
        Assert.assertTrue((boolean)accumulator.add(0L, (RowReference)rowReference));
        accumulator.verifyIntegrity();
        Assert.assertTrue((boolean)rowReference.isRowIdExtracted());
        Assert.assertTrue((boolean)evicted.isEmpty());
        LongBigArray rowIdOutput = new LongBigArray();
        Assert.assertEquals((long)accumulator.drainTo(0L, rowIdOutput), (long)2L);
        accumulator.verifyIntegrity();
        Assert.assertEquals((long)rowIdOutput.get(0L), (long)0L);
        Assert.assertEquals((long)rowIdOutput.get(1L), (long)1L);
    }

    @Test
    public void testMultipleGroups() {
        int groupId;
        int i;
        int groupCount = 10;
        int topN = 100;
        LongArraySet evicted = new LongArraySet();
        GroupedTopNRowNumberAccumulator accumulator = new GroupedTopNRowNumberAccumulator(Long::compare, topN, ((Set)evicted)::add);
        accumulator.verifyIntegrity();
        TestingRowReference rowReference = new TestingRowReference();
        int bulkInsertionCount = topN * groupCount;
        LongArraySet firstInsertionBatch = new LongArraySet();
        for (i = bulkInsertionCount; i < bulkInsertionCount * 2; ++i) {
            rowReference.setRowId(i);
            groupId = i % groupCount;
            Assert.assertTrue((boolean)accumulator.add((long)groupId, (RowReference)rowReference));
            accumulator.verifyIntegrity();
            Assert.assertTrue((boolean)rowReference.isRowIdExtracted());
            Assert.assertTrue((boolean)evicted.isEmpty());
            firstInsertionBatch.add(Long.valueOf(i));
        }
        for (i = bulkInsertionCount * 2; i < bulkInsertionCount * 3; ++i) {
            rowReference.setRowId(i);
            groupId = i % groupCount;
            Assert.assertFalse((boolean)accumulator.add((long)groupId, (RowReference)rowReference));
            accumulator.verifyIntegrity();
            Assert.assertFalse((boolean)rowReference.isRowIdExtracted());
            Assert.assertTrue((boolean)evicted.isEmpty());
        }
        for (i = bulkInsertionCount - 1; i >= 0; --i) {
            rowReference.setRowId(i);
            groupId = i % groupCount;
            Assert.assertTrue((boolean)accumulator.add((long)groupId, (RowReference)rowReference));
            accumulator.verifyIntegrity();
            Assert.assertTrue((boolean)rowReference.isRowIdExtracted());
        }
        Assert.assertEquals((Set)evicted, (Set)firstInsertionBatch);
        LongBigArray rowIdOutput = new LongBigArray();
        for (int i2 = 0; i2 < groupCount; ++i2) {
            Assert.assertEquals((long)accumulator.drainTo((long)i2, rowIdOutput), (long)topN);
            accumulator.verifyIntegrity();
            for (int j = 0; j < topN; ++j) {
                Assert.assertEquals((long)rowIdOutput.get((long)j), (long)(j * groupCount + i2));
            }
        }
    }

    @Test
    public void testEmptyDrain() {
        int topN = 1;
        LongArrayList evicted = new LongArrayList();
        GroupedTopNRowNumberAccumulator accumulator = new GroupedTopNRowNumberAccumulator(Long::compare, topN, ((List)evicted)::add);
        accumulator.verifyIntegrity();
        TestingRowReference rowReference = new TestingRowReference();
        rowReference.setRowId(0L);
        accumulator.add(1L, (RowReference)rowReference);
        accumulator.verifyIntegrity();
        LongBigArray rowIdOutput = new LongBigArray();
        Assert.assertEquals((long)accumulator.drainTo(0L, rowIdOutput), (long)0L);
        accumulator.verifyIntegrity();
    }

    private static class TestingRowReference
    implements RowReference {
        private long rowId;
        private boolean rowIdExtracted;

        private TestingRowReference() {
        }

        public void setRowId(long rowId) {
            this.rowId = rowId;
            this.rowIdExtracted = false;
        }

        public boolean isRowIdExtracted() {
            return this.rowIdExtracted;
        }

        public int compareTo(RowIdComparisonStrategy strategy, long otherRowId) {
            return strategy.compare(this.rowId, otherRowId);
        }

        public boolean equals(RowIdHashStrategy strategy, long otherRowId) {
            return strategy.equals(this.rowId, otherRowId);
        }

        public long hash(RowIdHashStrategy strategy) {
            return strategy.hashCode(this.rowId);
        }

        public long allocateRowId() {
            this.rowIdExtracted = true;
            return this.rowId;
        }
    }
}

