/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import io.airlift.units.DataSize;
import io.trino.ExceededMemoryLimitException;
import io.trino.RowPagesBuilder;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.operator.DriverContext;
import io.trino.operator.Operator;
import io.trino.operator.OperatorAssertion;
import io.trino.operator.OperatorFactory;
import io.trino.operator.TopNOperator;
import io.trino.spi.Page;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.MaterializedResult;
import io.trino.testing.TestingTaskContext;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestTopNOperator {
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;
    private DriverContext driverContext;
    private final TypeOperators typeOperators = new TypeOperators();

    @BeforeMethod
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-scheduledExecutor-%s")));
        this.driverContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).addPipelineContext(0, true, true, false).addDriverContext();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @Test
    public void testSingleFieldKey() {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, DoubleType.DOUBLE}).row(1L, 0.1).row(2L, 0.2).pageBreak().row(-1L, -0.1).row(4L, 0.4).pageBreak().row(5L, 0.5).row(4L, 0.41).row(6L, 0.6).pageBreak().build();
        OperatorFactory operatorFactory = this.topNOperatorFactory((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), 2, (List<Integer>)ImmutableList.of((Object)0), (List<SortOrder>)ImmutableList.of((Object)SortOrder.DESC_NULLS_LAST));
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, DoubleType.DOUBLE}).row(new Object[]{6L, 0.6}).row(new Object[]{5L, 0.5}).build();
        OperatorAssertion.assertOperatorEquals(operatorFactory, this.driverContext, input, expected);
    }

    @Test
    public void testMultiFieldKey() {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{VarcharType.VARCHAR, BigintType.BIGINT}).row("a", 1L).row("b", 2L).pageBreak().row("f", 3L).row("a", 4L).pageBreak().row("d", 5L).row("d", 7L).row("e", 6L).build();
        OperatorFactory operatorFactory = this.topNOperatorFactory((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT), 3, (List<Integer>)ImmutableList.of((Object)0, (Object)1), (List<SortOrder>)ImmutableList.of((Object)SortOrder.DESC_NULLS_LAST, (Object)SortOrder.DESC_NULLS_LAST));
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{"f", 3L}).row(new Object[]{"e", 6L}).row(new Object[]{"d", 7L}).build();
        OperatorAssertion.assertOperatorEquals(operatorFactory, this.driverContext, input, expected);
    }

    @Test
    public void testReverseOrder() {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, DoubleType.DOUBLE}).row(1L, 0.1).row(2L, 0.2).pageBreak().row(-1L, -0.1).row(4L, 0.4).pageBreak().row(5L, 0.5).row(4L, 0.41).row(6L, 0.6).pageBreak().build();
        OperatorFactory operatorFactory = this.topNOperatorFactory((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), 2, (List<Integer>)ImmutableList.of((Object)0), (List<SortOrder>)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST));
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, DoubleType.DOUBLE}).row(new Object[]{-1L, -0.1}).row(new Object[]{1L, 0.1}).build();
        OperatorAssertion.assertOperatorEquals(operatorFactory, this.driverContext, input, expected);
    }

    @Test
    public void testLimitZero() throws Exception {
        OperatorFactory factory = this.topNOperatorFactory((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), 0, (List<Integer>)ImmutableList.of((Object)0), (List<SortOrder>)ImmutableList.of((Object)SortOrder.DESC_NULLS_LAST));
        try (Operator operator = factory.createOperator(this.driverContext);){
            Assert.assertNull((Object)operator.getOutput());
            Assert.assertTrue((boolean)operator.isFinished());
            Assert.assertFalse((boolean)operator.needsInput());
            Assert.assertNull((Object)operator.getOutput());
        }
    }

    @Test
    public void testExceedMemoryLimit() throws Exception {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).row(1L).build();
        DriverContext smallDiverContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION, (DataSize)DataSize.ofBytes((long)1L)).addPipelineContext(0, true, true, false).addDriverContext();
        OperatorFactory operatorFactory = this.topNOperatorFactory((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), 100, (List<Integer>)ImmutableList.of((Object)0), (List<SortOrder>)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST));
        Operator operator = operatorFactory.createOperator(smallDiverContext);
        operator.addInput(input.get(0));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> operator.getOutput()).isInstanceOf(ExceededMemoryLimitException.class)).hasMessageStartingWith("Query exceeded per-node memory limit of ");
    }

    private OperatorFactory topNOperatorFactory(List<? extends Type> types, int n, List<Integer> sortChannels, List<SortOrder> sortOrders) {
        return TopNOperator.createOperatorFactory((int)0, (PlanNodeId)new PlanNodeId("test"), types, (int)n, sortChannels, sortOrders, (TypeOperators)this.typeOperators);
    }
}

