/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.Lists;
import io.trino.operator.RowIdComparisonStrategy;
import io.trino.operator.RowIdHashStrategy;
import io.trino.operator.RowReference;
import io.trino.operator.TopNPeerGroupLookup;
import java.util.Arrays;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestTopNPeerGroupLookup {
    private static final RowIdHashStrategy HASH_STRATEGY = new RowIdHashStrategy(){

        public boolean equals(long leftRowId, long rightRowId) {
            return leftRowId == rightRowId;
        }

        public long hashCode(long rowId) {
            return rowId;
        }
    };
    private static final long UNMAPPED_GROUP_ID = Long.MIN_VALUE;
    private static final long DEFAULT_RETURN_VALUE = -1L;

    @DataProvider
    public static Object[][] parameters() {
        List<Integer> expectedSizes = Arrays.asList(0, 1, 2, 3, 1000);
        List<Float> fillFactors = Arrays.asList(Float.valueOf(0.1f), Float.valueOf(0.9f), Float.valueOf(1.0f));
        List<Long> totalGroupIds = Arrays.asList(1L, 10L);
        List<Long> totalRowIds = Arrays.asList(1L, 1000L);
        return TestTopNPeerGroupLookup.to2DArray(Lists.cartesianProduct((List[])new List[]{expectedSizes, fillFactors, totalGroupIds, totalRowIds}));
    }

    private static Object[][] to2DArray(List<List<Object>> nestedList) {
        Object[][] array = new Object[nestedList.size()][];
        for (int i = 0; i < nestedList.size(); ++i) {
            array[i] = nestedList.get(i).toArray();
        }
        return array;
    }

    @Test(dataProvider="parameters")
    public void testCombinations(int expectedSize, float fillFactor, long totalGroupIds, long totalRowIds) {
        int rowId;
        TopNPeerGroupLookup lookup = new TopNPeerGroupLookup((long)expectedSize, fillFactor, HASH_STRATEGY, Long.MIN_VALUE, -1L);
        Assert.assertEquals((long)lookup.size(), (long)0L);
        Assert.assertTrue((boolean)lookup.isEmpty());
        int count = 0;
        int groupId = 0;
        while ((long)groupId < totalGroupIds) {
            int rowId2 = 0;
            while ((long)rowId2 < totalRowIds) {
                Assert.assertEquals((long)lookup.get((long)groupId, (long)rowId2), (long)-1L);
                Assert.assertEquals((long)lookup.get((long)groupId, TestTopNPeerGroupLookup.toRowReference(rowId2)), (long)-1L);
                Assert.assertEquals((long)lookup.remove((long)groupId, (long)rowId2), (long)-1L);
                Assert.assertEquals((long)lookup.put((long)groupId, (long)rowId2, (long)count), (long)-1L);
                Assert.assertFalse((boolean)lookup.isEmpty());
                Assert.assertEquals((long)lookup.size(), (long)(++count));
                ++rowId2;
            }
            ++groupId;
        }
        count = 0;
        long totalEntries = totalGroupIds * totalRowIds;
        int groupId2 = 0;
        while ((long)groupId2 < totalGroupIds) {
            rowId = 0;
            while ((long)rowId < totalRowIds) {
                Assert.assertEquals((long)lookup.get((long)groupId2, (long)rowId), (long)count);
                Assert.assertEquals((long)lookup.get((long)groupId2, TestTopNPeerGroupLookup.toRowReference(rowId)), (long)count);
                ++count;
                Assert.assertFalse((boolean)lookup.isEmpty());
                Assert.assertEquals((long)lookup.size(), (long)totalEntries);
                ++rowId;
            }
            ++groupId2;
        }
        count = 0;
        groupId2 = 0;
        while ((long)groupId2 < totalGroupIds) {
            rowId = 0;
            while ((long)rowId < totalRowIds) {
                Assert.assertEquals((long)lookup.put((long)groupId2, (long)rowId, (long)(count + 1)), (long)count);
                ++count;
                Assert.assertFalse((boolean)lookup.isEmpty());
                Assert.assertEquals((long)lookup.size(), (long)totalEntries);
                ++rowId;
            }
            ++groupId2;
        }
        count = 0;
        groupId2 = 0;
        while ((long)groupId2 < totalGroupIds) {
            rowId = 0;
            while ((long)rowId < totalRowIds) {
                Assert.assertFalse((boolean)lookup.isEmpty());
                Assert.assertEquals((long)lookup.size(), (long)(totalEntries - (long)count));
                Assert.assertEquals((long)lookup.remove((long)groupId2, (long)rowId), (long)(count + 1));
                ++count;
                ++rowId;
            }
            ++groupId2;
        }
        Assert.assertTrue((boolean)lookup.isEmpty());
        Assert.assertEquals((long)lookup.size(), (long)0L);
    }

    private static RowReference toRowReference(final long rowId) {
        return new RowReference(){

            public int compareTo(RowIdComparisonStrategy strategy, long otherRowId) {
                return strategy.compare(rowId, otherRowId);
            }

            public boolean equals(RowIdHashStrategy strategy, long otherRowId) {
                return strategy.equals(rowId, otherRowId);
            }

            public long hash(RowIdHashStrategy strategy) {
                return strategy.hashCode(rowId);
            }

            public long allocateRowId() {
                return rowId;
            }
        };
    }
}

