/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.trino.block.BlockAssertions;
import io.trino.operator.aggregation.AbstractTestAggregationFunction;
import io.trino.operator.aggregation.AggregationTestUtils;
import io.trino.spi.block.Block;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import java.util.List;
import org.apache.commons.math3.stat.correlation.PearsonsCorrelation;

public class TestRealCorrelationAggregation
extends AbstractTestAggregationFunction {
    @Override
    protected Block[] getSequenceBlocks(int start, int length) {
        return new Block[]{BlockAssertions.createSequenceBlockOfReal(start, start + length), BlockAssertions.createSequenceBlockOfReal(start + 2, start + 2 + length)};
    }

    @Override
    protected String getFunctionName() {
        return "corr";
    }

    @Override
    protected List<Type> getFunctionParameterTypes() {
        return ImmutableList.of((Object)RealType.REAL, (Object)RealType.REAL);
    }

    @Override
    protected Object getExpectedValue(int start, int length) {
        if (length <= 1) {
            return null;
        }
        PearsonsCorrelation corr = new PearsonsCorrelation();
        return Float.valueOf((float)corr.correlation(AggregationTestUtils.constructDoublePrimitiveArray(start + 2, length), AggregationTestUtils.constructDoublePrimitiveArray(start, length)));
    }
}

