/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.minmaxn;

import io.trino.operator.aggregation.minmaxn.TypedHeap;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.PrimitiveIterator;
import java.util.stream.IntStream;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTypedHeap {
    private static final int INPUT_SIZE = 1000000;
    private static final int OUTPUT_SIZE = 1000;
    private static final TypeOperators TYPE_OPERATOR_FACTORY = new TypeOperators();
    private static final MethodHandle MAX_ELEMENTS_COMPARATOR = TYPE_OPERATOR_FACTORY.getComparisonUnorderedFirstOperator((Type)BigintType.BIGINT, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}));
    private static final MethodHandle MIN_ELEMENTS_COMPARATOR = TYPE_OPERATOR_FACTORY.getComparisonUnorderedLastOperator((Type)BigintType.BIGINT, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}));

    @Test
    public void testAscending() {
        TestTypedHeap.test(IntStream.range(0, 1000000), false, MAX_ELEMENTS_COMPARATOR, (Type)BigintType.BIGINT, IntStream.range(999000, 1000000).iterator());
        TestTypedHeap.test(IntStream.range(0, 1000000), true, MIN_ELEMENTS_COMPARATOR, (Type)BigintType.BIGINT, IntStream.range(0, 1000).map(x -> 999 - x).iterator());
    }

    @Test
    public void testDescending() {
        TestTypedHeap.test(IntStream.range(0, 1000000).map(x -> 999999 - x), false, MAX_ELEMENTS_COMPARATOR, (Type)BigintType.BIGINT, IntStream.range(999000, 1000000).iterator());
        TestTypedHeap.test(IntStream.range(0, 1000000).map(x -> 999999 - x), true, MIN_ELEMENTS_COMPARATOR, (Type)BigintType.BIGINT, IntStream.range(0, 1000).map(x -> 999 - x).iterator());
    }

    @Test
    public void testShuffled() {
        List list = IntStream.range(0, 1000000).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
        Collections.shuffle(list);
        TestTypedHeap.test(list.stream().mapToInt(Integer::intValue), false, MAX_ELEMENTS_COMPARATOR, (Type)BigintType.BIGINT, IntStream.range(999000, 1000000).iterator());
        TestTypedHeap.test(list.stream().mapToInt(Integer::intValue), true, MIN_ELEMENTS_COMPARATOR, (Type)BigintType.BIGINT, IntStream.range(0, 1000).map(x -> 999 - x).iterator());
    }

    private static void test(IntStream inputStream, boolean min, MethodHandle comparisonMethod, Type elementType, PrimitiveIterator.OfInt outputIterator) {
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(null, 1000000);
        inputStream.forEach(value -> BigintType.BIGINT.writeLong(blockBuilder, (long)value));
        TypedHeap heap = new TypedHeap(min, comparisonMethod, elementType, 1000);
        heap.addAll((Block)blockBuilder);
        BlockBuilder resultBlockBuilder = BigintType.BIGINT.createBlockBuilder(null, 1000);
        heap.writeAll(resultBlockBuilder);
        Block resultBlock = resultBlockBuilder.build();
        Assert.assertEquals((int)resultBlock.getPositionCount(), (int)1000);
        for (int i = 999; i >= 0; --i) {
            Assert.assertEquals((long)BigintType.BIGINT.getLong(resultBlock, i), (long)outputIterator.nextInt());
        }
    }
}

