/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.state;

import io.trino.operator.aggregation.state.LongDecimalWithOverflowState;
import io.trino.operator.aggregation.state.LongDecimalWithOverflowStateFactory;
import io.trino.operator.aggregation.state.LongDecimalWithOverflowStateSerializer;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.VariableWidthBlockBuilder;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestLongDecimalWithOverflowStateSerializer {
    private static final LongDecimalWithOverflowStateFactory STATE_FACTORY = new LongDecimalWithOverflowStateFactory();

    @Test(dataProvider="input")
    public void testSerde(long low, long high, long overflow, int expectedLength) {
        LongDecimalWithOverflowState state = STATE_FACTORY.createSingleState();
        state.getDecimalArray()[0] = high;
        state.getDecimalArray()[1] = low;
        state.setOverflow(overflow);
        state.setNotNull();
        LongDecimalWithOverflowState outState = this.roundTrip(state, expectedLength);
        Assert.assertTrue((boolean)outState.isNotNull());
        Assert.assertEquals((long)outState.getDecimalArray()[0], (long)high);
        Assert.assertEquals((long)outState.getDecimalArray()[1], (long)low);
        Assert.assertEquals((long)outState.getOverflow(), (long)overflow);
    }

    @Test
    public void testNullSerde() {
        LongDecimalWithOverflowState state = STATE_FACTORY.createSingleState();
        LongDecimalWithOverflowState outState = this.roundTrip(state, 0);
        Assert.assertFalse((boolean)outState.isNotNull());
    }

    private LongDecimalWithOverflowState roundTrip(LongDecimalWithOverflowState state, int expectedLength) {
        LongDecimalWithOverflowStateSerializer serializer = new LongDecimalWithOverflowStateSerializer();
        VariableWidthBlockBuilder out = new VariableWidthBlockBuilder(null, 1, 0);
        serializer.serialize(state, (BlockBuilder)out);
        Block serialized = out.build();
        Assert.assertEquals((int)serialized.getSliceLength(0), (int)(expectedLength * 8));
        LongDecimalWithOverflowState outState = STATE_FACTORY.createSingleState();
        serializer.deserialize(serialized, 0, outState);
        return outState;
    }

    @DataProvider
    public Object[][] input() {
        return new Object[][]{{3, 0, 0, 1}, {3, 5, 0, 2}, {3, 5, 7, 3}, {3, 0, 7, 3}, {0, 0, 0, 1}, {0, 5, 0, 2}, {0, 5, 7, 3}, {0, 0, 7, 3}};
    }
}

