/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.output;

import io.airlift.concurrent.Threads;
import io.trino.block.BlockAssertions;
import io.trino.operator.OperatorContext;
import io.trino.operator.output.PartitionedOutputOperator;
import io.trino.operator.output.TestPagePartitioner;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestPartitionedOutputOperator {
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;
    private TestPagePartitioner.TestOutputBuffer outputBuffer;

    @BeforeClass
    public void setUpClass() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-executor-%s")));
        this.scheduledExecutor = Executors.newScheduledThreadPool(1, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-scheduledExecutor-%s")));
    }

    @AfterClass(alwaysRun=true)
    public void tearDownClass() {
        this.executor.shutdownNow();
        this.executor = null;
        this.scheduledExecutor.shutdownNow();
        this.scheduledExecutor = null;
    }

    @BeforeMethod
    public void setUp() {
        this.outputBuffer = new TestPagePartitioner.TestOutputBuffer();
    }

    @Test
    public void testOperatorContextStats() {
        PartitionedOutputOperator partitionedOutputOperator = new TestPagePartitioner.PagePartitionerBuilder(this.executor, this.scheduledExecutor, this.outputBuffer).withTypes(new Type[]{BigintType.BIGINT}).buildPartitionedOutputOperator();
        Page page = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 8)});
        partitionedOutputOperator.addInput(page);
        partitionedOutputOperator.finish();
        OperatorContext operatorContext = partitionedOutputOperator.getOperatorContext();
        Assert.assertEquals((long)operatorContext.getOutputDataSize().getTotalCount(), (long)page.getSizeInBytes());
        Assert.assertEquals((long)operatorContext.getOutputPositions().getTotalCount(), (long)page.getPositionCount());
    }
}

