/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.trino.jmh.Benchmarks;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.project.PageProcessor;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.Type;
import io.trino.sql.relational.CallExpression;
import io.trino.sql.relational.Expressions;
import io.trino.testing.TestingConnectorSession;
import io.trino.util.StructuralTestUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.options.WarmupMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=3)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkMapToMapCast {
    private static final int POSITION_COUNT = 100000;
    private static final int MAP_SIZE = 10;

    @Benchmark
    @OperationsPerInvocation(value=100000)
    public List<Optional<Page>> benchmark(BenchmarkData data) {
        return ImmutableList.copyOf((Iterator)data.getPageProcessor().process(TestingConnectorSession.SESSION, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), data.getPage()));
    }

    public static void main(String[] args) throws Exception {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkMapToMapCast().benchmark(data);
        Benchmarks.benchmark(BenchmarkMapToMapCast.class, (WarmupMode)WarmupMode.INDI).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private Page page;
        private PageProcessor pageProcessor;

        @Setup
        public void setup() {
            TestingFunctionResolution functionResolution = new TestingFunctionResolution();
            ImmutableList projections = ImmutableList.of((Object)new CallExpression(functionResolution.getCoercion((Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)BigintType.BIGINT), (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)DoubleType.DOUBLE)), (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)BigintType.BIGINT)))));
            this.pageProcessor = (PageProcessor)functionResolution.getExpressionCompiler().compilePageProcessor(Optional.empty(), (List)projections).get();
            Block keyBlock = BenchmarkData.createKeyBlock(100000, 10);
            Block valueBlock = BenchmarkData.createValueBlock(100000, 10);
            Block block = BenchmarkData.createMapBlock(StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)BigintType.BIGINT), 100000, keyBlock, valueBlock);
            this.page = new Page(new Block[]{block});
        }

        private static Block createMapBlock(MapType mapType, int positionCount, Block keyBlock, Block valueBlock) {
            int[] offsets = new int[positionCount + 1];
            int mapSize = keyBlock.getPositionCount() / positionCount;
            for (int i = 0; i < offsets.length; ++i) {
                offsets[i] = mapSize * i;
            }
            return mapType.createBlockFromKeyValue(Optional.empty(), offsets, keyBlock, valueBlock);
        }

        private static Block createKeyBlock(int positionCount, int mapSize) {
            BlockBuilder valueBlockBuilder = DoubleType.DOUBLE.createBlockBuilder(null, positionCount * mapSize);
            for (int i = 0; i < positionCount * mapSize; ++i) {
                DoubleType.DOUBLE.writeDouble(valueBlockBuilder, (double)ThreadLocalRandom.current().nextLong());
            }
            return valueBlockBuilder.build();
        }

        private static Block createValueBlock(int positionCount, int mapSize) {
            BlockBuilder valueBlockBuilder = BigintType.BIGINT.createBlockBuilder(null, positionCount * mapSize);
            for (int i = 0; i < positionCount * mapSize; ++i) {
                BigintType.BIGINT.writeLong(valueBlockBuilder, ThreadLocalRandom.current().nextLong());
            }
            return valueBlockBuilder.build();
        }

        public PageProcessor getPageProcessor() {
            return this.pageProcessor;
        }

        public Page getPage() {
            return this.page;
        }
    }
}

