/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestFormatNumberFunction {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testFormatNumber() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("format_number", "TINYINT '123'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("123");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("format_number", "SMALLINT '12345'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("12.3K");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("format_number", "SMALLINT '12399'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("12.4K");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("format_number", "INTEGER '12345678'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("12.3M");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("format_number", "INTEGER '12399999'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("12.4M");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("format_number", "BIGINT '12345678901'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("12.3B");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("format_number", "BIGINT '12399999999'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("12.4B");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("format_number", "DOUBLE '1234.5'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1.23K");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("format_number", "DOUBLE '1239.9'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1.24K");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("format_number", "REAL '1234567.8'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1.23M");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("format_number", "REAL '1239999.9'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1.24M");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("format_number", "DECIMAL '1234567890.1'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1.23B");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("format_number", "DECIMAL '1239999999.9'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1.24B");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("format_number", "-999")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("-999");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("format_number", "-1000")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("-1K");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("format_number", "-999999")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("-1000K");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("format_number", "-1000000")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("-1M");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("format_number", "-999999999")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("-1000M");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("format_number", "-1000000000")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("-1B");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("format_number", "-999999999999")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("-1000B");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("format_number", "-1000000000000")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("-1T");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("format_number", "-999999999999999")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("-1000T");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("format_number", "-1000000000000000")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("-1Q");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("format_number", "-9223372036854775808")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("-9223.37Q");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("format_number", "0")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("format_number", "999")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("999");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("format_number", "1000")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1K");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("format_number", "999999")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1000K");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("format_number", "1000000")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1M");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("format_number", "999999999")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1000M");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("format_number", "1000000000")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1B");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("format_number", "999999999999")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1000B");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("format_number", "1000000000000")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1T");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("format_number", "999999999999999")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1000T");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("format_number", "1000000000000000")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1Q");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("format_number", "9223372036854775807")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("9223Q");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("format_number", "CAST(NULL AS TINYINT)")))).isNull((Type)VarcharType.VARCHAR);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("format_number", "CAST(NULL AS SMALLINT)")))).isNull((Type)VarcharType.VARCHAR);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("format_number", "CAST(NULL AS INTEGER)")))).isNull((Type)VarcharType.VARCHAR);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("format_number", "CAST(NULL AS DOUBLE)")))).isNull((Type)VarcharType.VARCHAR);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("format_number", "CAST(NULL AS REAL)")))).isNull((Type)VarcharType.VARCHAR);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("format_number", "CAST(NULL AS DECIMAL)")))).isNull((Type)VarcharType.VARCHAR);
    }
}

